/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.export;

import java.awt.Component;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.RaptorDBAddin;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.data.writers.GenerationOutputStream;
import oracle.dbtools.raptor.ddl.TargetFormat;
import oracle.dbtools.raptor.export.wizard.ExportWizArb;
import oracle.dbtools.raptor.format.ResultsFormatter;
import oracle.dbtools.util.Service;
import oracle.dbtools.util.ZipOutputHandler;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.db.model.SqlNode;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Node;
import oracle.javatools.dialogs.MessageDialog;

public class ExportGenerationOutputStream
implements GenerationOutputStream {
    protected final int FLUSH_EVERY_N_WRITE = 20;
    protected int m_writeTracker = 0;
    private TargetFormat m_targetFormat;
    private ResultsFormatter m_formatter;
    private long m_linesWritten = 0L;
    private int m_fileIndex = 0;
    private Writer m_currentWriter;
    private OutputStream m_fout;
    private OutputStream m_bout;
    private ZipOutputHandler m_zipper;
    private String m_currentObjectType = "";
    private String m_lastObjectType = "";
    private ArrayList<String> m_createdFiles;
    private String m_currentFileName;
    private String m_controllingScriptName;
    private String m_controllingHeader;
    private boolean m_isControllingFileExecutable = false;
    private String m_encoding;
    private static final TypeToFolderNameTuple[] FOLDER_NAME_MAP = new TypeToFolderNameTuple[]{new TypeToFolderNameTuple("DROP", ExportWizArb.getString("DROP_FOLDER")), new TypeToFolderNameTuple("VIEW", ExportWizArb.getString("VIEW_FOLDER")), new TypeToFolderNameTuple("TYPE", ExportWizArb.getString("TYPE_FOLDER")), new TypeToFolderNameTuple("TRIGGER", ExportWizArb.getString("TRIGGER_FOLDER")), new TypeToFolderNameTuple("TABLE", ExportWizArb.getString("TABLE_FOLDER")), new TypeToFolderNameTuple("SEQUENCE", ExportWizArb.getString("SEQUENCE_FOLDER")), new TypeToFolderNameTuple("PROCEDURE", ExportWizArb.getString("PROCEDURE_FOLDER")), new TypeToFolderNameTuple("PACKAGE BODY", ExportWizArb.getString("PACKBODY_FOLDER")), new TypeToFolderNameTuple("PACKAGE", ExportWizArb.getString("PACKSPEC_FOLDER")), new TypeToFolderNameTuple("MATERIALIZED VIEW", ExportWizArb.getString("MATVIEW_FOLDER")), new TypeToFolderNameTuple("INDEX", ExportWizArb.getString("INDEX_FOLDER")), new TypeToFolderNameTuple("FUNCTION", ExportWizArb.getString("FUNCTION_FOLDER")), new TypeToFolderNameTuple("DATABASE LINK", ExportWizArb.getString("DBLINK_FOLDER")), new TypeToFolderNameTuple("SYNONYM", ExportWizArb.getString("SYNONYM_FOLDER")), new TypeToFolderNameTuple("MATERIALIZED VIEW LOG", ExportWizArb.getString("MATVIEWLOG_FOLDER")), new TypeToFolderNameTuple("DIRECTORY", ExportWizArb.getString("DIRECTORY_FOLDER")), new TypeToFolderNameTuple("QUEUE", ExportWizArb.getString("QUEUE_FOLDER")), new TypeToFolderNameTuple("QUEUE TABLE", ExportWizArb.getString("QUEUETABLE_FOLDER")), new TypeToFolderNameTuple("CONSTRAINT", ExportWizArb.getString("CONSTRAINT_FOLDER")), new TypeToFolderNameTuple("REFCONSTRAINT", ExportWizArb.getString("REFCONSTRAINT_FOLDER"))};

    public ExportGenerationOutputStream(TargetFormat targetFormat) {
        this.m_targetFormat = targetFormat;
        this.m_encoding = targetFormat.getEncoding();
    }

    public void setControllingFileHeader(String string) {
        this.m_controllingHeader = string;
    }

    @Override
    public void startPreamble(String string) throws FileNotFoundException, UnsupportedEncodingException {
        this.m_createdFiles = new ArrayList();
        if (this.m_targetFormat.isCompressed()) {
            this.m_zipper = new ZipOutputHandler();
            this.m_zipper.setEncoding(this.m_targetFormat.getEncoding());
            String string2 = this.m_targetFormat.getSaveAs();
            File file = new File(string2);
            String string3 = file.getParent();
            this.m_zipper.openZip(string2);
            this.m_targetFormat.setSaveAs(string3);
            this.m_controllingScriptName = string;
            this.m_targetFormat.setControllingBaseName(this.m_controllingScriptName);
        } else if (this.m_targetFormat.getSaveAsType() == 0 || this.m_targetFormat.getSaveAsType() >= 4 || this.m_targetFormat.isCompressed()) {
            this.open(this.m_targetFormat.getSaveAs());
        } else {
            this.m_controllingScriptName = string;
            this.m_targetFormat.setControllingBaseName(this.m_controllingScriptName);
        }
    }

    @Override
    public void endPreamble() {
    }

    @Override
    public void startObject(String string, String string2) {
        block11: {
            boolean bl = !this.m_currentObjectType.equals(string2);
            this.m_lastObjectType = this.m_currentObjectType;
            this.m_currentObjectType = string2;
            try {
                if (this.m_targetFormat.isCompressed()) {
                    if (this.m_targetFormat.getSaveAsType() != 0) {
                        this.closeCurrentStream();
                    } else {
                        this.flushCurrentStream();
                    }
                    this.m_zipper.openEntry(this.getFileName(Service.cleanScriptFileName((String)string), string2));
                    break block11;
                }
                if (!this.m_targetFormat.isCompressed() && (this.m_targetFormat.getSaveAsType() == 1 || this.m_targetFormat.getSaveAsType() == 2 && bl || this.m_targetFormat.getSaveAsType() == 2 && this.isTypeData(string2) || this.m_targetFormat.getSaveAsType() == 3)) {
                    this.closeCurrentStream();
                    String string3 = this.getFileName(Service.cleanScriptFileName((String)string), string2);
                    if (this.m_targetFormat.getSaveAsType() == 3 && bl) {
                        File file = new File(string3).getParentFile();
                        try {
                            file.mkdir();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.open(string3);
                    break block11;
                }
                this.m_currentFileName = this.m_targetFormat.getSaveAs();
                this.flushCurrentStream();
            }
            catch (FileNotFoundException fileNotFoundException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, fileNotFoundException.getStackTrace()[0].toString(), fileNotFoundException);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, unsupportedEncodingException.getStackTrace()[0].toString(), unsupportedEncodingException);
            }
            catch (IOException iOException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            }
        }
    }

    @Override
    public void endObject() {
    }

    @Override
    public void println(String string) {
        assert (this.m_currentWriter != null || this.m_zipper != null);
        int n = ExportGenerationOutputStream.countLines(string);
        try {
            if (string != null) {
                if (this.m_targetFormat.isCompressed()) {
                    this.m_zipper.writeEntryText(string);
                } else {
                    this.m_currentWriter.write(string);
                }
                if (this.m_writeTracker < 20) {
                    ++this.m_writeTracker;
                } else {
                    if (this.m_targetFormat.isCompressed()) {
                        this.m_zipper.flush();
                    } else {
                        this.m_currentWriter.flush();
                    }
                    this.m_writeTracker = 0;
                }
                this.m_linesWritten += (long)n;
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
    }

    public void writeFileEntry(URL uRL) {
        try {
            this.m_zipper.writeFileEntry(uRL);
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
    }

    @Override
    public void finished() {
        this.m_lastObjectType = this.m_currentObjectType;
        if (this.m_targetFormat.getSaveAsType() < 4) {
            this.closeCurrentStream();
            if (this.m_targetFormat.isCompressed() && this.m_targetFormat.isGenScript()) {
                try {
                    this.m_zipper.addSQLControllingFile(this.m_targetFormat.getControllingFile(), this.m_controllingHeader, this.m_targetFormat.isExcutableControlFile());
                    this.m_zipper.closeZip();
                }
                catch (IOException iOException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
                }
            } else if (!this.m_targetFormat.isCompressed() && this.m_targetFormat.isGenScript() && this.m_createdFiles != null && this.m_createdFiles.size() > 1 && (this.m_targetFormat.getSaveAsType() == 1 || this.m_targetFormat.getSaveAsType() == 3 || this.m_targetFormat.getSaveAsType() == 2)) {
                try {
                    for (String string : this.m_createdFiles) {
                        if (!string.endsWith(".sql")) continue;
                        this.m_isControllingFileExecutable = true;
                    }
                    if (this.m_isControllingFileExecutable) {
                        this.open(this.m_targetFormat.getControllingFile());
                        this.println(this.m_controllingHeader);
                        this.m_createdFiles.remove(this.m_createdFiles.size() - 1);
                        for (String string : this.m_createdFiles) {
                            if (new File(string).length() <= 0L) continue;
                            if (string.endsWith(".sql")) {
                                this.println("@" + string + "\n");
                                this.m_isControllingFileExecutable = true;
                                continue;
                            }
                            this.println("--@" + string + "\n");
                        }
                        this.m_lastObjectType = "CONTROL";
                        this.closeCurrentStream();
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, fileNotFoundException.getStackTrace()[0].toString(), fileNotFoundException);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, unsupportedEncodingException.getStackTrace()[0].toString(), unsupportedEncodingException);
                }
            }
        }
    }

    public boolean isControlFileExecutable() {
        return this.m_isControllingFileExecutable;
    }

    private void closeCurrentStream() {
        try {
            if (!this.m_targetFormat.isCompressed() && this.m_currentWriter != null) {
                if (this.isTypeData(this.m_lastObjectType) && this.m_formatter.isStreamHandler()) {
                    this.m_formatter.closeStream();
                } else {
                    this.m_currentWriter.flush();
                    this.m_currentWriter.close();
                    File file = new File(this.m_currentFileName);
                    if (file.length() == 0L) {
                        file.delete();
                    }
                }
                this.m_writeTracker = 0;
                this.m_currentWriter = null;
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
    }

    private void flushCurrentStream() {
        try {
            if (!this.m_targetFormat.isCompressed() && this.m_currentWriter != null) {
                if (this.isTypeData(this.m_lastObjectType) && this.m_formatter.isStreamHandler()) {
                    this.m_formatter.flushStream();
                } else {
                    this.m_currentWriter.flush();
                }
                this.m_writeTracker = 0;
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
    }

    private static int countLines(String string) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        int n = 1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '\n') continue;
            ++n;
        }
        return n;
    }

    private void open(String string) throws FileNotFoundException, UnsupportedEncodingException {
        if (this.m_targetFormat.isCompressed()) {
            try {
                this.m_zipper.openEntry(string);
                this.m_createdFiles.add(string.toString());
            }
            catch (IOException iOException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            }
        } else if (this.m_targetFormat.getSaveAsType() >= 4) {
            this.m_currentWriter = new StringWriter();
        } else {
            this.m_fout = new FileOutputStream(new File(string));
            this.m_bout = new BufferedOutputStream(this.m_fout);
            this.m_currentWriter = this.m_encoding == null ? new OutputStreamWriter(this.m_bout, this.m_encoding) : new OutputStreamWriter(this.m_bout, this.m_encoding);
            this.m_createdFiles.add(string.toString());
        }
    }

    public void addToControllingFile(String string) {
        this.m_createdFiles.add(string);
    }

    protected Writer getWriter() {
        return this.m_currentWriter;
    }

    protected OutputStream getOutputStream() {
        return this.m_bout;
    }

    protected ZipOutputHandler getZipper() {
        return this.m_zipper;
    }

    public String toString() {
        if (this.m_currentWriter != null && this.m_currentWriter instanceof StringWriter) {
            return this.m_currentWriter.toString();
        }
        return null;
    }

    protected TargetFormat getTargetFormat() {
        return this.m_targetFormat;
    }

    protected void setTargetFormat(TargetFormat targetFormat) {
        this.m_targetFormat = targetFormat;
    }

    protected void setFormatter(ResultsFormatter resultsFormatter) {
        this.m_formatter = resultsFormatter;
    }

    public String getFileNameToOpen() {
        if (this.m_targetFormat.getSaveAsType() == 0) {
            return this.m_targetFormat.getSaveAs();
        }
        if (this.isControlFileExecutable()) {
            return this.m_targetFormat.getControllingFile();
        }
        if (this.m_createdFiles != null && this.m_createdFiles.size() > 0) {
            String string = null;
            for (String string2 : this.m_createdFiles) {
                if (!string2.endsWith(".sql")) continue;
                if (string != null) {
                    return null;
                }
                string = string2;
            }
            return string;
        }
        return null;
    }

    public void openTargetInUI(String string) throws Exception {
        if (this.m_targetFormat.getSaveAsType() == 4) {
            final String string2 = this.toString();
            final String string3 = string;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RaptorDBAddin.getSqlOpener().openNewEditor(string2, string3);
                }
            });
        } else if (this.m_targetFormat.getSaveAsType() == 5) {
            String string4 = this.toString();
            UIUtils.setClipboard((String)string4);
        } else {
            final String string5 = this.getFileNameToOpen();
            if (this.m_targetFormat.isOpenTarget() && string5 != null && string5.length() > 4 && string5.endsWith("sql")) {
                final SqlNode sqlNode = new SqlNode(this.m_targetFormat.getURL(string5));
                final String string6 = sqlNode.getShortLabel();
                sqlNode.setSaveEncoding(this.m_targetFormat.getEncoding());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Object object;
                        if (ExportGenerationOutputStream.this.m_targetFormat.getSaveAsType() == 0 && new File(ExportGenerationOutputStream.this.m_targetFormat.getSaveAs()).length() > 500000L) {
                            String string = ExportWizArb.format("EXCEEDS_AUTO_OPEN_SIZE", ExportGenerationOutputStream.this.m_targetFormat.getSaveAs());
                            MessageDialog.information((Component)Ide.getMainWindow(), (Object)string, (String)ExportWizArb.getString("TASK_SHORT_NAME"), null);
                            return;
                        }
                        List list = EditorManager.getEditorManager().getAllEditors();
                        Iterator iterator = list.iterator();
                        Editor editor = null;
                        while (iterator.hasNext()) {
                            editor = (Editor)iterator.next();
                            object = editor.getTabLabel();
                            if (!string5.equals(object) && !string5.equals(((String)object).replace('*', ' ').trim()) && !string6.equals(object) && !string6.equals(((String)object).replace('*', ' ').trim())) continue;
                            EditorManager.getEditorManager().closeEditors(Arrays.asList(editor));
                            break;
                        }
                        object = Context.newIdeContext((Node)sqlNode);
                        OpenEditorOptions openEditorOptions = new OpenEditorOptions((Context)object);
                        openEditorOptions.setFlags(1);
                        EditorManager.getEditorManager().openEditor(openEditorOptions);
                    }
                });
            }
        }
    }

    private String getFileName(String string, String string2) {
        String string3;
        String string4 = string3 = this.m_targetFormat.isCompressed() ? "" : this.m_targetFormat.getSaveAs();
        if (this.m_targetFormat.getSaveAsType() == 0 || this.m_targetFormat.getSaveAsType() >= 4) {
            this.m_currentFileName = string3;
            return string3;
        }
        String string5 = "";
        if (this.isTypeData(string2)) {
            string5 = "_" + string2;
        } else if (string2.equals("CONSTRAINT")) {
            string5 = "_CONSTRAINT";
        } else if (string2.equals("REFCONSTRAINT")) {
            string5 = "_REFCONSTRAINT";
        }
        String string6 = Character.valueOf(File.separatorChar).toString();
        if (string3.endsWith(string6) || this.m_targetFormat.isCompressed()) {
            string6 = "";
        }
        string3 = this.m_targetFormat.getSaveAsType() == 1 ? string3 + string6 + string + string5 : (this.m_targetFormat.getSaveAsType() == 2 ? (this.isTypeData(string2) ? string3 + string6 + string + string5 : string3 + string6 + this.getFolderNameForType(string2)) : string3 + string6 + this.getFolderNameForType(string2) + string6 + string);
        this.m_currentFileName = this.m_targetFormat.isCompressed() ? this.m_zipper.getUniqueEntryName(string3, this.getExtension(string2)) : this.getUniqueFileName(string3, this.getExtension(string2));
        return this.m_currentFileName;
    }

    private boolean isTypeData(String string) {
        return string.startsWith("DATA") && !string.equals("DATABASE LINK");
    }

    private String getUniqueFileName(String string, String string2) {
        String string3 = string + string2;
        File file = new File(string3);
        int n = 0;
        while (file.isFile()) {
            string3 = string + "_" + ++n + string2;
            file = new File(string3);
        }
        return string3;
    }

    public String getCurrentFileName() {
        return this.m_currentFileName;
    }

    private String getExtension(String string) {
        return !this.isTypeData(string) ? ".sql" : "." + this.m_targetFormat.getDataFormatExtension();
    }

    private String getFolderNameForType(String string) {
        for (TypeToFolderNameTuple typeToFolderNameTuple : FOLDER_NAME_MAP) {
            if (!typeToFolderNameTuple.getType().equals(string)) continue;
            return typeToFolderNameTuple.getFolderName();
        }
        return string;
    }

    public void close() {
    }

    private static class TypeToFolderNameTuple {
        private String m_type;
        private String m_folderName;

        public TypeToFolderNameTuple(String string, String string2) {
            this.setType(string);
            this.setFolderName(string2);
        }

        public String getFolderName() {
            return this.m_folderName;
        }

        public String getType() {
            return this.m_type;
        }

        protected void setFolderName(String string) {
            this.m_folderName = string;
        }

        protected void setType(String string) {
            this.m_type = string;
        }
    }
}

