/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.user;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dialogs.user.PrivilegeObject;
import oracle.dbtools.raptor.dialogs.user.QuotaObject;
import oracle.dbtools.raptor.dialogs.user.RoleObject;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.javatools.util.Version;

public class UserObject {
    private Connection conn;
    private String userName = null;
    private boolean alter;
    private String password;
    private boolean expired = false;
    private boolean edition = false;
    private boolean locked = false;
    private String defTableSpace;
    private String tempTableSpace;
    private Map<String, RoleObject> roles = new HashMap<String, RoleObject>();
    private Map<String, PrivilegeObject> privs = new HashMap<String, PrivilegeObject>();
    private Map<String, QuotaObject> quotas = new HashMap<String, QuotaObject>();
    private List<String> tablespaceGroups = new ArrayList<String>();
    private String defRoles;
    private boolean enableEdition = false;

    private final Query getQueryFromFile(Connection connection, String string) {
        String string2 = "/oracle/dbtools/raptor/dialogs/user/UserQueries.xml";
        QueryXMLSupport queryXMLSupport = QueryXMLSupport.getQueryXMLSupport((String)string2);
        Query query = queryXMLSupport.getQuery(string, connection);
        return query;
    }

    protected final String getQuery(Connection connection, String string) {
        Query query = this.getQueryFromFile(connection, string);
        return query.getSql();
    }

    public UserObject(Connection connection, String string) {
        this.userName = string;
        this.conn = connection;
        this.enableEdition = DBUtil.checkVersion((Connection)connection, null, (Version)new Version("11.2"));
        this.loadUser();
        this.loadPrivs();
        this.loadQuotas();
        this.loadRoles();
        this.loadTablespaceGroups();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadUser() {
        Statement statement = null;
        ResultSet resultSet = null;
        if (this.userName != null) {
            this.alter = true;
            try {
                String string;
                statement = this.conn.prepareCall(this.getQuery(this.conn, "get_user"));
                statement.setString(1, this.userName);
                resultSet = statement.executeQuery();
                if (!resultSet.next()) return;
                String string2 = resultSet.getString(1);
                if (string2.indexOf("LOCKED") != -1) {
                    this.locked = true;
                }
                if (string2.indexOf("EXPIRED") != -1) {
                    this.expired = true;
                }
                this.defTableSpace = resultSet.getString(2);
                this.tempTableSpace = resultSet.getString(3);
                if (!this.enableEdition || !(string = resultSet.getString(4)).equals("Y")) return;
                this.edition = true;
                return;
            }
            catch (Exception exception) {
                return;
            }
            finally {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
        }
        this.alter = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadPrivs() {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.conn.prepareCall(this.getQuery(this.conn, "get_privs"));
            statement.setString(1, this.userName);
            statement.setString(2, this.userName);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                String string = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                String string3 = resultSet.getString(3);
                PrivilegeObject privilegeObject = new PrivilegeObject(string, string2, string3);
                this.privs.put(string, privilegeObject);
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception exception) {}
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadQuotas() {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.conn.prepareCall(this.getQuery(this.conn, "get_quotas"));
            statement.setString(1, this.userName);
            statement.setString(2, this.userName);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                String string = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                String string3 = resultSet.getString(3);
                String string4 = resultSet.getString(4);
                String string5 = resultSet.getString(5);
                QuotaObject quotaObject = new QuotaObject(string, string2, string3, string4, string5);
                this.quotas.put(string, quotaObject);
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception exception) {}
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTablespaceGroups() {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.conn.prepareCall(this.getQuery(this.conn, "get_tablespace_groups"));
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                String string = resultSet.getString(1);
                this.tablespaceGroups.add(string);
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception exception) {}
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadRoles() {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.conn.prepareCall(this.getQuery(this.conn, "get_roles"));
            statement.setString(1, this.userName);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                String string = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                String string3 = resultSet.getString(3);
                String string4 = resultSet.getString(4);
                RoleObject roleObject = new RoleObject(string, string2, string3, string4);
                this.roles.put(string, roleObject);
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception exception) {}
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    public String getSql() {
        this.defRoles = null;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("-- USER SQL\n");
        if (this.alter) {
            stringBuffer.append("ALTER USER \"");
            stringBuffer.append(this.userName);
            stringBuffer.append("\" ");
            if (this.password != null) {
                stringBuffer.append(" IDENTIFIED BY ");
                stringBuffer.append(this.password);
                stringBuffer.append(" ");
            }
            if (this.defTableSpace != null) {
                stringBuffer.append("\nDEFAULT TABLESPACE ");
                stringBuffer.append("\"" + this.defTableSpace + "\"");
            }
            if (this.tempTableSpace != null) {
                stringBuffer.append("\nTEMPORARY TABLESPACE ");
                stringBuffer.append("\"" + this.tempTableSpace + "\"");
            }
            if (this.expired) {
                stringBuffer.append("\nPASSWORD EXPIRE ");
            }
            if (this.locked) {
                stringBuffer.append("\nACCOUNT LOCK ");
            } else {
                stringBuffer.append("\nACCOUNT UNLOCK ");
            }
            if (this.enableEdition && this.edition) {
                stringBuffer.append("\nENABLE EDITIONS ");
            }
            stringBuffer.append(";\n");
        } else if (this.userName != null) {
            stringBuffer.append("CREATE USER ");
            stringBuffer.append(this.userName);
            stringBuffer.append(" IDENTIFIED BY ");
            stringBuffer.append(this.password);
            stringBuffer.append(" ");
            if (this.defTableSpace != null) {
                stringBuffer.append("\nDEFAULT TABLESPACE ");
                stringBuffer.append("\"" + this.defTableSpace + "\"");
            }
            if (this.tempTableSpace != null) {
                stringBuffer.append("\nTEMPORARY TABLESPACE ");
                stringBuffer.append("\"" + this.tempTableSpace + "\"");
            }
            if (this.expired) {
                stringBuffer.append("\nPASSWORD EXPIRE ");
            }
            if (this.locked) {
                stringBuffer.append("\nACCOUNT LOCK ");
            }
            if (this.enableEdition && this.edition) {
                stringBuffer.append("\nENABLE EDITIONS ");
            }
            stringBuffer.append(";\n");
        }
        stringBuffer.append("\n");
        stringBuffer.append("-- ROLES\n");
        for (String string : this.roles.keySet()) {
            RoleObject roleObject = this.roles.get(string);
            if (roleObject.doRevoke()) {
                stringBuffer.append("REVOKE \"");
                stringBuffer.append(string);
                stringBuffer.append("\" FROM ");
                if (this.alter) {
                    stringBuffer.append("\"" + this.userName + "\"");
                } else {
                    stringBuffer.append(this.userName);
                }
                stringBuffer.append(";\n");
            }
            if (roleObject.doGrant()) {
                stringBuffer.append("GRANT \"");
                stringBuffer.append(string);
                stringBuffer.append("\" TO ");
                if (this.alter) {
                    stringBuffer.append("\"" + this.userName + "\"");
                } else {
                    stringBuffer.append(this.userName);
                }
                stringBuffer.append(" ");
                if (roleObject.isAdmin()) {
                    stringBuffer.append("WITH ADMIN OPTION");
                }
                stringBuffer.append(";\n");
            }
            if (!roleObject.isDef()) continue;
            if (this.defRoles == null) {
                this.defRoles = "\"" + string + "\"";
                continue;
            }
            this.defRoles = this.defRoles + ",\"" + string + "\"";
        }
        if (this.defRoles != null) {
            stringBuffer.append("ALTER USER ");
            if (this.alter) {
                stringBuffer.append("\"" + this.userName + "\"");
            } else {
                stringBuffer.append(this.userName);
            }
            stringBuffer.append(" DEFAULT ROLE " + this.defRoles + ";\n");
        }
        stringBuffer.append("\n");
        stringBuffer.append("-- SYSTEM PRIVILEGES\n");
        for (String string : this.privs.keySet()) {
            PrivilegeObject privilegeObject = this.privs.get(string);
            if (privilegeObject.doRevoke()) {
                stringBuffer.append("REVOKE ");
                stringBuffer.append(string);
                stringBuffer.append(" FROM ");
                if (this.alter) {
                    stringBuffer.append("\"" + this.userName + "\"");
                } else {
                    stringBuffer.append(this.userName);
                }
                stringBuffer.append(";\n");
            }
            if (!privilegeObject.doGrant()) continue;
            stringBuffer.append("GRANT ");
            stringBuffer.append(string);
            stringBuffer.append(" TO ");
            if (this.alter) {
                stringBuffer.append("\"" + this.userName + "\"");
            } else {
                stringBuffer.append(this.userName);
            }
            stringBuffer.append(" ");
            if (privilegeObject.isAdmin()) {
                stringBuffer.append("WITH ADMIN OPTION");
            }
            stringBuffer.append(";\n");
        }
        stringBuffer.append("\n");
        stringBuffer.append("-- QUOTAS\n");
        for (String string : this.quotas.keySet()) {
            QuotaObject quotaObject = this.quotas.get(string);
            if (quotaObject.isUnlimited()) {
                stringBuffer.append("ALTER USER ");
                if (this.alter) {
                    stringBuffer.append("\"" + this.userName + "\"");
                } else {
                    stringBuffer.append(this.userName);
                }
                stringBuffer.append(" QUOTA UNLIMITED ON " + string + ";\n");
                continue;
            }
            if (quotaObject.revUnlimited()) {
                stringBuffer.append("ALTER USER ");
                if (this.alter) {
                    stringBuffer.append("\"" + this.userName + "\"");
                } else {
                    stringBuffer.append(this.userName);
                }
                stringBuffer.append(" QUOTA 0 ON " + string + ";\n");
                continue;
            }
            if (quotaObject.getQuota() == null || quotaObject.getQuota().equals("")) continue;
            stringBuffer.append("ALTER USER ");
            if (this.alter) {
                stringBuffer.append("\"" + this.userName + "\"");
            } else {
                stringBuffer.append(this.userName);
            }
            stringBuffer.append(" QUOTA " + quotaObject.getQuotaString() + " ON " + string + ";\n");
        }
        return stringBuffer.toString();
    }

    public String getDefTableSpace() {
        return this.defTableSpace;
    }

    public void setDefTableSpace(String string) {
        this.defTableSpace = string;
    }

    public boolean isExpired() {
        return this.expired;
    }

    public void setExpired(boolean bl) {
        this.expired = bl;
    }

    public boolean getEdition() {
        return this.edition;
    }

    public void setEdition(boolean bl) {
        this.edition = bl;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean bl) {
        this.locked = bl;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getTempTableSpace() {
        return this.tempTableSpace;
    }

    public void setTempTableSpace(String string) {
        this.tempTableSpace = string;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String string) {
        this.userName = string;
    }

    public void updateRole(String string, boolean bl, boolean bl2, boolean bl3) {
        this.roles.get(string).setGranted(bl);
        this.roles.get(string).setAdmin(bl2);
        this.roles.get(string).setDef(bl3);
    }

    public void updateRole(RoleObject roleObject) {
        RoleObject roleObject2 = this.roles.get(roleObject.getName());
        roleObject2.setAdmin(roleObject.isAdmin());
        roleObject2.setDef(roleObject.isDef());
        roleObject2.setGranted(roleObject.isGranted());
    }

    public void updatePriv(String string, boolean bl, boolean bl2) {
        this.privs.get(string).setGranted(bl);
        this.privs.get(string).setAdmin(bl2);
    }

    public void updatePrivs(PrivilegeObject privilegeObject) {
        PrivilegeObject privilegeObject2 = this.privs.get(privilegeObject.getName());
        privilegeObject2.setAdmin(privilegeObject.isAdmin());
        privilegeObject2.setGranted(privilegeObject.isGranted());
    }

    public void updateQuota(String string, boolean bl, String string2, String string3) {
        this.quotas.get(string).setUnlimited(bl);
        this.quotas.get(string).setQuota(string2);
        this.quotas.get(string).setUnit(string3);
    }

    public void updateQuota(QuotaObject quotaObject) {
        QuotaObject quotaObject2 = this.quotas.get(quotaObject.getName());
        quotaObject2.setUnlimited(quotaObject.isUnlimited());
        quotaObject2.setQuota(quotaObject.getQuota());
        quotaObject2.setUnit(quotaObject.getUnit());
    }

    public Map<String, PrivilegeObject> getPrivs() {
        return this.privs;
    }

    public Map<String, QuotaObject> getQuotas() {
        return this.quotas;
    }

    public Map<String, RoleObject> getRoles() {
        return this.roles;
    }

    public List<String> getTablespaceGroups() {
        return this.tablespaceGroups;
    }

    public boolean isAlter() {
        return this.alter;
    }

    public void setAlter(boolean bl) {
        this.alter = bl;
    }
}

