/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.actions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.ControlsArb;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.controls.celleditor.BFileInsertPanel;
import oracle.dbtools.raptor.dialogs.Messages;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLFilter;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;

public class LoadJava
extends AbstractMenuAction {
    private JTextField _txfName;
    private JTextArea _txaCode;
    private static String s_selectedURL;
    private JTextField m_txfFilePath;
    private JButton m_btnBrowse;
    private JComboBox m_cmbJavaType;
    protected URL s_selectedLocalFileURL;
    private JButton m_btnBrowseLocal;

    @Override
    public void launch() {
        JPanel jPanel = this.initUI();
        final String string = ((ActionEvent)this.getContext().getEvent()).getActionCommand();
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = ((JEWTDialog)actionEvent.getSource()).isCancelled();
                if (!this.validateInput()) {
                    return;
                }
                if (!bl) {
                    Object object;
                    String string6 = LoadJava.this._txfName.getText().trim();
                    ObjectFolder objectFolder = (ObjectFolder)LoadJava.this.getContext().getNode();
                    String string2 = objectFolder.getSchemaName();
                    string6 = string2 + "." + string6;
                    string2 = "SCHEMA " + string2;
                    String string3 = "BEGIN execute immediate 'CREATE OR REPLACE AND RESOLVE JAVA ";
                    String string4 = null;
                    String string5 = null;
                    s_selectedURL = LoadJava.this.m_txfFilePath.getText();
                    if (s_selectedURL != null && LoadJava.this.m_cmbJavaType.getSelectedIndex() > 0) {
                        try {
                            string4 = s_selectedURL.substring(0, s_selectedURL.lastIndexOf("/"));
                            string5 = s_selectedURL.substring(s_selectedURL.lastIndexOf("/") + 1);
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            MessageDialog.error((Component)LoadJava.this.m_txfFilePath, (Object)"Invalid source file path specified.", (String)string, (String)"f1_load_java");
                            return;
                        }
                    }
                    switch (LoadJava.this.m_cmbJavaType.getSelectedIndex()) {
                        case 0: {
                            string3 = string3 + "SOURCE NAMED ";
                            string3 = string3 + string6 + " AS \n";
                            object = LoadJava.this._txaCode.getText();
                            object = ((String)object).replaceAll("'", "''");
                            string3 = string3 + (String)object;
                            string3 = string3 + " '; end;";
                            break;
                        }
                        case 1: {
                            string3 = string3 + "SOURCE NAMED " + string6 + " USING BFILE (\"" + string4 + "\", ''" + string5 + "'') '; end;";
                            break;
                        }
                        case 2: {
                            string3 = string3 + "CLASS " + string2 + " USING BFILE (\"" + string4 + "\", ''" + string5 + "'') '; end;";
                            break;
                        }
                        case 3: {
                            string3 = string3 + "RESOURCE NAMED " + string6 + " USING BFILE (\"" + string4 + "\", ''" + string5 + "'') '; end;";
                            break;
                        }
                    }
                    object = LoadJava.this.getDBObject().getConnection();
                    try {
                        Statement statement = object.createStatement();
                        statement.executeUpdate(string3);
                        statement.close();
                    }
                    catch (Exception exception) {
                        ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)Messages.getString((String)"LoadJava.ErrorInDialog"), (String)Messages.getString((String)"LoadJava.ErrorInDialog"), null);
                        return;
                    }
                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)MessageFormat.format(Messages.getString((String)"LoadJava.15"), LoadJava.this._txfName.getText(), LoadJava.this.m_cmbJavaType.getSelectedItem()), (String)string, (String)"f1_load_java");
                }
                ((JEWTDialog)actionEvent.getSource()).closeDialog(true);
            }

            private boolean validateInput() {
                String string3 = null;
                if (LoadJava.this.m_cmbJavaType.getSelectedIndex() > 0 && LoadJava.this.m_txfFilePath.getText().trim().length() <= 0) {
                    string3 = Messages.getString((String)"LoadJava.SOURCE_NOT_SPECIFIED");
                }
                if (LoadJava.this._txfName.getText().trim().length() == 0 && LoadJava.this.m_cmbJavaType.getSelectedIndex() != 2) {
                    string3 = Messages.getString((String)"LoadJava.NAME_NOT_SPECIFIED");
                }
                if (string3 != null) {
                    String string2 = ((ActionEvent)LoadJava.this.getContext().getEvent()).getActionCommand();
                    MessageDialog.error((Component)LoadJava.this.m_cmbJavaType, (Object)string3, (String)string2, (String)"f1_load_java");
                    return false;
                }
                return true;
            }
        };
        jPanel.setPreferredSize(new Dimension(200, 400));
        HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_load_java");
        UIUtils.showPanelAsDialog((JPanel)jPanel, (String)string, (ActionListener)actionListener, (boolean)true);
    }

    private JPanel initUI() {
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        jPanel2.add((Component)new JLabel(Messages.getString((String)"LoadJava.32")), gridBagConstraints);
        this._txfName = new JTextField();
        this._txfName.setToolTipText(Messages.getString((String)"LoadJava.PrimaryNameTooltip"));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 3;
        jPanel2.add((Component)this._txfName, gridBagConstraints);
        this.m_cmbJavaType = new JComboBox<String>(new String[]{Messages.getString((String)"LoadJava.31"), Messages.getString((String)"LoadJava.21"), Messages.getString((String)"LoadJava.22"), Messages.getString((String)"LoadJava.23")});
        this.m_cmbJavaType.setToolTipText(Messages.getString((String)"LoadJava.TypeTooltip"));
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (Messages.getString((String)"LoadJava.31").equals(LoadJava.this.m_cmbJavaType.getSelectedItem())) {
                    LoadJava.this._txaCode.setEditable(true);
                    LoadJava.this._txaCode.setEnabled(true);
                    LoadJava.this.m_btnBrowseLocal.setEnabled(true);
                    LoadJava.this.m_txfFilePath.setEditable(false);
                    LoadJava.this.m_txfFilePath.setEnabled(false);
                    LoadJava.this.m_btnBrowse.setEnabled(false);
                } else {
                    LoadJava.this._txaCode.setEditable(false);
                    LoadJava.this._txaCode.setEnabled(false);
                    LoadJava.this.m_btnBrowseLocal.setEnabled(false);
                    LoadJava.this.m_txfFilePath.setEditable(true);
                    LoadJava.this.m_txfFilePath.setEnabled(true);
                    LoadJava.this.m_btnBrowse.setEnabled(true);
                }
                if (Messages.getString((String)"LoadJava.22").equals(LoadJava.this.m_cmbJavaType.getSelectedItem())) {
                    LoadJava.this._txfName.setEnabled(false);
                    LoadJava.this._txfName.setEditable(false);
                } else {
                    LoadJava.this._txfName.setEnabled(true);
                    LoadJava.this._txfName.setEditable(true);
                }
            }
        };
        this.m_cmbJavaType.addItemListener(itemListener);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)new JLabel(Messages.getString((String)"LoadJava.24")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel2.add((Component)this.m_cmbJavaType, gridBagConstraints);
        this.createDBDirBrowser(jPanel2, gridBagConstraints);
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)new JLabel(Messages.getString((String)"LoadJava.25")), "North");
        this._txaCode = new JTextArea();
        this._txaCode.setDisabledTextColor(this._txaCode.getBackground());
        this._txaCode.setToolTipText(Messages.getString((String)"LoadJava.SourceCodeTooltip"));
        jPanel3.add((Component)new JScrollPane(this._txaCode), "Center");
        this.createFileBrowser(jPanel3);
        jPanel.add((Component)jPanel3, "Center");
        this.m_cmbJavaType.setSelectedIndex(-1);
        this.m_cmbJavaType.setSelectedIndex(0);
        return jPanel;
    }

    private void createFileBrowser(JPanel jPanel) {
        this.m_btnBrowseLocal = new JButton(Messages.getString((String)"LoadJava.BrowseLocal"));
        this.m_btnBrowseLocal.setToolTipText(Messages.getString((String)"LoadJava.BrowseLocalTooltip"));
        JPanel jPanel2 = new JPanel(new FlowLayout(2));
        jPanel2.add(this.m_btnBrowseLocal);
        jPanel.add((Component)jPanel2, "South");
        this.m_btnBrowseLocal.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                URLFileChooser uRLFileChooser = new URLFileChooser();
                uRLFileChooser.clearChooseableURLFilters();
                uRLFileChooser.setSelectionScope(0);
                uRLFileChooser.setSelectionMode(0);
                uRLFileChooser.addChooseableURLFilter((URLFilter)new DefaultURLFilter(Messages.getString((String)"LoadJava.JavaFiles"), new String[]{"java", ".JAVA"}));
                if (LoadJava.this.m_txfFilePath.getText().trim().length() > 0) {
                    try {
                        uRLFileChooser.setSelectedURL(new File(LoadJava.this.m_txfFilePath.getText()).toURI().toURL());
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                if ((n = uRLFileChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString((String)"LoadJava.JavaFiles"))) == 0) {
                    LoadJava.this.s_selectedLocalFileURL = uRLFileChooser.getSelectedURL();
                    BufferedReader bufferedReader = null;
                    try {
                        FileInputStream fileInputStream = new FileInputStream(LoadJava.this.s_selectedLocalFileURL.getFile());
                        String string = IdeUtil.getIdeEncoding();
                        if (string == null) {
                            string = "UTF-8";
                        }
                        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, string);
                        bufferedReader = new BufferedReader(inputStreamReader);
                        LoadJava.this._txaCode.setText("");
                        char[] cArray = new char[1000];
                        int n2 = -1;
                        while ((n2 = bufferedReader.read(cArray)) >= 0) {
                            LoadJava.this._txaCode.append(String.valueOf(cArray, 0, n2));
                        }
                    }
                    catch (Exception exception) {
                        String string = ((ActionEvent)LoadJava.this.getContext().getEvent()).getActionCommand();
                        MessageDialog.error((Component)LoadJava.this.m_txfFilePath, (Object)exception.getMessage(), (String)string, (String)"f1_load_java");
                    }
                    finally {
                        if (bufferedReader != null) {
                            try {
                                bufferedReader.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
            }
        });
    }

    private void createDBDirBrowser(JPanel jPanel, GridBagConstraints gridBagConstraints) {
        this.m_txfFilePath = new JTextField();
        if (s_selectedURL != null && s_selectedURL.toString().length() > 0) {
            this.m_txfFilePath.setText(s_selectedURL);
        }
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)new JLabel(Messages.getString((String)"LoadJava.SelectedFile")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.m_txfFilePath, gridBagConstraints);
        this.m_txfFilePath.setToolTipText(Messages.getString((String)"LoadJava.DirectoryNameTooltip"));
        this.m_btnBrowse = new JButton(Messages.getString((String)"LoadJava.Browse"));
        this.m_btnBrowse.setToolTipText(Messages.getString((String)"LoadJava.BrowseServerTooltip"));
        this.m_btnBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Connection connection = LoadJava.this.getDBObject().getConnection();
                BFileInsertPanel bFileInsertPanel = new BFileInsertPanel(connection, null, "");
                HelpSystem.getHelpSystem().registerTopic((JComponent)bFileInsertPanel, "f1_load_java");
                JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)bFileInsertPanel, (Component)bFileInsertPanel, (String)ControlsArb.getString("RESULTSET_EDIT_VALUE_TITLE"));
                jEWTDialog.setResizable(true);
                jEWTDialog.setOKButtonEnabled(true);
                if (WizardLauncher.runDialog((JDialog)jEWTDialog)) {
                    String string = bFileInsertPanel.getDir();
                    String string2 = bFileInsertPanel.getFile();
                    if (string != null && string2 != null) {
                        s_selectedURL = string + "/" + string2;
                    } else {
                        s_selectedURL = "";
                    }
                    if (s_selectedURL != null && s_selectedURL.toString().length() > 0) {
                        LoadJava.this.m_txfFilePath.setText(s_selectedURL);
                    }
                }
            }
        });
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)this.m_btnBrowse, gridBagConstraints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEnabled(Context context) {
        Connection connection = this.getDBObject().getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            if (!Connections.getInstance().lock(connection, false)) {
                boolean bl = false;
                return bl;
            }
            String string = "select dbms_java.longname('foo') from dual";
            statement = connection.prepareStatement(string);
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                throw new RuntimeException("");
            }
            Connections.getInstance().unlock(connection);
        }
        return false;
    }
}

