/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ddl;

import javax.swing.JLabel;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.ddl.DDLResources;
import oracle.dbtools.raptor.utils.MnemonicUtil;
import oracle.ide.panels.TraversableContext;
import oracle.javatools.icons.OracleIcons;

public class DDLFormat {
    public static final int UNDEFINED = 1;
    public static final int EXPORT = 1;
    public static final int DIFF = 2;
    public static final int DEPLOY = 3;
    public static String SCHEMA = "SCHEMA";
    public static String STORAGE = "STORAGE";
    public static String TERM = "TERM";
    public static String PRETTY = "PRETTY";
    public static String BYTE = "BYTE";
    public static String FORCE = "FORCE";
    public static String ALTER = "ALTER";
    public static String DROP = "DROP";
    public static String CASCADE = "CASCADE";
    public static String GRANT = "GRANT";
    public static String DEPS = "DEPS";
    public static String CONS = "CON";
    public static String REF_CONS = "REF_CON";
    public static String TRIG = "TRIG";
    public static String TRUNCATE = "TRUNCATE";
    public static String GEN_SCHEMA = "GEN_SCHEMA";
    public static String GEN_CON = "GEN_CON";
    public static String GEN_CON_IDX = "GEN_CON_IDX";
    public static String GEN_REF_CON = "GEN_REF_CON";
    public static String GEN_PASS = "GEN_PASS";
    public static String IGN_PHYS = "IGN_PHYS";
    public static String IGN_SCHEMA = "CONSOLIDATE_SCHEMA";
    public static String MAINTAIN_SCHEMA = "MAINTAIN_SCHEMA";
    public static String IGN_SEG_ATTR = "IGN_SEG_ATTR";
    public static String IGN_STG = "IGN_STG";
    public static String IGN_TBL_COL_POS = "IGN_TBL_COL_POS";
    public static String IGN_TABLESPACE = "IGN_TABLESPACE";
    public static String MATCH_CONS_BY_NAME = "MATCH_CONS_BY_NAME";
    public static String MATCH_CONS_BY_DEF = "MATCH_CONS_BY_DEF";
    public static String RPT_CONS_NAME_DIFF = "RPT_CONS_NAME_DIFF";
    public static String STATS = "STATS";
    public static String GEN_SQL_TERM = "GEN_SQL_TERM";
    public static String GEN_COMMENTS = "GEN_COMMENTS";
    public static String IGN_PARTITIONING = "IGN_PARTITIONING";
    public static String IGN_HIGH_VALUES = "IGN_HIGH_VALUES";
    public static String LOG_COMPARE = "LOG_COMPARE";
    private boolean _extractEnabled = true;
    private boolean _segments = false;
    private boolean _terminiator = true;
    private boolean _pretty = true;
    private boolean _byte = true;
    private boolean _force = true;
    private boolean _alter = false;
    private boolean _schema = true;
    private boolean _drop = false;
    private boolean _cascade = false;
    private boolean _grant = false;
    private boolean _dep = false;
    private boolean _constraint = true;
    private boolean _refConstraint = true;
    private boolean _trigger = true;
    private boolean _truncate = false;
    private boolean _generateSchema = true;
    private boolean _generateConstraints = true;
    private boolean _generateConstraintIndexes = true;
    private boolean _generateRefConstraints = true;
    private boolean _generatePasswordValue = true;
    private boolean _generateSQLTerminator = true;
    private boolean _generateComments = false;
    private boolean _ignorePhysicalAttributes = true;
    private boolean _ignoreSchema = true;
    private boolean _ignoreSegmentAttributes = true;
    private boolean _ignoreStorage = true;
    private boolean _ignoreTableColumnPosition = true;
    private boolean _ignoreTablespace = true;
    private boolean _matchConstraintsByName = false;
    private boolean _reportConstraintNameDifferences = false;
    private boolean _statistics = false;
    private boolean _ignorePartitioning = false;
    private boolean _ignoreHighValues = false;
    private boolean _logicalCompare = true;
    private boolean _showExtractEnabled = true;
    private boolean _showSegments = false;
    private boolean _showTerminiator = true;
    private boolean _showPretty = true;
    private boolean _showByte = true;
    private boolean _showForce = true;
    private boolean _showAlter = false;
    private boolean _showSchema = true;
    private boolean _showDrop = false;
    private boolean _showCascade = false;
    private boolean _showGrant = false;
    private boolean _showDep = false;
    private boolean _showConstraint = false;
    private boolean _showRefConstraint = false;
    private boolean _showTrigger = false;
    private boolean _showTruncate = false;
    private boolean _showGenerateSchema = false;
    private boolean _showGenerateConstraints = false;
    private boolean _showGenerateConstraintIndexes = false;
    private boolean _showGenerateRefConstraints = false;
    private boolean _showGeneratePasswordValue = false;
    private boolean _showGenerateSQLTerminator = false;
    private boolean _showGenerateComments = false;
    private boolean _showIgnorePhysicalAttributes = false;
    private boolean _showIgnoreSchema = false;
    private boolean _showIgnoreSegmentAttributes = false;
    private boolean _showIgnoreStorage = false;
    private boolean _showIgnoreTableColumnPosition = false;
    private boolean _showIgnoreTablespace = false;
    private boolean _showMatchConstraintsByName = false;
    private boolean _showReportConstraintNameDifferences = false;
    private boolean _showStatistics = false;
    private boolean _showIgnorePartitioning = false;
    private boolean _showIgnoreHighValues = false;
    private boolean _showLogicalCompare = false;
    private int _preference = 1;

    public DDLFormat() {
        this.initFormat();
    }

    public DDLFormat(int n) {
        this._preference = n;
        this.initFormat();
    }

    public int getPreference() {
        return this._preference;
    }

    public void setAllOptionsEnabled(boolean bl) {
        this.setDDLOptionsEnabled(bl);
        this.setCompareOptionsEnabled(bl);
    }

    public void setDDLOptionsEnabled(boolean bl) {
        this._extractEnabled = bl;
        this._segments = bl;
        this._terminiator = bl;
        this._pretty = bl;
        this._byte = bl;
        this._force = bl;
        this._alter = bl;
        this._schema = bl;
        this._drop = bl;
        this._cascade = bl;
        this._grant = bl;
        this._dep = bl;
        this._constraint = bl;
        this._refConstraint = bl;
        this._trigger = bl;
        this._truncate = bl;
    }

    public void setCompareOptionsEnabled(boolean bl) {
        this._generateSchema = bl;
        this._generateConstraints = bl;
        this._generateConstraintIndexes = bl;
        this._generateRefConstraints = bl;
        this._generatePasswordValue = bl;
        this._generateSQLTerminator = bl;
        this._generateComments = bl;
        this._ignorePhysicalAttributes = bl;
        this._ignoreSchema = bl;
        this._ignoreSegmentAttributes = bl;
        this._ignoreStorage = bl;
        this._ignoreTableColumnPosition = bl;
        this._ignoreTablespace = bl;
        this._matchConstraintsByName = bl;
        this._reportConstraintNameDifferences = bl;
        this._statistics = bl;
        this._ignorePartitioning = bl;
        this._ignoreHighValues = bl;
        this._logicalCompare = bl;
    }

    public void setShowDDLOptionsEnabled(boolean bl) {
        this._showExtractEnabled = bl;
        this._showSegments = bl;
        this._showTerminiator = bl;
        this._showPretty = bl;
        this._showByte = bl;
        this._showForce = bl;
        this._showAlter = bl;
        this._showSchema = bl;
        this._showDrop = bl;
        this._showCascade = bl;
        this._showGrant = bl;
        this._showDep = bl;
        this._showConstraint = bl;
        this._showRefConstraint = bl;
        this._showTrigger = bl;
    }

    public void setShowGenerateOptionsEnabled(boolean bl) {
        this._showGenerateSchema = bl;
        this._showGenerateConstraints = bl;
        this._showGenerateConstraintIndexes = bl;
        this._showGenerateRefConstraints = bl;
        this._showGeneratePasswordValue = bl;
        this._showGenerateSQLTerminator = bl;
        this._showGenerateComments = bl;
    }

    public void setShowCompareOptionsEnabled(boolean bl) {
        this._showIgnorePhysicalAttributes = bl;
        this._showIgnoreSchema = bl;
        this._showIgnoreSegmentAttributes = bl;
        this._showIgnoreStorage = bl;
        this._showIgnoreTableColumnPosition = bl;
        this._showIgnoreTablespace = bl;
        this._showMatchConstraintsByName = bl;
        this._showReportConstraintNameDifferences = bl;
        this._showStatistics = bl;
        this._showIgnorePartitioning = bl;
        this._showIgnoreHighValues = bl;
        this._showLogicalCompare = bl;
    }

    public boolean isExtractEnabled() {
        return this._extractEnabled;
    }

    public void isExtractEnabled(boolean bl) {
        this._extractEnabled = bl;
    }

    public void setAlter(boolean bl) {
        this._alter = bl;
    }

    public void setDrop(boolean bl) {
        this._drop = bl;
    }

    public void setCascade(boolean bl) {
        this._cascade = bl;
    }

    public void setByte(boolean bl) {
        this._byte = bl;
    }

    public void setForce(boolean bl) {
        this._force = bl;
    }

    public void setPretty(boolean bl) {
        this._pretty = bl;
    }

    public void setSchema(boolean bl) {
        this._schema = bl;
    }

    public void setSegments(boolean bl) {
        this._segments = bl;
    }

    public void setTerminiator(boolean bl) {
        this._terminiator = bl;
    }

    public void setGrant(boolean bl) {
        this._grant = bl;
    }

    public void setDep(boolean bl) {
        this._dep = bl;
    }

    public void setConstraint(boolean bl) {
        this._constraint = bl;
    }

    public void setRefConstraint(boolean bl) {
        this._refConstraint = bl;
    }

    public void setTrigger(boolean bl) {
        this._trigger = bl;
    }

    public void setTruncate(boolean bl) {
        this._truncate = bl;
    }

    public void setGenerateSchema(boolean bl) {
        this._generateSchema = bl;
    }

    public void setGenerateConstraints(boolean bl) {
        this._generateConstraints = bl;
    }

    public void setGenerateConstraintIndexes(boolean bl) {
        this._generateConstraintIndexes = bl;
    }

    public void setGenerateRefConstraints(boolean bl) {
        this._generateRefConstraints = bl;
    }

    public void setGeneratePasswordValue(boolean bl) {
        this._generatePasswordValue = bl;
    }

    public void setGenerateSQLTerminator(boolean bl) {
        this._generateSQLTerminator = bl;
    }

    public void setGenerateComments(boolean bl) {
        this._generateComments = bl;
    }

    public void setIgnorePhysicalAttributes(boolean bl) {
        this._ignorePhysicalAttributes = bl;
    }

    public void setIgnoreSchema(boolean bl) {
        this._ignoreSchema = bl;
    }

    public void setIgnoreSegmentAttributes(boolean bl) {
        this._ignoreSegmentAttributes = bl;
    }

    public void setIgnoreStorage(boolean bl) {
        this._ignoreStorage = bl;
    }

    public void setIgnoreTableColumnPosition(boolean bl) {
        this._ignoreTableColumnPosition = bl;
    }

    public void setIgnoreTablespace(boolean bl) {
        this._ignoreTablespace = bl;
    }

    public void setMatchConstraintsByName(boolean bl) {
        this._matchConstraintsByName = bl;
    }

    public void setReportConstraintNameDifferences(boolean bl) {
        this._reportConstraintNameDifferences = bl;
    }

    public void setStatistics(boolean bl) {
        this._statistics = bl;
    }

    public void setIgnorePartitioning(boolean bl) {
        this._ignorePartitioning = bl;
    }

    public void setIgnoreHighValues(boolean bl) {
        this._ignoreHighValues = bl;
    }

    public void setLogicalCompare(boolean bl) {
        this._logicalCompare = bl;
    }

    public boolean getGrant() {
        return this._grant;
    }

    public boolean getAlter() {
        return this._alter;
    }

    public boolean getDrop() {
        return this._drop;
    }

    public boolean getCascade() {
        return this._cascade;
    }

    public boolean getByte() {
        return this._byte;
    }

    public boolean getForce() {
        return this._force;
    }

    public boolean getPretty() {
        return this._pretty;
    }

    public boolean getSchema() {
        return this._schema;
    }

    public boolean getSegments() {
        return this._segments;
    }

    public boolean getTerminator() {
        return this._terminiator;
    }

    public boolean getDep() {
        return this._dep;
    }

    public boolean getConstraint() {
        return this._constraint;
    }

    public boolean getRefConstraint() {
        return this._refConstraint;
    }

    public boolean getTrigger() {
        return this._trigger;
    }

    public boolean getTruncate() {
        return this._truncate;
    }

    public boolean getGenerateSchema() {
        return this._generateSchema;
    }

    public boolean getGenerateConstraints() {
        return this._generateConstraints;
    }

    public boolean getGenerateConstraintIndexes() {
        return this._generateConstraintIndexes;
    }

    public boolean getGenerateRefConstraints() {
        return this._generateRefConstraints;
    }

    public boolean getGeneratePasswordValue() {
        return this._generatePasswordValue;
    }

    public boolean getGenerateSQLTerminator() {
        return this._generateSQLTerminator;
    }

    public boolean getGenerateComments() {
        return this._generateComments;
    }

    public boolean getIgnorePhysicalAttributes() {
        return this._ignorePhysicalAttributes;
    }

    public boolean getIgnoreSchema() {
        return this._ignoreSchema;
    }

    public boolean getIgnoreSegmentAttributes() {
        return this._ignoreSegmentAttributes;
    }

    public boolean getIgnoreStorage() {
        return this._ignoreStorage;
    }

    public boolean getIgnoreTableColumnPosition() {
        return this._ignoreTableColumnPosition;
    }

    public boolean getIgnoreTablespace() {
        return this._ignoreTablespace;
    }

    public boolean getMatchConstraintsByName() {
        return this._matchConstraintsByName;
    }

    public boolean getReportConstraintNameDifferences() {
        return this._reportConstraintNameDifferences;
    }

    public boolean getStatistics() {
        return this._statistics;
    }

    public boolean getIgnorePartitioning() {
        return this._ignorePartitioning;
    }

    public boolean getIgnoreHighValues() {
        return this._ignoreHighValues;
    }

    public boolean getLogicalCompare() {
        return this._logicalCompare;
    }

    public boolean isShowExtractEnabled() {
        return this._showExtractEnabled;
    }

    public void isShowExtractEnabled(boolean bl) {
        this._showExtractEnabled = bl;
    }

    public void setShowAlter(boolean bl) {
        this._showAlter = bl;
    }

    public void setShowDrop(boolean bl) {
        this._showDrop = bl;
    }

    public void setShowCascade(boolean bl) {
        this._showCascade = bl;
    }

    public void setShowByte(boolean bl) {
        this._showByte = bl;
    }

    public void setShowForce(boolean bl) {
        this._showForce = bl;
    }

    public void setShowPretty(boolean bl) {
        this._showPretty = bl;
    }

    public void setShowSchema(boolean bl) {
        this._showSchema = bl;
    }

    public void setShowSegments(boolean bl) {
        this._showSegments = bl;
    }

    public void setShowTerminiator(boolean bl) {
        this._showTerminiator = bl;
    }

    public void setShowGrant(boolean bl) {
        this._showGrant = bl;
    }

    public void setShowDep(boolean bl) {
        this._showDep = bl;
    }

    public void setShowConstraint(boolean bl) {
        this._showConstraint = bl;
    }

    public void setShowRefConstraint(boolean bl) {
        this._showRefConstraint = bl;
    }

    public void setShowTrigger(boolean bl) {
        this._showTrigger = bl;
    }

    public void setShowTruncate(boolean bl) {
        this._showTruncate = bl;
    }

    public void setShowGenerateSchema(boolean bl) {
        this._showGenerateSchema = bl;
    }

    public void setShowGenerateConstraints(boolean bl) {
        this._showGenerateConstraints = bl;
    }

    public void setShowGenerateConstraintIndexes(boolean bl) {
        this._showGenerateConstraintIndexes = bl;
    }

    public void setShowGenerateRefConstraints(boolean bl) {
        this._showGenerateRefConstraints = bl;
    }

    public void setShowGeneratePasswordValue(boolean bl) {
        this._showGeneratePasswordValue = bl;
    }

    public void setShowGenerateSQLTerminator(boolean bl) {
        this._showGenerateSQLTerminator = bl;
    }

    public void setShowGenerateComments(boolean bl) {
        this._showGenerateComments = bl;
    }

    public void setShowIgnorePhysicalAttributes(boolean bl) {
        this._showIgnorePhysicalAttributes = bl;
    }

    public void setShowIgnoreSchema(boolean bl) {
        this._showIgnoreSchema = bl;
    }

    public void setShowIgnoreSegmentAttributes(boolean bl) {
        this._showIgnoreSegmentAttributes = bl;
    }

    public void setShowIgnoreStorage(boolean bl) {
        this._showIgnoreStorage = bl;
    }

    public void setShowIgnoreTableColumnPosition(boolean bl) {
        this._showIgnoreTableColumnPosition = bl;
    }

    public void setShowIgnoreTablespace(boolean bl) {
        this._showIgnoreTablespace = bl;
    }

    public void setShowMatchConstraintsByName(boolean bl) {
        this._showMatchConstraintsByName = bl;
    }

    public void setShowReportConstraintNameDifferences(boolean bl) {
        this._showReportConstraintNameDifferences = bl;
    }

    public void setShowStatistics(boolean bl) {
        this._showStatistics = bl;
    }

    public void setShowIgnorePartioning(boolean bl) {
        this._showIgnorePartitioning = bl;
    }

    public void setShowIgnoreHighValues(boolean bl) {
        this._showIgnoreHighValues = bl;
    }

    public void setShowLogicalCompare(boolean bl) {
        this._showLogicalCompare = bl;
    }

    public boolean getShowGrant() {
        return this._showGrant;
    }

    public boolean getShowAlter() {
        return this._showAlter;
    }

    public boolean getShowDrop() {
        return this._showDrop;
    }

    public boolean getShowCascade() {
        return this._showCascade;
    }

    public boolean getShowByte() {
        return this._showByte;
    }

    public boolean getShowForce() {
        return this._showForce;
    }

    public boolean getShowPretty() {
        return this._showPretty;
    }

    public boolean getShowSchema() {
        return this._showSchema;
    }

    public boolean getShowSegments() {
        return this._showSegments;
    }

    public boolean getShowTerminator() {
        return this._showTerminiator;
    }

    public boolean getShowDep() {
        return this._showDep;
    }

    public boolean getShowConstraint() {
        return this._showConstraint;
    }

    public boolean getShowRefConstraint() {
        return this._showRefConstraint;
    }

    public boolean getShowTrigger() {
        return this._showTrigger;
    }

    public boolean getShowTruncate() {
        return this._showTruncate;
    }

    public boolean getShowGenerateSchema() {
        return this._showGenerateSchema;
    }

    public boolean getShowGenerateConstraints() {
        return this._showGenerateConstraints;
    }

    public boolean getShowGenerateConstraintIndexes() {
        return this._showGenerateConstraintIndexes;
    }

    public boolean getShowGenerateRefConstraints() {
        return this._showGenerateRefConstraints;
    }

    public boolean getShowGeneratePasswordValue() {
        return this._showGeneratePasswordValue;
    }

    public boolean getShowGenerateSQLTerminator() {
        return this._showGenerateSQLTerminator;
    }

    public boolean getShowGenerateComments() {
        return this._showGenerateComments;
    }

    public boolean getShowIgnorePhysicalAttributes() {
        return this._showIgnorePhysicalAttributes;
    }

    public boolean getShowIgnoreSchema() {
        return this._showIgnoreSchema;
    }

    public boolean getShowIgnoreSegmentAttributes() {
        return this._showIgnoreSegmentAttributes;
    }

    public boolean getShowIgnoreStorage() {
        return this._showIgnoreStorage;
    }

    public boolean getShowIgnoreTableColumnPosition() {
        return this._showIgnoreTableColumnPosition;
    }

    public boolean getShowIgnoreTablespace() {
        return this._showIgnoreTablespace;
    }

    public boolean getShowMatchConstraintsByName() {
        return this._showMatchConstraintsByName;
    }

    public boolean getShowReportConstraintNameDifferences() {
        return this._showReportConstraintNameDifferences;
    }

    public boolean getShowStatistics() {
        return this._showStatistics;
    }

    public boolean getShowIgnorePartitioning() {
        return this._showIgnorePartitioning;
    }

    public boolean getShowIgnoreHighValues() {
        return this._showIgnoreHighValues;
    }

    public boolean getShowLogicalCompare() {
        return this._showLogicalCompare;
    }

    public DefaultMutableTreeNode getSummaryNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(DDLResources.getString("DDL_OPTIONS"));
        if (this.getShowSegments()) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.getSummaryNLSItem(STORAGE, this.getSegments())));
        }
        if (this.getShowTerminator()) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.getSummaryNLSItem(TERM, this.getTerminator())));
        }
        if (this.getShowPretty()) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.getSummaryNLSItem(PRETTY, this.getPretty())));
        }
        if (this.getShowByte()) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.getSummaryNLSItem(BYTE, this.getByte())));
        }
        if (this.getShowForce()) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.getSummaryNLSItem(FORCE, this.getForce())));
        }
        if (this.getShowAlter()) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.getSummaryNLSItem(ALTER, this.getAlter())));
        }
        if (this.getShowSchema()) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.getSummaryNLSItem(SCHEMA, this.getSchema())));
        }
        if (this.getShowDrop()) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.getSummaryNLSItem(DROP, this.getDrop())));
        }
        if (this.getShowCascade()) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.getSummaryNLSItem(CASCADE, this.getCascade())));
        }
        if (this.getShowGrant()) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.getSummaryNLSItem(GRANT, this.getGrant())));
        }
        if (this.getShowDep()) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.getSummaryNLSItem(DEPS, this.getDep())));
        }
        if (this.getShowGenerateConstraints()) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.getSummaryNLSItem(GEN_CON, this.getGenerateConstraints())));
        }
        if (this.getShowGenerateConstraintIndexes()) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.getSummaryNLSItem(GEN_CON_IDX, this.getGenerateConstraintIndexes())));
        }
        if (this.getShowGenerateRefConstraints()) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.getSummaryNLSItem(GEN_REF_CON, this.getGenerateRefConstraints())));
        }
        if (this.getShowGeneratePasswordValue()) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.getSummaryNLSItem(GEN_PASS, this.getGeneratePasswordValue())));
        }
        if (this.getShowGenerateSchema()) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.getSummaryNLSItem(GEN_SCHEMA, this.getGenerateSchema())));
        }
        if (this.getShowGenerateSQLTerminator()) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.getSummaryNLSItem(GEN_SQL_TERM, this.getGenerateSQLTerminator())));
        }
        if (this.getShowGenerateComments()) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.getSummaryNLSItem(GEN_COMMENTS, this.getGenerateComments())));
        }
        if (this.getShowIgnorePhysicalAttributes()) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.getSummaryNLSItem(IGN_PHYS, this.getIgnorePhysicalAttributes())));
        }
        if (this.getShowIgnoreSchema()) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.getSummaryNLSItem(IGN_SCHEMA, this.getIgnoreSchema())));
        }
        if (this.getShowIgnoreSegmentAttributes()) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.getSummaryNLSItem(IGN_SEG_ATTR, this.getIgnoreSegmentAttributes())));
        }
        if (this.getShowIgnoreStorage()) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.getSummaryNLSItem(IGN_STG, this.getIgnoreStorage())));
        }
        if (this.getShowIgnoreTableColumnPosition()) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.getSummaryNLSItem(IGN_TBL_COL_POS, this.getIgnoreTableColumnPosition())));
        }
        if (this.getShowIgnoreTablespace()) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.getSummaryNLSItem(IGN_TABLESPACE, this.getIgnoreTablespace())));
        }
        if (this.getShowMatchConstraintsByName()) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.getSummaryNLSItem(MATCH_CONS_BY_NAME, this.getMatchConstraintsByName())));
        }
        if (this.getShowReportConstraintNameDifferences()) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.getSummaryNLSItem(RPT_CONS_NAME_DIFF, this.getReportConstraintNameDifferences())));
        }
        if (this.getShowIgnorePartitioning()) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.getSummaryNLSItem(IGN_PARTITIONING, this.getIgnorePartitioning())));
        }
        if (this.getShowIgnoreHighValues()) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.getSummaryNLSItem(IGN_HIGH_VALUES, this.getIgnoreHighValues())));
        }
        if (this.getShowLogicalCompare()) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.getSummaryNLSItem(LOG_COMPARE, this.getLogicalCompare())));
        }
        return defaultMutableTreeNode;
    }

    public static String getDisplayName(String string) {
        String string2 = MnemonicUtil.extractLabelTextWithoutMnemonic(DDLResources.getString(string));
        return string2;
    }

    public static String getLabelText(String string) {
        return DDLResources.getString(string);
    }

    public JLabel getSummaryNLSItem(String string, boolean bl) {
        JLabel jLabel = new JLabel();
        jLabel.setText(DDLFormat.getDisplayName(string));
        if (bl) {
            jLabel.setIcon(OracleIcons.getIcon((String)"check.png"));
        } else {
            jLabel.setIcon(OracleIcons.getIcon((String)"delete.png"));
        }
        return jLabel;
    }

    private void initFormat() {
        DBConfig dBConfig = DBConfig.getInstance();
        if (this._preference != 3) {
            Boolean bl = dBConfig.getBoolean("EXPORT_DDL_ENABLED");
            if (bl != null) {
                this._extractEnabled = bl;
            }
            if ((bl = dBConfig.getBoolean("DDL_SEGMENTS")) != null) {
                this._segments = bl;
            }
            if ((bl = dBConfig.getBoolean("DDL_TERMINATOR")) != null) {
                this._terminiator = bl;
            }
            if ((bl = dBConfig.getBoolean("DDL_PRETTY")) != null) {
                this._pretty = bl;
            }
            if ((bl = dBConfig.getBoolean("DDL_BYTE")) != null) {
                this._byte = bl;
            }
            if ((bl = dBConfig.getBoolean("DDL_FORCE")) != null) {
                this._force = bl;
            }
            if ((bl = dBConfig.getBoolean("DDL_ALTER")) != null) {
                this._alter = bl;
            }
            if ((bl = dBConfig.getBoolean("DDL_SCHEMA")) != null) {
                this._schema = bl;
            }
            if ((bl = dBConfig.getBoolean("EXPORT_DROP")) != null) {
                this._drop = bl;
            }
            if ((bl = dBConfig.getBoolean("EXPORT_CASCADE")) != null) {
                this._cascade = bl;
            }
            if ((bl = dBConfig.getBoolean("EXPORT_GRANT")) != null) {
                this._grant = bl;
            }
            if ((bl = dBConfig.getBoolean("EXPORT_DEP")) != null) {
                this._dep = bl;
            }
            if ((bl = dBConfig.getBoolean("DIFF_GEN_SCHEMA")) != null) {
                this._generateSchema = bl;
            }
            if ((bl = dBConfig.getBoolean("DIFF_GEN_CONSTRAINT")) != null) {
                this._generateConstraints = bl;
            }
            if ((bl = dBConfig.getBoolean("DIFF_GEN_CONSTRAINT_INDEXES")) != null) {
                this._generateConstraintIndexes = bl;
            }
            if ((bl = dBConfig.getBoolean("DIFF_GEN_REF_CONSTRAINTS")) != null) {
                this._generateRefConstraints = bl;
            }
            if ((bl = dBConfig.getBoolean("DIFF_GEN_PASS_VALUE")) != null) {
                this._generatePasswordValue = bl;
            }
            if ((bl = dBConfig.getBoolean("DIFF_GEN_SQL_TERM")) != null) {
                this._generateSQLTerminator = bl;
            }
            if ((bl = dBConfig.getBoolean("DIFF_GEN_COMMENTS")) != null) {
                this._generateComments = bl;
            }
            if ((bl = dBConfig.getBoolean("DIFF_IGN_PHYSICAL")) != null) {
                this._ignorePhysicalAttributes = bl;
            }
            if ((bl = dBConfig.getBoolean("DIFF_IGN_SCHEMA")) != null) {
                this._ignoreSchema = bl;
            }
            if ((bl = dBConfig.getBoolean("DIFF_IGN_SEGMENTS")) != null) {
                this._ignoreSegmentAttributes = bl;
            }
            if ((bl = dBConfig.getBoolean("DIFF_IGN_STORAGE")) != null) {
                this._ignoreStorage = bl;
            }
            if ((bl = dBConfig.getBoolean("DIFF_IGN_TBL_COL_POS")) != null) {
                this._ignoreTableColumnPosition = bl;
            }
            if ((bl = dBConfig.getBoolean("DIFF_IGN_TABLESPACE")) != null) {
                this._ignoreTablespace = bl;
            }
            if ((bl = dBConfig.getBoolean("DIFF_MATCH_CONSTRAINTS_NAME")) != null) {
                this._matchConstraintsByName = bl;
            }
            if ((bl = dBConfig.getBoolean("DIFF_RPT_CONSTRAINT_NAME")) != null) {
                this._reportConstraintNameDifferences = bl;
            }
            if ((bl = dBConfig.getBoolean("DIFF_STATISTICS")) != null) {
                this._statistics = bl;
            }
            if ((bl = dBConfig.getBoolean("DIFF_IGN_PARTITIONING")) != null) {
                this._ignorePartitioning = bl;
            }
            if ((bl = dBConfig.getBoolean("DIFF_IGN_HIGH_VALUES")) != null) {
                this._ignoreHighValues = bl;
            }
            if ((bl = dBConfig.getBoolean("DIFF_LOG_COMPARE")) != null) {
                this._logicalCompare = bl;
            }
        } else {
            Boolean bl = dBConfig.getBoolean("DEPLOY_DDL_SEGMENTS");
            if (bl != null) {
                this._segments = bl;
            }
            if ((bl = dBConfig.getBoolean("DEPLOY_DDL_TERMINATOR")) != null) {
                this._terminiator = bl;
            }
            if ((bl = dBConfig.getBoolean("DEPLOY_DDL_PRETTY")) != null) {
                this._pretty = bl;
            }
            if ((bl = dBConfig.getBoolean("DEPLOY_DDL_BYTE")) != null) {
                this._byte = bl;
            }
            if ((bl = dBConfig.getBoolean("DEPLOY_DDL_FORCE")) != null) {
                this._force = bl;
            }
            if ((bl = dBConfig.getBoolean("DEPLOY_DDL_SCHEMA")) != null) {
                this._schema = bl;
            }
            if ((bl = dBConfig.getBoolean("DEPLOY_EXPORT_DROP")) != null) {
                this._drop = bl;
            }
            if ((bl = dBConfig.getBoolean("DEPLOY_EXPORT_CASCADE")) != null) {
                this._cascade = bl;
            }
            if ((bl = dBConfig.getBoolean("DEPLOY_EXPORT_GRANT")) != null) {
                this._grant = bl;
            }
            if ((bl = dBConfig.getBoolean("DEPLOY_EXPORT_DEP")) != null) {
                this._dep = bl;
            }
            if ((bl = dBConfig.getBoolean("DEPLOY_EXPORT_CONSTS")) != null) {
                this._constraint = bl;
            }
            if ((bl = dBConfig.getBoolean("DEPLOY_EXPORT_REF_CONSTS")) != null) {
                this._refConstraint = bl;
            }
            if ((bl = dBConfig.getBoolean("DEPLOY_EXPORT_TRIGGERS")) != null) {
                this._trigger = bl;
            }
            if ((bl = dBConfig.getBoolean("DEPLOY_EXPORT_TRUNCATE")) != null) {
                this._truncate = bl;
            }
        }
    }

    public void saveFormat(TraversableContext traversableContext) {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        if (this._preference != 3) {
            if (this._showExtractEnabled) {
                dBConfig.putBoolean("EXPORT_DDL_ENABLED", this.isExtractEnabled());
            }
            if (this._showSegments) {
                dBConfig.putBoolean("DDL_SEGMENTS", this.getSegments());
            }
            if (this._showTerminiator) {
                dBConfig.putBoolean("DDL_TERMINATOR", this.getTerminator());
            }
            if (this._showPretty) {
                dBConfig.putBoolean("DDL_PRETTY", this.getPretty());
            }
            if (this._showByte) {
                dBConfig.putBoolean("DDL_BYTE", this.getByte());
            }
            if (this._showForce) {
                dBConfig.putBoolean("DDL_FORCE", this.getForce());
            }
            if (this._showAlter) {
                dBConfig.putBoolean("DDL_ALTER", this.getAlter());
            }
            if (this._showSchema) {
                dBConfig.putBoolean("DDL_SCHEMA", this.getSchema());
            }
            if (this._showDrop) {
                dBConfig.putBoolean("EXPORT_DROP", this.getDrop());
            }
            if (this._showCascade) {
                dBConfig.putBoolean("EXPORT_CASCADE", this.getCascade());
            }
            if (this._showGrant) {
                dBConfig.putBoolean("EXPORT_GRANT", this.getGrant());
            }
            if (this._showDep) {
                dBConfig.putBoolean("EXPORT_DEP", this.getDep());
            }
            if (this._showGenerateSchema) {
                dBConfig.putBoolean("DIFF_GEN_SCHEMA", this.getGenerateSchema());
            }
            if (this._showGenerateConstraints) {
                dBConfig.putBoolean("DIFF_GEN_CONSTRAINT", this.getGenerateConstraints());
            }
            if (this._showGenerateConstraintIndexes) {
                dBConfig.putBoolean("DIFF_GEN_CONSTRAINT_INDEXES", this.getGenerateConstraintIndexes());
            }
            if (this._showGenerateRefConstraints) {
                dBConfig.putBoolean("DIFF_GEN_REF_CONSTRAINTS", this.getGenerateRefConstraints());
            }
            if (this._showGeneratePasswordValue) {
                dBConfig.putBoolean("DIFF_GEN_PASS_VALUE", this.getGeneratePasswordValue());
            }
            if (this._showGenerateSQLTerminator) {
                dBConfig.putBoolean("DIFF_GEN_SQL_TERM", this.getGenerateSQLTerminator());
            }
            if (this._showGenerateComments) {
                dBConfig.putBoolean("DIFF_GEN_COMMENTS", this.getGenerateComments());
            }
            if (this._showIgnorePhysicalAttributes) {
                dBConfig.putBoolean("DIFF_IGN_PHYSICAL", this.getIgnorePhysicalAttributes());
            }
            if (this._showIgnoreSchema) {
                dBConfig.putBoolean("DIFF_IGN_SCHEMA", this.getIgnoreSchema());
            }
            if (this._showIgnoreSegmentAttributes) {
                dBConfig.putBoolean("DIFF_IGN_SEGMENTS", this.getIgnoreSegmentAttributes());
            }
            if (this._showIgnoreStorage) {
                dBConfig.putBoolean("DIFF_IGN_STORAGE", this.getIgnoreStorage());
            }
            if (this._showIgnoreTableColumnPosition) {
                dBConfig.putBoolean("DIFF_IGN_TBL_COL_POS", this.getIgnoreTableColumnPosition());
            }
            if (this._showIgnoreTablespace) {
                dBConfig.putBoolean("DIFF_IGN_TABLESPACE", this.getIgnoreTablespace());
            }
            if (this._showMatchConstraintsByName) {
                dBConfig.putBoolean("DIFF_MATCH_CONSTRAINTS_NAME", this.getMatchConstraintsByName());
            }
            if (this._showReportConstraintNameDifferences) {
                dBConfig.putBoolean("DIFF_RPT_CONSTRAINT_NAME", this.getReportConstraintNameDifferences());
            }
            if (this._showStatistics) {
                dBConfig.putBoolean("DIFF_STATISTICS", this.getStatistics());
            }
            if (this._showIgnorePartitioning) {
                dBConfig.putBoolean("DIFF_IGN_PARTITIONING", this.getIgnorePartitioning());
            }
            if (this._showIgnoreHighValues) {
                dBConfig.putBoolean("DIFF_IGN_HIGH_VALUES", this.getIgnoreHighValues());
            }
            if (this._showLogicalCompare) {
                dBConfig.putBoolean("DIFF_LOG_COMPARE", this.getLogicalCompare());
            }
        } else {
            if (this._showSegments) {
                dBConfig.putBoolean("DEPLOY_DDL_SEGMENTS", this.getSegments());
            }
            if (this._showTerminiator) {
                dBConfig.putBoolean("DEPLOY_DDL_TERMINATOR", this.getTerminator());
            }
            if (this._showPretty) {
                dBConfig.putBoolean("DEPLOY_DDL_PRETTY", this.getPretty());
            }
            if (this._showByte) {
                dBConfig.putBoolean("DEPLOY_DDL_BYTE", this.getByte());
            }
            if (this._showForce) {
                dBConfig.putBoolean("DEPLOY_DDL_FORCE", this.getForce());
            }
            if (this._showSchema) {
                dBConfig.putBoolean("DEPLOY_DDL_SCHEMA", this.getSchema());
            }
            if (this._showDrop) {
                dBConfig.putBoolean("DEPLOY_EXPORT_DROP", this.getDrop());
            }
            if (this._showCascade) {
                dBConfig.putBoolean("DEPLOY_EXPORT_CASCADE", this.getCascade());
            }
            if (this._showGrant) {
                dBConfig.putBoolean("DEPLOY_EXPORT_GRANT", this.getGrant());
            }
            if (this._showDep) {
                dBConfig.putBoolean("DEPLOY_EXPORT_DEP", this.getDep());
            }
            if (this._showConstraint) {
                dBConfig.putBoolean("DEPLOY_EXPORT_CONSTS", this.getConstraint());
            }
            if (this._showRefConstraint) {
                dBConfig.putBoolean("DEPLOY_EXPORT_REF_CONSTS", this.getRefConstraint());
            }
            if (this._showTrigger) {
                dBConfig.putBoolean("DEPLOY_EXPORT_TRIGGERS", this.getTrigger());
            }
            if (this._showTruncate) {
                dBConfig.putBoolean("DEPLOY_EXPORT_TRUNCATE", this.getTruncate());
            }
        }
    }
}

