/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.databasecopy.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.databasecopy.wizard.CopyDatabaseCommon;
import oracle.dbtools.raptor.databasecopy.wizard.CopyWizArb;
import oracle.dbtools.raptor.extract.models.ExtractListModel;
import oracle.dbtools.raptor.extract.ui.wizard.ExtractWizSchemaSelector;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.panels.ShuttlePanel;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class CopyWizSchemaSelectorPanel
extends ExtractWizSchemaSelector {
    private static final long serialVersionUID = 1L;
    private boolean m_getChkbxCopyDDL = false;
    private boolean m_getChkbxCopyData = false;
    private ExtractListModel m_listModel;
    private final JCheckBox m_chkbxToSummary = new JCheckBox();
    private JWrappedLabel m_initialText = new JWrappedLabel();
    private JLabel sourceSchemaDesc = new JLabel(CopyWizArb.getString("SOURCE_SCHEMA_DESC"));
    private JLabel selectedSchemaDesc = new JLabel(CopyWizArb.getString("SELECTED_SCHEMA_DESC"));
    private boolean cbGoToSummaryFlag = true;
    List<String> m_schemaL = null;
    List<String> m_schemaSelected = null;
    private ArrayList<String> m_excludeSchemas = new ArrayList<String>(Arrays.asList("SYS", "SYSTEM"));

    @Override
    public void onEntry(TraversableContext traversableContext) {
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(true));
        this.m_listModel = (ExtractListModel)traversableContext.get("EXTRACT_LIST_MODEL");
        if (this._dataContext == null) {
            this._dataContext = traversableContext;
            this.buildUIPanel();
        } else {
            this.refreshPanel();
        }
        Boolean bl = (Boolean)traversableContext.get("DATABASE_COPY_DDL_ENABLED");
        this.m_getChkbxCopyDDL = bl;
        Boolean bl2 = (Boolean)traversableContext.get("DATABASE_COPY_DATA_ENABLED");
        this.m_getChkbxCopyData = bl2;
        this.m_initialText.setText(StringUtils.stripMnemonic((String)CopyWizArb.getString("SELECT_SCHEMA_DESC")));
        this.m_chkbxToSummary.setText(StringUtils.stripMnemonic((String)CopyWizArb.getString("GOTO_SUMMARY")));
        this.m_chkbxToSummary.setEnabled(true);
        this._dataContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        this._dataContext.getWizardCallbacks().wizardSetInitialFocus((Component)((Object)this));
    }

    @Override
    public void onExit(TraversableContext traversableContext) throws TraversalException {
        String string;
        this._dataContext = traversableContext;
        if (traversableContext.getDirection() == 1 && (this.dp.getSelected() == null || this.dp.getSelected().size() == 0)) {
            throw new TraversalException(CopyWizArb.getString("NO_SCHEMA_SELECTED"));
        }
        this.m_schemaSelected = this.dp.getSelected();
        String[] stringArray = new String[this.m_schemaSelected.size()];
        this.m_schemaSelected.toArray(stringArray);
        if (traversableContext.getDirection() == 1 && ((Boolean)traversableContext.get("MAINTAIN_SCHEMAS")).booleanValue() && !(string = this.validateDestinationSchemas((String)traversableContext.get("DATABASE_COPY_DESTINATION_CONNECTION_NAME"), stringArray)).equals("")) {
            throw new TraversalException(MessageFormat.format(CopyWizArb.getString("NO_SCHEMAS_AVAILABLE"), string), CopyWizArb.getString("NO_SCHEMAS_TITLE"));
        }
        traversableContext.put("EXTRACT_SCHEMA_LIST", this.m_schemaSelected);
        if (this.m_listModel.getSchemas() != null) {
            if (CopyDatabaseCommon.compareStringList(this.m_listModel.getSchemas(), stringArray)) {
                traversableContext.put("EXTRACT_LIST_UPDATED", (Object)false);
            } else {
                traversableContext.put("EXTRACT_LIST_UPDATED", (Object)true);
            }
        } else {
            traversableContext.put("EXTRACT_LIST_UPDATED", (Object)false);
        }
        this.m_listModel.setSchemas(stringArray);
        super.onExit(traversableContext);
    }

    private void buildUIPanel() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        this.setLayout(new BorderLayout());
        this.m_schemaL = this.getSourceSelection();
        this.m_schemaSelected = new ArrayList<String>();
        if (this.showUserOnly()) {
            this.m_schemaSelected = this.m_schemaL;
            this.m_schemaL = new ArrayList<String>();
        } else {
            object4 = (List)this._dataContext.get("EXTRACT_SCHEMA_LIST");
            if (object4 != null) {
                object3 = this.m_schemaSelected;
                object2 = this.m_schemaL;
                object = object4.iterator();
                while (object.hasNext()) {
                    String string = (String)object.next();
                    if (object3.contains(string)) continue;
                    object3.add((String)string);
                    if (!object2.contains(string)) continue;
                    object2.remove(string);
                }
                this.m_schemaSelected = object3;
                this.m_schemaL = object2;
            }
        }
        this.dp = new ShuttlePanel(this.m_schemaL, this.m_schemaSelected);
        object4 = new JPanel();
        ((Container)object4).setLayout(new BorderLayout());
        ((Container)object4).add((Component)this.m_initialText, "North");
        object3 = new JPanel();
        ((Container)object3).setLayout(new BorderLayout());
        ((Container)object3).add((Component)this.m_chkbxToSummary, "West");
        this.add((Component)object4, "North");
        this.add((Component)object3, "South");
        object2 = new JPanel();
        ((Container)object2).setLayout(new GridBagLayout());
        ((Container)object2).add((Component)this.sourceSchemaDesc, new GridBagConstraints(0, 0, 1, 1, 2.0, 0.0, 21, 2, new Insets(6, 0, 0, 0), 0, 0));
        ((Container)object2).add((Component)this.selectedSchemaDesc, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 22, 2, new Insets(6, 5, 0, 0), 0, 0));
        ((Container)object2).add((Component)this.dp.getPanel(), new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 21, 1, new Insets(6, 0, 0, 0), 0, 0));
        object = new JPanel();
        ((Container)object2).add((Component)object, LayoutControl.GBC.gbc(0, 1, 1, 1, LayoutControl.GBC.Inset.LINE_CONTROL2BUTTON_COMP, LayoutControl.GBC.Fill.NONE, LayoutControl.GBC.Spring.Y));
        ((JComponent)object).setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)object2, "Center");
    }

    private void refreshPanel() {
        this.removeAll();
        this.buildUIPanel();
    }

    @Override
    public Object getExitTransition() {
        return this.getTransition();
    }

    private Object getTransition() {
        if (this.m_chkbxToSummary.isSelected()) {
            return "Finish";
        }
        if (this.m_getChkbxCopyDDL) {
            return "TransitionSpecifyObjectTypes";
        }
        if (this.m_getChkbxCopyData) {
            return "TransitionData";
        }
        return "Finish";
    }

    protected String validateDestinationSchemas(String string, String[] stringArray) {
        boolean bl = false;
        Object var4_4 = null;
        String string2 = "";
        List<String> list = this.getDestinationSchemas(string);
        Iterator<String> iterator = list.iterator();
        for (int i = 0; i < stringArray.length; ++i) {
            if (list.contains(stringArray[i])) continue;
            string2 = string2 + " " + stringArray[i] + ",";
        }
        if (!string2.equals("")) {
            return string2.substring(0, string2.lastIndexOf(","));
        }
        return string2;
    }

    protected List<String> getDestinationSchemas(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        DBUtil dBUtil = DBUtil.getInstance((String)string);
        String string2 = "select username from all_users order by username";
        String string3 = null;
        List list = dBUtil.executeReturnList(string2, null);
        for (Map map : list) {
            string3 = (String)map.get("USERNAME");
            if (string3 == null || this.m_excludeSchemas.contains(string3)) continue;
            arrayList.add(string3);
        }
        return arrayList;
    }

    @Override
    protected List<String> getSourceSelection() {
        ArrayList<String> arrayList = new ArrayList<String>();
        DBUtil dBUtil = DBUtil.getInstance((String)this.getConnectionName());
        String string = "select username from all_users order by username";
        String string2 = null;
        if (this.showUserOnly()) {
            string = "select user USERNAME from dual";
        }
        List list = dBUtil.executeReturnList(string, null);
        for (Map map : list) {
            string2 = (String)map.get("USERNAME");
            if (string2 == null || this.m_excludeSchemas.contains(string2)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }
}

