/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.databasecopy.wizard;

import java.awt.Component;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import oracle.dbtools.raptor.databasecopy.wizard.CopyDatabaseCommon;
import oracle.dbtools.raptor.databasecopy.wizard.CopyWizArb;
import oracle.dbtools.raptor.databasecopy.wizard.CopyWizDBSelectorPanel;
import oracle.dbtools.raptor.databasecopy.wizard.CopyWizDataPanel;
import oracle.dbtools.raptor.databasecopy.wizard.CopyWizObjectTypesPanel;
import oracle.dbtools.raptor.databasecopy.wizard.CopyWizSchemaSelectorPanel;
import oracle.dbtools.raptor.databasecopy.wizard.CopyWizSpecifyObjectsPanel;
import oracle.dbtools.raptor.databasecopy.wizard.CopyWizSummaryPage;
import oracle.dbtools.raptor.databasecopy.wizard.CopyWizTableSpacePanel;
import oracle.dbtools.raptor.extract.models.ExtractListModel;
import oracle.dbtools.raptor.navigator.DatabaseConnection;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.FSM;
import oracle.ide.wizard.FSMBuilder;
import oracle.ide.wizard.FSMInvalidException;
import oracle.ide.wizard.FSMWizard;
import oracle.ide.wizard.Step;

public class CopyWizMain {
    public static final String COPY_WIZ_NAME = "raptor.copyWizard";
    public static final int COPY_WIZ_ACTION = Ide.findOrCreateCmdID((String)"raptor.copyWizard");
    private static CopyWizMain INSTANCE;
    private static Context m_staticContext;

    public static Context getStaticContext() {
        return m_staticContext;
    }

    public void setContext(Context context) {
        m_staticContext = context;
    }

    public void setObjectFilter(ArrayList<DatabaseNode> arrayList) {
        if (m_staticContext == null) {
            m_staticContext = new Context();
        }
        try {
            m_staticContext.setProperty("OBJECT_FILTER", arrayList);
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public void setConnections(DatabaseConnection databaseConnection, DatabaseConnection databaseConnection2) {
        if (m_staticContext == null) {
            m_staticContext = new Context();
        }
        try {
            m_staticContext.setProperty("DATABASE_COPY_SOURCE_CONNECTION_NAME", (Object)databaseConnection.getQualifiedConnectionName());
            m_staticContext.setProperty("DATABASE_COPY_DESTINATION_CONNECTION_NAME", (Object)databaseConnection2.getQualifiedConnectionName());
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public static void initMenu() {
        IdeAction ideAction = IdeAction.get((int)COPY_WIZ_ACTION);
        Menubar menubar = Ide.getMenubar();
        JMenuItem jMenuItem = menubar.createMenuItem((ToggleAction)ideAction, 1.0f);
        jMenuItem.setIcon(null);
        menubar.add((Component)jMenuItem, MenuManager.getJMenu((String)"Tools"));
    }

    public static CopyWizMain getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CopyWizMain();
        }
        return INSTANCE;
    }

    public void launchDatabaseCopyTool() {
        FSM fSM = CopyWizMain.getFSMforDatabaseCopyTool();
        this.launchWizard(fSM, CopyDatabaseCommon.CONNECT_PAGE_ID, new ExtractListModel());
    }

    public void launchWizard(FSM fSM, String string, ExtractListModel extractListModel) {
        Object object;
        Namespace namespace = new Namespace();
        namespace.put("WIZARD_TYPE", (Object)string);
        if (extractListModel == null) {
            namespace.put("EXTRACT_LIST_MODEL", (Object)new ExtractListModel());
        } else {
            namespace.put("EXTRACT_LIST_MODEL", (Object)extractListModel);
        }
        namespace.put("CONNECTION_NAME", (Object)extractListModel.getSourceConnName());
        if (m_staticContext != null) {
            object = m_staticContext.getProperty("DATABASE_COPY_SOURCE_CONNECTION_NAME");
            if (object != null) {
                namespace.put("DATABASE_COPY_SOURCE_CONNECTION_NAME", object);
            }
            if ((object = m_staticContext.getProperty("DATABASE_COPY_DESTINATION_CONNECTION_NAME")) != null) {
                namespace.put("DATABASE_COPY_DESTINATION_CONNECTION_NAME", object);
            }
        }
        object = new FSMWizard(fSM, namespace);
        object.setWizardTitle(CopyWizArb.getString("MAIN_TITLE"));
        object.setShowStepNumber(true);
        object.setLogoImage(CopyWizArb.getImage("WIZ_IMAGE"));
        object.setRoadmapVisible(true);
        object.setSize(800, 800);
        WizardLauncher.runDialog((JDialog)object.getDialog((Frame)Ide.getMainWindow()));
    }

    private static FSM getFSMforDatabaseCopyTool() {
        FSMBuilder fSMBuilder = new FSMBuilder();
        Step step = new Step(CopyWizArb.getString("STEP_SOURCE_DESTINATION"), CopyWizDBSelectorPanel.class, "f1_dbcopy_sourcedest_html");
        fSMBuilder.newStartState(step, null);
        fSMBuilder.addStateTrans((Object)"TransitionObjectTypes", (Object)"StateObjectTypes");
        fSMBuilder.addStateTrans((Object)"TransitionTablespaceSelector", (Object)"StateTablespaceSelector");
        fSMBuilder.addStateTrans((Object)"TransitionSchemaSelector", (Object)"StateSchemaSelector");
        fSMBuilder.addStateTrans((Object)"TransitionSpecifyObjectTypes", (Object)"StateSpecifyObjectTypes");
        fSMBuilder.addStateTrans((Object)"TransitionData", (Object)"StateData");
        fSMBuilder.addStateTrans((Object)"Finish", (Object)"StateFinish");
        Step step2 = new Step(CopyWizArb.getString("STEP_OBJECTTYPES"), CopyWizObjectTypesPanel.class, "f1_wizards_types_html");
        fSMBuilder.newState((Object)"StateObjectTypes", step2, null);
        fSMBuilder.addStateTrans((Object)"TransitionTablespaceSelector", (Object)"StateTablespaceSelector");
        fSMBuilder.addStateTrans((Object)"TransitionSchemaSelector", (Object)"StateSchemaSelector");
        fSMBuilder.addStateTrans((Object)"TransitionSpecifyObjectTypes", (Object)"StateSpecifyObjectTypes");
        fSMBuilder.addStateTrans((Object)"TransitionData", (Object)"StateData");
        fSMBuilder.addStateTrans((Object)"Finish", (Object)"StateFinish");
        Step step3 = new Step(CopyWizArb.getString("STEP_TABLESPACE_SELECTOR"), CopyWizTableSpacePanel.class, "f1_dbcopy_tablespace_html");
        fSMBuilder.newState((Object)"StateTablespaceSelector", step3, null);
        fSMBuilder.addStateTrans((Object)"TransitionSpecifyObjectTypes", (Object)"StateSpecifyObjectTypes");
        fSMBuilder.addStateTrans((Object)"TransitionData", (Object)"StateData");
        fSMBuilder.addStateTrans((Object)"Finish", (Object)"StateFinish");
        Step step4 = new Step(CopyWizArb.getString("STEP_SCHEMA_SELECTOR"), CopyWizSchemaSelectorPanel.class, "f1_dbcopy_schemas_html");
        fSMBuilder.newState((Object)"StateSchemaSelector", step4, null);
        fSMBuilder.addStateTrans((Object)"TransitionSpecifyObjectTypes", (Object)"StateSpecifyObjectTypes");
        fSMBuilder.addStateTrans((Object)"TransitionData", (Object)"StateData");
        fSMBuilder.addStateTrans((Object)"Finish", (Object)"StateFinish");
        Step step5 = new Step(CopyWizArb.getString("STEP_SPECIFY_OBJECTS"), CopyWizSpecifyObjectsPanel.class, "f1_wizards_objects_html");
        fSMBuilder.newState((Object)"StateSpecifyObjectTypes", step5, null);
        fSMBuilder.addStateTrans((Object)"TransitionData", (Object)"StateData");
        fSMBuilder.addStateTrans((Object)"Finish", (Object)"StateFinish");
        Step step6 = new Step(CopyWizArb.getString("STEP_SPECIFY_DATA"), CopyWizDataPanel.class, "f1_wizards_data_html");
        fSMBuilder.newState((Object)"StateData", step6, null);
        fSMBuilder.addStateTrans((Object)"Finish", (Object)"StateFinish");
        Step step7 = new Step(CopyWizArb.getString("STEP_SUMMARY"), CopyWizSummaryPage.class, "f1_wizards_summary_html");
        fSMBuilder.newFinalState((Object)"StateFinish", step7);
        try {
            return fSMBuilder.getFSM();
        }
        catch (FSMInvalidException fSMInvalidException) {
            return null;
        }
    }

    static {
        m_staticContext = null;
    }

    public static class CopyController
    implements Controller {
        public boolean handleEvent(IdeAction ideAction, Context context) {
            if (ideAction.getCommandId() == COPY_WIZ_ACTION) {
                CopyWizMain.getInstance().launchDatabaseCopyTool();
                return true;
            }
            return false;
        }

        public boolean update(IdeAction ideAction, Context context) {
            boolean bl = true;
            String[] stringArray = Connections.getInstance().getConnNames();
            if (stringArray != null && stringArray.length < 2) {
                bl = false;
            }
            if (ideAction.getCommandId() == COPY_WIZ_ACTION) {
                ideAction.setEnabled(bl);
                return true;
            }
            return false;
        }
    }
}

