/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.databasecopy.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.controls.OracleConnectionComboBox;
import oracle.dbtools.raptor.databasecopy.wizard.CopyWizArb;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.javatools.db.DBException;

class CopyDBConnPanel {
    private JPanel m_copyDBConnPanel = new JPanel();
    private OracleConnectionComboBox m_sourceConnSelector = new OracleConnectionComboBox();
    private OracleConnectionComboBox m_destConnSelector = new OracleConnectionComboBox();

    public CopyDBConnPanel() {
        this.m_sourceConnSelector.getJComboBox().addItemListener(new Connector(this.m_sourceConnSelector));
        this.m_sourceConnSelector.getJComboBox().setSelectedIndex(-1);
        this.m_destConnSelector.getJComboBox().addItemListener(new Connector(this.m_destConnSelector));
        this.m_destConnSelector.getJComboBox().setSelectedIndex(-1);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel(StringUtils.stripMnemonic((String)CopyWizArb.getString("S_CON_LABEL")));
        jLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)CopyWizArb.getString("S_CON_LABEL")));
        jLabel.setLabelFor(this.m_sourceConnSelector.getJComboBox());
        JLabel jLabel2 = new JLabel(StringUtils.stripMnemonic((String)CopyWizArb.getString("D_CON_LABEL")));
        jLabel2.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)CopyWizArb.getString("D_CON_LABEL")));
        jLabel2.setLabelFor(this.m_destConnSelector.getJComboBox());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.m_sourceConnSelector.getJComboBox(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 22, 2, new Insets(0, 8, 0, 0), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 2, new Insets(6, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.m_destConnSelector.getJComboBox(), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 22, 2, new Insets(6, 8, 0, 0), 0, 0));
        JPanel jPanel2 = new JPanel();
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 20, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.m_copyDBConnPanel.setLayout(new BorderLayout());
        this.m_copyDBConnPanel.add((Component)jPanel, "Center");
    }

    public JPanel getPanel() {
        return this.m_copyDBConnPanel;
    }

    public void setSourceConnection(String string) {
        if (this.m_sourceConnSelector != null) {
            this.m_sourceConnSelector.setCurrentConnection(string);
        }
    }

    public void setTargetConnection(String string) {
        if (this.m_destConnSelector != null) {
            this.m_destConnSelector.setCurrentConnection(string);
        }
    }

    public String getSourceConnection() {
        if (this.m_sourceConnSelector != null) {
            return this.m_sourceConnSelector.getCurrentConnectionName();
        }
        return null;
    }

    public String getTargetConnection() {
        if (this.m_destConnSelector != null) {
            return this.m_destConnSelector.getCurrentConnectionName();
        }
        return null;
    }

    void dispose() {
        this.m_sourceConnSelector.dispose();
        this.m_destConnSelector.dispose();
    }

    private static class Connector
    implements ItemListener {
        private OracleConnectionComboBox m_selector;

        Connector(OracleConnectionComboBox oracleConnectionComboBox) {
            this.m_selector = oracleConnectionComboBox;
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            try {
                Connections.getInstance().getConnection(this.m_selector.getCurrentConnectionName());
            }
            catch (Exception exception) {
                Throwable throwable;
                Exception exception2;
                this.m_selector.getJComboBox().setSelectedIndex(-1);
                while (exception2 instanceof DBException && (throwable = exception2.getCause()) instanceof Exception) {
                    exception2 = (Exception)throwable;
                }
                ExceptionHandler.handleException((Throwable)exception2);
            }
        }
    }
}

