/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.writers;

import java.awt.Component;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.Messages;
import oracle.dbtools.raptor.data.core.Cancelable;
import oracle.dbtools.raptor.data.core.Column;
import oracle.dbtools.raptor.data.core.GenericTable;
import oracle.dbtools.raptor.data.core.ImportDataFormat;
import oracle.dbtools.raptor.data.readers.DataFormatException;
import oracle.dbtools.raptor.data.readers.DataReadable;
import oracle.dbtools.raptor.data.readers.DataReaderRegistry;
import oracle.dbtools.raptor.data.writers.DataTypeFormatterRegistry;
import oracle.dbtools.raptor.data.writers.ITypeFormattor;
import oracle.dbtools.raptor.data.writers.ImportWriteStream;
import oracle.dbtools.raptor.datatools.core.BaseDataFormat;
import oracle.dbtools.raptor.newscriptrunner.OutputRedirector;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutorTask;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.util.Resource;
import oracle.ide.Ide;
import oracle.ide.db.model.SqlNode;
import oracle.ide.editor.EditorUtil;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.log.MessagePage;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdbc.OraclePreparedStatement;
import org.antlr.stringtemplate.CommonGroupLoader;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateGroupLoader;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;

public class ImportGenerator
implements Cancelable {
    private final String ERR_FILE_BASE = Resource.raptorUser.getAbsolutePath() + File.separator;
    private ImportWriteStream _stream;
    private StringBuilder _sql = new StringBuilder();
    private URL m_url;
    private static String DEFAULT_GROUP_QUOTE = "importgen";
    private static StringTemplateGroup m_templateGroup = null;
    private TraversableContext m_ctx;
    private boolean CANCELLED;
    private boolean m_connLocked = false;
    private boolean m_autoCommit;
    private Connection m_conn;
    private boolean sqlldrWriteSh = true;
    private boolean sqlldrWriteBat = true;
    private boolean sqlldrWriteCtl = true;
    private String m_outWithPath;
    private ImportDataFormat m_dataFormat;
    protected final String ENCODING = "UTF-8";
    protected String m_encoding;
    private Connection m_baseConn;
    String m_baseUser;
    String m_schemaName;
    private Boolean m_insertIntoExistingTable;
    private int m_loadMethod;
    private String m_tableName;

    public ImportGenerator(ImportWriteStream importWriteStream, TraversableContext traversableContext) {
        this._stream = importWriteStream;
        this.m_ctx = traversableContext;
        this.m_encoding = "UTF-8";
        this.m_dataFormat = (ImportDataFormat)this.m_ctx.get("DATA_FORMAT");
    }

    public ImportGenerator(ImportWriteStream importWriteStream, URL uRL) {
        this._stream = importWriteStream;
        this.m_url = uRL;
        this.m_encoding = "UTF-8";
    }

    public void setUrl(URL uRL) {
        this.m_url = uRL;
    }

    public void setCtx(TraversableContext traversableContext) {
        this.m_ctx = traversableContext;
        this.m_dataFormat = (ImportDataFormat)this.m_ctx.get("DATA_FORMAT");
    }

    public String getExternalTableText() {
        StringBuilder stringBuilder = new StringBuilder();
        this.loadTemplates();
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, Messages.getString("ImportGenerator.1"));
        stringBuilder.append("SET DEFINE OFF\n");
        Logger.getLogger(this.getClass().getName()).log(Level.FINE, Messages.getString("ImportGenerator.3"));
        DataReadable dataReadable = DataReaderRegistry.getReader((String)this.m_ctx.get("IMPORT_TYPE"));
        dataReadable.setDataFormat((ImportDataFormat)this.m_ctx.get("DATA_FORMAT"));
        String string = (String)this.m_ctx.get("FILENAME");
        dataReadable.setFileName(string);
        if (this.m_ctx.get("PAGEID") != null) {
            dataReadable.setPage((Integer)this.m_ctx.get("PAGEID"));
        }
        Logger.getLogger(this.getClass().getName()).log(Level.FINE, Messages.getString("ImportGenerator.4"));
        GenericTable genericTable = null;
        genericTable = (GenericTable)this.m_ctx.get("TABLE");
        Column[] columnArray = genericTable.getColumns();
        String[] stringArray = dataReadable.getColumnNames();
        Column[] columnArray2 = new Column[columnArray.length];
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            Column column = this.getColumnFromSourceName(stringArray[i], columnArray);
            if (column == null) continue;
            columnArray2[n++] = column;
        }
        if (!this.CANCELLED) {
            stringBuilder.append(this.getExtCreateTableStatement(genericTable) + "\n\n");
        }
        if (!this.CANCELLED && this.m_insertIntoExistingTable.booleanValue()) {
            stringBuilder.append(this.getInsertStatementFromStaging() + "\n\n");
        }
        String string2 = stringBuilder.toString();
        string2 = string2.replaceAll("\r", "");
        dataReadable.closeFile();
        return string2;
    }

    private boolean writeFile(String string) {
        File file = new File(string);
        boolean bl = true;
        if (file.exists()) {
            ImplementsRunnable implementsRunnable = new ImplementsRunnable(string);
            try {
                if (SwingUtilities.isEventDispatchThread()) {
                    implementsRunnable.run();
                } else {
                    SwingUtilities.invokeAndWait(implementsRunnable);
                }
                if (implementsRunnable.getDeleted() != null && implementsRunnable.getDeleted().equals(Boolean.FALSE)) {
                    bl = false;
                }
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, interruptedException.getStackTrace()[0].toString(), interruptedException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, invocationTargetException.getStackTrace()[0].toString(), invocationTargetException);
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public void getSqlldrCall(boolean bl) {
        String string;
        String string2 = (String)this.m_ctx.get("FILENAME");
        String string3 = "filename";
        try {
            string3 = new File(string2).getCanonicalPath();
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        String string4 = string3.substring(string3.lastIndexOf(File.separator) + 1, string3.lastIndexOf("."));
        String string5 = (String)this.m_ctx.get("USEGENDIR");
        this.m_outWithPath = string3.substring(0, string3.lastIndexOf(File.separator));
        if (string5 != null && string5.equals("Y")) {
            string = (String)this.m_ctx.get("GENDIR");
            if (this.m_outWithPath.endsWith(File.separator)) {
                this.m_outWithPath = string.substring(0, this.m_outWithPath.length() - 2);
            }
            this.m_outWithPath = string;
        }
        string = this.m_outWithPath + File.separator + string4 + ".sh";
        String string6 = this.m_outWithPath + File.separator + string4 + ".bat";
        String string7 = this.m_outWithPath + File.separator + string4 + ".ctl";
        if (!bl) {
            this.sqlldrWriteSh = this.writeFile(string);
            this.sqlldrWriteBat = this.writeFile(string6);
            this.sqlldrWriteCtl = this.writeFile(string7);
        } else {
            void var23_30;
            String string8;
            Object object2;
            Object object3;
            String string9;
            Logger.getLogger(this.getClass().getName()).log(Level.FINE, Messages.getString("ImportGenerator.13"));
            StringTemplate stringTemplate = m_templateGroup.getInstanceOf("CreateSqlldrStatement");
            stringTemplate.setAttribute("fileName", (Object)string4);
            String string10 = (String)this.m_ctx.get("ORACLELOGDIRNAME");
            String string11 = "";
            if (string10 != null && string10.length() > 0) {
                string11 = "LOG=" + string10 + File.separator + string4 + ".log";
            }
            stringTemplate.setAttribute("logClause", (Object)string11);
            String string12 = (String)this.m_ctx.get("ORACLEBADDIRNAME");
            String string13 = "";
            if (string12 != null && string12.length() > 0) {
                string13 = "BAD=" + string12 + File.separator + string4 + ".bad";
            }
            stringTemplate.setAttribute("badClause", (Object)string13);
            Integer n = this.m_dataFormat.isHeader() ? this.m_dataFormat.getSkipRows() + 1 : this.m_dataFormat.getSkipRows();
            stringTemplate.setAttribute("rowsToSkip", (Object)n.toString());
            n = (Integer)this.m_ctx.get("LOAD_LIMIT");
            if (n > 0) {
                string9 = "LOAD=" + n;
                stringTemplate.setAttribute("loadLimitClause", (Object)string9);
            }
            string9 = stringTemplate.toString();
            File file = new File(string);
            if (this.sqlldrWriteSh) {
                object3 = string9;
                this.writeOutFile(file, this.nix((String)object3));
            }
            object3 = new File(string6);
            if (this.sqlldrWriteBat) {
                object2 = string9;
                this.writeOutFile((File)object3, this.dos((String)object2));
            }
            stringTemplate = m_templateGroup.getInstanceOf("CreateSqlldrCtlFile");
            object2 = (GenericTable)this.m_ctx.get("TABLE");
            stringTemplate.setAttribute("tableName", (Object)this.addUser(this.addDoubleQuote(((GenericTable)object2).getTable().getTablename())));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Column column : ((GenericTable)object2).getColumns()) {
                if (column.getType().equalsIgnoreCase("DATE")) {
                    arrayList.add(this.addDoubleQuote(column.getName()) + " DATE \"" + column.getFormat() + "\"");
                    continue;
                }
                if (column.getType().equalsIgnoreCase("TIMESTAMP")) {
                    arrayList.add(this.addDoubleQuote(column.getName()) + " TIMESTAMP \"" + column.getFormat() + "\"");
                    continue;
                }
                string8 = (String)this.m_ctx.get("CHARNUMCHARACTERS");
                if (string8 != null && string8 != "" && string8.replaceAll("[0-9]*", "").equals("")) {
                    arrayList.add(this.addDoubleQuote(column.getName()) + " CHAR(" + string8 + ")");
                    continue;
                }
                arrayList.add(this.addDoubleQuote(column.getName()) + " CHAR(4000)");
            }
            stringTemplate.setAttribute("nameList", (Object)arrayList.toArray());
            if (string5 != null && string5.equals("Y")) {
                stringTemplate.setAttribute("fileName", (Object)string3);
            } else {
                stringTemplate.setAttribute("fileName", (Object)string3.substring(string3.lastIndexOf(File.separator) + 1));
            }
            String string14 = BaseDataFormat.singleQuote(BaseDataFormat.getRecordTerminatorString(this.m_dataFormat.getRecordTerminator()));
            stringTemplate.setAttribute("endOfRow", (Object)string14);
            String string15 = this.m_dataFormat.getEnclosureLeftValue();
            String string16 = this.m_dataFormat.getEnclosureRightValue();
            String string17 = "";
            if (string15.length() != 0) {
                String string18 = "OPTIONALLY ENCLOSED BY '" + string15 + "'" + " AND " + "'" + string16 + "'";
            }
            stringTemplate.setAttribute("enclosures", (Object)var23_30);
            string8 = (String)this.m_ctx.get("CHARSETVAL");
            if (!string8.equals("")) {
                string8 = "CHARACTERSET " + string8;
            }
            stringTemplate.setAttribute("charset", (Object)string8);
            String string19 = BaseDataFormat.singleQuote(BaseDataFormat.getDelimiterString(this.m_dataFormat.getDelimiter()));
            if (string19 == null || string19.equals("")) {
                string19 = "','";
            } else if (string19.equals("'WHITESPACE'")) {
                string19 = "WHITESPACE";
            }
            stringTemplate.setAttribute("fieldDelimiter", (Object)string19);
            String string20 = stringTemplate.toString();
            File file2 = new File(string7);
            if (this.sqlldrWriteCtl) {
                this.writeOutFile(file2, this.translateEOL(string20 + "\n"));
            }
        }
    }

    private String addUser(String string) {
        if (!this.m_baseUser.equals(this.m_schemaName)) {
            return DBUtil.addDoubleQuote((String)this.m_schemaName) + "." + string;
        }
        return string;
    }

    private String addDoubleQuote(String string) {
        if (this.m_insertIntoExistingTable.booleanValue()) {
            return DBUtil.addDoubleQuote((String)string);
        }
        return string;
    }

    private String translateEOL(String string) {
        string = string.replaceAll("\\r", "");
        String string2 = this.m_dataFormat.getRecordTerminatorValue((String)this.m_ctx.get("FILEOUTNEWLINE"));
        String string3 = this.m_dataFormat.getRecordTerminatorValue(this.m_dataFormat.getRecordTerminator());
        String string4 = string2 != null && !BaseDataFormat.isRecordTerminatorImportFile(string2) ? string2 : string3;
        string = string.replaceAll("\\n", string4);
        return string;
    }

    private String dos(String string) {
        return string.replaceAll("\\r", "").replaceAll("\\n", "\r\n");
    }

    private String nix(String string) {
        return string.replaceAll("\\r", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOutFile(File file, String string) {
        OutputStreamWriter outputStreamWriter = null;
        String string2 = DBConfig.getInstance().getString("IMPORT_LDR_GEN_ENCODING");
        try {
            outputStreamWriter = string2 != null && string2.length() > 0 ? new OutputStreamWriter((OutputStream)new FileOutputStream(file), string2) : (this.m_encoding == null ? new OutputStreamWriter(new FileOutputStream(file)) : new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.m_encoding));
            outputStreamWriter.write(string);
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        finally {
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.flush();
                    outputStreamWriter.close();
                }
                catch (IOException iOException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
                }
            }
        }
    }

    @Override
    public void signalCancel() {
        this.CANCELLED = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate() {
        this.m_loadMethod = (Integer)this.m_ctx.get("LOAD_METHOD");
        this.loadTemplates();
        this.m_insertIntoExistingTable = (Boolean)this.m_ctx.get("INSERT_INTO_EXISTING_TABLE");
        String string = ((DBObject)this.m_ctx.get("DBOBJECT")).getConnectionName();
        try {
            this.m_baseConn = Connections.getInstance().getConnection(string);
            this.m_baseUser = this.m_baseConn.getMetaData().getUserName();
            this.m_schemaName = ((DBObject)this.m_ctx.get("DBOBJECT")).getSchemaName();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.m_loadMethod == ImportDataFormat.METHOD_SQLLDR) {
            bl = true;
            this.getSqlldrCall(false);
        } else if (this.m_loadMethod == ImportDataFormat.METHOD_EXTERNAL_TABLE || this.m_loadMethod == ImportDataFormat.METHOD_STAGING_EXTERNAL_TABLE) {
            bl2 = true;
        } else {
            bl3 = true;
        }
        if (bl3) {
            this.generateForInserts();
            return;
        }
        ScriptRunnerContext scriptRunnerContext = new ScriptRunnerContext();
        this._sql.append("SET DEFINE OFF\n");
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, Messages.getString("ImportGenerator.1"));
        GenericTable genericTable = (GenericTable)this.m_ctx.get("TABLE");
        String string2 = genericTable.getTable().getTablename();
        if (bl2) {
            Object object;
            if (this.m_loadMethod == ImportDataFormat.METHOD_STAGING_EXTERNAL_TABLE && !this.m_insertIntoExistingTable.booleanValue() && !this.CANCELLED) {
                object = genericTable.getColumns();
                this._sql.append(this.getCreateTableStatement(genericTable) + "\n\n");
                for (int i = 0; i < ((Object)object).length; ++i) {
                    if (object[i] == null || ((Column)object[i]).getComment() == null || ((Column)object[i]).getComment().trim().length() <= 0) continue;
                    this._sql.append(this.getCommentStatement(genericTable.getTable().getTablename(), ((Column)object[i]).getName(), ((Column)object[i]).getComment()) + "\n\n");
                }
            }
            if (!this.CANCELLED) {
                this._sql.append(this.getExtCreateTableStatement(genericTable) + "\n\n");
            }
            if (!this.CANCELLED && this.m_loadMethod == ImportDataFormat.METHOD_STAGING_EXTERNAL_TABLE) {
                this._sql.append(this.getInsertStatementFromStaging() + "\n\n");
            }
            object = this._sql.toString();
            object = ((String)object).replaceAll("\\r", "");
            this._stream.println((String)object);
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, Messages.getString("ImportGenerator.68"));
            try {
                ImportGenerator.openSqlNodeForURL(this.m_url);
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        } else {
            Object object;
            if (!this.m_insertIntoExistingTable.booleanValue() && !this.CANCELLED) {
                object = genericTable.getColumns();
                this._sql.append(this.getCreateTableStatement(genericTable) + "\n\n");
                for (int i = 0; i < ((Object)object).length; ++i) {
                    if (object[i] == null || ((Column)object[i]).getComment() == null || ((Column)object[i]).getComment().trim().length() <= 0) continue;
                    this._sql.append(this.getCommentStatement(genericTable.getTable().getTablename(), ((Column)object[i]).getName(), ((Column)object[i]).getComment()) + "\n\n");
                }
            }
            this.getSqlldrCall(true);
            this._sql.append(DataImportArb.format("GEN_FILES_LOCATION", this.m_outWithPath));
            object = this._sql.toString();
            ((String)object).replaceAll("\r", "");
            this._stream.println((String)object);
            if (((Boolean)this.m_ctx.get("SEND_TO_WORKSHEET")).booleanValue()) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, Messages.getString("ImportGenerator.77"));
                try {
                    ImportGenerator.openSqlNodeForURL(this.m_url);
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
            } else {
                try {
                    Closeable closeable = new PipedInputStream();
                    PipedOutputStream pipedOutputStream = new PipedOutputStream((PipedInputStream)closeable);
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(pipedOutputStream);
                    MessagePage messagePage = (MessagePage)LogManager.getLogManager().getMsgPage();
                    if (messagePage == null) {
                        messagePage = new MessagePage();
                        LogManager.getLogManager().addPage((LogPage)messagePage);
                    }
                    OutputRedirector outputRedirector = new OutputRedirector((PipedInputStream)closeable, (LogPage)messagePage);
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, Messages.getString("ImportGenerator.78") + string2 + Messages.getString("ImportGenerator.79") + string);
                    ScriptExecutor scriptExecutor = new ScriptExecutor(this._sql.toString(), this.m_baseConn);
                    scriptRunnerContext.setErrWriter(new PrintWriter(this._stream.getBadStreamWriter()));
                    scriptRunnerContext.setOutputStreamWrapper(bufferedOutputStream);
                    scriptRunnerContext.setEscape(false);
                    scriptExecutor.setScriptRunnerContext(scriptRunnerContext);
                    scriptExecutor.setOut(bufferedOutputStream);
                    Logger.getLogger(this.getClass().getName()).log(Level.FINE, Messages.getString("ImportGenerator.84"));
                    scriptExecutor.run();
                    outputRedirector.start();
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
                finally {
                    LogManager.getLogManager().getLogWindow().selectPage(LogManager.getLogManager().getMsgPage());
                    LogManager.getLogManager().getLogWindow().activate();
                    PrintWriter printWriter = scriptRunnerContext.getErrWriter();
                    if (printWriter != null) {
                        printWriter.flush();
                        printWriter.close();
                    }
                    if (this._stream.isBadFileUsed()) {
                        try {
                            ImportGenerator.openSqlNodeForURL(this._stream.geturlBad());
                        }
                        catch (Exception exception) {
                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                        }
                    } else {
                        this._stream.deleteEmptyBadFile();
                    }
                    this.getPostProcessCallback().run();
                }
            }
        }
        this._stream.finished();
    }

    private ObjectActionController.ObjectActionPostProcess getPostProcessCallback() {
        ObjectAction objectAction = (ObjectAction)this.m_ctx.get("OBJECTACTION");
        DBObject dBObject = (DBObject)this.m_ctx.get("DBOBJECT");
        ObjectActionController.ObjectActionPostProcess objectActionPostProcess = ObjectActionController.getPostProcessCallback(objectAction, dBObject);
        return objectActionPostProcess;
    }

    private void generateForInserts() {
        ScriptRunnerContext scriptRunnerContext = new ScriptRunnerContext();
        try {
            String string = ((DBObject)this.m_ctx.get("DBOBJECT")).getConnectionName();
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, Messages.getString("ImportGenerator.78"));
            this.m_conn = Connections.getInstance().getConnection(string);
            this.m_autoCommit = this.m_conn.getAutoCommit();
            String string2 = Connections.getInstance().getDatabase(string).getUserName();
            String string3 = (String)this.m_ctx.get("FILENAME");
            GenericTable genericTable = (GenericTable)this.m_ctx.get("TABLE");
            int n = -1;
            n = string3.lastIndexOf("/");
            if (n > 0) {
                string3 = string3.substring(n + 1);
            }
            String string4 = genericTable.getTable().getTablename();
            String string5 = DataImportArb.format("TASK_FULL_NAME", string4, string3);
            final PipedInputStream pipedInputStream = new PipedInputStream();
            PipedOutputStream pipedOutputStream = new PipedOutputStream(pipedInputStream);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(pipedOutputStream);
            scriptRunnerContext.setOutputStreamWrapper(bufferedOutputStream);
            scriptRunnerContext.setEscape(false);
            ScriptExecutorTask scriptExecutorTask = new ScriptExecutorTask(string5, IRaptorTaskRunMode.MODAL_OPTIONAL, true, true){
                DataReadable _reader;
                Column[] _insCols;
                StringBuffer _createTableSql;
                String _insertForErrSql;
                boolean _ignoreAllErrors;
                final Integer _loadRowsLimit;
                final boolean _loadLimit;
                final int _loadMethod;
                {
                    super(string, iRaptorTaskRunMode, bl, bl2);
                    this._createTableSql = new StringBuffer();
                    this._ignoreAllErrors = false;
                    this._loadRowsLimit = (Integer)ImportGenerator.this.m_ctx.get("LOAD_LIMIT");
                    this._loadLimit = this._loadRowsLimit > 0;
                    this._loadMethod = (Integer)ImportGenerator.this.m_ctx.get("LOAD_METHOD");
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Void doWork() {
                    block22: {
                        try {
                            if (this._loadMethod == ImportDataFormat.METHOD_INSERT_SCRIPT) {
                                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.INFO, Messages.getString("ImportGenerator.77"));
                                try {
                                    this.startup();
                                    break block22;
                                }
                                finally {
                                    try {
                                        ImportGenerator.this._stream.finishedBad();
                                    }
                                    catch (Exception exception) {
                                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                                    }
                                    if (ImportGenerator.this._stream.isBadFileUsed()) {
                                        try {
                                            ImportGenerator.openSqlNodeForURL(ImportGenerator.this._stream.geturlBad());
                                        }
                                        catch (Exception exception) {
                                            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                                        }
                                    } else {
                                        ImportGenerator.this._stream.deleteEmptyBadFile();
                                    }
                                    try {
                                        ImportGenerator.openSqlNodeForURL(ImportGenerator.this.m_url);
                                    }
                                    catch (Exception exception) {
                                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                                    }
                                }
                            }
                            super.doWork();
                        }
                        catch (ExecutionException executionException) {}
                    }
                    return null;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void startup() throws ExecutionException {
                    int n;
                    int n2 = 0;
                    GenericTable genericTable = (GenericTable)ImportGenerator.this.m_ctx.get("TABLE");
                    ImportGenerator.this.m_tableName = genericTable.getTable().getTablename();
                    Object[] objectArray = null;
                    Column[] columnArray = genericTable.getColumns();
                    Column[] columnArray2 = (Column[])ImportGenerator.this.m_ctx.get("SELECTED_COLUMNS");
                    String[] stringArray = new String[columnArray2.length];
                    for (n = columnArray2.length - 1; n >= 0; --n) {
                        stringArray[n] = columnArray2[n].getSourceColumnName();
                    }
                    this._insCols = new Column[columnArray.length];
                    int n3 = 0;
                    for (n = 0; n < stringArray.length; ++n) {
                        Column column = ImportGenerator.this.getColumnFromSourceName(stringArray[n], columnArray);
                        if (column == null) continue;
                        this._insCols[n3++] = column;
                    }
                    if (this._loadMethod == ImportDataFormat.METHOD_INSERT_EXEC) {
                        this._createTableSql.append("SET DEFINE OFF\n");
                    }
                    ImportGenerator.this._stream.println("SET DEFINE OFF\n");
                    if (!ImportGenerator.this.m_insertIntoExistingTable.booleanValue()) {
                        String string = ImportGenerator.this.getCreateTableStatement(genericTable) + "\n";
                        ImportGenerator.this._stream.println(string);
                        if (this._loadMethod == ImportDataFormat.METHOD_INSERT_EXEC) {
                            this._createTableSql.append(ImportGenerator.this.getDropTableStatement(genericTable) + "\n");
                            this._createTableSql.append("/*\n");
                            this._createTableSql.append(string);
                        }
                        for (n3 = 0; n3 < columnArray.length; ++n3) {
                            if (columnArray[n3] == null || columnArray[n3].getComment() == null || columnArray[n3].getComment().trim().length() <= 0) continue;
                            string = ImportGenerator.this.getCommentStatement(genericTable.getTable().getTablename(), columnArray[n3].getName(), columnArray[n3].getComment()) + "\n";
                            ImportGenerator.this._stream.println(string);
                            if (this._loadMethod != ImportDataFormat.METHOD_INSERT_EXEC) continue;
                            this._createTableSql.append(string);
                        }
                        if (this._loadMethod == ImportDataFormat.METHOD_INSERT_EXEC) {
                            this._createTableSql.append("*/\n");
                        }
                    }
                    this._reader = DataReaderRegistry.getReader((String)ImportGenerator.this.m_ctx.get("IMPORT_TYPE"));
                    this._reader.setDataFormat((ImportDataFormat)ImportGenerator.this.m_ctx.get("DATA_FORMAT"));
                    String string = (String)ImportGenerator.this.m_ctx.get("FILENAME");
                    this._reader.setFileName(string);
                    if (ImportGenerator.this.m_ctx.get("PAGEID") != null) {
                        this._reader.setPage((Integer)ImportGenerator.this.m_ctx.get("PAGEID"));
                    }
                    if (this._loadMethod == ImportDataFormat.METHOD_INSERT_SCRIPT) {
                        try {
                            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.INFO, Messages.getString("ImportGenerator.74"));
                            n3 = 0;
                            int n4 = 0;
                            this._reader.start();
                            if (ImportGenerator.this.m_dataFormat.getSkipRows() != 0) {
                                int n5 = ImportGenerator.this.m_dataFormat.isHeader() ? ImportGenerator.this.m_dataFormat.getSkipRows() + 1 : ImportGenerator.this.m_dataFormat.getSkipRows();
                                for (int i = 0; this._reader.hasMoreRows() && i < n5 && !ImportGenerator.this.CANCELLED; ++i) {
                                    try {
                                        this._reader.readline();
                                        continue;
                                    }
                                    catch (DataFormatException dataFormatException) {
                                        // empty catch block
                                    }
                                }
                            }
                            while (this._reader.hasMoreRows() && (!this._loadLimit || n4 < this._loadRowsLimit)) {
                                this.checkCanProceed();
                                if (ImportGenerator.this.CANCELLED) {
                                    break;
                                }
                                try {
                                    ++n4;
                                    objectArray = this._reader.readline();
                                    if (n3 == 0 && ImportGenerator.this.m_dataFormat.isHeader()) {
                                        n3 = 1;
                                        continue;
                                    }
                                    if (objectArray == null) continue;
                                    ImportGenerator.this._stream.println(ImportGenerator.this.getInsertStatement(ImportGenerator.this.m_tableName, this._insCols, objectArray) + "\n");
                                }
                                catch (DataFormatException dataFormatException) {
                                    if (ImportGenerator.this.m_dataFormat.isHeader()) {
                                        n3 = 1;
                                        continue;
                                    }
                                    ++n2;
                                    objectArray = dataFormatException.getColumns();
                                    this.handleScriptException(n4, dataFormatException);
                                    ImportGenerator.this._stream.println("-- " + dataFormatException.getMessage());
                                    ImportGenerator.this._stream.println("-- " + DataImportArb.getString("DATA_FORMAT_EXCEPTION_LINE"));
                                    ImportGenerator.this._stream.println("-- " + dataFormatException.getLine());
                                    ImportGenerator.this._stream.println(ImportGenerator.this.getInsertStatementForComment(ImportGenerator.this.m_tableName, this._insCols, objectArray) + "\n");
                                    this.outBad("-- " + dataFormatException.getMessage());
                                    this.outBad("-- " + DataImportArb.getString("DATA_FORMAT_EXCEPTION_LINE"));
                                    this.outBad("-- " + dataFormatException.getLine());
                                    this.outBad(ImportGenerator.this.getInsertStatement(ImportGenerator.this.m_tableName, this._insCols, objectArray) + "\n");
                                }
                            }
                        }
                        finally {
                            if (n2 > 0) {
                                ImportGenerator.this._stream.println("-- " + DataImportArb.getString("DATA_FORMAT_EXCEPTION_SUMMARY"));
                            }
                            OutputRedirector outputRedirector = this.getScriptRedirector();
                            super.startup();
                            outputRedirector.start();
                        }
                    }
                    OutputRedirector outputRedirector = this.getScriptRedirector();
                    super.startup();
                    outputRedirector.start();
                }

                private OutputRedirector getScriptRedirector() {
                    FileInputStream fileInputStream;
                    this._reader.closeFile();
                    ImportGenerator.this._stream.finished();
                    try {
                        fileInputStream = new FileInputStream(new File(ImportGenerator.this._stream.getFileName()));
                        this.setStmt(fileInputStream, ImportGenerator.this.m_encoding);
                    }
                    catch (Exception exception) {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    }
                    fileInputStream = (MessagePage)LogManager.getLogManager().getMsgPage();
                    if (fileInputStream == null) {
                        fileInputStream = new MessagePage();
                        LogManager.getLogManager().addPage((LogPage)fileInputStream);
                    }
                    return new OutputRedirector(pipedInputStream, (LogPage)fileInputStream);
                }

                public void beforeLoopProcessing() throws ExecutionException {
                    super.beforeLoopProcessing();
                    try {
                        if (this._loadMethod == ImportDataFormat.METHOD_INSERT_EXEC) {
                            ImportGenerator.this.m_connLocked = Connections.getInstance().lock(ImportGenerator.this.m_conn);
                            if (!ImportGenerator.this.m_connLocked) {
                                super.cancel();
                            } else {
                                ImportGenerator.this.m_conn.setAutoCommit(false);
                            }
                        }
                    }
                    catch (Exception exception) {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    }
                }

                protected void afterRunStatementProcessing() throws ExecutionException {
                    if (this.wasErrorEncountered()) {
                        this.outBad("/*");
                        this.outBad(this.getStatementErrorMessage());
                        this.outBad("*/");
                        String string = DataImportArb.getString("IMPORT_CANCELLED") + "\n" + this.getStatementErrorMessage();
                        MessageDialog.information((Component)Ide.getMainWindow(), (Object)string, (String)DataImportArb.getString("TASK_SHORT_NAME"), null);
                        ImportGenerator.this.rollbackTask();
                        this.requestCancel();
                    }
                }

                public void afterLoopProcessing() throws ExecutionException {
                    super.afterLoopProcessing();
                    if (this._loadMethod == ImportDataFormat.METHOD_INSERT_SCRIPT) {
                        return;
                    }
                    int n = DBConfig.getInstance().getInt("IMPORT_INSERT_BATCH_SIZE");
                    ArrayList<Object> arrayList = new ArrayList<Object>(n);
                    int n2 = 0;
                    int n3 = 1;
                    int n4 = 0;
                    int n5 = 0;
                    StringBuffer stringBuffer = null;
                    boolean bl = false;
                    try {
                        int[] nArray;
                        CharSequence charSequence;
                        Object[] objectArray = new String[]{};
                        String string = ImportGenerator.this.getInsertStatementForPrepare(ImportGenerator.this.m_tableName, this._insCols, objectArray);
                        this._insertForErrSql = ImportGenerator.this.getInsertStatementForError(ImportGenerator.this.m_tableName, this._insCols, objectArray);
                        this.checkCanProceed();
                        OraclePreparedStatement oraclePreparedStatement = (OraclePreparedStatement)this.getConnection().prepareStatement(string);
                        boolean bl2 = false;
                        this._reader.start();
                        if (ImportGenerator.this.m_ctx.get("PAGEID") != null) {
                            this._reader.setPage((Integer)ImportGenerator.this.m_ctx.get("PAGEID"));
                        }
                        while (this._reader.hasMoreRows() && (!this._loadLimit || n5 < this._loadRowsLimit)) {
                            stringBuffer = new StringBuffer();
                            charSequence = new StringBuffer();
                            try {
                                if (ImportGenerator.this.CANCELLED) break;
                                try {
                                    objectArray = this._reader.readline();
                                    if (!bl2 && ImportGenerator.this.m_dataFormat.isHeader()) {
                                        bl2 = true;
                                        continue;
                                    }
                                }
                                catch (DataFormatException dataFormatException) {
                                    stringBuffer.append("--" + dataFormatException.getMessage() + "\n");
                                    objectArray = dataFormatException.getColumns();
                                }
                                if (objectArray != null) {
                                    this.checkCanProceed();
                                    bl = ImportGenerator.this.getBatchForInsert(ImportGenerator.this.m_tableName, this._insCols, objectArray, (StringBuffer)charSequence, oraclePreparedStatement, stringBuffer);
                                    if (bl) {
                                        arrayList.add(((StringBuffer)charSequence).toString());
                                        ++n2;
                                        ++n5;
                                    }
                                }
                                if (n2 == n || stringBuffer.length() > 0 && n2 > 0) {
                                    n4 = n3 + n2 - 1;
                                    String string2 = DataImportArb.format("TASK_PROGRESS_INS2", "" + n3, "" + n4);
                                    if (n3 == n4) {
                                        string2 = DataImportArb.format("TASK_PROGRESS_INS", "" + n3);
                                    }
                                    this.outLine(string2);
                                    super.setMessage(string2);
                                    this.checkCanProceed();
                                    nArray = oraclePreparedStatement.executeBatch();
                                    this.processUpdateCounts(nArray, n2, n3, arrayList);
                                    n2 = 0;
                                    n4 = n3 = n4 + 1;
                                    arrayList.clear();
                                }
                                if (stringBuffer.length() <= 0) continue;
                                arrayList.add(((StringBuffer)charSequence).toString());
                                n4 = n3;
                                this.handleBatchUpdateException(new BatchUpdateException(stringBuffer.toString(), null), 1, n3, n4, arrayList);
                                arrayList.clear();
                                n4 = ++n3;
                            }
                            catch (BatchUpdateException batchUpdateException) {
                                this.handleBatchUpdateException(batchUpdateException, n2, n3, n4, arrayList);
                                n2 = 0;
                                n3 = n4 + 1;
                                arrayList.clear();
                                if (stringBuffer == null || stringBuffer.length() <= 0) continue;
                                arrayList.add(((StringBuffer)charSequence).toString());
                                n4 = n3;
                                this.handleBatchUpdateException(new BatchUpdateException(stringBuffer.toString(), null), 1, n3, n4, arrayList);
                                arrayList.clear();
                                n4 = ++n3;
                            }
                        }
                        if (n2 != 0) {
                            n4 = n3 + n2 - 1;
                            charSequence = DataImportArb.format("TASK_PROGRESS_INS2", "" + n3, "" + n4);
                            if (n2 == 1) {
                                charSequence = DataImportArb.format("TASK_PROGRESS_INS", "" + n4);
                            }
                            super.checkCanProceed();
                            super.setMessage((String)charSequence);
                            this.outLine((String)charSequence);
                            super.checkCanProceed();
                            nArray = oraclePreparedStatement.executeBatch();
                            this.processUpdateCounts(nArray, n2, n3, arrayList);
                        }
                    }
                    catch (BatchUpdateException batchUpdateException) {
                        this.handleBatchUpdateException(batchUpdateException, n2, n3, n4, arrayList);
                    }
                    catch (SQLException sQLException) {
                        this.cancelTask();
                    }
                    this.checkCanProceed();
                }

                private void handleScriptException(int n, Exception exception) throws ExecutionException {
                    String string = exception.getMessage();
                    string = string.substring(0, string.length() - 1);
                    if (!this._ignoreAllErrors) {
                        try {
                            this.askContinueOnError(string + "\n\n" + DataImportArb.getString("TASK_PROGRESS_SCRIPT_CONTINUE"));
                        }
                        catch (Throwable throwable) {
                            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, throwable.getStackTrace()[0].toString(), throwable);
                            ImportGenerator.this.rollbackTask();
                            this.requestCancel();
                        }
                    }
                }

                private void handleBatchUpdateException(BatchUpdateException batchUpdateException, int n, int n2, int n3, ArrayList<Object> arrayList) throws ExecutionException {
                    if (this._createTableSql != null && this._createTableSql.length() > 0) {
                        this.outBad(this._createTableSql.toString());
                        this._createTableSql = null;
                    }
                    int[] nArray = batchUpdateException.getUpdateCounts();
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, batchUpdateException.getMessage(), batchUpdateException);
                    String string = batchUpdateException.getMessage().startsWith("--") ? batchUpdateException.getMessage() : "--" + batchUpdateException.getMessage();
                    String string2 = DataImportArb.format("TASK_PROGRESS_INS_FAIL2", " " + n2 + " ", " " + n3 + " ") + string;
                    if (n == 1) {
                        string2 = DataImportArb.format("TASK_PROGRESS_INS_FAIL", " " + n2 + " ") + string;
                    }
                    string2 = string2.substring(0, string2.length() - 1);
                    String string3 = string2.replace("--", "");
                    this.outLine(string3);
                    this.outBad("--" + string2);
                    this.processUpdateCounts(nArray, n, n2, arrayList);
                    if (!this._ignoreAllErrors) {
                        try {
                            this.askContinueOnError(string3 + "\n\n" + DataImportArb.getString("TASK_PROGRESS_CONTINUE"));
                        }
                        catch (Throwable throwable) {
                            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, throwable.getStackTrace()[0].toString(), throwable);
                            ImportGenerator.this.rollbackTask();
                            this.requestCancel();
                        }
                    }
                }

                private void askContinueOnError(String string) throws Throwable {
                    final String string2 = string;
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                int n = MessageDialog.confirmOrCancel((Component)Ide.getMainWindow(), (Object)string2, (String)DataImportArb.getString("TASK_SHORT_NAME"), null);
                                if (n == -1) {
                                    this.requestCancel();
                                } else if (n == 1) {
                                    _ignoreAllErrors = true;
                                }
                            }
                            catch (Exception exception) {
                                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                                this.requestCancel();
                            }
                        }
                    };
                    if (SwingUtilities.isEventDispatchThread()) {
                        runnable.run();
                    } else {
                        try {
                            SwingUtilities.invokeAndWait(runnable);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            throw invocationTargetException.getCause();
                        }
                    }
                }

                protected boolean cancelTask() {
                    if (this._reader != null) {
                        this._reader.closeFile();
                    }
                    ImportGenerator.this.rollbackTask();
                    boolean bl = super.requestCancel();
                    return bl;
                }

                private void processUpdateCounts(int[] nArray, int n, int n2, ArrayList<Object> arrayList) {
                    String string;
                    if (nArray == null || nArray.length < 1) {
                        int n3 = 0;
                        while (n3 < n) {
                            String string2 = DataImportArb.format("ROW", n2);
                            this.outLine(string2);
                            this.outBad("--" + string2);
                            string2 = (String)arrayList.get(n3);
                            this.outLine(this._insertForErrSql + string2);
                            this.outBad(this._insertForErrSql + string2);
                            ++n3;
                            ++n2;
                        }
                        return;
                    }
                    int n4 = 0;
                    while (n4 < nArray.length) {
                        if (nArray[n4] < 0 && nArray[n4] != -2 && nArray[n4] == -3) {
                            string = DataImportArb.format("ROW", n2);
                            this.outLine(string);
                            this.outBad("--" + string);
                            string = (String)arrayList.get(n4);
                            this.outLine(this._insertForErrSql + string);
                            this.outBad(this._insertForErrSql + string);
                        }
                        ++n4;
                        ++n2;
                    }
                    if (nArray.length < n) {
                        n4 = nArray.length;
                        while (n4 < n) {
                            string = DataImportArb.format("ROW", n2);
                            this.outLine(string);
                            this.outBad("--" + string);
                            string = (String)arrayList.get(n4);
                            this.outLine(this._insertForErrSql + string);
                            this.outBad(this._insertForErrSql + string);
                            ++n4;
                            ++n2;
                        }
                        return;
                    }
                }

                private void outLine(String string) {
                    try {
                        try {
                            this.getOut().write(string.getBytes("UTF-8"));
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            this.getOut().write(string.getBytes());
                        }
                        this.getOut().write(10);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }

                private void outBad(String string) {
                    try {
                        ImportGenerator.this._stream.printlnBad(string);
                    }
                    catch (Exception exception) {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    }
                }

                public void cleanup() {
                    if (this.getDescriptor().isCancelled()) {
                        ImportGenerator.this.rollbackTask();
                    }
                    if (this._reader != null) {
                        this._reader.closeFile();
                    }
                    ImportGenerator.this._stream.finished();
                    LogManager.getLogManager().getLogWindow().selectPage(LogManager.getLogManager().getMsgPage());
                    LogManager.getLogManager().getLogWindow().activate();
                    try {
                        ImportGenerator.this._stream.finishedBad();
                    }
                    catch (Exception exception) {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    }
                    if (ImportGenerator.this._stream.isBadFileUsed()) {
                        try {
                            ImportGenerator.openSqlNodeForURL(ImportGenerator.this._stream.geturlBad());
                        }
                        catch (Exception exception) {
                            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                        }
                    } else {
                        ImportGenerator.this._stream.deleteEmptyBadFile();
                    }
                    this.flushOut(true);
                }
            };
            scriptExecutorTask.setOut(bufferedOutputStream);
            scriptExecutorTask.setScriptRunnerContext(scriptRunnerContext);
            scriptExecutorTask.setConnection(this.m_conn);
            if ((Integer)this.m_ctx.get("LOAD_METHOD") == ImportDataFormat.METHOD_INSERT_EXEC) {
                ObjectActionController.ObjectActionPostProcess objectActionPostProcess = this.getPostProcessCallback();
                IRaptorTaskListener iRaptorTaskListener = ObjectActionController.getRaptorTaskListener(objectActionPostProcess, true);
                scriptExecutorTask.getDescriptor().addListener(iRaptorTaskListener);
            }
            this.runTask(scriptExecutorTask, string5);
        }
        catch (Exception exception) {
            LogManager.getLogManager().getLogWindow().selectPage(LogManager.getLogManager().getMsgPage());
            LogManager.getLogManager().getLogWindow().activate();
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private String[] formatTableColumns(GenericTable genericTable) {
        return this.formatTableColumns(genericTable, false);
    }

    private String[] formatTableColumns(GenericTable genericTable, boolean bl) {
        String[] stringArray = null;
        Column[] columnArray = null;
        String string = null;
        ITypeFormattor iTypeFormattor = null;
        if (genericTable != null) {
            columnArray = genericTable.getColumns();
            stringArray = new String[columnArray.length];
            for (int i = 0; i < columnArray.length; ++i) {
                string = columnArray[i].getType();
                iTypeFormattor = DataTypeFormatterRegistry.getInstance().getFormattor(string.toUpperCase());
                if (iTypeFormattor != null) {
                    iTypeFormattor.setLocale((Locale)this.m_ctx.get("LOCALE"));
                } else {
                    iTypeFormattor = DataTypeFormatterRegistry.getInstance().getFormattor("VARCHAR2");
                }
                iTypeFormattor.isAddDoubleQuote(bl);
                stringArray[i] = iTypeFormattor.formatColumn(columnArray[i]);
            }
        }
        return stringArray;
    }

    private Column getColumnFromSourceName(String string, Column[] columnArray) {
        if (string == null || columnArray == null) {
            return null;
        }
        for (int i = 0; i < columnArray.length; ++i) {
            if (!columnArray[i].getSourceColumnName().equals(string)) continue;
            return columnArray[i];
        }
        return null;
    }

    private String getCommentStatement(String string, String string2, String string3) {
        StringTemplate stringTemplate = m_templateGroup.getInstanceOf("CommentOnColumnStatement");
        stringTemplate.setAttribute("tableName", (Object)this.addUser(string));
        stringTemplate.setAttribute("colName", (Object)this.addDoubleQuote(string2));
        stringTemplate.setAttribute("comment", (Object)string3);
        return stringTemplate.toString();
    }

    private String getDropTableStatement(GenericTable genericTable) {
        String string = genericTable.getTable().getTablename();
        StringTemplate stringTemplate = m_templateGroup.getInstanceOf("DropTableStatement");
        stringTemplate.setAttribute("tableName", (Object)this.addUser(string));
        return stringTemplate.toString();
    }

    private String getDropTableStatementForPrepare(String string) {
        StringTemplate stringTemplate = m_templateGroup.getInstanceOf("DropTableStatementForPrepare");
        stringTemplate.setAttribute("tableName", (Object)this.addUser(string));
        return stringTemplate.toString();
    }

    private String getCreateTableStatement(GenericTable genericTable) {
        String string = genericTable.getTable().getTablename();
        String[] stringArray = this.formatTableColumns(genericTable);
        StringTemplate stringTemplate = m_templateGroup.getInstanceOf("CreateTableStatement");
        stringTemplate.setAttribute("tableName", (Object)this.addUser(string));
        stringTemplate.setAttribute("colList", (Object)stringArray);
        return stringTemplate.toString();
    }

    private String getExtCreateTableStatement(GenericTable genericTable) {
        String string;
        String string2;
        String string3;
        Object object2;
        String string4 = genericTable.getTable().getTablename();
        String string5 = (String)this.m_ctx.get("STAGING_TABLE_NAME");
        String[] stringArray = this.formatTableColumns(genericTable, this.m_loadMethod == ImportDataFormat.METHOD_STAGING_EXTERNAL_TABLE && this.m_insertIntoExistingTable != false);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string6 : stringArray) {
            arrayList.add(string6.replaceAll("NOT NULL", ""));
        }
        ArrayList arrayList2 = new ArrayList();
        for (Object object2 : genericTable.getColumns()) {
            if (((Column)object2).getType().equalsIgnoreCase("DATE")) {
                arrayList2.add(this.addDoubleQuote(((Column)object2).getName()) + " DATE \"" + ((Column)object2).getFormat() + "\"");
                continue;
            }
            if (((Column)object2).getType().equalsIgnoreCase("TIMESTAMP")) {
                arrayList2.add(this.addDoubleQuote(((Column)object2).getName()) + " TIMESTAMP \"" + ((Column)object2).getFormat() + "\"");
                continue;
            }
            string3 = (String)this.m_ctx.get("CHARNUMCHARACTERS");
            if (string3 != null && string3 != "" && string3.replaceAll("[0-9]*", "").equals("")) {
                arrayList2.add(this.addDoubleQuote(((Column)object2).getName()) + " CHAR(" + string3 + ")");
                continue;
            }
            arrayList2.add(this.addDoubleQuote(((Column)object2).getName()) + " CHAR(4000)");
        }
        StringTemplate stringTemplate = m_templateGroup.getInstanceOf("CreateExtTableStatement");
        stringTemplate.setAttribute("tableName", (Object)(this.m_loadMethod == ImportDataFormat.METHOD_STAGING_EXTERNAL_TABLE ? this.addUser(string5) : this.addUser(this.addDoubleQuote(string4))));
        stringTemplate.setAttribute("colList", (Object)arrayList.toArray());
        stringTemplate.setAttribute("nameList", (Object)arrayList2.toArray());
        String string7 = (String)this.m_ctx.get("FILENAMECANONICAL");
        string7 = string7.replaceFirst("^([a-zA-Z]:)([^\\\\])", "$1\\\\$2");
        String string8 = string7.substring(string7.lastIndexOf(File.separator) + 1);
        string7 = string7.substring(string7.lastIndexOf(File.separator) + 1, string7.lastIndexOf(46));
        stringTemplate.setAttribute("fileName", (Object)string7);
        stringTemplate.setAttribute("path", this.m_ctx.get("DIRPATH"));
        stringTemplate.setAttribute("dirName", (Object)((String)this.m_ctx.get("ORACLEDIRNAME")));
        object2 = "NOBADFILE";
        if (this.m_ctx.get("USEBADFILE") == "Y") {
            string3 = (String)this.m_ctx.get("ORACLEBADDIRNAME");
            if (string3 == null || string3.length() == 0) {
                string3 = (String)this.m_ctx.get("ORACLEDIRNAME");
            }
            object2 = "BADFILE " + string3 + ":'" + string7 + ".bad'";
        }
        stringTemplate.setAttribute("badClause", object2);
        string3 = "NOLOGFILE";
        if (this.m_ctx.get("USELOGFILE") == "Y") {
            string2 = (String)this.m_ctx.get("ORACLELOGDIRNAME");
            if (string2 == null || string2.length() == 0) {
                string2 = (String)this.m_ctx.get("ORACLEDIRNAME");
            }
            string3 = "LOGFILE " + string2 + ":'" + string7 + ".log'";
        }
        stringTemplate.setAttribute("logClause", (Object)string3);
        string2 = "NODISCARDFILE";
        if (this.m_ctx.get("USEDISCARDFILE") == "Y") {
            string = (String)this.m_ctx.get("ORACLEDISCARDDIRNAME");
            if (string == null || string.length() == 0) {
                string = (String)this.m_ctx.get("ORACLEDIRNAME");
            }
            string2 = "DISCARDFILE " + string + ":'" + string7 + ".discard'";
        }
        stringTemplate.setAttribute("discardClause", (Object)string2);
        string = BaseDataFormat.singleQuote(BaseDataFormat.getDelimiterString(this.m_dataFormat.getDelimiter()));
        if (string == null || string.equals("")) {
            string = "','";
        } else if (string.equals("'WHITESPACE'")) {
            string = "WHITESPACE";
        }
        stringTemplate.setAttribute("fieldDelimiter", (Object)string);
        Integer n = this.m_dataFormat.isHeader() ? this.m_dataFormat.getSkipRows() + 1 : this.m_dataFormat.getSkipRows();
        stringTemplate.setAttribute("toSkip", (Object)n.toString());
        stringTemplate.setAttribute("allFile", (Object)string8);
        String string9 = (String)this.m_ctx.get("CHARSETVAL");
        if (!string9.equals("")) {
            string9 = "CHARACTERSET " + string9;
        }
        stringTemplate.setAttribute("charset", (Object)string9);
        String string10 = BaseDataFormat.singleQuote(BaseDataFormat.getRecordTerminatorString(this.m_dataFormat.getRecordTerminator()));
        stringTemplate.setAttribute("newline", (Object)string10);
        String string11 = this.m_dataFormat.getEnclosureLeftValue();
        String string12 = this.m_dataFormat.getEnclosureRightValue();
        String string13 = "";
        if (string11.length() != 0) {
            string13 = "OPTIONALLY ENCLOSED BY '" + string11 + "'" + " AND " + "'" + string12 + "'";
        }
        stringTemplate.setAttribute("enclosures", (Object)string13);
        if (this.m_ctx.get("PREVIEW_LIMIT") == null) {
            stringTemplate.setAttribute("limit", (Object)"");
        } else {
            stringTemplate.setAttribute("limit", (Object)("WHERE ROWNUM <= " + (String)this.m_ctx.get("PREVIEW_LIMIT")));
        }
        return stringTemplate.toString();
    }

    private String getInsertStatementFromStaging() {
        String string = (String)this.m_ctx.get("TABLE_NAME");
        String string2 = (String)this.m_ctx.get("STAGING_TABLE_NAME");
        StringTemplate stringTemplate = (StringTemplate)this.m_ctx.get("SELECTED_COLUMNS");
        String[] stringArray = new String[((Column[])stringTemplate).length];
        int n = 0;
        for (Column column : stringTemplate) {
            stringArray[n++] = this.addDoubleQuote(column.getName());
        }
        StringTemplate stringTemplate2 = null;
        stringTemplate2 = (Boolean)this.m_ctx.get("DROP_STAGING_TABLE") != false ? m_templateGroup.getInstanceOf("InsertStatementFromStagingWithDrop") : m_templateGroup.getInstanceOf("InsertStatementFromStaging");
        stringTemplate2.setAttribute("tableName", (Object)this.addUser(this.addDoubleQuote(string)));
        stringTemplate2.setAttribute("stagingTableName", (Object)this.addUser(this.addDoubleQuote(string2)));
        stringTemplate2.setAttribute("colList", (Object)stringArray);
        int n2 = (Integer)this.m_ctx.get("LOAD_LIMIT");
        if (n2 > 0) {
            String string3 = "WHERE ROWNUM <= " + n2;
            stringTemplate2.setAttribute("loadLimitClause", (Object)string3);
        }
        return stringTemplate2.toString();
    }

    private String getInsertStatement(String string, Column[] columnArray, Object[] objectArray) {
        return this.getInsertStatement(string, columnArray, objectArray, 1);
    }

    private String getInsertStatementForPrepare(String string, Column[] columnArray, Object[] objectArray) {
        return this.getInsertStatement(string, columnArray, objectArray, 2);
    }

    private String getInsertStatementForError(String string, Column[] columnArray, Object[] objectArray) {
        return this.getInsertStatement(string, columnArray, objectArray, 3);
    }

    private String getInsertStatementForComment(String string, Column[] columnArray, Object[] objectArray) {
        return this.getInsertStatement(string, columnArray, objectArray, 4);
    }

    private String getInsertStatement(String string, Column[] columnArray, Object[] objectArray, int n) {
        int n2;
        boolean bl = false;
        boolean bl2 = false;
        StringTemplate stringTemplate = new StringTemplate();
        if (n == 1) {
            stringTemplate = m_templateGroup.getInstanceOf("InsertStatement");
        } else if (n == 2) {
            bl = true;
            stringTemplate = m_templateGroup.getInstanceOf("InsertStatementForPrepare");
        } else if (n == 3) {
            bl2 = true;
            stringTemplate = m_templateGroup.getInstanceOf("InsertStatementForError");
        } else {
            stringTemplate = m_templateGroup.getInstanceOf("InsertStatementForComment");
        }
        String[] stringArray = new String[columnArray.length];
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < columnArray.length; ++i) {
            if (i < objectArray.length) {
                arrayList.add(objectArray[columnArray[i].getSourceColID()]);
                continue;
            }
            arrayList.add("");
        }
        Object[] objectArray2 = arrayList.toArray();
        String[] stringArray2 = new String[objectArray2.length];
        ITypeFormattor iTypeFormattor = null;
        for (n2 = 0; n2 < columnArray.length; ++n2) {
            stringArray[n2] = this.m_insertIntoExistingTable != false ? DBUtil.addDoubleQuote((String)columnArray[n2].getName()) : columnArray[n2].getName();
        }
        if (!bl2) {
            for (n2 = 0; n2 < objectArray2.length; ++n2) {
                if (bl) {
                    stringArray2[n2] = "?";
                    continue;
                }
                iTypeFormattor = DataTypeFormatterRegistry.getInstance().getFormattor(columnArray[n2].getType());
                if (iTypeFormattor == null) {
                    iTypeFormattor = DataTypeFormatterRegistry.getInstance().getFormattor("VARCHAR2");
                }
                iTypeFormattor.setLocale((Locale)this.m_ctx.get("LOCALE"));
                stringArray2[n2] = iTypeFormattor.formatData(objectArray2[n2], columnArray[n2]);
            }
        }
        stringTemplate.setAttribute("tableName", (Object)this.addUser(this.addDoubleQuote(string)));
        stringTemplate.setAttribute("colList", (Object)stringArray);
        if (!bl2) {
            stringTemplate.setAttribute("valList", (Object)stringArray2);
        }
        return stringTemplate.toString();
    }

    private boolean getBatchForInsert(String string, Column[] columnArray, Object[] objectArray, StringBuffer stringBuffer, OraclePreparedStatement oraclePreparedStatement, StringBuffer stringBuffer2) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < columnArray.length; ++i) {
            if (i < objectArray.length) {
                arrayList.add(objectArray[columnArray[i].getSourceColID()]);
                continue;
            }
            arrayList.add("");
        }
        Object[] objectArray2 = arrayList.toArray();
        String string2 = "(";
        ITypeFormattor iTypeFormattor = null;
        for (int i = 0; i < objectArray2.length; ++i) {
            iTypeFormattor = DataTypeFormatterRegistry.getInstance().getFormattor(columnArray[i].getType());
            if (iTypeFormattor == null) {
                iTypeFormattor = DataTypeFormatterRegistry.getInstance().getFormattor("VARCHAR2");
            }
            iTypeFormattor.setLocale((Locale)this.m_ctx.get("LOCALE"));
            iTypeFormattor.setConnection(this.m_baseConn);
            try {
                stringBuffer.append(string2);
                stringBuffer.append(iTypeFormattor.formatData(objectArray2[i], columnArray[i]));
                Object object = iTypeFormattor.formatDataForJava(objectArray2[i], columnArray[i]);
                if (object != null && object instanceof String) {
                    String string3 = (String)object;
                    if (string3 == null || string3.length() == 0 || string3.equals("''") || string3.equals("NULL")) {
                        oraclePreparedStatement.setNull(i + 1, iTypeFormattor.getSqlType(columnArray[i].getType()));
                    } else {
                        if (columnArray[i].getType().equals("NCHAR") || columnArray[i].getType().equals("NVARCHAR2")) {
                            oraclePreparedStatement.setFormOfUse(i + 1, (short)2);
                        }
                        oraclePreparedStatement.setString(i + 1, string3);
                    }
                } else {
                    oraclePreparedStatement.setObject(i + 1, object, iTypeFormattor.getSqlType(columnArray[i].getType()));
                }
            }
            catch (Exception exception) {
                stringBuffer2.append(columnArray[i].getName() + " " + exception.getMessage() + " ");
            }
            string2 = ",";
        }
        stringBuffer.append(");");
        if (stringBuffer2.length() == 0) {
            try {
                oraclePreparedStatement.addBatch();
            }
            catch (Exception exception) {
                stringBuffer2.append(exception.getMessage());
            }
        }
        return stringBuffer2.length() == 0;
    }

    private void loadTemplates() {
        CommonGroupLoader commonGroupLoader = new CommonGroupLoader("oracle/dbtools/raptor/data/templates", null);
        StringTemplateGroup.registerGroupLoader((StringTemplateGroupLoader)commonGroupLoader);
        StringTemplateGroup.registerDefaultLexer(AngleBracketTemplateLexer.class);
        m_templateGroup = StringTemplateGroup.loadGroup((String)DEFAULT_GROUP_QUOTE);
        this.setTemplateName(DEFAULT_GROUP_QUOTE);
    }

    public void setTemplateName(String string) {
        this.setTemplateGroup(StringTemplateGroup.loadGroup((String)string));
    }

    protected void setTemplateGroup(StringTemplateGroup stringTemplateGroup) {
        m_templateGroup = stringTemplateGroup;
    }

    protected StringTemplateGroup getTemplateGroup() {
        return m_templateGroup;
    }

    private static void openSqlNodeForURL(URL uRL) throws Exception {
        SqlNode sqlNode = null;
        sqlNode = (SqlNode)NodeFactory.findOrCreate(SqlNode.class, (URL)uRL);
        final SqlNode sqlNode2 = sqlNode;
        if (sqlNode2 != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    IdeUtil.invokeAfterRepaint((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            EditorUtil.openDefaultEditorInFrame((Node)sqlNode2);
                        }
                    });
                }
            });
        }
    }

    private void runTask(ScriptExecutorTask scriptExecutorTask, String string) {
        scriptExecutorTask.setCancellable(true);
        scriptExecutorTask.setPausable(true);
        scriptExecutorTask.getDescriptor().addListener((IRaptorTaskListener)new SchemaTaskListener(string, this.m_conn, (Boolean)this.m_ctx.get("SEND_TO_WORKSHEET")));
        RaptorTaskManager.getInstance().addTask((RaptorTask)scriptExecutorTask);
    }

    final void rollbackTask() {
        block8: {
            try {
                if (this.m_conn.isClosed() || !this.m_connLocked) break block8;
                try {
                    this.m_conn.rollback();
                    if (!this.m_insertIntoExistingTable.booleanValue()) {
                        String string = this.getDropTableStatementForPrepare(this.m_tableName);
                        PreparedStatement preparedStatement = this.m_conn.prepareStatement(string);
                        preparedStatement.execute();
                        this.m_conn.commit();
                    }
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                }
                try {
                    if (this.m_connLocked) {
                        Connections.getInstance().unlock(this.m_conn);
                        this.m_conn.setAutoCommit(this.m_autoCommit);
                        this.m_connLocked = false;
                    }
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
        }
    }

    static class ImplementsRunnable
    implements Runnable {
        private Boolean deleted = Boolean.FALSE;
        private String in = null;
        private File inFile = null;

        public ImplementsRunnable(String string) {
            this.in = string;
            this.inFile = new File(this.in);
        }

        @Override
        public void run() {
            String string = this.in;
            int n = this.in.lastIndexOf(File.separator);
            if (n != -1) {
                string = this.in.substring(n + 1);
            }
            switch (MessageDialog.confirmOrCancel((Component)Ide.getMainWindow(), (Object)DataImportArb.getString("FILE_EXISTS_OVERWRITE"), (String)string)) {
                case 1: {
                    this.inFile.delete();
                    this.deleted = Boolean.TRUE;
                    break;
                }
                default: {
                    this.deleted = Boolean.FALSE;
                }
            }
        }

        public Boolean getDeleted() {
            return this.deleted;
        }
    }

    final class SchemaTaskListener
    extends RaptorTaskAdapter {
        private String _taskFullName;
        private Connection _conn;
        private boolean _sendToWorksheet;
        private String _msg = "";

        SchemaTaskListener(String string, Connection connection, Boolean bl) {
            this._taskFullName = string;
            this._conn = connection;
            this._sendToWorksheet = bl;
        }

        public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
            RaptorTaskEvent raptorTaskEvent2 = raptorTaskEvent;
            if (raptorTaskEvent2.getTaskDescriptor().isCancelled()) {
                this._msg = this._taskFullName + ". ";
                this._msg = this._msg + (this._sendToWorksheet ? DataImportArb.getString("TASK_CANCELLED") : DataImportArb.getString("TASK_CANCELLED_ROLLBACK"));
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, this._msg);
            } else {
                this._msg = this._taskFullName + ". ";
                this._msg = this._msg + (this._sendToWorksheet ? DataImportArb.getString("TASK_FAILED") : DataImportArb.getString("TASK_FAILED_ROLLBACK"));
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, this._msg);
            }
            this.showFinalMsg(this._msg);
        }

        public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
            this._msg = this._taskFullName + ". ";
            this._msg = this._msg + (this._sendToWorksheet ? DataImportArb.getString("TASK_CANCELLED") : DataImportArb.getString("TASK_CANCELLED_ROLLBACK"));
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, this._msg);
            this.showFinalMsg(this._msg);
        }

        public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
            RaptorTaskEvent raptorTaskEvent2 = raptorTaskEvent;
            if (raptorTaskEvent2.getTaskDescriptor().isCancelled()) {
                this._msg = this._taskFullName + ". ";
                this._msg = this._msg + (this._sendToWorksheet ? DataImportArb.getString("TASK_FAILED") : DataImportArb.getString("TASK_FAILED_ROLLBACK"));
            } else {
                try {
                    if (ImportGenerator.this.m_connLocked) {
                        this._conn.commit();
                    }
                }
                catch (Exception exception) {
                    this._msg = this._taskFullName + ". ";
                    this._msg = this._msg + (this._sendToWorksheet ? DataImportArb.getString("TASK_FAILED") : DataImportArb.getString("TASK_FAILED_ROLLBACK"));
                }
            }
            if (this._msg.length() == 0) {
                this._msg = this._sendToWorksheet ? this._taskFullName + ". " + DataImportArb.getString("TASK_SUCCEEDED") : this._taskFullName + ". " + DataImportArb.getString("TASK_SUCCEEDED_AND_COMMITTED");
            }
            try {
                if (ImportGenerator.this.m_connLocked) {
                    Connections.getInstance().unlock(this._conn);
                    this._conn.setAutoCommit(ImportGenerator.this.m_autoCommit);
                    ImportGenerator.this.m_connLocked = false;
                }
            }
            catch (Exception exception) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
            this.showFinalMsg(this._msg);
        }

        private void showFinalMsg(String string) {
            final String string2 = string;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        MessageDialog.information((Component)Ide.getMainWindow(), (Object)string2, (String)DataImportArb.getString("TASK_SHORT_NAME"), null);
                    }
                    catch (Exception exception) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    }
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }
}

