/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.core.ImportDataFormat;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class LoadLimitPanel {
    private JCheckBox loadLimitCheckBox;
    private NumericSpinBox loadLimitSpinBox;
    private boolean checkBoxControlled;
    private ImportDataFormat dataFormat;
    private static final long serialVersionUID = -2739487292165944123L;

    public LoadLimitPanel() {
        this(true);
    }

    public LoadLimitPanel(ImportDataFormat importDataFormat, boolean bl) {
        this(bl);
        this.dataFormat = importDataFormat;
    }

    public LoadLimitPanel(boolean bl) {
        try {
            this.checkBoxControlled = bl;
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void jbInit() throws Exception {
        this.initLoadLimit();
    }

    public JCheckBox getUseLoadLimitComponent() {
        return this.loadLimitCheckBox;
    }

    public NumericSpinBox getLoadLimitComponent() {
        return this.loadLimitSpinBox;
    }

    void initLoadLimit() {
        this.loadLimitCheckBox = new JCheckBox();
        this.loadLimitCheckBox.setSelected(true);
        this.loadLimitCheckBox.setText(DataImportArb.getString("WIZARD_LOAD_LIMIT"));
        if (this.checkBoxControlled) {
            this.loadLimitCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                    LoadLimitPanel.this.loadLimitSpinBox.setEnabled(jCheckBox.isSelected());
                }
            });
        }
        this.loadLimitSpinBox = new NumericSpinBox(0, Integer.MAX_VALUE);
    }

    public void onEntry() {
        DBConfig dBConfig = DBConfig.getInstance();
        this.setOptions(dBConfig);
    }

    public void onEntry(TraversableContext traversableContext) {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        this.setOptions(dBConfig);
    }

    private void setOptions(DBConfig dBConfig) {
        if (this.dataFormat != null) {
            this.loadLimitCheckBox.setSelected(this.dataFormat.getUseLoadLimit());
            this.loadLimitSpinBox.setIntValue(this.dataFormat.getLoadLimit());
        } else {
            this.loadLimitCheckBox.setSelected(dBConfig.getBoolean("IMPORT_USE_LOAD_LIMIT"));
            this.loadLimitSpinBox.setIntValue(dBConfig.getInt("IMPORT_LOAD_LIMIT"));
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        dBConfig.putBoolean("IMPORT_USE_LOAD_LIMIT", this.loadLimitCheckBox.isSelected());
        dBConfig.putInt("IMPORT_LOAD_LIMIT", this.loadLimitSpinBox.getIntValue());
    }
}

