/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.config.PreferencesArb;
import oracle.dbtools.raptor.controls.FilePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class ImportBadFilePanel
extends JPanel {
    JLabel _importFileLabel;
    private FilePanel _importFilePanel;
    private static final long serialVersionUID = -2739487292165944123L;

    public ImportBadFilePanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.initFilePanel();
    }

    public FilePanel getFilePanel() {
        return this._importFilePanel;
    }

    void initFilePanel() {
        int n = 0;
        this._importFileLabel = new JLabel(PreferencesArb.getString("IMPORT_BAD_DIR"));
        this._importFilePanel = new FilePanel(this, false);
        this._importFilePanel.setSelectionMode(1);
        this._importFileLabel.setLabelFor(this._importFilePanel);
        this.add((Component)this._importFileLabel, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 0, 0, 8), 0, 0));
        this.add((Component)this._importFilePanel, new GridBagConstraints(1, n, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void onEntry() {
        DBConfig dBConfig = DBConfig.getInstance();
        this.setOptions(dBConfig);
    }

    public void onEntry(TraversableContext traversableContext) {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        this.setOptions(dBConfig);
    }

    private void setOptions(DBConfig dBConfig) {
        this._importFilePanel.setFileName(dBConfig.getString("IMPORT_LDR_BAD_DIR"));
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        dBConfig.putString("IMPORT_LDR_BAD_DIR", this._importFilePanel.getFileName());
    }
}

