/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.grid.contextmenu;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.sql.Connection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.Messages;
import oracle.dbtools.raptor.controls.FilteringJList;
import oracle.dbtools.raptor.controls.grid.FilteringJListItem;
import oracle.dbtools.raptor.controls.grid.RaptorGridFilter;
import oracle.dbtools.raptor.controls.grid.ResultSetTable;
import oracle.dbtools.raptor.controls.grid.ResultSetTableCellRenderer;
import oracle.dbtools.raptor.controls.grid.ResultSetTableModel;
import oracle.dbtools.raptor.controls.grid.contextmenu.GridHeaderContextMenuItem;
import oracle.dbtools.raptor.controls.grid.contextmenu.RSTCMMessages;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.help.HelpSystem;
import oracle.javatools.db.DBException;
import oracle.javatools.ui.ghost.GhostPalette;

public class FilterGrid
extends GridHeaderContextMenuItem {
    private static FilterGrid _instance = null;
    public static final String _cmdFilterGrid = "cmdFilterGrid";
    public static final int _cmdIdFilterGrid = Ide.findOrCreateCmdID((String)"cmdFilterGrid");
    private IdeAction _actionFilterGrid;
    private JMenuItem _mi = null;
    private GhostPalette gp = null;

    private FilterGrid() {
        this.initAction();
    }

    public static FilterGrid getInstance() {
        if (_instance == null) {
            _instance = new FilterGrid();
        }
        return _instance;
    }

    private void initAction() {
        if (this._actionFilterGrid == null) {
            this._actionFilterGrid = this.createAction(_cmdIdFilterGrid, RSTCMMessages.getString("FilterGrid.0"), null);
        }
    }

    protected boolean canShow(ContextMenu contextMenu) {
        return this.canShow();
    }

    protected void createAndShowMenu(ContextMenu contextMenu) {
        this.createJMenuItem(contextMenu);
        contextMenu.add((Component)this._mi);
    }

    private void createJMenuItem(ContextMenu contextMenu) {
        if (this._mi == null) {
            this._mi = contextMenu.createMenuItem((ToggleAction)this._actionFilterGrid);
        }
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        if (ideAction.getCommandId() == _cmdIdFilterGrid && this._table != null) {
            this.showFilterPanel((ResultSetTable)this._table, this._table.getSelectedColumn());
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        if (this._table != null && this._table instanceof ResultSetTable) {
            String string = ((ResultSetTable)this._table).getGridModel().getConnectionName();
            Connection connection = null;
            try {
                connection = Connections.getInstance().getConnection(string, false);
            }
            catch (DBException dBException) {
                // empty catch block
            }
            if (connection == null) {
                ideAction.setEnabled(false);
                return true;
            }
            int n = this._table.getSelectedColumn();
            if (n == -1 || this._table.isVerticalDisplay() || !this._table.canAutoFilter(n)) {
                ideAction.setEnabled(false);
            } else {
                ideAction.setEnabled(true);
            }
        }
        return true;
    }

    private boolean canShow() {
        if (this._table != null && this._table instanceof ResultSetTable && !this._table.isHostedInDialog()) {
            String string = ((ResultSetTable)this._table).getGridModel().getConnectionName();
            Connection connection = null;
            try {
                connection = Connections.getInstance().getConnection(string, false);
            }
            catch (DBException dBException) {
                // empty catch block
            }
            if (connection == null) {
                return false;
            }
            if (Connections.getInstance().isOracle(connection) || Connections.getInstance().isTimesTen(connection)) {
                return true;
            }
        }
        return false;
    }

    public void showFilterPanel(final ResultSetTable resultSetTable, final int n) {
        if (n == -1) {
            return;
        }
        if (!this.canShow()) {
            return;
        }
        try {
            if (this.gp != null) {
                this.gp.hidePanel();
                this.gp.remove((Component)resultSetTable.getTableHeader());
            }
            final String string = resultSetTable.getColumnName(n);
            final ResultSetTableModel resultSetTableModel = resultSetTable.getGridModel();
            this.gp = new GhostPalette((JComponent)resultSetTable.getTableHeader());
            this.gp.setHideOnLoseFocus(false);
            this.gp.fadeInOut(true);
            int n2 = resultSetTable.getCellRect((int)-1, (int)n, (boolean)true).getLocation().x;
            int n3 = -resultSetTable.getLocation().y - resultSetTable.getRowHeight(0) - resultSetTable.getRowMargin() - 10;
            Point point = new Point(n2, n3);
            point = SwingUtilities.convertPoint((Component)((Object)resultSetTable), point, null);
            this.gp.setLocation(point);
            this.gp.setTitle(RSTCMMessages.getString("FilterGrid.1") + string);
            JPanel jPanel = new JPanel(new BorderLayout());
            HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_filtercolumn_html");
            FilteringJList filteringJList = new FilteringJList(){

                public void itemSelected(Object object) {
                    String string5 = string;
                    String string2 = object instanceof FilteringJListItem ? ((FilteringJListItem)object).getValue() : object.toString();
                    string5 = DBUtil.addDoubleQuote((String)string);
                    if (object == RaptorGridFilter._ALL_ || string2 != null && string2.equals("") || string2 != null && RaptorGridFilter._ALL_.toString().equals(string2) && this.getSelectedValue() == RaptorGridFilter._ALL_) {
                        resultSetTableModel.removeFilter(resultSetTable.convertColumnIndexToModel(n));
                    } else if (string2 != null) {
                        String string3 = null;
                        String string4 = string2.toLowerCase().trim();
                        if (object != RaptorGridFilter._NULL_ && string2.trim().indexOf("=") == 0 || string4.indexOf(">") == 0 || string4.indexOf("<") == 0 || string4.indexOf("!=") == 0 || string4.indexOf("<=") == 0 || string4.indexOf(">=") == 0 || string4.indexOf("!=") == 0 || string4.indexOf("<>") == 0 || string4.indexOf("^=") == 0 || string4.indexOf("~=") == 0 || string4.indexOf("between ") == 0 || string4.indexOf("not between ") == 0 || string4.indexOf("like ") == 0 || string4.indexOf("not like ") == 0 || string4.indexOf("is null") == 0 || string4.indexOf("is not null") == 0 || string4.indexOf("in ") == 0 || string4.indexOf("not in ") == 0) {
                            string3 = string5 + "  " + string2;
                        } else if (string2 != null && RaptorGridFilter._NULL_.toString().equals(string2) && this.getSelectedValue() == RaptorGridFilter._NULL_) {
                            string3 = string5 + " IS NULL";
                        } else if (object != RaptorGridFilter._NULL_) {
                            string2 = string2.replaceAll("'", "''");
                            string3 = string5 + " = '" + string2 + "'";
                        }
                        RaptorGridFilter raptorGridFilter = new RaptorGridFilter(resultSetTable.convertColumnIndexToModel(n), string3, string3, string2);
                        resultSetTableModel.addFilter(raptorGridFilter);
                    }
                    try {
                        resultSetTable.clearSelection();
                        resultSetTableModel.refresh();
                    }
                    catch (ExecutionException executionException) {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, executionException.getStackTrace()[0].toString(), executionException);
                    }
                    FilterGrid.this.gp.hidePanel();
                }
            };
            JTextField jTextField = new JTextField();
            filteringJList.installJTextField(jTextField);
            List<FilteringJListItem> list = resultSetTable.getLoadedRowsForColumn(n);
            RaptorGridFilter raptorGridFilter = resultSetTableModel.getFilter(resultSetTable.convertColumnIndexToModel(n));
            if (raptorGridFilter != null && raptorGridFilter.isEnabled()) {
                list.add(0, RaptorGridFilter._ALL_);
                jTextField.setText(this.getRemoveFilterString(raptorGridFilter));
                jTextField.setEditable(false);
            }
            for (FilteringJListItem filteringJListItem : list) {
                filteringJList.addElement((Object)filteringJListItem);
                filteringJList.setSelectedIndex(-1);
            }
            filteringJList.setCellRenderer((ListCellRenderer)new FilterListRenderer((JTable)((Object)resultSetTable), raptorGridFilter, n));
            JScrollPane jScrollPane = new JScrollPane((Component)filteringJList);
            jPanel.add((Component)jScrollPane, "Center");
            jPanel.add((Component)jTextField, "North");
            this.gp.add((Component)jPanel);
            this.gp.setSize(resultSetTable.getColumnModel().getColumn(n).getWidth(), Math.max(resultSetTable.getVisibleRect().height, jScrollPane.getPreferredSize().height));
            this.gp.show(Ide.getMainWindow().getLayeredPane(), false, true);
        }
        catch (Exception exception) {
            Logger.getLogger(FilterGrid.class.getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public JMenuItem[] getJMenuItems(ContextMenu contextMenu) {
        this.createJMenuItem(contextMenu);
        return new JMenuItem[]{this._mi};
    }

    public void setTable(ResultSetTable resultSetTable) {
        this._table = resultSetTable;
    }

    private String getRemoveFilterString(RaptorGridFilter raptorGridFilter) {
        String string = raptorGridFilter.getFilterClause();
        if (string.indexOf("=") != -1 && string.indexOf("=") + 1 < string.length()) {
            string = string.substring(string.indexOf("=") + 1);
        }
        string = Messages.getString((String)"TablePanel.2") + " (" + string + ")";
        return string;
    }

    private class FilterListRenderer
    extends ResultSetTableCellRenderer
    implements ListCellRenderer {
        JTable table = null;
        RaptorGridFilter filter = null;
        int viewCol = -1;

        FilterListRenderer(JTable jTable, RaptorGridFilter raptorGridFilter, int n) {
            this.table = jTable;
            this.filter = raptorGridFilter;
            this.viewCol = n;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Object object2 = null;
            int n2 = n;
            Component component = null;
            Component component2 = null;
            String string = "";
            if (object == RaptorGridFilter._ALL_) {
                component = new JLabel();
                ((JLabel)component).setText(FilterGrid.this.getRemoveFilterString(this.filter));
            } else {
                if (object instanceof FilteringJListItem) {
                    n2 = ((FilteringJListItem)object).getRow();
                    object2 = ((FilteringJListItem)object).getObject();
                } else {
                    object2 = object;
                }
                component = super.getTableCellRendererComponent(this.table, object2, bl, bl2, n2, this.viewCol);
            }
            if (component instanceof JLabel && (string = ((JLabel)(component2 = component)).getText()).equals("")) {
                string = "NULL";
                ((JLabel)component2).setText(string);
            }
            if (component instanceof AbstractButton) {
                String string2 = ((AbstractButton)component).getText();
                component = new JLabel(string2);
            }
            return component;
        }
    }
}

