/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.grid;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.ParsePosition;
import java.util.EventObject;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.ControlsArb;
import oracle.dbtools.raptor.controls.celleditor.ICellEditor;
import oracle.dbtools.raptor.controls.celleditor.RaptorTableEditorJPanel;
import oracle.dbtools.raptor.controls.celleditor.RaptorTableEditorTextField;
import oracle.dbtools.raptor.controls.celleditor.popups.OracleDateTimeEditPanel;
import oracle.dbtools.raptor.controls.celleditor.popups.PopupCellEditor;
import oracle.dbtools.raptor.controls.celleditor.popups.PopupCellEditorFactory;
import oracle.dbtools.raptor.controls.celleditor.popups.PopupCellEditorHandler;
import oracle.dbtools.raptor.controls.display.EditableGridInfo;
import oracle.dbtools.raptor.controls.grid.EditableResultSetTableModel;
import oracle.dbtools.raptor.controls.grid.IDrillLink;
import oracle.dbtools.raptor.controls.grid.RSTableMessages;
import oracle.dbtools.raptor.controls.grid.ResultSetTable;
import oracle.dbtools.raptor.controls.grid.ResultSetTableModel;
import oracle.dbtools.raptor.navigator.net.editor.BreakoutEditorListener;
import oracle.dbtools.raptor.nls.NLSProvider;
import oracle.dbtools.raptor.nls.OraDATEFormat;
import oracle.dbtools.raptor.nls.OraTIMESTAMPFormat;
import oracle.dbtools.raptor.nls.OracleNLSProvider;
import oracle.dbtools.raptor.query.Column;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.ide.dialogs.DialogSizeKeeper;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.RichHintLabel;
import oracle.javatools.util.ModelUtil;
import oracle.sql.DATE;
import oracle.sql.TIMESTAMP;

public class ResultSetTableCellEditor
extends DefaultCellEditor
implements PopupCellEditorHandler {
    private Object valFrompopupEditor = null;
    private int columnDataType = -1;
    private String columnDataTypeName = null;
    private OraDATEFormat dateFormat = null;
    private OraTIMESTAMPFormat tsFormat = null;
    private ICellEditor iCellEditor = null;
    private JTable table = null;

    public ResultSetTableCellEditor(ResultSetTable resultSetTable) {
        super(new RaptorTableEditorTextField((JTable)((Object)resultSetTable)));
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        Component component;
        this.valFrompopupEditor = null;
        this.columnDataType = -1;
        this.columnDataTypeName = null;
        this.dateFormat = null;
        this.iCellEditor = null;
        this.table = jTable;
        Component component2 = null;
        if (object != null && object.toString().indexOf("SQLDEV:") == 0 && (component = this.getDrillComponent(object, jTable)) != null) {
            return component;
        }
        component = null;
        if (jTable instanceof ResultSetTable && ((ResultSetTable)((Object)jTable)).getGridModel() != null) {
            Column column;
            Connection connection;
            ResultSetTableModel resultSetTableModel;
            ResultSetTable resultSetTable;
            block30: {
                resultSetTable = (ResultSetTable)((Object)jTable);
                resultSetTableModel = resultSetTable.getGridModel();
                connection = null;
                column = resultSetTableModel.getQueryColumn(resultSetTable.convertRowIndexToModel(n), resultSetTable.convertColumnIndexToModel(n2));
                if (column != null && column.getCellEditor() != null && column.getCellEditor() != null) {
                    try {
                        Object obj = Class.forName(column.getCellEditor()).newInstance();
                        if (obj instanceof DefaultCellEditor) {
                            component2 = ((DefaultCellEditor)obj).getTableCellEditorComponent(jTable, object, bl, n, n2);
                            break block30;
                        }
                        if (obj instanceof ICellEditor) {
                            this.iCellEditor = (ICellEditor)obj;
                            component2 = ((ICellEditor)obj).getComponent(jTable, object, n, n2);
                            break block30;
                        }
                        RuntimeException runtimeException = new RuntimeException("Must be a DefaultCellEditor or ICellEditor");
                        Logger.getLogger(this.getClass().getName()).throwing(this.getClass().getName(), "getTableCellEditorComponent", runtimeException);
                        throw runtimeException;
                    }
                    catch (InstantiationException instantiationException) {
                        Logger.getLogger(this.getClass().getName()).severe(instantiationException.getLocalizedMessage());
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        Logger.getLogger(this.getClass().getName()).severe(illegalAccessException.getLocalizedMessage());
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        Logger.getLogger(this.getClass().getName()).severe(classNotFoundException.getLocalizedMessage());
                    }
                }
            }
            try {
                connection = Connections.getInstance().getConnection(resultSetTableModel.getConnectionName(), false);
            }
            catch (DBException dBException) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, dBException.getStackTrace()[0].toString(), dBException);
            }
            if (connection != null) {
                Object object2;
                boolean bl2 = resultSetTable.isEditable();
                this.columnDataType = resultSetTableModel.getGridColumns().get(jTable.convertColumnIndexToModel(n2)).getSqlType();
                this.columnDataTypeName = resultSetTableModel.getGridColumns().get(jTable.convertColumnIndexToModel(n2)).getSqlTypeName();
                if (Connections.getInstance().isOracle(connection)) {
                    this.tsFormat = ((OracleNLSProvider)NLSProvider.getProvider((Connection)connection)).getOraTIMESTAMPFormat();
                    this.dateFormat = ((OracleNLSProvider)NLSProvider.getProvider((Connection)connection)).getOraDATEFormat();
                }
                boolean bl3 = false;
                boolean bl4 = false;
                if (bl2) {
                    bl4 = resultSetTableModel.isCellEditorEditable(resultSetTable.convertRowIndexToModel(n), resultSetTable.convertColumnIndexToModel(n2));
                    bl3 = bl4 && this.isInPlaceEditingAllowed(this.columnDataType);
                }
                PopupCellEditor popupCellEditor = null;
                if (column != null && column.getCellPopup() != null) {
                    try {
                        object2 = Class.forName(column.getCellPopup()).newInstance();
                        if (!(object2 instanceof PopupCellEditor)) {
                            RuntimeException runtimeException = new RuntimeException("Must be a PopupCellEditor");
                            Logger.getLogger(this.getClass().getName()).throwing(this.getClass().getName(), "getTableCellEditorComponent", runtimeException);
                            throw runtimeException;
                        }
                        popupCellEditor = (PopupCellEditor)object2;
                    }
                    catch (InstantiationException instantiationException) {
                        Logger.getLogger(this.getClass().getName()).severe(instantiationException.getLocalizedMessage());
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        Logger.getLogger(this.getClass().getName()).severe(illegalAccessException.getLocalizedMessage());
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        Logger.getLogger(this.getClass().getName()).severe(classNotFoundException.getLocalizedMessage());
                    }
                }
                if (popupCellEditor == null && this.iCellEditor == null) {
                    popupCellEditor = PopupCellEditorFactory.getPopupCellEditor(resultSetTableModel.getConnectionName(), this.columnDataType, this.columnDataTypeName);
                }
                if (!Connections.getInstance().isOracle(connection) && DataTypesUtil.isDateOrTime((int)this.columnDataType) && popupCellEditor instanceof OracleDateTimeEditPanel) {
                    popupCellEditor = null;
                }
                if (popupCellEditor != null) {
                    popupCellEditor.setConnection(connection);
                    popupCellEditor.setRowData(resultSetTableModel.getRowModel(n));
                    popupCellEditor.setEditable(bl4);
                    if (bl4) {
                        object2 = new EditableGridInfo(resultSetTableModel.getSql(), resultSetTableModel.getBindList(), resultSetTableModel.getBindMap(), ((EditableResultSetTableModel)resultSetTableModel).getTableName());
                        popupCellEditor.setGridInfo((EditableGridInfo)object2);
                    }
                }
                if (DataTypesUtil.isExtendedType((Object)object, (int)this.columnDataType)) {
                    this.valFrompopupEditor = object;
                }
                object = component == null ? DataTypesUtil.stringValue((Object)object, (Connection)connection, (int)Integer.MAX_VALUE) : component;
                object2 = null;
                if (component2 == null) {
                    final RaptorTableEditorTextField raptorTableEditorTextField = new RaptorTableEditorTextField((JTable)((Object)resultSetTable));
                    raptorTableEditorTextField.setText(object != null ? object.toString() : "");
                    this.delegate = new DefaultCellEditor.EditorDelegate(){

                        @Override
                        public void setValue(Object object) {
                            raptorTableEditorTextField.setText(object != null ? object.toString() : "");
                        }

                        @Override
                        public Object getCellEditorValue() {
                            return raptorTableEditorTextField.getText();
                        }
                    };
                    raptorTableEditorTextField.addActionListener(this.delegate);
                    String string = raptorTableEditorTextField.getText();
                    if (string.contains("\n") || string.contains("\t") || string.contains("\r")) {
                        bl3 = false;
                    }
                    object2 = new RaptorTableEditorJPanel((PopupCellEditorHandler)this, raptorTableEditorTextField, bl3, popupCellEditor);
                } else {
                    object2 = new RaptorTableEditorJPanel((PopupCellEditorHandler)this, (JComponent)component2, bl3, popupCellEditor);
                }
                component2 = object2;
            } else {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, MessageFormat.format(RSTableMessages.getString("ResultSetTableModel.14"), Connections.getDisplayName(resultSetTableModel.getConnectionName())));
            }
        }
        if (component2 == null) {
            component2 = super.getTableCellEditorComponent(jTable, object, bl, n, n2);
        }
        return component2;
    }

    protected boolean isInPlaceEditingAllowed(int n) {
        switch (n) {
            case -13: 
            case -4: 
            case -3: 
            case -2: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2007: {
                return false;
            }
        }
        return true;
    }

    public static boolean hasExtendedEdit(int n) {
        switch (n) {
            case -13: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 12: 
            case 91: 
            case 93: 
            case 2004: 
            case 2005: 
            case 2007: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        MouseEvent mouseEvent;
        return !(eventObject instanceof MouseEvent) || (mouseEvent = (MouseEvent)eventObject).getClickCount() == 2;
    }

    @Override
    public Object getCellEditorValue() {
        if (this.valFrompopupEditor != null) {
            return this.valFrompopupEditor;
        }
        if (this.iCellEditor != null) {
            return this.iCellEditor.getValue();
        }
        return super.getCellEditorValue();
    }

    public void setValue(Object object) {
        this.delegate.setValue(object);
    }

    @Override
    public void handlePopupEdit(final PopupCellEditor popupCellEditor) {
        final JComponent jComponent = popupCellEditor.getComponent();
        if (jComponent == null) {
            return;
        }
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jComponent, (Component)popupCellEditor.getDefaultComponent(), (String)(popupCellEditor.isEditable() ? ControlsArb.getString("RESULTSET_EDIT_VALUE_TITLE") : ControlsArb.getString("RESULTSET_VIEW_VALUE_TITLE")));
        String string = popupCellEditor.getHelpTopicId();
        if (!ModelUtil.hasLength((String)string)) {
            string = "f1_extendeddataedit_html";
        }
        HelpSystem.getHelpSystem().registerTopic(jComponent, string);
        jEWTDialog.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                String string;
                if ("closed".equals(propertyChangeEvent.getPropertyName()) && Boolean.TRUE.equals(propertyChangeEvent.getNewValue()) && (string = popupCellEditor.validateValue()) != null) {
                    MessageDialog.error((Component)jComponent, (Object)string, (String)RSTableMessages.getString("ResultSetTableCellEditor.0"), (String)popupCellEditor.getHelpTopicId());
                    throw new PropertyVetoException(RSTableMessages.getString("ResultSetTableCellEditor.1"), propertyChangeEvent);
                }
            }
        });
        jEWTDialog.setResizable(true);
        DialogSizeKeeper.attachToComponent((Component)jEWTDialog, (String)(popupCellEditor.getClass().getName() + ".dialogSize"));
        jEWTDialog.setOKButtonEnabled(popupCellEditor.isEditable());
        popupCellEditor.setValue(this.getCellEditorValue());
        popupCellEditor.setPopupDialog(jEWTDialog);
        popupCellEditor.setBreakoutEditorListener(new BreakoutEditorListener(){

            @Override
            public void save(Object object) {
                if (this.savable()) {
                    ResultSetTableCellEditor.this.valFrompopupEditor = object;
                    if (ResultSetTableCellEditor.this.isDateDatatype(ResultSetTableCellEditor.this.columnDataTypeName)) {
                        ResultSetTableCellEditor.this.valFrompopupEditor = ResultSetTableCellEditor.this.getDateString((String)ResultSetTableCellEditor.this.valFrompopupEditor);
                    }
                    ResultSetTableCellEditor.this.setValue(ResultSetTableCellEditor.this.valFrompopupEditor);
                    ResultSetTableCellEditor.this.stopCellEditing();
                }
            }

            @Override
            public boolean savable() {
                int n = ResultSetTableCellEditor.this.getCellEditorListeners().length;
                return n > 0;
            }
        });
        if (WizardLauncher.runDialog((JDialog)jEWTDialog)) {
            this.valFrompopupEditor = popupCellEditor.getValue();
            if (this.dateFormat != null && this.isDateDatatype(this.columnDataTypeName)) {
                this.valFrompopupEditor = this.getDateString((String)this.valFrompopupEditor);
            }
            this.setValue(this.valFrompopupEditor);
            this.stopCellEditing();
        } else if (!popupCellEditor.editorBrokeout()) {
            this.cancelCellEditing();
        }
        popupCellEditor.dismissPopupEditor();
        if (this.table != null) {
            this.table.requestFocusInWindow();
            this.table = null;
        }
    }

    private boolean isDateDatatype(String string) {
        return string.equals("DATE");
    }

    private String getDateString(String string) {
        String string2 = null;
        TIMESTAMP tIMESTAMP = this.tsFormat.parseTIMESTAMP(string, new ParsePosition(0));
        try {
            Timestamp timestamp = tIMESTAMP.timestampValue();
            string2 = this.dateFormat.format(new DATE(timestamp));
        }
        catch (SQLException sQLException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        return string2;
    }

    private Component getDrillComponent(Object object, JTable jTable) {
        final RichHintLabel richHintLabel = new RichHintLabel();
        String string = ":";
        String string2 = object.toString();
        if (string2.startsWith("SQLDEV:LINK")) {
            if (string2.startsWith("SQLDEV:LINK{")) {
                string = string2.substring(string2.indexOf("{") + 1, string2.indexOf("}"));
                string2 = string2.substring(string2.indexOf("}") + 1);
            } else if (string2.startsWith("SQLDEV:LINK:")) {
                string2 = string2.substring(string2.indexOf("LINK:") + 5);
            }
            final String[] stringArray = string2.split(string);
            final String string3 = stringArray[stringArray.length - 1];
            String string4 = stringArray[stringArray.length - 2];
            if (jTable instanceof ResultSetTable && ((ResultSetTable)((Object)jTable)).getGridModel() != null) {
                ResultSetTable resultSetTable = (ResultSetTable)((Object)jTable);
                ResultSetTableModel resultSetTableModel = resultSetTable.getGridModel();
                try {
                    Connection connection = Connections.getInstance().getConnection(resultSetTableModel.getConnectionName(), false);
                    if (connection != null) {
                        final String string5 = Connections.getInstance().getConnectionName(connection);
                        richHintLabel.setHtmlText("<a href=\"http:" + string4 + "\">" + string4 + "</a>");
                        richHintLabel.registerAction(string4, (Action)new AbstractAction(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                try {
                                    Class<?> clazz = Class.forName(string3);
                                    IDrillLink iDrillLink = (IDrillLink)clazz.newInstance();
                                    iDrillLink.setArgs(stringArray);
                                    iDrillLink.setConnName(string5);
                                    iDrillLink.performDrill();
                                }
                                catch (Exception exception) {
                                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
                                }
                            }
                        });
                        final HyperlinkEvent hyperlinkEvent = new HyperlinkEvent(this, HyperlinkEvent.EventType.ACTIVATED, null, string4);
                        Runnable runnable = new Runnable(){

                            @Override
                            public void run() {
                                richHintLabel.fireHyperlinkUpdate(hyperlinkEvent);
                            }
                        };
                        SwingUtilities.invokeLater(runnable);
                        return richHintLabel;
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
                }
            }
        }
        return null;
    }
}

