/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.grid;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionHook;
import oracle.dbtools.raptor.controls.grid.RSTableMessages;
import oracle.dbtools.raptor.controls.grid.ResultSetTableModel;
import oracle.javatools.util.ModelUtil;

public class RSTModelHook
extends ExtensionHook {
    private static Logger LOGGER = Logger.getLogger(RSTModelHook.class.getName());
    private static final String NS = "http://xmlns.oracle.com/sqldeveloper/sqldev-rstmodel";
    public static final ElementName ELEMENT_NAME = new ElementName("http://xmlns.oracle.com/sqldeveloper/sqldev-rstmodel", "sqldev-rstmodel-hook");
    public static final String HOOKELEMENTNAME = "provider";
    public static final String DRIVERCLASS = "driverClass";
    private static Map<String, Class<? extends ResultSetTableModel>> s_provClassNames = new HashMap<String, Class<? extends ResultSetTableModel>>();

    public static Class<? extends ResultSetTableModel> getRSTModel(String string) {
        return s_provClassNames.get(string);
    }

    public static void registerRSTModel(String string, Class<? extends ResultSetTableModel> clazz) {
        if (string == null || !ModelUtil.hasLength((String)string.trim())) {
            LOGGER.log(Level.SEVERE, RSTableMessages.getString("RSTModelHook.2"));
            return;
        }
        if (clazz == null) {
            LOGGER.log(Level.SEVERE, RSTableMessages.getString("RSTModelHook.0"));
            return;
        }
        string = string.trim();
        s_provClassNames.put(string, clazz);
    }

    public void start(ElementStartContext elementStartContext) {
        elementStartContext.registerChildVisitor(new ElementName(NS, HOOKELEMENTNAME), (ElementVisitor)new ProviderChildVisitor());
    }

    private static class ProviderChildVisitor
    extends ElementVisitor {
        private ProviderChildVisitor() {
        }

        public void start(ElementStartContext elementStartContext) {
            String string = elementStartContext.getAttributeValue(RSTModelHook.DRIVERCLASS);
            elementStartContext.getScopeData().put("_driverClass", string);
        }

        public void end(ElementEndContext elementEndContext) {
            String string = elementEndContext.getText();
            String string2 = elementEndContext.getScopeData().get("_driverClass").toString();
            try {
                RSTModelHook.registerRSTModel(string2, Class.forName(string).asSubclass(ResultSetTableModel.class));
            }
            catch (ClassNotFoundException classNotFoundException) {
                LogRecord logRecord = new LogRecord(Level.SEVERE, classNotFoundException.getLocalizedMessage());
                logRecord.setThrown(classNotFoundException);
                LOGGER.log(logRecord);
            }
        }
    }
}

