/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.grid;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.controls.CompletionTextFieldWithDrop;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.controls.grid.EditableResultSetTable;
import oracle.dbtools.raptor.controls.grid.GridFilterField;
import oracle.dbtools.raptor.controls.grid.GridFilterInsightProvider;
import oracle.dbtools.raptor.controls.grid.RSTableMessages;
import oracle.dbtools.raptor.controls.grid.RaptorGridTable;
import oracle.dbtools.raptor.controls.grid.contextmenu.GridContextMenuItem;
import oracle.dbtools.raptor.controls.grid.contextmenu.GridSorter;
import oracle.dbtools.raptor.dialogs.CreateDialogArb;
import oracle.dbtools.util.Logger;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.view.View;
import oracle.javatools.controls.completionfield.CompletionTextField;
import oracle.javatools.controls.completionfield.FieldInsightProvider;

public class EditableGridController
implements Controller {
    public static final String NO_REFRESH_CMD = "EditableGridControl.NO_REFRESH_CMD";
    private static final String FILTER_DATA_CMD = "raptor.dataeditor.filter.data";
    private static final String REFRESH_CMD = "raptor.dataeditor.refresh";
    private static final String SORT_CMD = "raptor.dataeditor.sort";
    private static final String ROLLBACK_CHANGES_CMD = "raptor.dataeditor.rollback";
    private static final String COMMIT_CHANGES_CMD = "raptor.dataeditor.commit";
    private static final String DELETE_ROW_CMD = "raptor.dataeditor.delete";
    private static final String INSERT_ROW_CMD = "raptor.dataeditor.insert";
    private static final int INSERT_ROW_CMD_ID = Ide.findOrCreateCmdID((String)"raptor.dataeditor.insert");
    private static final int DELETE_ROW_CMD_ID = Ide.findOrCreateCmdID((String)"raptor.dataeditor.delete");
    private static final int COMMIT_CHANGES_CMD_ID = Ide.findOrCreateCmdID((String)"raptor.dataeditor.commit");
    private static final int ROLLBACK_CHANGES_CMD_ID = Ide.findOrCreateCmdID((String)"raptor.dataeditor.rollback");
    private static final int SORT_CMD_ID = Ide.findOrCreateCmdID((String)"raptor.dataeditor.sort");
    private static final int REFRESH_CMD_ID = Ide.findOrCreateCmdID((String)"raptor.dataeditor.refresh");
    private static final int FILTER_DATA_CMD_ID = Ide.findOrCreateCmdID((String)"raptor.dataeditor.filter.data");
    private IdeAction m_INSERT_ACTION;
    private IdeAction m_DELETE_ACTION;
    private IdeAction m_REFRESH_ACTION;
    private IdeAction m_COMMIT_ACTION;
    private IdeAction m_ROLLBACK_ACTION;
    private IdeAction m_SORT_ACTION;
    private IdeAction m_FILTER_ACTION;
    private EditableResultSetTable _grid = null;
    private View _view = null;
    private Controller _superController = null;
    private JButton _sortButton = null;
    private GridSorter sorter = (GridSorter)GridSorter.getInstance();
    private JLabel filterLabel;
    private GridFilterField filterField;
    private CompletionTextFieldWithDrop filterPanel;
    private EditableGridContextMenu _cm = new EditableGridContextMenu();
    private static final List<Integer> _handledCommandIds = new ArrayList<Integer>();
    private static final String BUTTON = "BUTTON";

    private IdeAction getInsertAction() {
        if (null == this.m_INSERT_ACTION) {
            this.m_INSERT_ACTION = IdeAction.find((int)INSERT_ROW_CMD_ID).newLocalAction(this._view);
            this.setupAccelaratorToolTip(this.m_INSERT_ACTION);
            this.m_INSERT_ACTION.addController(new Controller(){

                public boolean handleEvent(IdeAction ideAction, Context context) {
                    EditableGridController.this._grid.addRow();
                    return true;
                }

                public boolean update(IdeAction ideAction, Context context) {
                    ideAction.setEnabled(EditableGridController.this.isGridReady() && EditableGridController.this._grid.isInsertAllowed());
                    return true;
                }
            });
        }
        return this.m_INSERT_ACTION;
    }

    private IdeAction getDeleteAction() {
        if (null == this.m_DELETE_ACTION) {
            this.m_DELETE_ACTION = IdeAction.find((int)DELETE_ROW_CMD_ID).newLocalAction(this._view);
            this.setupAccelaratorToolTip(this.m_DELETE_ACTION);
            this.m_DELETE_ACTION.addController(new Controller(){

                public boolean handleEvent(IdeAction ideAction, Context context) {
                    EditableGridController.this._grid.deleteRow();
                    return true;
                }

                public boolean update(IdeAction ideAction, Context context) {
                    ideAction.setEnabled(EditableGridController.this.isGridReady() && EditableGridController.this._grid.isDeleteAllowed() && EditableGridController.this._grid.getSelectedRow() != -1);
                    return true;
                }
            });
        }
        return this.m_DELETE_ACTION;
    }

    public IdeAction getRefreshAction() {
        if (null == this.m_REFRESH_ACTION) {
            this.m_REFRESH_ACTION = IdeAction.find((int)REFRESH_CMD_ID).newLocalAction(this._view);
            this.setupAccelaratorToolTip(this.m_REFRESH_ACTION);
            this.m_REFRESH_ACTION.addController(new Controller(){

                public boolean handleEvent(IdeAction ideAction, Context context) {
                    EditableGridController.this._grid.refresh();
                    return true;
                }

                public boolean update(IdeAction ideAction, Context context) {
                    ideAction.setEnabled(EditableGridController.this.isGridReady());
                    return true;
                }
            });
        }
        return this.m_REFRESH_ACTION;
    }

    public IdeAction getCommitAction() {
        if (null == this.m_COMMIT_ACTION) {
            this.m_COMMIT_ACTION = IdeAction.find((int)COMMIT_CHANGES_CMD_ID).newLocalAction(this._view);
            this.setupAccelaratorToolTip(this.m_COMMIT_ACTION);
            this.m_COMMIT_ACTION.addController(new Controller(){

                public boolean handleEvent(IdeAction ideAction, Context context) {
                    EditableGridController.this._grid.save();
                    return true;
                }

                public boolean update(IdeAction ideAction, Context context) {
                    ideAction.setEnabled(EditableGridController.this.isGridReady() && EditableGridController.this._grid.isChanged());
                    return true;
                }
            });
        }
        return this.m_COMMIT_ACTION;
    }

    public IdeAction getRollbackAction() {
        if (null == this.m_ROLLBACK_ACTION) {
            this.m_ROLLBACK_ACTION = IdeAction.find((int)ROLLBACK_CHANGES_CMD_ID).newLocalAction(this._view);
            this.setupAccelaratorToolTip(this.m_ROLLBACK_ACTION);
            this.m_ROLLBACK_ACTION.addController(new Controller(){

                public boolean handleEvent(IdeAction ideAction, Context context) {
                    EditableGridController.this._grid.rollback();
                    return true;
                }

                public boolean update(IdeAction ideAction, Context context) {
                    ideAction.setEnabled(EditableGridController.this.isGridReady() && EditableGridController.this._grid.isChanged());
                    return true;
                }
            });
        }
        return this.m_ROLLBACK_ACTION;
    }

    private IdeAction getSortAction() {
        if (null == this.m_SORT_ACTION) {
            this.m_SORT_ACTION = IdeAction.find((int)SORT_CMD_ID).newLocalAction(this._view);
            this.setupAccelaratorToolTip(this.m_SORT_ACTION);
            this.m_SORT_ACTION.addController(new Controller(){

                public boolean handleEvent(IdeAction ideAction, Context context) {
                    EditableGridController.this.sorter.setGrid((RaptorGridTable)EditableGridController.this._grid);
                    EditableGridController.this.sorter.sort();
                    return true;
                }

                public boolean update(IdeAction ideAction, Context context) {
                    ideAction.setEnabled(EditableGridController.this.isGridReady());
                    return true;
                }
            });
        }
        return this.m_SORT_ACTION;
    }

    private IdeAction getFilterAction() {
        if (null == this.m_FILTER_ACTION) {
            this.m_FILTER_ACTION = IdeAction.find((int)FILTER_DATA_CMD_ID).newLocalAction(this._view);
            this.setupAccelaratorToolTip(this.m_FILTER_ACTION);
            this.m_FILTER_ACTION.addController(new Controller(){

                public boolean handleEvent(IdeAction ideAction, Context context) {
                    EditableGridController.this.filterField.requestFocusInWindow();
                    return true;
                }

                public boolean update(IdeAction ideAction, Context context) {
                    ideAction.setEnabled(EditableGridController.this.isGridReady() && EditableGridController.this._grid.isFilterFieldAllowed());
                    return true;
                }
            });
        }
        return this.m_FILTER_ACTION;
    }

    private void setupAccelaratorToolTip(IdeAction ideAction) {
        UIUtils.setupAccelerator((IdeAction)ideAction);
        if (null == this._grid) {
            Logger.severe(this.getClass(), (String)"Internal Error: Attempt to set up accelerators before _grid initialized.");
        } else {
            this._grid.getActionMap().put(ideAction.getCommandId(), (Action)ideAction);
        }
    }

    public boolean isGridReady() {
        if (this._grid == null) {
            return false;
        }
        if (this._grid.getGridModel() == null) {
            return false;
        }
        if (this._grid.getGridModel().isBusy()) {
            return false;
        }
        return this._grid.getGridModel().getGridColumns() != null;
    }

    private static void addHandledCommandId(Integer n) {
        _handledCommandIds.add(n);
    }

    private static boolean isHandledCommandId(Integer n) {
        return _handledCommandIds.contains(n);
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (!EditableGridController.isHandledCommandId(n)) {
            if (this._superController != null) {
                return this._superController.handleEvent(ideAction, context);
            }
            return false;
        }
        if (null == this._grid) {
            Logger.warn(this.getClass(), (String)("Internal Error: Null grid when trying to handle " + ideAction));
        }
        try {
            if (n == 17) {
                if (this._grid.getGridCopyAdapter().canCut()) {
                    this._grid.getGridCopyAdapter().copyToClipboard(true);
                }
            } else if (n == 18) {
                if (this._grid.getGridCopyAdapter().canCopy()) {
                    this._grid.getGridCopyAdapter().copyToClipboard();
                }
            } else if (n == 19) {
                if (this.filterField.hasFocus()) {
                    this.filterField.paste();
                } else {
                    this._grid.getGridCopyAdapter().pasteToJTable();
                }
            } else {
                Logger.severe(this.getClass(), (String)("Internal Error: No handler implementation for " + ideAction));
            }
        }
        catch (Exception exception) {
            Logger.warn(this.getClass(), (Throwable)exception);
        }
        return true;
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (!EditableGridController.isHandledCommandId(n)) {
            if (this._superController != null) {
                return this._superController.update(ideAction, context);
            }
            return false;
        }
        if (!this.isGridReady()) {
            ideAction.setEnabled(false);
            return true;
        }
        try {
            if (n == 17) {
                ideAction.setEnabled(this._grid.getGridCopyAdapter().canCut());
            } else if (n == 18) {
                ideAction.setEnabled(this._grid.getGridCopyAdapter().canCopy());
            } else if (n == 19) {
                ideAction.setEnabled(this._grid.getGridCopyAdapter().canPaste());
            } else {
                Logger.severe(this.getClass(), (String)("Internal Error: No update implementation for " + ideAction));
            }
        }
        catch (Exception exception) {
            Logger.warn(this.getClass(), (Throwable)exception);
        }
        return true;
    }

    void setGrid(EditableResultSetTable editableResultSetTable) {
        this.clearLocalActions();
        this._grid = editableResultSetTable;
        if (editableResultSetTable == null) {
            this._superController = null;
            this.setView(null);
            return;
        }
        EditableResultSetTable.addGridContextMenu((GridContextMenuItem)this._cm);
        this.filterField = new GridFilterField(this._grid){

            List<String> getColumnNames() {
                List list = super.getColumnNames();
                ArrayList<String> arrayList = new ArrayList<String>();
                for (String string : list) {
                    if (EditableGridController.this.caseMatters(string)) {
                        string = DBUtil.getInstance((String)EditableGridController.this._grid.getGridModel().getConnectionName()).addDbQuotes(string);
                    }
                    arrayList.add(string);
                }
                return arrayList;
            }
        };
        this.filterPanel = new CompletionTextFieldWithDrop((CompletionTextField)this.filterField);
    }

    private boolean caseMatters(String string) {
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            Character c = Character.valueOf(cArray[i]);
            if (Character.isUpperCase(c.charValue()) || Character.isDigit(c.charValue())) continue;
            if (i == 0) {
                return true;
            }
            if (c.charValue() == '_' || c.charValue() == '$' || c.charValue() == '#') continue;
            return true;
        }
        return false;
    }

    private void clearLocalActions() {
        this.m_INSERT_ACTION = null;
        this.m_DELETE_ACTION = null;
        this.m_REFRESH_ACTION = null;
        this.m_COMMIT_ACTION = null;
        this.m_ROLLBACK_ACTION = null;
        this.m_SORT_ACTION = null;
        this.m_FILTER_ACTION = null;
    }

    public void setView(View view) {
        this.clearLocalActions();
        this._view = view;
    }

    public void setSuperController(Controller controller) {
        this._superController = controller;
    }

    private boolean addToToolbar(JButton jButton, Toolbar toolbar) {
        boolean bl = false;
        if (jButton == null || toolbar.getComponentIndex((Component)jButton) == -1) {
            toolbar.add((Component)jButton);
            bl = true;
        }
        return bl;
    }

    public boolean addToToolbar(IdeAction ideAction, Toolbar toolbar) {
        boolean bl = false;
        JComponent jComponent = (JComponent)ideAction.getValue(BUTTON);
        if (jComponent == null || toolbar.getComponentIndex((Component)jComponent) == -1) {
            jComponent = toolbar.add((ToggleAction)ideAction);
            jComponent.setName(ideAction.getValue("Name").toString());
            ideAction.putValue(BUTTON, (Object)jComponent);
            bl = true;
        }
        return bl;
    }

    private void removeFromToolbar(IdeAction ideAction, Toolbar toolbar) {
        if (null == ideAction) {
            return;
        }
        JComponent jComponent = (JComponent)ideAction.getValue(BUTTON);
        if (jComponent != null && toolbar.getComponentIndex((Component)jComponent) != -1) {
            toolbar.remove((Component)jComponent);
        }
    }

    public void addToolBarActions(Toolbar toolbar) {
        if (this._grid != null && toolbar != null) {
            if (this._grid.isRefreshAllowed() && !Boolean.parseBoolean((String)toolbar.getClientProperty((Object)NO_REFRESH_CMD))) {
                this.addToToolbar(this.getRefreshAction(), toolbar);
            }
            boolean bl = false;
            if (this.addToToolbar(this.getInsertAction(), toolbar)) {
                bl = true;
            }
            if (this.addToToolbar(this.getDeleteAction(), toolbar)) {
                bl = true;
            }
            if (this.addToToolbar(this.getCommitAction(), toolbar)) {
                bl = true;
            }
            if (this.addToToolbar(this.getRollbackAction(), toolbar)) {
                bl = true;
            }
            if (bl) {
                toolbar.addSeparator();
            }
            if (this._grid.isMultiColSort()) {
                if (this._sortButton == null) {
                    IdeAction ideAction = this.getSortAction();
                    this._sortButton = new JButton((Action)ideAction);
                    this._sortButton.setText(RSTableMessages.getString("EditableGridController.0"));
                    this._sortButton.setIcon(null);
                    this._sortButton.setToolTipText(RSTableMessages.getString("EditableGridController.1"));
                    ideAction.putValue(BUTTON, (Object)this._sortButton);
                }
                if (this.addToToolbar(this._sortButton, toolbar)) {
                    toolbar.addSeparator();
                }
            } else {
                this.removeFromToolbar(this.m_SORT_ACTION, toolbar);
            }
            if (this._grid.isFilterFieldAllowed()) {
                if (this.filterLabel == null) {
                    this.filterLabel = new JLabel(CreateDialogArb.getString("DATAED_FILTER"));
                }
                if (toolbar.getComponentIndex((Component)this.filterLabel) == -1) {
                    this.filterField.getPopupHandler().registerInsightProvider((FieldInsightProvider)new GridFilterInsightProvider(this.filterField));
                    this.filterField.getAccessibleContext().setAccessibleName(this.filterLabel.getText());
                    this.filterField.getAccessibleContext().setAccessibleName("Filter");
                    this.filterField.setEditable(true);
                    this.filterPanel.setSize(200, 0);
                    toolbar.add((Component)this.filterLabel);
                    toolbar.add((Component)this.filterPanel);
                }
            } else {
                toolbar.remove((Component)this.filterPanel);
                if (this.filterLabel != null) {
                    toolbar.remove((Component)this.filterLabel);
                }
            }
        }
    }

    public void addContextMenuActions(ContextMenu contextMenu) {
        if (this._grid != null && contextMenu != null) {
            JMenuItem jMenuItem;
            Context context = contextMenu.getContext();
            context.setView(this._view);
            if (this._grid.isRefreshAllowed()) {
                jMenuItem = contextMenu.createMenuItem((ToggleAction)this.getRefreshAction());
                contextMenu.add((Component)jMenuItem);
            }
            if (this._grid.isEditable()) {
                if (this._grid.isInsertAllowed()) {
                    jMenuItem = contextMenu.createMenuItem((ToggleAction)this.getInsertAction());
                    contextMenu.add((Component)jMenuItem);
                }
                if (this._grid.isDeleteAllowed()) {
                    jMenuItem = contextMenu.createMenuItem((ToggleAction)this.getDeleteAction());
                    contextMenu.add((Component)jMenuItem);
                }
                if (this._grid.isCommitActionAllowed()) {
                    jMenuItem = contextMenu.createMenuItem((ToggleAction)this.getCommitAction());
                    contextMenu.add((Component)jMenuItem);
                }
                if (this._grid.isRollbackActionAllowed()) {
                    jMenuItem = contextMenu.createMenuItem((ToggleAction)this.getRollbackAction());
                    contextMenu.add((Component)jMenuItem);
                }
            }
        }
    }

    public GridFilterField getGridFilterField() {
        return this.filterField;
    }

    EditableGridContextMenu getEditableGridContextMenu() {
        return this._cm;
    }

    public EditableResultSetTable getGrid() {
        return this._grid;
    }

    public void updateControllerActions(boolean bl) {
        this.setEnabled(this.m_INSERT_ACTION, bl);
        this.setEnabled(this.m_DELETE_ACTION, bl);
        this.setEnabled(this.m_COMMIT_ACTION, bl);
        this.setEnabled(this.m_ROLLBACK_ACTION, bl);
        this.filterPanel.setEnabled(bl);
        this._sortButton.setEnabled(bl);
    }

    private void setEnabled(IdeAction ideAction, boolean bl) {
        if (null == ideAction) {
            return;
        }
        ideAction.setEnabled(bl);
    }

    static {
        EditableGridController.addHandledCommandId(17);
        EditableGridController.addHandledCommandId(18);
        EditableGridController.addHandledCommandId(19);
    }

    private class EditableGridContextMenu
    extends GridContextMenuItem {
        private EditableGridContextMenu() {
        }

        protected boolean canShow(ContextMenu contextMenu) {
            if (this._table == null || !this._table.isEditable()) {
                return false;
            }
            if (!(this._table instanceof EditableResultSetTable)) {
                return false;
            }
            return (EditableResultSetTable)this._table == EditableGridController.this._grid;
        }

        protected void createAndShowMenu(ContextMenu contextMenu) {
            EditableGridController.this.addContextMenuActions(contextMenu);
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            return EditableGridController.this.handleEvent(ideAction, context);
        }

        public boolean update(IdeAction ideAction, Context context) {
            return EditableGridController.this.update(ideAction, context);
        }
    }
}

