/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.TabbedPaneUI;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskDescriptor;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskUtils;
import oracle.dbtools.raptor.controls.BindInfo;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.controls.display.DisplayRegistry;
import oracle.dbtools.raptor.controls.display.IDisplay;
import oracle.dbtools.raptor.controls.display.IModifyToolbar;
import oracle.dbtools.raptor.controls.display.ISelectionChangeListener;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.query.Bind;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.controls.tabbedpane.CustomTabbedPaneUI;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.IdeUtil;
import oracle.javatools.db.DBException;
import oracle.javatools.icons.OracleIcons;

public class DisplayPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final String NO_REFRESH = "no.refresh.in.toolbar";
    public static final String NO_RUN = "no.run.in.toolbar";
    private Logger logger = Logger.getLogger(DisplayPanel.class.getName());
    private Toolbar _toolbar;
    private DisplayPanel _parent = null;
    private DisplayModel _model;
    private JSplitPane _sp;
    private JTabbedPane _tabbed;
    private IDisplay _main = null;
    private List<IDisplay> _children = new ArrayList<IDisplay>();
    private List<DisplayPanel> _childPanels = new ArrayList<DisplayPanel>();
    JEWTDialog dlg;
    boolean renderDisplay = true;
    boolean _building = false;
    private JComboBox _timerInterval;
    private Timer _timer;
    private TimerTask _tt;
    private boolean prompt;
    protected RaptorTaskAdapter _taskListener;
    boolean _isEnableRefresh = true;
    protected ISelectionChangeListener selectionChangeListener = new SelectChanged();
    private Map<String, Object> _binds;
    private boolean _forceBindPrompt = false;
    private String _connName;
    boolean _force;
    boolean _detail;

    public DisplayPanel(DisplayModel displayModel) {
        this(displayModel, null, true, null);
    }

    public DisplayPanel(DisplayModel displayModel, boolean bl) {
        this(displayModel, null, bl, null);
    }

    public DisplayPanel(DisplayModel displayModel, Map<String, Object> map, boolean bl, Toolbar toolbar) {
        this.setLayout(new BorderLayout());
        this._toolbar = toolbar == null ? new Toolbar() : toolbar;
        this.add((Component)this._toolbar, "First");
        this._taskListener = new TaskListener();
        this._binds = map;
        if (displayModel == null) {
            this._model = new DisplayModel();
        } else {
            this._model = displayModel;
            this.close();
            this.buildToolbar();
            this.buildUI(bl);
            this.setChildBinds(map);
        }
        if (this._main != null) {
            this._main.appendBindMap(this._binds);
        }
    }

    public ArrayList<IDisplay> getChildren() {
        return (ArrayList)this._children;
    }

    public DisplayPanel(DisplayModel displayModel, DisplayPanel displayPanel, Toolbar toolbar) {
        this._parent = displayPanel;
        this.setLayout(new BorderLayout());
        this._toolbar = toolbar == null ? new Toolbar() : toolbar;
        this.add((Component)this._toolbar, "First");
        if (displayModel == null) {
            this._model = new DisplayModel();
        } else {
            this._model = displayModel;
            this.close();
            this.buildToolbar();
            this.buildUI(true);
        }
    }

    public void setChildBinds(Map<String, Object> map) {
        for (IDisplay iDisplay : this._children) {
            iDisplay.setConn(this.getConnection());
            iDisplay.appendBindMap(map);
        }
    }

    private void buildToolbar() {
        Object object;
        Object object2;
        this.addToolbarActions();
        if (!Boolean.parseBoolean(this._model.getExtValues().get(NO_RUN))) {
            object2 = new AbstractAction(Messages.getString("DisplayPanel.6"), OracleIcons.getIcon((String)"refresh.png")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (null == DisplayPanel.this._parent) {
                        DisplayPanel.this.refresh(false, true);
                    } else {
                        ((DisplayPanel)DisplayPanel.this)._parent.selectionChangeListener.parentSelectionChanged();
                    }
                }
            };
            ((AbstractAction)object2).putValue("ShortDescription", Messages.getString("DisplayPanel.33"));
            this._toolbar.add((Action)object2);
            this._toolbar.addSeparator();
        }
        if (!Boolean.parseBoolean(this._model.getExtValues().get(NO_REFRESH))) {
            object2 = new JLabel(Messages.getString("DisplayPanel.10"));
            this._timerInterval = new JComboBox();
            object = (DefaultComboBoxModel)this._timerInterval.getModel();
            ((DefaultComboBoxModel)object).addElement("0");
            ((DefaultComboBoxModel)object).addElement("5");
            ((DefaultComboBoxModel)object).addElement("10");
            ((DefaultComboBoxModel)object).addElement("15");
            ((DefaultComboBoxModel)object).addElement("20");
            ((DefaultComboBoxModel)object).addElement("25");
            ((DefaultComboBoxModel)object).addElement("30");
            ((DefaultComboBoxModel)object).addElement("60");
            ((DefaultComboBoxModel)object).addElement("120");
            this._timerInterval.setMaximumSize(this._timerInterval.getMinimumSize());
            this._timerInterval.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        if (DisplayPanel.this._timer != null) {
                            DisplayPanel.this.cancelTimer();
                            DisplayPanel.this.prompt = true;
                        }
                        if (!DisplayPanel.this._timerInterval.getSelectedItem().equals("0")) {
                            DisplayPanel.this._timer = new Timer();
                            DisplayPanel.this._tt = new TimerTask(){

                                @Override
                                public void run() {
                                    Connection connection = null;
                                    try {
                                        connection = Connections.getInstance().getConnection(DisplayPanel.this._connName, false);
                                    }
                                    catch (DBException dBException) {
                                        // empty catch block
                                    }
                                    if (connection != null) {
                                        DisplayPanel.this.prompt = false;
                                        DisplayPanel.this.refresh(false, true);
                                    }
                                }
                            };
                            DisplayPanel.this._timer.scheduleAtFixedRate(DisplayPanel.this._tt, 0L, Long.parseLong((String)DisplayPanel.this._timerInterval.getSelectedItem()) * 1000L);
                        }
                    }
                }
            });
            this._toolbar.add((Component)object2);
            this._toolbar.add((Component)this._timerInterval);
            this._toolbar.addSeparator();
        }
        if ((object2 = this._model.getExtValues().get("ToolbarExtra")) != null) {
            try {
                object = (IModifyToolbar)this.getClass().getClassLoader().loadClass((String)object2).newInstance();
                object.modifyToolbar(this._toolbar, this._binds);
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
            }
        }
    }

    public void openSQLEditor() {
    }

    public IDisplay getMainUI() {
        return this._main;
    }

    public Toolbar getToolbar() {
        return this._toolbar;
    }

    private void addListeners() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                DisplayPanel.this.refresh();
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                DisplayPanel.this.refresh();
            }
        });
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent ancestorEvent) {
                DisplayPanel.this.refresh();
            }

            @Override
            public void ancestorRemoved(AncestorEvent ancestorEvent) {
                DisplayPanel.this.refresh();
            }

            @Override
            public void ancestorMoved(AncestorEvent ancestorEvent) {
                DisplayPanel.this.refresh();
            }
        });
        this.addContainerListener(new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent containerEvent) {
                DisplayPanel.this.refresh();
            }

            @Override
            public void componentRemoved(ContainerEvent containerEvent) {
                DisplayPanel.this.refresh();
            }
        });
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                DisplayPanel.this.refresh();
            }
        });
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
                DisplayPanel.this.refresh();
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                DisplayPanel.this.refresh();
            }

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                DisplayPanel.this.refresh();
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                DisplayPanel.this.refresh();
            }
        });
    }

    public Connection getConnection() {
        String string;
        Connection connection = this._model.getConnection();
        if (connection == null && (string = this._model.getConnName()) != null) {
            try {
                connection = Connections.getInstance().getConnection(string);
                this._model.setConnection(connection);
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
            }
        }
        return connection;
    }

    public DisplayModel getModel() {
        return this._model;
    }

    public void setModel(DisplayModel displayModel) {
        if (this._main == null || this._model != displayModel) {
            this._model = displayModel;
            this.close();
            this.buildUI();
        } else {
            this.refresh();
        }
    }

    public void setMainPanelBinds(Map<String, Object> map) {
        this._binds = map;
    }

    private void initTabbedPane() {
        this._tabbed = new JTabbedPane();
        this._tabbed.setUI((TabbedPaneUI)new CustomTabbedPaneUI());
        this._sp = new JSplitPane();
        this._sp.setOneTouchExpandable(true);
        this._sp.setContinuousLayout(true);
        this._sp.setOrientation(0);
        this._sp.setTopComponent(this._main.getScrollableUI());
        this._sp.setBottomComponent(this._tabbed);
        this._sp.setResizeWeight(0.5);
        this._sp.setDividerLocation(0.5);
        this.add((Component)this._sp, "Center");
        this._tabbed.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                DisplayPanel.this.logger.finer("DisplayPanel.stateChanged() has fired...");
                if (((JTabbedPane)changeEvent.getSource()).getSelectedComponent().isShowing() && !DisplayPanel.this._building) {
                    ((DisplayPanel)((JTabbedPane)changeEvent.getSource()).getSelectedComponent()).refresh();
                }
            }
        });
    }

    private void buildUI() {
        this.buildUI(false);
    }

    private void buildUI(boolean bl) {
        this.logger.finer("DisplayPanel.buildUI()");
        this._building = true;
        try {
            if (this._model == null) {
                return;
            }
            this._main = DisplayRegistry.getInstanceFor(this._model.getStyle());
            this._main.setDisplayModel(this._model);
            this._main.setId(this._model.getID());
            this._main.setConn(this.getConnection());
            this._connName = Connections.getInstance().getConnectionName(this.getConnection());
            this._main.setConnName(this._connName);
            this._main.setQuery(this._model.getQuery(this.getConnection()));
            this._main.setExtVales(this._model.getExtValues());
            this._main.addSelectionChangeListener(this.selectionChangeListener);
            this._main.setType(this._model.getType());
            this._main.addActions(this._model.getActions());
            this._main.addTaskListener((IRaptorTaskListener)this._taskListener);
            this._main.setToolbar(this._toolbar);
            this.addToolbarActions();
            this.add((Component)this._toolbar, "First");
            if (this._model.hasChildren()) {
                this.initTabbedPane();
                DisplayPanel displayPanel = null;
                for (DisplayModel displayModel : this._model.getChildren()) {
                    displayPanel = new DisplayPanel(displayModel, this, null);
                    this._children.add(displayPanel.getMainUI());
                    this._childPanels.add(displayPanel);
                    if (displayPanel.getMainUI() instanceof ISelectionChangeListener) {
                        this._main.addSelectionChangeListener((ISelectionChangeListener)((Object)displayPanel.getMainUI()));
                    }
                    this._tabbed.addTab(displayModel.getName(), displayModel.getIcon(), displayPanel);
                }
            } else {
                this.add((Component)this._main.getScrollableUI(), "Center");
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
        }
        if (this._model.getQuery(this.getConnection()) == null) {
            this.displayNoQuery();
            return;
        }
        if (this._model.getQueriesBindMap() != null) {
            this._main.appendBindMap(this._model.getQueriesBindMap());
        } else if (this._parent == null && this._binds == null && !bl) {
            this.promptForBind(this._model.getQuery(this.getConnection()));
        } else if (this._binds != null) {
            this._main.appendBindMap(this._binds);
        }
        if (!bl && this.renderDisplay) {
            this._main.refresh();
        }
        this._building = false;
    }

    private List<ObjectAction> getModelActions() {
        List<ObjectAction> list = null;
        DisplayModel displayModel = this.getModel();
        if (displayModel != null) {
            list = displayModel.getActions();
        }
        return list != null ? list : Collections.emptyList();
    }

    private void addToolbarActions() {
        for (ObjectAction objectAction : this.getModelActions()) {
            if (!objectAction.isToolbar()) continue;
            IdeAction ideAction = objectAction.getAction();
            boolean bl = true;
            for (Component component : this._toolbar.getComponents()) {
                if (!(component instanceof ToolButton) || ((ToolButton)component).getAction() != ideAction) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            this._toolbar.add((ToggleAction)ideAction);
        }
    }

    public String getConnectionName() {
        return this._connName;
    }

    public void setConnectionName(String string) {
        this._connName = string;
    }

    private Component createSplitPane(Component component, Component component2) {
        this._sp = new JSplitPane(0);
        JScrollPane jScrollPane = new JScrollPane(component);
        if (component instanceof JTable) {
            jScrollPane.setRowHeaderView(((JTable)component).getTableHeader());
        }
        this._sp.setTopComponent(jScrollPane);
        this._sp.setDividerLocation(200);
        JScrollPane jScrollPane2 = new JScrollPane(component2);
        if (component2 instanceof JTable) {
            jScrollPane2.setRowHeaderView(((JTable)component2).getTableHeader());
        }
        this._sp.setBottomComponent(component2);
        return this._sp;
    }

    public void refresh() {
        this.refresh(false);
    }

    public void refresh(boolean bl) {
        this.logger.finer("DisplayPanel.Refresh()");
        this.refresh(true, bl);
    }

    public void clear() {
        if (this._main != null) {
            this._main.clear();
        }
        for (IDisplay iDisplay : this._children) {
            iDisplay.clear();
        }
    }

    public void close() {
        this.cancelTimer();
        if (this._main != null) {
            this._main.close();
        }
        for (IDisplay object : this._children) {
            if (object == null) continue;
            object.close();
        }
        this._children.clear();
        if (this._sp != null && this._sp.getParent() != null) {
            this._sp.getParent().remove(this._sp);
        }
        if (this._main != null && this._main.getScrollableUI() != null && this._main.getScrollableUI().getParent() != null) {
            this._main.getScrollableUI().getParent().remove(this._main.getScrollableUI());
        }
        if (this._main != null && this._main.getUI() != null && this._main.getUI().getParent() != null) {
            this._main.getUI().getParent().remove(this._main.getUI());
        }
        for (DisplayPanel displayPanel : this._childPanels) {
            if (displayPanel == null) continue;
            displayPanel.cancelTimer();
        }
    }

    public void displayNoQuery() {
        JLabel jLabel = new JLabel(Messages.getString("DisplayPanel.MISSING_KEY"));
        this.dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)jLabel, null, (String)Messages.getString("DisplayPanel.27"), (int)1);
        this.dlg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DisplayPanel.this.dlg.dispose();
            }
        });
        this.dlg.setSize(500, 150);
        this.dlg.setPreferredSize(500, 150);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this.dlg);
        this.dlg.setVisible(true);
    }

    public void promptForBind(Query query) {
        if (query.getBinds().size() > 0) {
            this.renderDisplay = false;
            BindInfo bindInfo = new BindInfo(query);
            HelpSystem.getHelpSystem().registerTopic((JComponent)bindInfo, "f1_bindnulldefault_html");
            this.dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)bindInfo, null, (String)Messages.getString("DisplayPanel.BIND_TITLE"), (int)14);
            this.dlg.setDefaultButton(8);
            this.dlg.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DisplayPanel.this.renderDisplay = true;
                    DisplayPanel.this.dlg.dispose();
                }
            });
            this.dlg.pack();
            IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this.dlg);
            this.dlg.setVisible(true);
        } else {
            this.renderDisplay = true;
        }
    }

    public void promptForBindsOnNextRun(boolean bl) {
        this._forceBindPrompt = bl;
    }

    public void refresh(boolean bl, boolean bl2) {
        this._force = bl2;
        this._detail = bl;
        this.logger.finer("DisplayPanel.Refresh(" + bl + "}" + " for " + this.getModel().getName());
        Query query = this.getModel().getQuery(this.getConnection());
        if (query == null && this._binds != null) {
            this.displayNoQuery();
            return;
        }
        if (this.getModel().getParent() == null) {
            if (this._parent == null && this._binds == null && this.prompt) {
                this.promptForBind(query);
                this._forceBindPrompt = false;
            }
            if (this._forceBindPrompt) {
                this.promptForBind(query);
                this._forceBindPrompt = false;
            }
        } else {
            this._main.appendBindMap(this._model.getQueriesBindMap());
            this._binds = this._model.getQueriesBindMap();
        }
        if (!this.renderDisplay) {
            return;
        }
        for (IDisplay iDisplay : this._children) {
            boolean bl3 = true;
            for (Container container = iDisplay.getUI(); container != null && bl3 && container.getParent() != null; container = container.getParent()) {
                bl3 = container.isShowing();
            }
            if (!bl3) continue;
            boolean bl4 = true;
            for (Bind bind : iDisplay.getQuery().getBinds()) {
                if (this._binds == null || this._binds.containsKey(bind.getName()) || bind.getValue() != null) continue;
                bl4 = false;
            }
            if (this._binds != null) {
                iDisplay.appendBindMap(this._binds);
            } else if (this._parent != null) {
                iDisplay.appendBindMap(this._parent.getMainUI().getBindMap());
            }
            if (!bl4) continue;
            iDisplay.refresh(this._detail);
            iDisplay.getScrollableUI().paintAll(iDisplay.getScrollableUI().getGraphics());
        }
        this._main.setConn(this.getConnection());
        this._main.setQuery(this._model.getQuery(this.getConnection()));
        if (this._binds != null) {
            this._main.appendBindMap(this._binds);
        } else if (this._parent == null) {
            this._main.appendBindMap(this._model.getQuery(this.getConnection()).getBindValues());
        } else {
            this._main.appendBindMap(this._parent.getMainUI().getBindMap());
        }
        this._main.refresh(this._force);
    }

    public DisplayPanel getParentPanel() {
        return this._parent;
    }

    public void setParentPanel(DisplayPanel displayPanel) {
        this._parent = displayPanel;
    }

    public Component getFocusedComponent() {
        return this.getFocusedComponent(this);
    }

    public Component getFocusedComponent(Component component) {
        Component component2 = null;
        if (component.hasFocus()) {
            component2 = component;
        } else if (component instanceof Container) {
            for (int i = 0; component2 == null && i < ((Container)component).getComponentCount(); ++i) {
                component2 = this.getFocusedComponent(((Container)component).getComponent(i));
            }
        }
        return component2;
    }

    private void updateToolbarActions(boolean bl) {
        if (this.isVisible()) {
            Action[] actionArray;
            for (Action action : actionArray = this._toolbar.getActions()) {
                action.setEnabled(bl);
            }
        }
    }

    protected void showErrorMessage(RaptorTaskEvent raptorTaskEvent) {
        RaptorTaskUtils.showErrorMessage((String)this.getConnectionName(), (Component)this, (RaptorTaskDescriptor)raptorTaskEvent.getTaskDescriptor());
    }

    public String getModelName() {
        return this._model.getName();
    }

    private void setEnableRefresh(boolean bl) {
        this._isEnableRefresh = bl;
        if (bl) {
            if (this._timerInterval != null && !this._timerInterval.isEnabled()) {
                this._timerInterval.setEnabled(true);
            }
        } else if (this._timerInterval != null && this._timerInterval.isEnabled()) {
            if (!this._timerInterval.getSelectedItem().equals("0")) {
                this._timerInterval.setSelectedItem("0");
            }
            this._timerInterval.setEnabled(false);
            this.cancelTimer();
        }
    }

    public boolean isEnableRefresh() {
        return this._isEnableRefresh;
    }

    public void cancelTimer() {
        if (this._timer != null) {
            this._timer.cancel();
            this._timer = null;
        }
    }

    public void setTimerInterval(JComboBox jComboBox) {
        this._timerInterval = jComboBox;
    }

    private class TaskListener
    extends RaptorTaskAdapter {
        private TaskListener() {
        }

        public void taskScheduled(RaptorTaskEvent raptorTaskEvent) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    DisplayPanel.this.updateToolbarActions(false);
                    DisplayPanel.this.setEnableRefresh(true);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }

        public void taskFailed(final RaptorTaskEvent raptorTaskEvent) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    DisplayPanel.this.updateToolbarActions(true);
                    DisplayPanel.this.setEnableRefresh(false);
                    DisplayPanel.this.showErrorMessage(raptorTaskEvent);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }

        public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    DisplayPanel.this.updateToolbarActions(true);
                    DisplayPanel.this.setEnableRefresh(true);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }

        public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    DisplayPanel.this.updateToolbarActions(true);
                    DisplayPanel.this.setEnableRefresh(true);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    private class SelectChanged
    implements ISelectionChangeListener {
        private SelectChanged() {
        }

        @Override
        public void parentSelectionChanged() {
            for (IDisplay iDisplay : DisplayPanel.this._children) {
                iDisplay.setConn(DisplayPanel.this.getConnection());
                Map<String, Object> map = DisplayPanel.this._main.getBinds(null);
                iDisplay.appendBindMap(map);
                iDisplay.setDirty(true);
                if (!iDisplay.getUI().isShowing()) continue;
                iDisplay.refresh(true);
            }
        }
    }
}

