/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display;

import com.sleepycat.je.Transaction;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.controls.display.DisplayModelCache;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.export.pdf.PDFXMLUtil;
import oracle.dbtools.raptor.format.PDFFormatOptions;
import oracle.dbtools.raptor.images.RaptorImage;
import oracle.dbtools.raptor.query.Bind;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryUtils;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.XLIFFHelper;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.dbtools.scripting.Script;
import oracle.ide.util.GuidGen;
import oracle.javatools.db.DBException;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.Version;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLParseException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DisplayModel
implements Cloneable {
    private DisplayModel parent;
    private Connection _conn;
    private String _connName;
    private Version dbVersion;
    private boolean _enable;
    private String _name;
    private String _description;
    private String _tooltip;
    private String _drillClass;
    private String _type;
    private String _style;
    private List<Query> _queries;
    private List<Bind> _queriesBinds;
    private List<DisplayModel> _children;
    private Map<String, String> _extValues;
    private Map<String, String> _extAttrs;
    private List<ObjectAction> _actions;
    private String _path;
    private String _id;
    private Map<String, Object> _queriesBindMap;
    private String _iconName;
    private Icon _icon;
    private Script _insertScript;
    private String _insertClass;
    private Script _deleteScript;
    private String _deleteClass;
    private Script _updateScript;
    private String _updateClass;
    private PDFFormatOptions _pdfOptions;

    public DisplayModel() {
        this._name = "";
        this._description = "";
        this._tooltip = "";
        this._enable = true;
        this._type = "";
        this._style = "";
    }

    public static DisplayModel getDisplayModel(Node node) {
        return DisplayModel.getDisplayModel(node, null, null);
    }

    public static DisplayModel getDisplayModel(Node node, XLIFFHelper xLIFFHelper, Transaction transaction) {
        DisplayModel displayModel = null;
        String string = XMLHelper.getAttributeNode((Node)node, (String)"sharedId");
        if (string != null && !string.equals("")) {
            displayModel = DisplayModelCache.getDisplayModel(string);
        }
        if (displayModel == null) {
            displayModel = new DisplayModel(node, xLIFFHelper, transaction);
        }
        if (displayModel.getID() != null) {
            DisplayModelCache.putDisplayModel(displayModel);
        }
        return displayModel;
    }

    private DisplayModel(Node node, XLIFFHelper xLIFFHelper, Transaction transaction) {
        if (node != null) {
            this._name = this.notNull(XMLHelper.getNodeValue((Node)node, (String)"name"));
            this._description = this.notNull(XMLHelper.getNodeValue((Node)node, (String)"description"));
            this._tooltip = this.notNull(XMLHelper.getNodeValue((Node)node, (String)"tooltip"));
            this._drillClass = this.notNull(XMLHelper.getNodeValue((Node)node, (String)"drillClass"));
            this._iconName = this.notNull(XMLHelper.getNodeValue((Node)node, (String)"iconName"));
            this._actions = ObjectAction.getActions(node, xLIFFHelper);
            if (xLIFFHelper != null) {
                this._name = xLIFFHelper.getTranslation(this._name);
                this._description = xLIFFHelper.getTranslation(this._description);
                this._tooltip = xLIFFHelper.getTranslation(this._tooltip);
            }
            this.populateAttributes(node);
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String string = nodeList.item(i).getNodeName();
                if (string.equalsIgnoreCase("CustomValues")) {
                    NodeList nodeList2 = nodeList.item(i).getChildNodes();
                    for (int j = 0; j < nodeList2.getLength(); ++j) {
                        String string2 = nodeList2.item(j).getNodeName();
                        String string3 = nodeList2.item(j).getTextContent();
                        if (this._extValues == null) {
                            this._extValues = new HashMap<String, String>();
                        }
                        if (string2.equals("#text")) continue;
                        this._extValues.put(string2, string3.intern());
                    }
                    continue;
                }
                if (string.equalsIgnoreCase("query")) {
                    this.addQuery(Query.getQuery((Node)nodeList.item(i), (XLIFFHelper)xLIFFHelper, (Transaction)transaction));
                    continue;
                }
                if (string.equalsIgnoreCase("display")) {
                    this.addChild(nodeList.item(i), xLIFFHelper, transaction);
                    continue;
                }
                if (string.equalsIgnoreCase("queries")) {
                    this.setQueries(Query.getQueries((Node)nodeList.item(i)));
                    continue;
                }
                if (string.equalsIgnoreCase("insert")) {
                    this._insertClass = XMLHelper.getAttributeNode((Node)nodeList.item(i), (String)"class");
                    if (XMLHelper.getChildNode((Node)nodeList.item(i), (String)"script") == null) continue;
                    this._insertScript = new Script(XMLHelper.getChildNode((Node)nodeList.item(i), (String)"script"));
                    continue;
                }
                if (string.equalsIgnoreCase("update")) {
                    this._updateClass = XMLHelper.getAttributeNode((Node)nodeList.item(i), (String)"class");
                    if (XMLHelper.getChildNode((Node)nodeList.item(i), (String)"script") == null) continue;
                    this._updateScript = new Script(XMLHelper.getChildNode((Node)nodeList.item(i), (String)"script"));
                    continue;
                }
                if (string.equalsIgnoreCase("delete")) {
                    this._deleteClass = XMLHelper.getAttributeNode((Node)nodeList.item(i), (String)"class");
                    if (XMLHelper.getChildNode((Node)nodeList.item(i), (String)"script") == null) continue;
                    this._deleteScript = new Script(XMLHelper.getChildNode((Node)nodeList.item(i), (String)"script"));
                    continue;
                }
                if (!string.equalsIgnoreCase("pdf")) continue;
                this.setPDFFormatOptions(PDFXMLUtil.getInstance().getPDFOptions(nodeList.item(i)));
            }
        }
    }

    public DisplayModel(String string, String string2, String string3, String string4) {
        this._name = this.notNull(string);
        this._description = this.notNull(string2);
        this._tooltip = this.notNull(string4);
        this._enable = Boolean.parseBoolean(this.notNullBoolean(string3));
        this._type = "";
        this._style = "";
    }

    public void populateAttributes(Node node) {
        NamedNodeMap namedNodeMap = ((Element)node).getAttributes();
        Node node2 = null;
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            node2 = namedNodeMap.item(i);
            if (node2.getNodeName().equals("type")) {
                this._type = this.notNull(XMLHelper.getAttributeNode((Node)node, (String)"type"));
                continue;
            }
            if (node2.getNodeName().equals("style")) {
                this._style = this.notNull(XMLHelper.getAttributeNode((Node)node, (String)"style"));
                continue;
            }
            if (node2.getNodeName().equals("id")) {
                this._id = this.notNull(XMLHelper.getAttributeNode((Node)node, (String)"id"));
                continue;
            }
            if (node2.getNodeName().equals("enable")) {
                this._enable = Boolean.parseBoolean(this.notNullBoolean(XMLHelper.getAttributeNode((Node)node, (String)"enable")));
                continue;
            }
            if (this._extAttrs == null) {
                this._extAttrs = new HashMap<String, String>();
            }
            this._extAttrs.put(node2.getNodeName(), node2.getNodeValue().intern());
        }
    }

    public Connection getConnection() {
        if (this._conn == null && this._connName != null) {
            try {
                this._conn = Connections.getInstance().getConnection(this._connName);
            }
            catch (DBException dBException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
            }
        }
        return this._conn;
    }

    public void setConnection(Connection connection) {
        if (this._conn != connection) {
            this._conn = connection;
            this.setDbVersion(connection);
            if (this.hasChildren()) {
                for (DisplayModel displayModel : this.getChildren()) {
                    displayModel.setConnection(connection);
                }
            }
        }
    }

    public String notNull(String string) {
        if (string == null || string.equals("null")) {
            return "";
        }
        return string;
    }

    public String notNullBoolean(String string) {
        if (string == null || string.equals("null")) {
            return "false";
        }
        return "true";
    }

    public void setActions(List<ObjectAction> list) {
        this._actions = list;
    }

    public List<ObjectAction> getActions() {
        return this._actions;
    }

    public String getConnName() {
        return this._connName;
    }

    public void setConnName(String string) {
        if (ModelUtil.areDifferent((Object)this._connName, (Object)string)) {
            this._connName = string;
            this._conn = null;
            if (this.hasChildren()) {
                for (DisplayModel displayModel : this.getChildren()) {
                    displayModel.setConnName(string);
                }
            }
        }
    }

    private Version getDbVersion() {
        return this.dbVersion;
    }

    private void setDbVersion(Connection connection) {
        this.dbVersion = connection != null ? DBUtil.getDbVersion((Connection)connection) : null;
    }

    public Boolean getEnable() {
        return this._enable;
    }

    public void setEnable(String string) {
        this._enable = Boolean.parseBoolean(string);
    }

    public void setEnable(Boolean bl) {
        this._enable = bl;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        this._name = string;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String string) {
        this._description = string;
    }

    public String getToolTip() {
        return this._tooltip;
    }

    public void setToolTip(String string) {
        this._tooltip = string;
    }

    public Icon getIcon() {
        if (this._iconName != null && this._icon == null) {
            this._icon = RaptorImage.getIcon((String)this._iconName);
        }
        return this._icon;
    }

    public String getDrillClass() {
        return this._drillClass;
    }

    public void setDrillClass(String string) {
        this._drillClass = string;
    }

    public String getType() {
        if (this._type == null) {
            return "Child";
        }
        return this._type;
    }

    public void setType(String string) {
        this._type = string;
    }

    public String getStyle() {
        if (this._style == null && !this.isChangeable()) {
            return "Table";
        }
        if (this._style == null && this.isChangeable()) {
            return "UpdableTable";
        }
        return this._style;
    }

    public boolean isChangeable() {
        return this._insertScript != null || this._insertClass != null || this._updateScript != null || this._updateClass != null || this._deleteScript != null || this._deleteClass != null;
    }

    public boolean isChild() {
        return this._type.equals("Child");
    }

    public void setStyle(String string) {
        this._style = string;
    }

    public List<Query> getQueries() {
        return this._queries;
    }

    public void setQueries(List<Query> list) {
        this._queries = list;
    }

    public void addQuery(Query query) {
        if (this._queries == null) {
            this._queries = new ArrayList<Query>();
        }
        this._queries.add(query);
    }

    public List<Bind> getQueriesBinds() {
        return this._queriesBinds;
    }

    public void setQueriesBinds(List<Bind> list) {
        this._queriesBinds = list;
    }

    public Map<String, Object> getQueriesBindMap() {
        return this._queriesBindMap;
    }

    public void setQueriesBindMap(Map<String, Object> map) {
        this._queriesBindMap = map;
    }

    public List<DisplayModel> getChildren() {
        return this._children;
    }

    public boolean hasChildren() {
        return this._children != null && this._children.size() > 0;
    }

    public void setChildren(List<DisplayModel> list) {
        this._children = list;
    }

    public void addChild(DisplayModel displayModel) {
        if (this._children == null) {
            this._children = new ArrayList<DisplayModel>();
        }
        this._children.add(displayModel);
    }

    public void addChild(Node node, XLIFFHelper xLIFFHelper, Transaction transaction) {
        if (this._children == null) {
            this._children = new ArrayList<DisplayModel>();
        }
        DisplayModel displayModel = new DisplayModel(node, xLIFFHelper, transaction);
        this._children.add(displayModel);
    }

    private boolean checkVersion(Query query) {
        Version version = query.getMinversion();
        Version version2 = query.getMaxversion();
        return this.dbVersion == null || (version == null || version.compareTo((Object)this.dbVersion) <= 0) && (version2 == null || version2.compareTo((Object)this.dbVersion) >= 0);
    }

    public Query getQuery(Connection connection) {
        return this.getQuery(connection, false, false);
    }

    public Query getQuery(Connection connection, boolean bl, boolean bl2) {
        Connection connection2 = this._conn;
        this.setConnection(connection);
        Query query = this.getQuery(bl, bl2);
        this.setConnection(connection2);
        return query;
    }

    public Query getQuery() {
        return this.getQuery(false, false);
    }

    public Query getQuery(boolean bl, boolean bl2) {
        if (this._queries == null) {
            this._queries = this.getQueries();
        }
        return QueryUtils.getQuery(this._queries, (Connection)this._conn, (boolean)bl, (boolean)bl2);
    }

    public String getIndent(int n) {
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = 9;
        }
        return new String(cArray);
    }

    public String toXML(int n) {
        return this.toXML(new StringBuffer(), n).toString();
    }

    public StringBuffer toXML(StringBuffer stringBuffer, int n) {
        stringBuffer.append(this.getIndent(n) + "<display");
        stringBuffer.append(" id=\"" + this._id + "\"");
        stringBuffer.append(" type=\"" + this._type + "\"");
        stringBuffer.append(" style=\"" + this._style + "\"");
        stringBuffer.append(" enable=\"" + this.getEnable() + "\"");
        if (this._extAttrs != null) {
            for (String object : this._extAttrs.keySet()) {
                stringBuffer.append(" " + object + "=\"" + this._extAttrs.get(object) + "\"");
            }
        }
        stringBuffer.append(">\n");
        stringBuffer.append(this.getIndent(n + 1) + "<name><![CDATA[" + this._name + "]]></name>\n");
        stringBuffer.append(this.getIndent(n + 1) + "<description><![CDATA[" + this._description + "]]></description>\n");
        stringBuffer.append(this.getIndent(n + 1) + "<tooltip><![CDATA[" + this._tooltip + "]]></tooltip>\n");
        stringBuffer.append(this.getIndent(n + 1) + "<drillclass><![CDATA[" + this._drillClass + "]]></drillclass>\n");
        if (this._extValues != null) {
            stringBuffer.append(this.getIndent(n + 1) + "<CustomValues>\n");
            for (String string : this._extValues.keySet()) {
                stringBuffer.append(this.getIndent(n + 2) + "<" + string + ">" + this._extValues.get(string) + "</" + string + ">\n");
            }
            stringBuffer.append(this.getIndent(n + 1) + "</CustomValues>\n");
        }
        if (this._queries != null) {
            for (Query query : this._queries) {
                stringBuffer.append(query.toXML(n + 1));
            }
        }
        if (this._pdfOptions != null) {
            stringBuffer.append(PDFXMLUtil.getInstance().toXML(this._pdfOptions, n + 1));
        }
        if (this._children != null) {
            for (DisplayModel displayModel : this._children) {
                stringBuffer.append(displayModel.toXML(n + 1));
            }
        }
        if (this._actions != null) {
            for (ObjectAction objectAction : this._actions) {
                objectAction.toXML(stringBuffer);
            }
        }
        stringBuffer.append(this.getIndent(n) + "</display>\n");
        return stringBuffer;
    }

    public Map<String, String> getExtAttributes() {
        if (this._extAttrs != null) {
            return this._extAttrs;
        }
        return null;
    }

    public void setExtAttributes(Map<String, String> map) {
        this._extAttrs = map;
    }

    public Map<String, String> getExtValues() {
        if (this._extValues == null) {
            this._extValues = new HashMap<String, String>();
        }
        return this._extValues;
    }

    public void setExtValues(Map<String, String> map) {
        this._extValues = map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DisplayModel clone() {
        DOMParser dOMParser = new DOMParser();
        dOMParser.setPreserveWhitespace(false);
        StringReader stringReader = null;
        try {
            stringReader = new StringReader(this.toXML(0));
            dOMParser.parse((Reader)stringReader);
        }
        catch (XMLParseException xMLParseException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, xMLParseException.getStackTrace()[0].toString(), xMLParseException);
        }
        catch (SAXException sAXException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sAXException.getStackTrace()[0].toString(), sAXException);
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        finally {
            if (stringReader != null) {
                try {
                    stringReader.close();
                }
                catch (Exception exception) {}
            }
        }
        XMLDocument xMLDocument = dOMParser.getDocument();
        Node node = xMLDocument.getChildNodes().item(0);
        DisplayModel displayModel = new DisplayModel(node, null, null);
        displayModel.setID(GuidGen.toString((byte[])GuidGen.uuidCreate()));
        return displayModel;
    }

    public String getPath() {
        return this._path;
    }

    public void setPath(String string) {
        this._path = string;
    }

    public String getID() {
        return this._id;
    }

    public void setID(String string) {
        this._id = string;
    }

    public void setIconName(String string) {
        this._iconName = string;
    }

    public String getIconName() {
        return this._iconName;
    }

    public DisplayModel getParent() {
        return this.parent;
    }

    public void setParent(DisplayModel displayModel) {
        this.parent = displayModel;
    }

    public Script getInsertScript() {
        return this._insertScript;
    }

    public void setInsertScript(Script script) {
        this._insertScript = script;
    }

    public String getInsertClass() {
        return this._insertClass;
    }

    public void setInsertClass(String string) {
        this._insertClass = string;
    }

    public Script getDeleteScript() {
        return this._deleteScript;
    }

    public void setDeleteScript(Script script) {
        this._deleteScript = script;
    }

    public String getDeleteClass() {
        return this._deleteClass;
    }

    public void setDeleteClass(String string) {
        this._deleteClass = string;
    }

    public Script getUpdateScript() {
        return this._updateScript;
    }

    public void setUpdateScript(Script script) {
        this._updateScript = script;
    }

    public String getUpdateClass() {
        return this._updateClass;
    }

    public void set_updateClass(String string) {
        this._updateClass = string;
    }

    public void setPDFFormatOptions(PDFFormatOptions pDFFormatOptions) {
        this._pdfOptions = pDFFormatOptions;
    }

    public PDFFormatOptions getPDFFormatOptions() {
        return this._pdfOptions;
    }
}

