/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.raptor.controls.ControlsArb;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryCache;
import oracle.dbtools.raptor.utils.AbstractFolderedXml;
import oracle.dbtools.raptor.utils.XLIFFHelper;
import oracle.dbtools.raptor.utils.XMLHelper;
import org.w3c.dom.Node;

public abstract class AbstractDisplayModelParser
extends AbstractFolderedXml {
    private static final String EDITOR_CLASS = "editorClass";
    private static Map<String, String[]> s_nodeTypeMap = new HashMap<String, String[]>();

    public static String[] getTypesForNode(String string) {
        return s_nodeTypeMap.get(string);
    }

    @Override
    public void openFolder(String string, String string2, String string3, Node node) {
    }

    @Override
    public void closeFolder() {
    }

    @Override
    public void newNode(Node node) {
        this.newItem(node);
    }

    public DisplayModel createDisplayModelFromEditor(Node node, String string) {
        DisplayModel displayModel = new DisplayModel();
        if (string != null && string.equals("editor")) {
            DisplayModel displayModel2;
            displayModel.setName(XMLHelper.getNodeValue((Node)node, (String)"title"));
            displayModel.setType(XMLHelper.getAttributeNode((Node)node, (String)"vertical"));
            displayModel.setStyle(XMLHelper.getAttributeNode((Node)node, (String)"display"));
            String string2 = XMLHelper.getAttributeNode((Node)XMLHelper.getChildNode((Node)node, (String)"query"), (String)"id");
            displayModel.populateAttributes(node);
            if (string2 != null && !string2.equals("")) {
                displayModel.setQueries(QueryCache.getQueries((String)string2));
            } else {
                displayModel.setQueries(Query.getQueries((Node)node));
            }
            if (XMLHelper.getChildNode((Node)node, (String)"bottomquery") != null) {
                displayModel2 = new DisplayModel();
                displayModel2.setName(XMLHelper.getNodeValue((Node)XMLHelper.getChildNode((Node)node, (String)"bottomquery"), (String)"title"));
                string2 = XMLHelper.getAttributeNode((Node)XMLHelper.getChildNode((Node)XMLHelper.getChildNode((Node)node, (String)"bottomquery"), (String)"query"), (String)"id");
                if (string2 != null && !string2.equals("")) {
                    displayModel2.setQueries(QueryCache.getQueries((String)string2));
                } else {
                    displayModel2.setQueries(Query.getQueries((Node)XMLHelper.getChildNode((Node)node, (String)"bottomquery")));
                }
                displayModel.addChild(displayModel2);
            }
            if (XMLHelper.getChildNode((Node)node, (String)"subquery") != null) {
                displayModel2 = new DisplayModel();
                displayModel2.setQueries(Query.getQueries((Node)XMLHelper.getChildNode((Node)node, (String)"subquery")));
                displayModel2.setStyle(XMLHelper.getAttributeNode((Node)XMLHelper.getChildNode((Node)node, (String)"subquery"), (String)"type"));
                displayModel.addChild(displayModel2);
            }
        }
        return displayModel;
    }

    public void newItem(Node node, XLIFFHelper xLIFFHelper) {
        this.xliff = xLIFFHelper;
        this.newItem(node);
    }

    @Override
    public void newItem(Node node) {
        String string;
        Object object;
        String string2 = XMLHelper.getAttributeNode((Node)node, (String)"type");
        String string3 = XMLHelper.getAttributeNode((Node)node, (String)"connType") == null ? "Oracle" : XMLHelper.getAttributeNode((Node)node, (String)"connType");
        String string4 = XMLHelper.getAttributeNode((Node)node, (String)"objectType");
        String[] stringArray = null;
        String[] stringArray2 = null;
        if (string3 != null && string3.indexOf(",") != -1) {
            stringArray2 = string3.split(",");
        } else if (string3 != null) {
            stringArray2 = new String[]{string3};
        }
        if (string4 == null) {
            object = XMLHelper.getAttributeNode((Node)node, (String)"node");
            if (object != null && (stringArray = s_nodeTypeMap.get(object)) == null) {
                LOGGER.warning(ControlsArb.format("AbstractDisplayModel_BogusNodeType", object));
            }
        } else {
            stringArray = string4.indexOf(",") != -1 ? string4.split(",") : new String[]{string4};
        }
        object = null;
        if (node.getNodeName().equals("display")) {
            object = this.xliff != null ? DisplayModel.getDisplayModel(node, this.xliff, null) : DisplayModel.getDisplayModel(node, null, null);
        } else if (string2 != null && string2.equals("editor")) {
            object = this.createDisplayModelFromEditor(node, string2);
        } else if (string2 != null && string2.equals("sharedQuery")) {
            string = XMLHelper.getAttributeNode((Node)node, (String)"id");
            QueryCache.putQuery((String)string, (List)Query.getQueries((Node)node));
        } else {
            object = DisplayModel.getDisplayModel(node, null, null);
        }
        if (string2 == null || !string2.equals("sharedQuery")) {
            String string5 = string = ((DisplayModel)object).getExtAttributes() == null ? null : ((DisplayModel)object).getExtAttributes().get(EDITOR_CLASS);
            if (stringArray != null) {
                for (String string6 : stringArray) {
                    for (String string7 : stringArray2) {
                        this.registerEditor(string7, string6, (DisplayModel)object, string);
                    }
                }
            }
        }
    }

    protected abstract void registerEditor(String var1, String var2, DisplayModel var3, String var4);

    static {
        s_nodeTypeMap.put("TableNode", new String[]{"TABLE"});
        s_nodeTypeMap.put("ViewNode", new String[]{"VIEW"});
        s_nodeTypeMap.put("MViewNode", new String[]{"MATERIALIZED_VIEW"});
        s_nodeTypeMap.put("PlSqlBaseNode", new String[]{"PROCEDURE", "FUNCTION", "PACKAGE", "PACKAGE BODY", "TYPE", "TYPE BODY"});
        s_nodeTypeMap.put("DatabaseLinkNode", new String[]{"DATABASE LINK"});
        s_nodeTypeMap.put("MViewLogNode", new String[]{"MATERIALIZED VIEW LOG"});
        s_nodeTypeMap.put("TriggerNode", new String[]{"TRIGGER"});
        s_nodeTypeMap.put("IndexNode", new String[]{"INDEX"});
        s_nodeTypeMap.put("RecycledObjectNode", new String[]{"RECYCLEBIN"});
        s_nodeTypeMap.put("DirectoryNode", new String[]{"DIRECTORY"});
        s_nodeTypeMap.put("QueueNode", new String[]{"QUEUE"});
        s_nodeTypeMap.put("QueueTableNode", new String[]{"QUEUE TABLE"});
        s_nodeTypeMap.put("JavaNode", new String[]{"JAVA"});
        s_nodeTypeMap.put("XmlSchemaNode", new String[]{"XML SCHEMA"});
        s_nodeTypeMap.put("FunctionNode", new String[]{"FUNCTION"});
    }
}

