/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.celleditor.popups;

import java.sql.Connection;
import java.sql.Timestamp;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.controls.celleditor.popups.OracleDateTimeEditPanel;
import oracle.dbtools.raptor.nls.NLSProvider;
import oracle.dbtools.raptor.nls.OraDATEFormat;
import oracle.dbtools.raptor.nls.OracleNLSProvider;
import oracle.dbtools.raptor.ui.controls.DateTimeEditor;
import oracle.sql.DATE;
import oracle.sql.TIMESTAMP;

public class OracleTimestampEditPanel
extends OracleDateTimeEditPanel {
    private static final long serialVersionUID = 2333206898709375565L;

    public OracleTimestampEditPanel() {
    }

    public OracleTimestampEditPanel(Object object, boolean bl, Connection connection) {
        this._canChange = bl;
        if (object == null || object.toString().equals("")) {
            object = new Timestamp(new Date().getTime());
        } else if (object instanceof TIMESTAMP) {
            try {
                object = new Timestamp(((TIMESTAMP)object).timestampValue().getTime());
            }
            catch (Exception exception) {
                object = new Timestamp(new Date().getTime());
            }
        } else if (object instanceof DATE) {
            try {
                object = ((DATE)object).dateValue();
                object = new Timestamp(((Date)object).getTime());
            }
            catch (Exception exception) {
                object = new Timestamp(new Date().getTime());
            }
        } else {
            OraDATEFormat oraDATEFormat = null;
            try {
                oraDATEFormat = ((OracleNLSProvider)NLSProvider.getProvider((Connection)connection)).getOraDATEFormat();
                this.tsFormat = ((OracleNLSProvider)NLSProvider.getProvider((Connection)connection)).getOraTIMESTAMPFormat();
                object = this.tsFormat.parseTIMESTAMP(object.toString(), new ParsePosition(0)).dateValue();
                object = new Timestamp(((Date)object).getTime());
            }
            catch (Exception exception) {
                object = new Timestamp(new Date().getTime());
            }
        }
    }

    @Override
    protected void createDateEditor(Timestamp timestamp) {
        try {
            this.format = ((OracleNLSProvider)NLSProvider.getProvider((Connection)this.m_conn)).getOraDATEFormat();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        if (this.format == null) {
            return;
        }
        try {
            this.tsFormat = ((OracleNLSProvider)NLSProvider.getProvider((Connection)this.m_conn)).getOraTIMESTAMPFormat();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        if (this.tsFormat == null) {
            return;
        }
        String string = null;
        string = this.tsFormat.toPattern().toLowerCase();
        String string2 = this.convertToSimplifiedDateFormat(string);
        string2 = string2.replaceAll("[Ff]{2}[0-9]?", "S");
        SimpleDateFormat simpleDateFormat = null;
        try {
            simpleDateFormat = new SimpleDateFormat(string2, this.tsFormat.getLocale());
        }
        catch (Exception exception) {
            simpleDateFormat = (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(0, 0, this.format.getLocale());
        }
        this.dateEditor = new DateTimeEditor(timestamp, this.tsFormat.getCalendar(), simpleDateFormat);
    }

    @Override
    public void setValue(Object object) {
        if (object == null || object.toString().equals("")) {
            object = new Timestamp(new Date().getTime());
        } else if (object instanceof TIMESTAMP) {
            try {
                object = new Timestamp(((TIMESTAMP)object).timestampValue().getTime());
            }
            catch (Exception exception) {
                object = new Timestamp(new Date().getTime());
            }
        } else if (object instanceof DATE) {
            try {
                object = ((DATE)object).dateValue();
                object = new Timestamp(((Date)object).getTime());
            }
            catch (Exception exception) {
                object = new Timestamp(new Date().getTime());
            }
        } else {
            try {
                this.tsFormat = ((OracleNLSProvider)NLSProvider.getProvider((Connection)this.m_conn)).getOraTIMESTAMPFormat();
                object = this.tsFormat.parseTIMESTAMP(object.toString(), new ParsePosition(0)).timestampValue();
                object = new Timestamp(((Timestamp)object).getTime());
            }
            catch (Exception exception) {
                object = new Timestamp(new Date().getTime());
            }
        }
        this.createDateTimeEditPanel((Timestamp)object, this._canChange, this.m_conn);
    }
}

