/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.celleditor.popups;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.controls.celleditor.popups.AbstractPopupCellEditor;
import oracle.dbtools.raptor.nls.NLSProvider;
import oracle.dbtools.raptor.nls.OraDATEFormat;
import oracle.dbtools.raptor.nls.OraTIMESTAMPFormat;
import oracle.dbtools.raptor.nls.OracleNLSProvider;
import oracle.dbtools.raptor.ui.controls.DateTimeEditor;
import oracle.ide.util.ResourceUtils;
import oracle.sql.DATE;
import oracle.sql.TIMESTAMP;

public class OracleDateTimeEditPanel
extends AbstractPopupCellEditor {
    protected DateTimeEditor dateEditor = null;
    protected JButton setTodayButton = new JButton();
    protected JButton setNullButton = new JButton();
    protected JButton setSysdateButton = new JButton();
    protected JPanel buttonPanel = new JPanel(new GridBagLayout());
    protected boolean _canChange = false;
    protected OraDATEFormat format = null;
    protected OraTIMESTAMPFormat tsFormat = null;
    protected Connection m_conn = null;

    public OracleDateTimeEditPanel() {
    }

    public OracleDateTimeEditPanel(Object object, boolean bl, Connection connection) {
        this._canChange = bl;
        if (object == null || object.toString().equals("")) {
            object = new Timestamp(new java.util.Date().getTime());
        } else if (object instanceof DATE) {
            object = ((DATE)object).dateValue();
            object = new Timestamp(((java.util.Date)object).getTime());
        } else {
            OraDATEFormat oraDATEFormat = null;
            try {
                oraDATEFormat = ((OracleNLSProvider)NLSProvider.getProvider((Connection)connection)).getOraDATEFormat();
                this.tsFormat = ((OracleNLSProvider)NLSProvider.getProvider((Connection)connection)).getOraTIMESTAMPFormat();
                object = oraDATEFormat.parseDATE(object.toString(), new ParsePosition(0)).dateValue();
                object = new Timestamp(((java.util.Date)object).getTime());
            }
            catch (Exception exception) {
                object = new Timestamp(new java.util.Date().getTime());
            }
        }
    }

    public void createDateTimeEditPanel(Timestamp timestamp, boolean bl, Connection connection) {
        this.removeAll();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.createDateEditor(timestamp);
        this.add((Component)((Object)this.dateEditor), gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.getButtonPanel(), gridBagConstraints);
    }

    protected void createDateEditor(Timestamp timestamp) {
        try {
            this.format = ((OracleNLSProvider)NLSProvider.getProvider((Connection)this.m_conn)).getOraDATEFormat();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        if (this.format == null) {
            return;
        }
        try {
            this.tsFormat = ((OracleNLSProvider)NLSProvider.getProvider((Connection)this.m_conn)).getOraTIMESTAMPFormat();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        if (this.tsFormat == null) {
            return;
        }
        String string = this.format.toPattern().toLowerCase();
        String string2 = this.convertToSimplifiedDateFormat(string);
        SimpleDateFormat simpleDateFormat = null;
        try {
            simpleDateFormat = new SimpleDateFormat(string2, this.format.getLocale());
        }
        catch (Exception exception) {
            simpleDateFormat = (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(0, 0, this.format.getLocale());
        }
        this.dateEditor = new DateTimeEditor(timestamp, this.format.getCalendar(), simpleDateFormat);
    }

    @Override
    public JComponent getDefaultComponent() {
        return this.dateEditor;
    }

    protected JPanel getButtonPanel() {
        this.buttonPanel.add((Component)this.getSetTodayButton(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 0, 5), 0, 0));
        return this.buttonPanel;
    }

    protected JButton getSetTodayButton() {
        ResourceUtils.resButton((AbstractButton)this.setTodayButton, (String)Messages.getString("DateTimeEditPanel.1"));
        this.setTodayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OracleDateTimeEditPanel.this.dateEditor.setCalendar(Calendar.getInstance());
            }
        });
        this.setTodayButton.setEnabled(this._canChange);
        return this.setTodayButton;
    }

    protected JButton getSetNullButton() {
        ResourceUtils.resButton((AbstractButton)this.setNullButton, (String)Messages.getString("DateTimeEditPanel.2"));
        this.setNullButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OracleDateTimeEditPanel.this.dateEditor.setDate(null);
            }
        });
        return this.setNullButton;
    }

    public Date getDate() {
        return new Date(this.dateEditor.getDate().getTime());
    }

    public Timestamp getTimestamp() {
        long l = this.dateEditor.getCalendar().getTimeInMillis();
        return new Timestamp(l);
    }

    public Calendar getCalendar() {
        return this.dateEditor.getCalendar();
    }

    @Override
    public void dismissPopupEditor() {
        super.dismissPopupEditor();
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public String getHelpTopicId() {
        return "f1_extendeddataedit_html";
    }

    @Override
    public Object getValue() {
        String string = null;
        if (this.tsFormat == null) {
            this.tsFormat = ((OracleNLSProvider)NLSProvider.getProvider((Connection)this.m_conn)).getOraTIMESTAMPFormat();
            if (this.tsFormat == null) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yyyy hh.mm.ss a");
                string = simpleDateFormat.format(this.getTimestamp());
                return string.toUpperCase();
            }
            string = this.tsFormat.format(new TIMESTAMP(this.getTimestamp()));
        } else {
            this.tsFormat = ((OracleNLSProvider)NLSProvider.getProvider((Connection)this.m_conn)).getOraTIMESTAMPFormat();
            string = this.tsFormat.format(new TIMESTAMP(this.getTimestamp()));
        }
        return string;
    }

    @Override
    public boolean isEditable() {
        return this._canChange;
    }

    @Override
    public boolean isNULL() {
        return false;
    }

    @Override
    public void setEditable(boolean bl) {
        this._canChange = bl;
    }

    @Override
    public void setValue(Object object) {
        if (object == null || object.toString().equals("")) {
            object = new Timestamp(new java.util.Date().getTime());
        } else if (object instanceof DATE) {
            object = ((DATE)object).dateValue();
            object = new Timestamp(((java.util.Date)object).getTime());
        } else {
            OraDATEFormat oraDATEFormat = null;
            try {
                oraDATEFormat = ((OracleNLSProvider)NLSProvider.getProvider((Connection)this.m_conn)).getOraDATEFormat();
                object = oraDATEFormat.parseDATE(object.toString(), new ParsePosition(0)).timestampValue();
                object = new Timestamp(((Timestamp)object).getTime());
            }
            catch (Exception exception) {
                object = new Timestamp(new java.util.Date().getTime());
            }
        }
        this.createDateTimeEditPanel((Timestamp)object, this._canChange, this.m_conn);
    }

    @Override
    public String validateValue() {
        return null;
    }

    @Override
    public void setConnection(Connection connection) {
        this.m_conn = connection;
    }

    protected String convertToSimplifiedDateFormat(String string) {
        String string2 = string;
        if (string2.contains("month")) {
            string2 = string2.replace("month", "MMMMM");
        }
        if (string2.contains("mon")) {
            string2 = string2.replace("mon", "MMM");
        }
        if (string2.contains("mm")) {
            string2 = string2.replace("mm", "MM");
        }
        if (string2.contains("dy")) {
            string2 = string2.replace("dy", "EEE");
        }
        if (string2.contains("day")) {
            string2 = string2.replace("day", "EEE");
        }
        if (string2.contains("ddd")) {
            string2 = string2.replace("ddd", "D");
        }
        if (string2.contains("rr")) {
            string2 = string2.replace("rr", "yy");
        }
        if (string2.contains("syyyy")) {
            string2 = string2.replace("syyyy", "-yyyy");
        }
        if (string2.contains("hh12")) {
            string2 = string2.replace("hh12", "hh");
        }
        if (string2.contains("hh24")) {
            string2 = string2.replace("hh24", "HH");
        }
        if (string2.contains("mi")) {
            string2 = string2.replace("mi", "mm");
        }
        if (string2.contains("a.m.") || string2.contains("am")) {
            string2 = string2.contains("a.m.") ? string2.replace("a.m.", "a") : string2.replace("am", "a");
        }
        if (string2.contains("p.m.") || string2.contains("pm")) {
            string2 = string2.contains("p.m.") ? string2.replace("p.m.", "a") : string2.replace("pm", "a");
        }
        return string2;
    }

    @Override
    public void setPopupDialog(JEWTDialog jEWTDialog) {
    }
}

