/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.celleditor.popups;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.sql.Connection;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskUtils;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.controls.celleditor.popups.AbstractPopupCellEditor;
import oracle.dbtools.raptor.controls.grid.ColumnAutoSizer;
import oracle.dbtools.raptor.extendedtype.ExtendedType;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.net.URLFactory;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.controls.HyperlinkButton;
import oracle.javatools.ui.Header;
import oracle.javatools.ui.HeaderPanel;

public abstract class ExtendedTypeEditPanel
extends AbstractPopupCellEditor {
    protected ExtendedType extendedType;
    protected URL saveToURL = null;
    protected static URL _lastSaveUrl;
    protected HeaderPanel<JPanel> savedInfoHeaderPanel;
    protected HeaderPanel<JPanel> localInfoHeaderPanel;
    protected JTable savedDataTable;
    protected JTable localDataTable;
    protected String[] columnNames = new String[]{Messages.getString("ExtendedTypeEditPanel.0"), Messages.getString("ExtendedTypeEditPanel.1")};
    protected HyperlinkButton loadButton = new HyperlinkButton();
    protected HyperlinkButton saveButton = new HyperlinkButton();
    protected HyperlinkButton setNullButton = new HyperlinkButton();
    protected HyperlinkButton extEditorButton = new HyperlinkButton();
    protected HyperlinkButton editorButton = new HyperlinkButton();
    protected JPanel buttonPanel = new JPanel(new GridBagLayout());
    protected JLabel savedDataImageLabel = new JLabel();
    protected JTextArea savedDataTextArea = new JTextArea();
    protected JLabel localDataImageLabel = new JLabel();
    protected JTextArea localDataTextArea = new JTextArea();
    protected JCheckBox savedViewAsImageBtn = new JCheckBox();
    protected JCheckBox savedViewAsTextBtn = new JCheckBox();
    protected JCheckBox localViewAsImageBtn = new JCheckBox();
    protected JCheckBox localViewAsTextBtn = new JCheckBox();
    protected JScrollPane savedImageScrollPane = new JScrollPane(this.savedDataImageLabel);
    protected JScrollPane savedTextScrollPane = new JScrollPane(this.savedDataTextArea);
    protected JScrollPane localImageScrollPane = new JScrollPane(this.localDataImageLabel);
    protected JScrollPane localTextScrollPane = new JScrollPane(this.localDataTextArea);
    protected JTabbedPane tabbedPane;
    protected JPanel infoPanel;
    protected boolean savedShowImage = false;
    protected boolean savedShowText = false;
    protected boolean localShowImage = false;
    protected boolean localShowText = false;
    protected Connection conn = null;
    protected boolean editable = false;
    protected JEWTDialog _dialog = null;
    private boolean _isEdited;

    public ExtendedTypeEditPanel(ExtendedType extendedType) {
        this.extendedType = extendedType;
        this.createGUI();
    }

    protected abstract void createGUI();

    protected void createDefaultGUI() {
        this.setLayout(new GridBagLayout());
        this.tabbedPane = new JTabbedPane(1);
        this.tabbedPane.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.infoPanel = new JPanel(new GridBagLayout());
        this.infoPanel.setPreferredSize(new Dimension(400, 300));
        this.infoPanel.add((Component)this.getSavedInfoPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.infoPanel.add((Component)this.getLocalInfoPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.tabbedPane.addTab(Messages.getString("ExtendedTypeEditPanel.4"), this.infoPanel);
        this.setupImageLabel(this.savedDataImageLabel, this.savedImageScrollPane);
        this.setupImageLabel(this.localDataImageLabel, this.localImageScrollPane);
        this.setupTextArea(this.localDataTextArea, this.localTextScrollPane);
        this.setupTextArea(this.savedDataTextArea, this.savedTextScrollPane);
        this.add((Component)this.tabbedPane, new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    protected void setupImageLabel(JLabel jLabel, JScrollPane jScrollPane) {
        jLabel.setVerticalAlignment(1);
        jScrollPane.setPreferredSize(new Dimension(400, 300));
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setViewportBorder(null);
        jScrollPane.getViewport().setBackground(Color.white);
    }

    protected void setupTextArea(JTextArea jTextArea, JScrollPane jScrollPane) {
        jTextArea.setEditable(false);
        jScrollPane.setPreferredSize(new Dimension(400, 300));
        jScrollPane.setHorizontalScrollBarPolicy(32);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setViewportBorder(null);
        jScrollPane.getViewport().setBackground(Color.white);
    }

    protected JPanel getSavedInfoPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.savedInfoHeaderPanel = new HeaderPanel((JComponent)jPanel);
        this.savedViewAsImageBtn = new JCheckBox();
        this.savedViewAsTextBtn = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.savedViewAsImageBtn, (String)Messages.getString("ExtendedTypeEditPanel.2"));
        ResourceUtils.resButton((AbstractButton)this.savedViewAsTextBtn, (String)Messages.getString("ExtendedTypeEditPanel.3"));
        this.savedViewAsImageBtn.setSelected(this.localShowImage);
        this.savedViewAsImageBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (ExtendedTypeEditPanel.this.savedViewAsImageBtn.isSelected()) {
                        ExtendedTypeEditPanel.this.tabbedPane.addTab(Messages.getString("ExtendedTypeEditPanel.7"), ExtendedTypeEditPanel.this.savedImageScrollPane);
                        ExtendedTypeEditPanel.this.showAsImage(ExtendedTypeEditPanel.this.extendedType, true);
                        ExtendedTypeEditPanel.this.savedShowImage = true;
                        ExtendedTypeEditPanel.this.tabbedPane.setSelectedComponent(ExtendedTypeEditPanel.this.savedImageScrollPane);
                    } else {
                        ExtendedTypeEditPanel.this.tabbedPane.remove(ExtendedTypeEditPanel.this.savedImageScrollPane);
                        ExtendedTypeEditPanel.this.showAsImage(null, true);
                        ExtendedTypeEditPanel.this.savedShowImage = false;
                    }
                }
                catch (Exception exception) {
                    ExtendedTypeEditPanel.this.showAsImage(null, true);
                }
            }
        });
        this.savedViewAsTextBtn.setSelected(this.savedShowText);
        this.savedViewAsTextBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (ExtendedTypeEditPanel.this.savedViewAsTextBtn.isSelected()) {
                        ExtendedTypeEditPanel.this.tabbedPane.addTab(Messages.getString("ExtendedTypeEditPanel.9"), ExtendedTypeEditPanel.this.savedTextScrollPane);
                        ExtendedTypeEditPanel.this.showAsText(ExtendedTypeEditPanel.this.extendedType, true);
                        ExtendedTypeEditPanel.this.savedShowText = true;
                        ExtendedTypeEditPanel.this.tabbedPane.setSelectedComponent(ExtendedTypeEditPanel.this.savedTextScrollPane);
                    } else {
                        ExtendedTypeEditPanel.this.tabbedPane.remove(ExtendedTypeEditPanel.this.savedTextScrollPane);
                        ExtendedTypeEditPanel.this.showAsText(null, true);
                        ExtendedTypeEditPanel.this.savedShowText = false;
                    }
                }
                catch (Exception exception) {
                    ExtendedTypeEditPanel.this.showAsText(null, true);
                }
            }
        });
        Header header = this.savedInfoHeaderPanel.getHeader();
        header.setText(Messages.getString("ExtendedTypeEditPanel.25"));
        header.setLevel(Header.Level.SUB);
        header.setExpanded(true);
        this.addSavedInfoHeaderComps();
        jPanel.add((Component)this.createTable(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        return this.savedInfoHeaderPanel;
    }

    protected void addSavedInfoHeaderComps() {
        Header header = this.savedInfoHeaderPanel.getHeader();
        header.addActionControl((Component)this.getSaveButton());
        header.addActionControl((Component)new JLabel(Messages.getString("ExtendedTypeEditPanel.8")));
        header.addActionControl((Component)this.savedViewAsImageBtn);
        header.addActionControl((Component)this.savedViewAsTextBtn);
    }

    protected JPanel getLocalInfoPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.localInfoHeaderPanel = new HeaderPanel((JComponent)jPanel, true);
        this.localDataTable = new JTable(this.getLocalDataTableData(), this.columnNames){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        ColumnAutoSizer.autoResizeTable((JTable)this.localDataTable, (String)ColumnAutoSizer.AUTO_FIT_ON_DATA);
        this.localDataTable.setCellSelectionEnabled(true);
        this.localDataTable.setBackground(this.getBackground());
        this.localDataTable.setTableHeader(new JTableHeader());
        this.localViewAsImageBtn = new JCheckBox();
        this.localViewAsTextBtn = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.localViewAsImageBtn, (String)Messages.getString("ExtendedTypeEditPanel.2"));
        ResourceUtils.resButton((AbstractButton)this.localViewAsTextBtn, (String)Messages.getString("ExtendedTypeEditPanel.3"));
        this.localViewAsImageBtn.setSelected(this.localShowImage);
        this.localViewAsImageBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (ExtendedTypeEditPanel.this.localViewAsImageBtn.isSelected()) {
                        ExtendedTypeEditPanel.this.tabbedPane.addTab(Messages.getString("ExtendedTypeEditPanel.28"), ExtendedTypeEditPanel.this.localImageScrollPane);
                        ExtendedTypeEditPanel.this.showAsImage(ExtendedTypeEditPanel.this.extendedType, false);
                        ExtendedTypeEditPanel.this.localShowImage = true;
                        ExtendedTypeEditPanel.this.tabbedPane.setSelectedComponent(ExtendedTypeEditPanel.this.localImageScrollPane);
                    } else {
                        ExtendedTypeEditPanel.this.tabbedPane.remove(ExtendedTypeEditPanel.this.localImageScrollPane);
                        ExtendedTypeEditPanel.this.showAsImage(null, false);
                        ExtendedTypeEditPanel.this.localShowImage = false;
                    }
                }
                catch (Exception exception) {
                    ExtendedTypeEditPanel.this.showAsImage(null, false);
                }
            }
        });
        this.localViewAsTextBtn.setSelected(this.localShowText);
        this.localViewAsTextBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (ExtendedTypeEditPanel.this.localViewAsTextBtn.isSelected()) {
                        ExtendedTypeEditPanel.this.tabbedPane.addTab(Messages.getString("ExtendedTypeEditPanel.29"), ExtendedTypeEditPanel.this.localTextScrollPane);
                        ExtendedTypeEditPanel.this.showAsText(ExtendedTypeEditPanel.this.extendedType, false);
                        ExtendedTypeEditPanel.this.localShowText = true;
                        ExtendedTypeEditPanel.this.tabbedPane.setSelectedComponent(ExtendedTypeEditPanel.this.localTextScrollPane);
                    } else {
                        ExtendedTypeEditPanel.this.tabbedPane.remove(ExtendedTypeEditPanel.this.localTextScrollPane);
                        ExtendedTypeEditPanel.this.showAsText(null, false);
                        ExtendedTypeEditPanel.this.localShowText = false;
                    }
                }
                catch (Exception exception) {
                    ExtendedTypeEditPanel.this.showAsText(null, false);
                }
            }
        });
        Header header = this.localInfoHeaderPanel.getHeader();
        header.setText(Messages.getString("ExtendedTypeEditPanel.30"));
        header.setLevel(Header.Level.SUB);
        header.setExpanded(true);
        this.addLocalInfoHeaderComps();
        jPanel.add((Component)this.localDataTable, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        return this.localInfoHeaderPanel;
    }

    protected void addLocalInfoHeaderComps() {
        Header header = this.localInfoHeaderPanel.getHeader();
        header.addActionControl((Component)this.getLoadButton());
        header.addActionControl((Component)this.getSetNullButton());
        header.addActionControl((Component)new JLabel(Messages.getString("ExtendedTypeEditPanel.8")));
        header.addActionControl((Component)this.localViewAsImageBtn);
        header.addActionControl((Component)this.localViewAsTextBtn);
    }

    protected String[][] getLocalDataTableData() {
        String string = "";
        String string2 = "";
        if (this.extendedType != null && this.extendedType.getLoadFromURL() != null) {
            URL uRL = this.extendedType.getLoadFromURL();
            string = uRL.getPath();
            string2 = new File(string).length() + "";
        }
        return new String[][]{{Messages.getString("ExtendedTypeEditPanel.31"), string}, {Messages.getString("ExtendedTypeEditPanel.32"), string2}};
    }

    protected JTable createTable() {
        Object[][] objectArray = this.getTableData();
        this.savedDataTable = new JTable(objectArray, this.columnNames){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.savedDataTable.setBackground(this.getBackground());
        this.savedDataTable.setRowHeight(20);
        this.savedDataTable.setCellSelectionEnabled(true);
        this.savedDataTable.setTableHeader(new JTableHeader());
        return this.savedDataTable;
    }

    public void setJTable(JTable jTable) {
        this.savedDataTable = jTable;
    }

    public JTable getJTable() {
        return this.savedDataTable;
    }

    protected abstract String[][] getTableData();

    public abstract boolean processExtendedType();

    protected abstract void load();

    protected HyperlinkButton getLoadButton() {
        ResourceUtils.resButton((AbstractButton)this.loadButton, (String)Messages.getString("ExtendedTypeEditPanel.10"));
        this.loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExtendedTypeEditPanel.this.load();
            }
        });
        return this.loadButton;
    }

    protected HyperlinkButton getSaveButton() {
        ResourceUtils.resButton((AbstractButton)this.saveButton, (String)Messages.getString("ExtendedTypeEditPanel.11"));
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExtendedTypeEditPanel.this.save();
            }
        });
        return this.saveButton;
    }

    protected HyperlinkButton getSetNullButton() {
        ResourceUtils.resButton((AbstractButton)this.setNullButton, (String)Messages.getString("ExtendedTypeEditPanel.24"));
        this.setNullButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExtendedTypeEditPanel.this.setNull();
                ExtendedTypeEditPanel.this._dialog.closeDialog(false);
            }
        });
        return this.setNullButton;
    }

    protected void save() {
        URLFileChooser uRLFileChooser = new URLFileChooser();
        uRLFileChooser.setDefaultTitle(Messages.getString("ExtendedTypeEditPanel.12"));
        uRLFileChooser.setSelectionMode(0);
        uRLFileChooser.setSelectionScope(0);
        uRLFileChooser.clearChooseableURLFilters();
        if (_lastSaveUrl == null) {
            String string = System.getProperty("user.home");
            File file = new File(string);
            uRLFileChooser.setSelectedURL(URLFactory.newFileURL((File)file));
        } else {
            uRLFileChooser.setSelectedURL(_lastSaveUrl);
        }
        if (uRLFileChooser.showSaveDialog(this) == 0) {
            this.saveToURL = uRLFileChooser.getSelectedURL();
            _lastSaveUrl = uRLFileChooser.getSelectedURL();
        }
        if (!this.saveToDisk()) {
            // empty if block
        }
    }

    public String getFileName() {
        String string = "";
        for (int i = 0; i < this.getJTable().getColumnCount(); ++i) {
            String string2 = this.getJTable().getColumnName(i);
            if (!string2.equalsIgnoreCase("file_name") && !string2.equalsIgnoreCase("file name")) continue;
            string = this.getJTable().getValueAt(this.getJTable().getSelectedRow(), i).toString();
        }
        return string;
    }

    public URL getSaveToURL() {
        return this.saveToURL;
    }

    protected void showAsImage(ExtendedType extendedType, boolean bl) {
        if (extendedType == null) {
            this.savedDataImageLabel.setIcon(null);
            this.savedDataImageLabel.setText(null);
            return;
        }
        InputStream inputStream = null;
        try {
            if (bl) {
                inputStream = extendedType.getBinaryStream();
            } else if (extendedType.getLoadFromURL() != null) {
                inputStream = extendedType.getLoadFromURL().openStream();
            }
            if (inputStream == null) {
                this.savedDataImageLabel.setIcon(null);
                this.savedDataImageLabel.setText(null);
                return;
            }
            ShowImageTask showImageTask = new ShowImageTask(Messages.getString("ExtendedTypeEditPanel.22"), true, IRaptorTaskRunMode.MODAL, inputStream);
            showImageTask.getDescriptor().addListener((IRaptorTaskListener)new ShowImageTaskListener(showImageTask, bl));
            RaptorTaskManager.getInstance().addTask((RaptorTask)showImageTask);
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private boolean skipOLEHeader(InputStream inputStream) {
        String string = "Bitmap Image";
        String string2 = "Paint.Picture";
        byte[] byArray = new byte[512];
        try {
            int n;
            int n2 = inputStream.read(byArray);
            if (n2 == -1 || n2 < 46) {
                return false;
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (n = 20; n < 20 + string.length(); ++n) {
                stringBuffer.append((char)byArray[n]);
            }
            if (!stringBuffer.toString().equals(string)) {
                return false;
            }
            stringBuffer = new StringBuffer();
            for (n = 33; n < 33 + string2.length(); ++n) {
                stringBuffer.append((char)byArray[n]);
            }
            if (!stringBuffer.toString().equals(string2)) {
                return false;
            }
            boolean bl = false;
            for (n = 33 + string2.length(); n < n2; ++n) {
                if (byArray[n] != 66 || byArray[n + 1] != 77) continue;
                bl = true;
                break;
            }
            if (bl) {
                inputStream.reset();
                inputStream.skip(n);
                return true;
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            return false;
        }
        return false;
    }

    protected void showAsText(ExtendedType extendedType, boolean bl) {
        if (extendedType != null) {
            try {
                this.savedDataTextArea.setText("");
                InputStream inputStream = null;
                if (bl) {
                    inputStream = extendedType.getBinaryStream();
                } else if (extendedType.getLoadFromURL() != null) {
                    inputStream = extendedType.getLoadFromURL().openStream();
                }
                ShowTextTask showTextTask = new ShowTextTask(Messages.getString("ExtendedTypeEditPanel.23"), true, IRaptorTaskRunMode.MODAL, inputStream);
                showTextTask.getDescriptor().addListener((IRaptorTaskListener)new ShowTextTaskListener(showTextTask, bl));
                RaptorTaskManager.getInstance().addTask((RaptorTask)showTextTask);
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
    }

    protected void setNull() {
        this.extendedType.setNULL(true);
    }

    protected boolean saveToDisk() {
        FileOutputStream fileOutputStream = null;
        URL uRL = this.getSaveToURL();
        if (uRL != null) {
            try {
                fileOutputStream = new FileOutputStream(uRL.getFile());
                this.extendedType.setToDiskStream((OutputStream)fileOutputStream);
                this.extendedType.saveToDisk(null, null, null, null, false);
                return true;
            }
            catch (Exception exception) {
                ExceptionHandler.handleException((Throwable)exception);
            }
        }
        return false;
    }

    protected void reload() {
        this.savedDataTable.setModel(new DefaultTableModel(this.getTableData(), this.columnNames));
        this.localDataTable.setModel(new DefaultTableModel(this.getLocalDataTableData(), this.columnNames));
        ColumnAutoSizer.autoResizeTable((JTable)this.savedDataTable, (String)ColumnAutoSizer.AUTO_FIT_ON_DATA);
        ColumnAutoSizer.autoResizeTable((JTable)this.localDataTable, (String)ColumnAutoSizer.AUTO_FIT_ON_DATA);
        this.tabbedPane.remove(this.localTextScrollPane);
        this.tabbedPane.remove(this.localImageScrollPane);
        this.tabbedPane.remove(this.savedTextScrollPane);
        this.tabbedPane.remove(this.savedImageScrollPane);
        this.savedViewAsImageBtn.setSelected(false);
        this.savedViewAsTextBtn.setSelected(false);
        this.localViewAsImageBtn.setSelected(false);
        this.localViewAsTextBtn.setSelected(false);
        this.repaint();
    }

    @Override
    public void dismissPopupEditor() {
        this.savedDataTextArea.setText("");
        this.savedDataImageLabel.setIcon(null);
        this.localDataTextArea.setText("");
        this.localDataImageLabel.setIcon(null);
        super.dismissPopupEditor();
    }

    @Override
    public void setEditable(boolean bl) {
        this.editable = bl;
        this.loadButton.setEnabled(bl);
        this.setNullButton.setEnabled(bl);
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public JComponent getDefaultComponent() {
        return this;
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public boolean isNULL() {
        return false;
    }

    @Override
    public void setConnection(Connection connection) {
        this.conn = connection;
    }

    @Override
    public String validateValue() {
        return null;
    }

    protected boolean isFileEdited() {
        return this._isEdited;
    }

    protected void setFileEdited(boolean bl) {
        this._isEdited = bl;
    }

    @Override
    public void setPopupDialog(JEWTDialog jEWTDialog) {
        this._dialog = jEWTDialog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StringBuilder readText(InputStream inputStream) {
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = null;
        if (inputStream != null) {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            try {
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)bufferedInputStream, IdeUtil.getIdeEncoding()));
                if (bufferedReader != null) {
                    String string;
                    while ((string = bufferedReader.readLine()) != null) {
                        stringBuilder.append(string + "\n");
                    }
                }
            }
            catch (IOException iOException) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, iOException.getStackTrace()[0].toString(), iOException);
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, iOException.getStackTrace()[0].toString(), iOException);
                }
            }
        }
        return stringBuilder;
    }

    private class ShowTextTaskListener
    extends RaptorTaskAdapter {
        private ShowTextTask _task;
        private boolean _savedData;

        ShowTextTaskListener(ShowTextTask showTextTask, boolean bl) {
            this._task = showTextTask;
            this._savedData = bl;
        }

        public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
            try {
                StringBuilder stringBuilder = (StringBuilder)this._task.getResult();
                this.showText(stringBuilder.toString(), null);
            }
            catch (InterruptedException interruptedException) {
                this.showText(null, interruptedException);
            }
            catch (ExecutionException executionException) {
                this.showText(null, executionException);
            }
        }

        public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
            this.showText(null, raptorTaskEvent.getThrowable());
        }

        public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
            this.showText(null, raptorTaskEvent.getThrowable());
        }

        private void showText(final String string, final Throwable throwable) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (ShowTextTaskListener.this._savedData) {
                        if (throwable != null) {
                            ExtendedTypeEditPanel.this.savedDataTextArea.setText(RaptorTaskUtils.getErrorMessage((Throwable)throwable));
                        } else {
                            ExtendedTypeEditPanel.this.savedDataTextArea.setText(string);
                        }
                    } else if (throwable != null) {
                        ExtendedTypeEditPanel.this.localDataTextArea.setText(RaptorTaskUtils.getErrorMessage((Throwable)throwable));
                    } else {
                        ExtendedTypeEditPanel.this.localDataTextArea.setText(string);
                    }
                }
            });
        }
    }

    private class ShowImageTaskListener
    extends RaptorTaskAdapter {
        private ShowImageTask _task;
        private boolean _savedData;

        ShowImageTaskListener(ShowImageTask showImageTask, boolean bl) {
            this._task = showImageTask;
            this._savedData = bl;
        }

        public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
            try {
                final ImageIcon imageIcon = (ImageIcon)this._task.getResult();
                final String string = imageIcon == null ? Messages.getString("ExtendedTypeEditPanel.20") : null;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (ShowImageTaskListener.this._savedData) {
                            ExtendedTypeEditPanel.this.savedDataImageLabel.setIcon(imageIcon);
                            ExtendedTypeEditPanel.this.savedDataImageLabel.setText(string);
                        } else {
                            ExtendedTypeEditPanel.this.localDataImageLabel.setIcon(imageIcon);
                            ExtendedTypeEditPanel.this.localDataImageLabel.setText(string);
                        }
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                this.taskFailed(null);
            }
            catch (ExecutionException executionException) {
                this.taskFailed(null);
            }
        }

        public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
            this.showError(raptorTaskEvent);
        }

        public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
            this.showError(raptorTaskEvent);
        }

        private void showError(final RaptorTaskEvent raptorTaskEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (ShowImageTaskListener.this._savedData) {
                        ExtendedTypeEditPanel.this.savedDataImageLabel.setIcon(null);
                        ExtendedTypeEditPanel.this.savedDataImageLabel.setText(RaptorTaskUtils.getErrorMessage((Throwable)raptorTaskEvent.getThrowable()));
                    } else {
                        ExtendedTypeEditPanel.this.localDataImageLabel.setIcon(null);
                        ExtendedTypeEditPanel.this.localDataImageLabel.setText(RaptorTaskUtils.getErrorMessage((Throwable)raptorTaskEvent.getThrowable()));
                    }
                }
            });
        }
    }

    private class ShowTextTask
    extends RaptorTask {
        InputStream _in;

        public ShowTextTask(String string, boolean bl, IRaptorTaskRunMode iRaptorTaskRunMode, InputStream inputStream) {
            super(string, bl, iRaptorTaskRunMode);
            this._in = null;
            this._in = inputStream;
        }

        protected StringBuilder doWork() throws TaskException {
            return ExtendedTypeEditPanel.this.readText(this._in);
        }
    }

    private class ShowImageTask
    extends RaptorTask {
        InputStream _in;

        public ShowImageTask(String string, boolean bl, IRaptorTaskRunMode iRaptorTaskRunMode, InputStream inputStream) {
            super(string, bl, iRaptorTaskRunMode);
            this._in = null;
            this._in = inputStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ImageIcon doWork() throws TaskException {
            BufferedImage bufferedImage = null;
            ImageIcon imageIcon = null;
            if (this._in != null) {
                try {
                    block24: {
                        this._in.mark(Integer.MAX_VALUE);
                        try {
                            bufferedImage = ImageIO.read(this._in);
                            if (bufferedImage != null) {
                                ImageIcon imageIcon2 = new ImageIcon(bufferedImage);
                                return imageIcon2;
                            }
                            if (this._in.markSupported()) break block24;
                            ImageIcon imageIcon3 = null;
                            return imageIcon3;
                        }
                        catch (IOException iOException) {
                            ImageIcon imageIcon4 = null;
                            return imageIcon4;
                        }
                    }
                    this._in.reset();
                    if (ExtendedTypeEditPanel.this.skipOLEHeader(this._in)) {
                        bufferedImage = ImageIO.read(this._in);
                    }
                    if (bufferedImage != null) {
                        ImageIcon imageIcon5 = new ImageIcon(bufferedImage);
                        return imageIcon5;
                    }
                }
                finally {
                    try {
                        this._in.close();
                    }
                    catch (IOException iOException) {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, iOException.getStackTrace()[0].toString(), iOException);
                    }
                }
            }
            return imageIcon;
        }
    }
}

