/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.celleditor.popups;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Blob;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.controls.celleditor.popups.ExtendedTypeEditPanel;
import oracle.dbtools.raptor.extendedtype.BLOBType;
import oracle.dbtools.raptor.extendedtype.ExtendedType;
import oracle.dbtools.raptor.extendedtype.GenericBlobType;
import oracle.dbtools.raptor.mimeeditor.ExternalBlobEditor;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.controls.HyperlinkButton;
import oracle.sql.BLOB;

public class BLOBEditPanel
extends ExtendedTypeEditPanel {
    protected URL loadFromURL = null;
    protected static URL _lastLoadUrl;
    protected GenericBlobType blobType;
    protected static boolean showImage;

    public BLOBEditPanel(ExtendedType extendedType) {
        super(extendedType);
        this.blobType = (GenericBlobType)extendedType;
        if (!(this.blobType instanceof BLOBType)) {
            this.loadButton.setEnabled(false);
        }
    }

    public BLOBEditPanel() {
        super((ExtendedType)new GenericBlobType());
    }

    @Override
    protected void createGUI() {
        this.createDefaultGUI();
    }

    @Override
    protected void addSavedInfoHeaderComps() {
        this.savedInfoHeaderPanel.getHeader().addActionControl((Component)this.getExtEditorButton());
        super.addSavedInfoHeaderComps();
    }

    @Override
    protected String[][] getTableData() {
        GenericBlobType genericBlobType = (GenericBlobType)this.extendedType;
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        try {
            string = Long.toString(genericBlobType.length());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (genericBlobType instanceof BLOBType) {
            BLOBType bLOBType = (BLOBType)genericBlobType;
            try {
                string2 = Boolean.toString(bLOBType.isTemporary());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                string3 = Boolean.toString(bLOBType.isEmptyLob());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                string4 = Boolean.toString(bLOBType.isOpen());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new String[][]{{Messages.getString("BLOBEditPanel.4"), string}, {Messages.getString("BLOBEditPanel.5"), string3}, {Messages.getString("BLOBEditPanel.6"), string2}, {Messages.getString("BLOBEditPanel.7"), string4}};
        }
        return new String[][]{{Messages.getString("BLOBEditPanel.8"), string}};
    }

    @Override
    protected void load() {
        Object object;
        URLFileChooser uRLFileChooser = new URLFileChooser();
        uRLFileChooser.setDefaultTitle(Messages.getString("BLOBEditPanel.9"));
        uRLFileChooser.setSelectionMode(0);
        uRLFileChooser.setSelectionScope(0);
        uRLFileChooser.clearChooseableURLFilters();
        if (_lastLoadUrl == null) {
            object = System.getProperty("user.home");
            File file = new File((String)object);
            uRLFileChooser.setSelectedURL(URLFactory.newFileURL((File)file));
        } else {
            uRLFileChooser.setSelectedURL(_lastLoadUrl);
        }
        object = new File(uRLFileChooser.getSelectedURL().getFile());
        if (((File)object).isDirectory()) {
            try {
                uRLFileChooser.setSelectedURL(new URL(uRLFileChooser.getSelectedURL() + File.separator + this.getFileName()));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (uRLFileChooser.showOpenDialog(this) == 0) {
            if (this.extendedType != null) {
                this.extendedType.setNULL(false);
            }
            this.loadFromURL = uRLFileChooser.getSelectedURL();
            if (this.blobType != null) {
                this.blobType.setLoadFromURL(this.loadFromURL);
            }
            _lastLoadUrl = this.loadFromURL;
            if (this._dialog != null) {
                this._dialog.closeDialog(false);
            }
        }
    }

    public URL getLoadFromURL() {
        return this.loadFromURL;
    }

    @Override
    public boolean processExtendedType() {
        this.saveToDisk();
        URL uRL = this.getLoadFromURL();
        if (uRL != null) {
            if (this.blobType != null) {
                this.blobType.setLoadFromURL(uRL);
                return true;
            }
        } else if (this.extendedType != null && (this.extendedType.isSetNULL() || this.extendedType.getLoadFromURL() != null)) {
            return true;
        }
        return false;
    }

    @Override
    public JComponent getDefaultComponent() {
        return this;
    }

    @Override
    public String getHelpTopicId() {
        return "f1_BLOBpopupeditor_html";
    }

    @Override
    public Object getValue() {
        if (this.extendedType != null && this.extendedType.isSetNULL()) {
            return this.extendedType;
        }
        if (this.processExtendedType()) {
            return this.blobType;
        }
        if (this.isFileEdited()) {
            return this.extendedType;
        }
        return ((BLOBType)this.extendedType).getOrigBlob();
    }

    @Override
    public void setValue(Object object) {
        this.extendedType = object instanceof String ? new BLOBType(null) : (object instanceof BLOBType ? (BLOBType)object : (object instanceof BLOB ? new BLOBType((BLOB)object) : (object instanceof Blob ? new GenericBlobType((Blob)object) : null)));
        this.blobType = (GenericBlobType)this.extendedType;
        this.reload();
    }

    @Override
    protected void reload() {
        this.loadFromURL = null;
        this.saveToURL = null;
        boolean bl = false;
        if (this.extendedType instanceof BLOBType) {
            if (((BLOBType)this.extendedType).getOrigBlob() == null) {
                bl = true;
            }
        } else if (this.extendedType instanceof BLOB) {
            if (((BLOBType)this.extendedType).getOrigBlob() == null) {
                bl = true;
            }
        } else if (this.extendedType instanceof Blob && ((GenericBlobType)this.extendedType).getOrigBlob() == null) {
            bl = true;
        }
        if (bl) {
            this.saveButton.setEnabled(false);
            this.savedViewAsImageBtn.setEnabled(false);
            this.savedViewAsTextBtn.setEnabled(false);
            this.extEditorButton.setEnabled(false);
        } else {
            this.saveButton.setEnabled(true);
            this.savedViewAsImageBtn.setEnabled(true);
            this.savedViewAsTextBtn.setEnabled(true);
            this.extEditorButton.setEnabled(true);
        }
        if (this.extendedType != null && this.extendedType.getLoadFromURL() == null) {
            this.localViewAsImageBtn.setEnabled(false);
            this.localViewAsTextBtn.setEnabled(false);
        } else {
            this.localViewAsImageBtn.setEnabled(true);
            this.localViewAsTextBtn.setEnabled(true);
        }
        super.reload();
    }

    protected HyperlinkButton getExtEditorButton() {
        ResourceUtils.resButton((AbstractButton)this.extEditorButton, (String)Messages.getString("ExtendedTypeEditPanel.19"));
        this.extEditorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BLOBEditPanel.this.externalEditor();
            }
        });
        return this.extEditorButton;
    }

    protected JPanel getButtonPanel() {
        return null;
    }

    protected void externalEditor() {
        if (this.extendedType != null) {
            final ExternalBlobEditor externalBlobEditor = new ExternalBlobEditor();
            RaptorTaskAdapter raptorTaskAdapter = new RaptorTaskAdapter(){

                public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                    if (externalBlobEditor.isFileModified()) {
                        BLOBEditPanel.this.setFileEdited(true);
                    } else {
                        BLOBEditPanel.this.setFileEdited(false);
                    }
                    ExtendedType extendedType = externalBlobEditor.getExtendedType();
                    if (extendedType != null) {
                        BLOBEditPanel.this.extendedType = extendedType;
                    }
                }
            };
            externalBlobEditor.startExternalBlobEditor(this.extendedType, raptorTaskAdapter);
        }
    }

    static {
        showImage = false;
    }
}

