/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.connections;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.TabbedPaneUI;
import javax.swing.table.AbstractTableModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.connections.ConnectionTypeRegistry;
import oracle.dbtools.raptor.connections.IConnectionPanel;
import oracle.dbtools.raptor.conntypes.RaptorClassLoader;
import oracle.dbtools.raptor.dialogs.conn.ConnectionPrompt;
import oracle.dbtools.raptor.explorer.dt.dialog.ConnectionDialogArb;
import oracle.dbtools.raptor.navigator.DatabaseConnection;
import oracle.dbtools.raptor.navigator.NavWindow;
import oracle.dbtools.raptor.utils.ConnectionCanceledException;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.Ide;
import oracle.ide.controls.SmallSquareButton;
import oracle.ide.controls.tabbedpane.CustomTabbedPaneUI;
import oracle.ide.dialogs.DialogSizeKeeper;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.explorer.TNode;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Element;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.ide.view.View;
import oracle.javatools.clipboard.ClipboardStack;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.ConnectionInfo;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdevimpl.db.adapter.DatabaseProviderHelper;
import oracle.jdevimpl.db.adapter.PasswordPrompter;

public class ConnectionDialog
extends JPanel {
    private JButton _btnTest;
    private JButton _btnSave;
    private JButton _btnClear;
    private JButton _btnConnect;
    private JTable _table;
    private JTabbedPane _tabs;
    private JLabel lblUser = new JLabel();
    private JTextField tfdUser = new JTextField(15);
    private JLabel lblPassword = new JLabel();
    private JPasswordField tfdPassword = new JPasswordField(15);
    private JCheckBox chkSavePassword = new JCheckBox();
    private JLabel lblName = new JLabel();
    private JTextField tfdConnName = new JTextField(15);
    private JLabel lblStatus = new JLabel(ConnectionDialogArb.getString("CONNECTION_DIALOG_STATUS"));
    private SmallSquareButton copyBtn = new SmallSquareButton(OracleIcons.getIcon((String)"copy.png"), "Copy Error Message");
    private JEWTDialog _dlg;
    private KeyAdapter _enterKey;
    private static final String CLEAR = Messages.getString("ConnectionDialog.0");
    private static final String TEST = Messages.getString("ConnectionDialog.1");
    private static final String SAVE = Messages.getString("ConnectionDialog.2");
    private static final String CONNECT = Messages.getString("ConnectionDialog.3");
    public static final String EXCLUSION_CHAR_PATTERN = "^[^<>:\\\"/\\\\|?*()%&'$@^~#]*$";
    private DatabaseConnections m_store;
    private String m_initName;
    private ArrayList listOfPanels;

    public ConnectionDialog() {
        this.setLayout(new GridBagLayout());
        this._table = new JTable();
        this._table.setPreferredScrollableViewportSize(new Dimension(150, 0));
        this._table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ConnectionDialog.this.tableFocusChanged();
            }
        });
        if (this._btnSave == null) {
            this._btnSave = new JButton();
            this._btnSave.setActionCommand(SAVE);
            ResourceUtils.resButton((AbstractButton)this._btnSave, (String)ConnectionDialogArb.getString("CONNECTION_DIALOG_BUTTON_SAVE"));
        }
        if (this._btnTest == null) {
            this._btnTest = new JButton();
            this._btnTest.setActionCommand(TEST);
            ResourceUtils.resButton((AbstractButton)this._btnTest, (String)ConnectionDialogArb.getString("CONNECTION_DIALOG_BUTTON_TEST"));
        }
        if (this._btnClear == null) {
            this._btnClear = new JButton();
            this._btnClear.setActionCommand(CLEAR);
            ResourceUtils.resButton((AbstractButton)this._btnClear, (String)ConnectionDialogArb.getString("CONNECTION_DIALOG_BUTTON_CLEAR"));
        }
        if (this._btnConnect == null) {
            this._btnConnect = new JButton();
            this._btnConnect.setActionCommand(CONNECT);
            ResourceUtils.resButton((AbstractButton)this._btnConnect, (String)ConnectionDialogArb.getString("CONNECTION_DIALOG_BUTTON_CONNECT"));
        }
        this._table.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                int n = ConnectionDialog.this._table.rowAtPoint(point);
                int n2 = ConnectionDialog.this._table.columnAtPoint(point);
                Object object = ConnectionDialog.this._table.getValueAt(n, n2);
                ConnectionDialog.this._table.setToolTipText(object.toString());
            }
        });
        this._enterKey = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                char c = keyEvent.getKeyChar();
                if (n == 10) {
                    ConnectionDialog.this.processButtons(CONNECT);
                }
            }
        };
        JScrollPane jScrollPane = new JScrollPane(this._table);
        jScrollPane.setSize(new Dimension(250, 250));
        jScrollPane.setMaximumSize(new Dimension(300, 0));
        jScrollPane.setMinimumSize(new Dimension(200, 0));
        this.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 6, 1.0, 1.0, 17, 1, new Insets(2, 5, 0, 0), 0, 0));
        ResourceUtils.resLabel((JLabel)this.lblUser, (Component)this.tfdUser, (String)ConnectionDialogArb.getString("CONNECTION_DIALOG_DETAILS_USER"));
        ResourceUtils.resLabel((JLabel)this.lblPassword, (Component)this.tfdPassword, (String)ConnectionDialogArb.getString("CONNECTION_DIALOG_DETAILS_PASSWORD"));
        ResourceUtils.resButton((AbstractButton)this.chkSavePassword, (String)ConnectionDialogArb.getString("CONNECTION_DIALOG_DETAILS_SAVE_PASSWORD"));
        ResourceUtils.resLabel((JLabel)this.lblName, (Component)this.tfdConnName, (String)ConnectionDialogArb.getString("CONNECTION_DIALOG_DETAILS_NAME"));
        this.add((Component)this.lblName, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 0, 0), 0, 0));
        this.add((Component)this.tfdConnName, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 5, 0, 0), 0, 0));
        this.add((Component)this.lblUser, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 0, 0), 0, 0));
        this.add((Component)this.tfdUser, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 5, 0, 0), 0, 0));
        this.add((Component)this.lblPassword, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 0, 0), 0, 0));
        this.add((Component)this.tfdPassword, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 5, 0, 0), 0, 0));
        if (Boolean.parseBoolean(System.getProperty("sqldev.savepasswd", "true"))) {
            this.add((Component)this.chkSavePassword, new GridBagConstraints(1, 3, 1, 2, 0.0, 0.0, 18, 0, new Insets(2, 5, 0, 0), 0, 0));
        }
        this._tabs = new JTabbedPane();
        this._tabs.setUI((TabbedPaneUI)new CustomTabbedPaneUI());
        ArrayList<String> arrayList = ConnectionTypeRegistry.getTabNames();
        for (String string : arrayList) {
            try {
                IConnectionPanel iConnectionPanel = ConnectionTypeRegistry.getPanelFor(string);
                boolean bl = false;
                String[] stringArray = iConnectionPanel.getSupportedDrivers();
                ClassLoader classLoader = null;
                for (String string2 : stringArray) {
                    try {
                        classLoader = RaptorClassLoader.findClassLoader(string2);
                        if (classLoader == null) continue;
                        classLoader.loadClass(string2);
                        bl = true;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!bl) continue;
                iConnectionPanel.setDialog(this);
                this._tabs.addTab(string, (Component)((Object)iConnectionPanel));
            }
            catch (Exception exception) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)(Messages.getString("ConnectionDialog.7") + string + "\n" + exception.getMessage()), (String)Messages.getString("ConnectionDialog.9"), (String)"f1_connectiontype_load_err_html");
            }
        }
        this._tabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Properties properties = null;
                try {
                    properties = ((ConnectionModel)ConnectionDialog.this._table.getModel()).getRowData(ConnectionDialog.this._table.getSelectedRow());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (properties != null) {
                    ConnectionDialog.this.tfdConnName.setText(properties.getProperty("ConnName"));
                    ConnectionDialog.this.tfdUser.setText(properties.getProperty("user"));
                    ConnectionDialog.this.tfdPassword.setText(properties.getProperty("password"));
                    ConnectionDialog.this.chkSavePassword.setSelected(Boolean.parseBoolean(properties.getProperty("SavePassword")));
                    IConnectionPanel iConnectionPanel = (IConnectionPanel)((Object)ConnectionDialog.this._tabs.getSelectedComponent());
                    if (iConnectionPanel.getConnectionType().equalsIgnoreCase(properties.getProperty("RaptorConnectionType"))) {
                        iConnectionPanel.updatePrompts(properties);
                    } else {
                        iConnectionPanel.setDefaultPrompts();
                    }
                }
            }
        });
        this.add((Component)this._tabs, new GridBagConstraints(1, 5, 2, 1, 1.0, 1.0, 18, 1, new Insets(2, 5, 0, 0), 0, 0));
        this.add((Component)this.lblStatus, new GridBagConstraints(0, 6, 3, 1, 0.0, 0.0, 18, 0, new Insets(2, 5, 0, 0), 0, 0));
        this.add((Component)this.copyBtn, new GridBagConstraints(1, 6, 3, 1, 0.0, 0.0, 13, 0, new Insets(2, 5, 0, 0), 0, 0));
        this.copyBtn.setVisible(false);
        this.copyBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StringSelection stringSelection = new StringSelection(ConnectionDialog.this.lblStatus.getText());
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                ClipboardStack.pushCurrentClipboard();
                clipboard.setContents(stringSelection, stringSelection);
                ConnectionDialog.this.copyBtn.setSelected(false);
            }
        });
        Dimension dimension = Ide.getMainWindow().getSize();
        this.setMinimumSize(new Dimension(750, 390));
        this.validate();
    }

    public void initDialog(JEWTDialog jEWTDialog) {
        this._dlg = jEWTDialog;
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConnectionDialog.this.processButtons(actionEvent.getActionCommand());
            }
        };
        this._dlg.addActionListener(actionListener);
        this._btnSave.addActionListener(actionListener);
        this._btnTest.addActionListener(actionListener);
        this._btnClear.addActionListener(actionListener);
        this._btnConnect.addActionListener(actionListener);
        this._btnSave.setMaximumSize(this._btnSave.getMinimumSize());
        this._btnTest.setMaximumSize(this._btnTest.getMinimumSize());
        this._btnClear.setMaximumSize(this._btnClear.getMinimumSize());
        this._dlg.addCustomButton((Component)this._btnSave);
        this._dlg.addCustomButton((Component)this._btnClear);
        this._dlg.addCustomButton((Component)this._btnTest);
        this._dlg.addCustomButton((Component)this._btnConnect);
        this.tfdConnName.addKeyListener(this._enterKey);
        this.tfdPassword.addKeyListener(this._enterKey);
        this.tfdUser.addKeyListener(this._enterKey);
    }

    public void attachEnterKey(Component component) {
        component.addKeyListener(this._enterKey);
        if (component instanceof Container) {
            for (int i = 0; i < ((Container)component).getComponentCount(); ++i) {
                this.attachEnterKey(((Container)component).getComponent(i));
            }
        }
    }

    public String getUserName() {
        return this.tfdUser.getText();
    }

    public String getPassword() {
        return new String(this.tfdPassword.getPassword());
    }

    public void setPassword(String string) {
        this.tfdPassword.setText(string);
    }

    public Properties getConnectionProperties() {
        IConnectionPanel iConnectionPanel = (IConnectionPanel)((Object)this._tabs.getSelectedComponent());
        return iConnectionPanel.getConnectionProperties();
    }

    private static List<Properties> getAllConnections(DatabaseConnections databaseConnections) {
        ArrayList<Properties> arrayList = new ArrayList<Properties>();
        try {
            Collection collection = databaseConnections.listConnections();
            String[] stringArray = collection.toArray(new String[0]);
            Arrays.sort(stringArray, String.CASE_INSENSITIVE_ORDER);
            for (String string : stringArray) {
                Properties properties = databaseConnections.getProperties(string);
                properties.setProperty("ConnName", string);
                arrayList.add(properties);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(ConnectionDialog.class.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return arrayList;
    }

    private void setActivePanel(Properties properties) {
        Object object;
        int n;
        String string = properties.getProperty("RaptorConnectionType");
        if (this.listOfPanels == null) {
            this.listOfPanels = new ArrayList();
            for (n = 0; n < this._tabs.getTabCount(); ++n) {
                object = this._tabs.getComponentAt(n);
                this.listOfPanels.add(object);
            }
        }
        for (n = 0; n < this.listOfPanels.size(); ++n) {
            object = (IConnectionPanel)((Object)this.listOfPanels.get(n));
            if (!object.getConnectionType().equals(string)) continue;
            this._tabs.setSelectedIndex(n);
        }
        ((IConnectionPanel)((Object)this._tabs.getSelectedComponent())).updatePrompts(properties);
    }

    public void tableFocusChanged() {
        if (this._table.getSelectedRow() > -1) {
            IConnectionPanel iConnectionPanel = (IConnectionPanel)((Object)this._tabs.getSelectedComponent());
            Properties properties = ((ConnectionModel)this._table.getModel()).getRowData(this._table.getSelectedRow());
            this.tfdConnName.setText(properties.getProperty("ConnName"));
            this.tfdUser.setText(properties.getProperty("user"));
            this.tfdPassword.setText(properties.getProperty("password"));
            this.chkSavePassword.setSelected(Boolean.parseBoolean(properties.getProperty("SavePassword")));
            this.setActivePanel(properties);
            this._table.requestFocusInWindow();
        }
    }

    public boolean validateInput() {
        boolean bl = true;
        if (this.tfdConnName.getText() == null || this.tfdConnName.getText().trim().length() == 0) {
            MessageDialog.error((Component)this._dlg, (Object)Messages.getString("ConnectionDialog.11"), (String)Messages.getString("ConnectionDialog.12"), null);
            bl = false;
        } else if (!Pattern.matches(EXCLUSION_CHAR_PATTERN, this.tfdConnName.getText())) {
            MessageDialog.error((Component)this._dlg, (Object)Messages.getString("ConnectionDialog.13"), (String)Messages.getString("ConnectionDialog.12"), null);
            bl = false;
        }
        return bl;
    }

    private void processButtons(String string) {
        final IConnectionPanel iConnectionPanel = (IConnectionPanel)((Object)this._tabs.getSelectedComponent());
        Properties properties = new Properties();
        properties.setProperty("ConnName", this.tfdConnName.getText().trim());
        properties.setProperty("user", this.tfdUser.getText());
        properties.setProperty("password", new String(this.tfdPassword.getPassword()));
        properties.setProperty("SavePassword", Boolean.toString(this.chkSavePassword.isSelected()));
        iConnectionPanel.setConnectionProperties(properties);
        if (string == CLEAR) {
            iConnectionPanel.clear();
            this.tfdConnName.setText("");
            this.tfdPassword.setText("");
            this.tfdUser.setText("");
        } else if (string == TEST) {
            ConnectRunnable connectRunnable = new ConnectRunnable(){

                protected Object doWork() throws Exception {
                    iConnectionPanel.testConnection(ConnectionDialog.this.getUserName(), ConnectionDialog.this.getPassword());
                    return null;
                }
            };
            try {
                connectRunnable.setTitle(Messages.getString("ConnectionDialog.16"));
                connectRunnable.start(true);
            }
            catch (ProgressException progressException) {}
        } else if (string == SAVE && this.validateInput()) {
            String string2 = this.getConnectionName();
            try {
                int n = this.checkForReplace(string2, false);
                if (n == 1) {
                    Properties properties2 = this.getConnectionProperties();
                    String string3 = properties2.getProperty("SavePassword");
                    if (string3 != null && string3.equals(Boolean.toString(false))) {
                        Properties properties3 = new Properties();
                        properties3.putAll((Map<?, ?>)properties2);
                        properties3.remove("password");
                        properties2 = properties3;
                    }
                    this.registerConnection(string2, properties2);
                    ((ConnectionModel)this._table.getModel()).reReadConnections();
                }
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        } else if (string == CONNECT && this.validateInput()) {
            final String string4 = this.getConnectionName();
            try {
                int n = this.checkForReplace(string4, true);
                if (n == 1) {
                    ConnectRunnable connectRunnable = new ConnectRunnable(){

                        protected Object doWork() throws Exception {
                            return iConnectionPanel.testConnection(ConnectionDialog.this.getUserName(), ConnectionDialog.this.getPassword());
                        }

                        protected void finish(Object object) {
                            if (!this.isCanceled()) {
                                boolean bl;
                                boolean bl2 = bl = object instanceof Boolean && (Boolean)object != false;
                                if (bl) {
                                    try {
                                        final Properties properties = ConnectionDialog.this.getConnectionProperties();
                                        ConnectionDialog.this.registerConnection(string4, properties);
                                        ((ConnectionModel)ConnectionDialog.this._table.getModel()).reReadConnections();
                                        SwingUtilities.invokeLater(new Runnable(){

                                            @Override
                                            public void run() {
                                                block4: {
                                                    PasswordPrompter passwordPrompter = DatabaseProviderHelper.getPasswordPrompter();
                                                    try {
                                                        Connections.ConnectionKey connectionKey = Connections.ConnectionKey.createConnectionKey(ConnectionDialog.this.m_store.getStoreName(), string4);
                                                        String string = connectionKey.getQualifiedName();
                                                        passwordPrompter.cache(properties);
                                                        Connections.getInstance().getConnection(string);
                                                    }
                                                    catch (DBException dBException) {
                                                        Throwable throwable;
                                                        if (passwordPrompter instanceof ConnectionPrompt) {
                                                            ((ConnectionPrompt)passwordPrompter).uncache(properties);
                                                        }
                                                        Throwable throwable2 = throwable = dBException;
                                                        while (throwable instanceof DBException) {
                                                            if ((throwable = throwable.getCause()) == null) continue;
                                                            throwable2 = throwable;
                                                        }
                                                        if (throwable2 instanceof ConnectionCanceledException) break block4;
                                                        ExceptionHandler.handleException((Throwable)throwable2);
                                                    }
                                                }
                                            }
                                        });
                                        ConnectionDialog.this._dlg.setVisible(false);
                                        ConnectionDialog.this._dlg.closeDialog(false);
                                    }
                                    catch (ConnectionException connectionException) {}
                                }
                            } else {
                                ConnectionDialog.this.setStatus(Messages.getString("ConnectionDialog.17"));
                            }
                        }
                    };
                    try {
                        connectRunnable.setTitle(Messages.getString("ConnectionDialog.18"));
                        connectRunnable.start(true);
                    }
                    catch (ProgressException progressException) {}
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static ConnectionInfo launch(DatabaseConnections databaseConnections, String string) {
        String string2 = databaseConnections != null ? databaseConnections.getStoreName() : "IdeConnections";
        String string3 = ConnectionDialog.launch(string2, string);
        return string3 != null ? new ConnectionInfo(string2, string3) : null;
    }

    private int checkForReplace(String string, boolean bl) throws ConnectionException {
        boolean bl2;
        Properties properties = this.m_store.getProperties(string);
        boolean bl3 = bl2 = (this.m_initName == null || ModelUtil.areDifferent((Object)string, (Object)this.m_initName)) && properties != null;
        if (bl2 && !bl || bl2 && bl && !this.equals(this.getConnectionProperties(), properties)) {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.isConnectionFound(string, stringBuffer)) {
                String string2 = MessageFormat.format(Messages.getString("ConnectionDialog.21"), stringBuffer.toString());
                return MessageDialog.confirmOrCancel((Component)this, (Object)string2, (String)Messages.getString("ConnectionDialog.20"));
            }
            return MessageDialog.confirmOrCancel((Component)this, (Object)Messages.getString("ConnectionDialog.19"), (String)Messages.getString("ConnectionDialog.20"));
        }
        return 1;
    }

    private boolean isConnectionFound(String string, StringBuffer stringBuffer) {
        Object object;
        View view = Ide.getMainWindow().getLastActiveView();
        if (!(view instanceof NavWindow)) {
            object = Ide.getMainWindow().getVisibleViews();
            for (int i = 0; i < object.size() && !((view = (View)object.get(i)) instanceof NavWindow); ++i) {
            }
        }
        if (view != null && view instanceof NavWindow) {
            object = (NavWindow)view;
            TNode tNode = object.getTreeExplorer().getRoot();
            Enumeration enumeration = tNode.getChildTNodes();
            while (enumeration.hasMoreElements()) {
                TNode tNode2 = (TNode)enumeration.nextElement();
                Element element = tNode2.getData();
                Enumeration enumeration2 = tNode2.getChildTNodes();
                while (enumeration2.hasMoreElements()) {
                    TNode tNode3 = (TNode)enumeration2.nextElement();
                    Element element2 = tNode3.getData();
                    if (!element2.getClass().getName().equals("oracle.dbtools.raptor.navigator.folders.DatabasesFolder")) continue;
                    stringBuffer.append(tNode3.toString());
                    Enumeration enumeration3 = tNode3.getChildTNodes();
                    while (enumeration3.hasMoreElements()) {
                        TNode tNode4 = (TNode)enumeration3.nextElement();
                        Element element3 = tNode4.getData();
                        if (!(element3 instanceof DatabaseConnection)) continue;
                        String string2 = tNode4.toString();
                        return string.equals(string2);
                    }
                }
            }
        }
        return false;
    }

    private boolean equals(Properties properties, Properties properties2) {
        boolean bl = false;
        if (properties != null && properties2 != null) {
            String string = properties.getProperty("customUrl");
            String string2 = properties2.getProperty("customUrl");
            String string3 = properties.getProperty("user");
            String string4 = properties2.getProperty("user");
            bl = ModelUtil.areEqual((Object)string, (Object)string2) && ModelUtil.areEqual((Object)string3, (Object)string4);
        }
        return bl;
    }

    public boolean useUserName() {
        return this.tfdUser.isEditable();
    }

    public boolean usePassword() {
        return this.tfdPassword.isEditable();
    }

    public void useUserName(boolean bl) {
        this.tfdUser.setEditable(bl);
        this.lblUser.setEnabled(bl);
        if (bl) {
            this.tfdUser.setForeground(Color.BLACK);
        } else {
            this.tfdUser.setText("");
            this.tfdUser.setForeground(Color.LIGHT_GRAY);
        }
    }

    public void usePassword(boolean bl) {
        this.tfdPassword.setEditable(bl);
        this.chkSavePassword.setEnabled(bl);
        this.lblPassword.setEnabled(bl);
        if (bl) {
            this.tfdPassword.setForeground(Color.BLACK);
        } else {
            this.tfdPassword.setText("");
            this.tfdPassword.setForeground(Color.LIGHT_GRAY);
        }
    }

    public void useSavePwd(boolean bl) {
        this.chkSavePassword.setEnabled(bl);
    }

    public void chkSavePwd(boolean bl) {
        this.chkSavePassword.setSelected(bl);
    }

    public static String launch(String string) {
        return ConnectionDialog.launch("IdeConnections", string);
    }

    public static String launch(String string, String string2) {
        final ConnectionDialog connectionDialog = new ConnectionDialog();
        connectionDialog.setConnectionStore(string);
        if (string2 != null) {
            connectionDialog.setConnectionName(string2);
        }
        HelpSystem.getHelpSystem().registerTopic((JComponent)connectionDialog, "f1_idewcxnwelcome_html");
        Dimension dimension = connectionDialog.getPreferredSize();
        dimension.setSize(dimension.getWidth() + 150.0, dimension.getHeight() + 100.0);
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)connectionDialog, null, (String)Messages.getString("ConnectionDialog.24"), (int)6);
        connectionDialog.initDialog(jEWTDialog);
        jEWTDialog.setModal(true);
        jEWTDialog.pack();
        jEWTDialog.setMinimumSize(new Dimension(750, 390));
        DialogSizeKeeper.attachToComponent((Component)jEWTDialog, (String)"connection.dialog.size");
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
        Timer timer = new Timer("Focus", false);
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                connectionDialog.tfdConnName.requestFocus();
                connectionDialog.tfdConnName.requestFocusInWindow();
            }
        }, 250L);
        jEWTDialog.setVisible(true);
        if (jEWTDialog.isCancelled()) {
            return null;
        }
        return connectionDialog.getConnectionName();
    }

    public static void main(String[] stringArray) {
        ConnectionDialog.launch(null);
    }

    private void registerConnection(String string, Properties properties) throws ConnectionException {
        if (this.m_store.getProperties(string) != null) {
            String string2;
            String string3 = (String)this.m_store.getProperties(string).get("RaptorConnectionType");
            if (!string3.equals(string2 = (String)properties.get("RaptorConnectionType"))) {
                this.m_store.removeConnection(string);
                this.m_store.addConnection(string, properties);
            } else {
                this.m_store.updateConnection(string, string, properties);
            }
        } else {
            this.m_store.addConnection(string, properties);
        }
    }

    public void setStatus(String string) {
        this.copyBtn.setVisible(false);
        this.lblStatus.setText(string);
        this.lblStatus.setForeground(Color.BLACK);
        this.lblStatus.getAccessibleContext().setAccessibleName(this.lblStatus.getText());
    }

    public void setErrorStatus(String string) {
        this.copyBtn.setVisible(true);
        this.lblStatus.setText(string);
        this.lblStatus.setForeground(Color.RED);
        this.lblStatus.getAccessibleContext().setAccessibleName(this.lblStatus.getText());
    }

    public String getConnectionName() {
        return this.tfdConnName.getText().trim();
    }

    private void setConnectionStore(String string) {
        this.m_store = DatabaseConnectionStores.getInstance().getStore(string);
        this._table.setModel(new ConnectionModel(this.m_store));
    }

    public void setConnectionName(String string) {
        IConnectionPanel iConnectionPanel = (IConnectionPanel)((Object)this._tabs.getSelectedComponent());
        Properties properties = Connections.getInstance().getConnectionInfo(this.m_store.getStoreName(), string);
        if (properties != null) {
            this.m_initName = string;
            this.tfdConnName.setText(string);
            this.tfdUser.setText(properties.getProperty("user"));
            this.tfdPassword.setText(properties.getProperty("password"));
            this.chkSavePassword.setSelected(Boolean.parseBoolean(properties.getProperty("SavePassword", Boolean.TRUE.toString())));
            this.setActivePanel(properties);
            for (int i = 0; i < this._table.getRowCount(); ++i) {
                Object object = this._table.getValueAt(i, 0);
                if (!((String)this._table.getValueAt(i, 0)).equals(string)) continue;
                this._table.setRowSelectionInterval(i, i);
            }
        }
    }

    private static class ConnectionModel
    extends AbstractTableModel {
        List<Properties> data = null;
        DatabaseConnections m_store;

        public ConnectionModel(DatabaseConnections databaseConnections) {
            this.m_store = databaseConnections;
            this.data = ConnectionDialog.getAllConnections(this.m_store);
        }

        public void setData(ArrayList<Properties> arrayList) {
            assert (arrayList != null);
            this.data = arrayList;
        }

        public void reReadConnections() {
            this.data = ConnectionDialog.getAllConnections(this.m_store);
            this.fireTableStructureChanged();
            this.fireTableDataChanged();
        }

        public List<Properties> getData() {
            return this.data;
        }

        @Override
        public String getColumnName(int n) {
            String string = null;
            switch (n) {
                case 0: {
                    string = ConnectionDialogArb.getString("CONNECTION_DIALOG_LIST_HEADER_NAME");
                    break;
                }
                case 1: {
                    string = ConnectionDialogArb.getString("CONNECTION_DIALOG_LIST_HEADER_DETAIL");
                }
            }
            return string;
        }

        @Override
        public int getRowCount() {
            return this.data != null ? this.data.size() : 0;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Properties properties = this.getRowData(n);
            String string = null;
            switch (n2) {
                case 0: {
                    string = properties.getProperty("ConnName");
                    break;
                }
                case 1: {
                    String string2;
                    String string3 = properties.getProperty("hostname");
                    if (string3 != null) {
                        string2 = properties.getProperty("port");
                        String string4 = properties.getProperty("sid");
                        String string5 = properties.getProperty("serviceName");
                        string4 = string4 != null ? string4 : string5;
                        string = MessageFormat.format("//{0}:{1}/{2}", string3, string2 != null ? string2 : "1521", string4);
                    } else {
                        string2 = properties.getProperty("customUrl");
                        if (string2 != null) {
                            string = string2.substring(string2.lastIndexOf(64) + 1);
                        }
                    }
                    string2 = properties.getProperty("user");
                    if (string2 == null) {
                        string2 = "";
                    }
                    string = string2 + "@" + string;
                }
            }
            return string;
        }

        public Properties getRowData(int n) {
            return this.data.get(n);
        }
    }

    private static abstract class ConnectRunnable
    extends ProgressRunnable {
        boolean m_canceled;

        private ConnectRunnable() {
        }

        protected void doCancel() {
            super.doCancel();
            this.m_canceled = true;
        }

        boolean isCanceled() {
            return this.m_canceled;
        }
    }
}

