/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.config.PreferencesArb;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;

public class CodeAdvisorInfo
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 0L;
    private JCheckBox m_enableCodeAdvisor = new JCheckBox();
    private JCheckBox m_showBasicAdvice = new JCheckBox();
    private JCheckBox m_showDetailedAdvice = new JCheckBox();
    private JCheckBox m_showEnvironment = new JCheckBox();
    private JTextField m_refreshDelay = new JTextField();
    private JTextField m_inactivityDelay = new JTextField();

    public CodeAdvisorInfo() {
        this.setHelpID(Messages.getString("CodeAdvisorInfo.0"));
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        this.m_enableCodeAdvisor.setSelected(dBConfig.getBoolean("CODEADVISOR_ENABLE"));
        this.m_showBasicAdvice.setSelected(dBConfig.getBoolean("CODEADVISOR_BASIC"));
        this.m_showDetailedAdvice.setSelected(dBConfig.getBoolean("CODEADVISOR_DETAILED"));
        this.m_showEnvironment.setSelected(dBConfig.getBoolean("CODEADVISOR_ENVIRONMENT"));
        this.m_refreshDelay.setText(dBConfig.getString("CODEADVISOR_REFRESHDELAY"));
        this.m_inactivityDelay.setText(dBConfig.getString("CODEADVISOR_INACTIVITYDELAY"));
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        dBConfig.putBoolean("CODEADVISOR_ENABLE", this.m_enableCodeAdvisor.isSelected());
        dBConfig.putBoolean("CODEADVISOR_BASIC", this.m_showBasicAdvice.isSelected());
        dBConfig.putBoolean("CODEADVISOR_DETAILED", this.m_showDetailedAdvice.isSelected());
        dBConfig.putBoolean("CODEADVISOR_ENVIRONMENT", this.m_showEnvironment.isSelected());
        dBConfig.putString("CODEADVISOR_REFRESHDELAY", this.m_refreshDelay.getText());
        dBConfig.putString("CODEADVISOR_INACTIVITYDELAY", this.m_inactivityDelay.getText());
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        ResourceUtils.resButton((AbstractButton)this.m_enableCodeAdvisor, (String)PreferencesArb.getString("CODEADVISOR_ENABLE"));
        this.add(this.m_enableCodeAdvisor, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(null, PreferencesArb.getString("CODEADVISOR_ADVICEGROUPS"), 0, 0, null, null));
        ResourceUtils.resButton((AbstractButton)this.m_showBasicAdvice, (String)PreferencesArb.getString("CODEADVISOR_BASIC"));
        ResourceUtils.resButton((AbstractButton)this.m_showDetailedAdvice, (String)PreferencesArb.getString("CODEADVISOR_DETAILED"));
        ResourceUtils.resButton((AbstractButton)this.m_showEnvironment, (String)PreferencesArb.getString("CODEADVISOR_ENVIRONMENT"));
        jPanel.add((Component)this.m_showBasicAdvice, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        jPanel.add((Component)this.m_showDetailedAdvice, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        jPanel.add((Component)this.m_showEnvironment, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        this.add(jPanel, new GridBagConstraints(0, 4, 2, 2, 1.0, 0.0, 17, 1, new Insets(10, 5, 0, 0), 0, 0));
        this.add(new JLabel(PreferencesArb.getString("CODEADVISOR_REFRESHDELAY")), new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add(this.m_refreshDelay, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 17, 1, new Insets(10, 5, 0, 0), 0, 0));
        this.add(new JLabel(PreferencesArb.getString("CODEADVISOR_INACTIVITYDELAY")), new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add(this.m_inactivityDelay, new GridBagConstraints(1, 7, 1, 1, 1.0, 0.0, 17, 1, new Insets(10, 5, 0, 0), 0, 0));
        JLabel jLabel = new JLabel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridx = 2;
        this.add(jLabel, gridBagConstraints);
    }
}

