/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.cloud.navigator;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.Icon;
import oracle.dbtools.raptor.navigator.OracleNavigatorResource;
import oracle.dbtools.raptor.navigator.xml.ResourceProvider;
import oracle.dbtools.raptor.navigator.xml.XmlNavigatorUtils;
import oracle.dbtools.util.Logger;

class CloudObjectType
implements ResourceProvider {
    private String m_type;
    private String m_path;
    private String m_label;
    private String m_folderIconKey;
    private String m_nodeIconKey;
    private String m_labelKey;
    private ResourceBundle m_bundle;
    private Icon m_folderIcon;
    private Icon m_nodeIcon;

    CloudObjectType() {
    }

    CloudObjectType(String string) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(OracleNavigatorResource.class.getName());
        this.setBundle(resourceBundle);
        this.setType(string);
        if (string.equals("TABLE")) {
            this.setLabelKey("TABLE_LABEL");
            this.setFolderIconKey("TABLE_FOLDER_ICON");
            this.setNodeIconKey("OracleIcons.TABLE");
        } else if (string.equals("VIEW")) {
            this.setLabelKey("VIEW_LABEL");
            this.setFolderIconKey("VIEW_FOLDER_ICON");
            this.setNodeIconKey("OracleIcons.VIEW");
        } else if (string.equals("INDEX")) {
            this.setLabelKey("INDEX_LABEL");
            this.setFolderIconKey("INDEX_FOLDER_ICON");
            this.setNodeIconKey("OracleIcons.INDEX");
        } else if (string.equals("PACKAGE")) {
            this.setLabelKey("PACKAGE_LABEL");
            this.setFolderIconKey("PACKAGE_FOLDER_ICON");
            this.setNodeIconKey("OracleIcons.PACKAGE");
        } else if (string.equals("PROCEDURE")) {
            this.setLabelKey("PROCEDURE_LABEL");
            this.setFolderIconKey("PROCEDURE_FOLDER_ICON");
            this.setNodeIconKey("OracleIcons.PROCEDURE");
        } else if (string.equals("FUNCTION")) {
            this.setLabelKey("FUNCTION_LABEL");
            this.setFolderIconKey("FUNCTION_FOLDER_ICON");
            this.setNodeIconKey("OracleIcons.FUNCTION");
        } else if (string.equals("TRIGGER")) {
            this.setLabelKey("TRIGGER_LABEL");
            this.setFolderIconKey("TRIGGER_FOLDER_ICON");
            this.setNodeIconKey("OracleIcons.TRIGGER");
        } else if (string.equals("TYPE")) {
            this.setLabelKey("TYPE_LABEL");
            this.setFolderIconKey("TYPE_FOLDER_ICON");
            this.setNodeIconKey("OracleIcons.TYPE");
        } else if (string.equals("SEQUENCE")) {
            this.setLabelKey("SEQUENCE_LABEL");
            this.setFolderIconKey("SEQUENCE_FOLDER_ICON");
            this.setNodeIconKey("OracleIcons.SEQUENCE");
        } else if (string.equals("RECYCLE_BIN")) {
            this.setLabelKey("RECYCLE_LABEL");
            this.setFolderIconKey("RECYCLE_FOLDER_ICON");
            this.setNodeIconKey("OracleIcons.RECYCLE");
        } else if (string.equals("DEPLOYMENTS")) {
            this.setLabelKey("DEPLOYMENTS_LABEL");
            this.setFolderIconKey("DEPLOYMENTS_FOLDER_ICON");
            this.setNodeIconKey("DEPLOYMENTS_FOLDER_ICON");
        } else {
            this.setLabelKey(string);
            this.setFolderIconKey("OracleIcons.UNKNOWNSTATUS");
            this.setNodeIconKey("OracleIcons.UNKNOWNSTATUS");
        }
    }

    public void setFolderIconKey(String string) {
        this.m_folderIconKey = string;
    }

    public void setNodeIconKey(String string) {
        this.m_nodeIconKey = string;
    }

    public void setBundle(ResourceBundle resourceBundle) {
        this.m_bundle = resourceBundle;
    }

    public void setType(String string) {
        this.m_type = string;
    }

    public void setPath(String string) {
        this.m_path = string;
    }

    public void setLabelKey(String string) {
        this.m_labelKey = string;
    }

    public ResourceBundle getBundle() {
        return this.m_bundle;
    }

    public String getType() {
        return this.m_type;
    }

    public String getPath() {
        return this.m_path;
    }

    public String getLabel() {
        if (this.m_label == null && this.m_labelKey != null) {
            this.m_label = this.getResource(this.m_labelKey);
        }
        return this.m_label;
    }

    public Icon getFolderIcon() {
        if (this.m_folderIcon == null && this.m_folderIconKey != null) {
            this.m_folderIcon = XmlNavigatorUtils.getIcon(this.m_folderIconKey, this);
        }
        return this.m_folderIcon;
    }

    public Icon getNodeIcon() {
        if (this.m_nodeIcon == null && this.m_nodeIconKey != null) {
            this.m_nodeIcon = XmlNavigatorUtils.getIcon(this.m_nodeIconKey, this);
        }
        return this.m_nodeIcon;
    }

    @Override
    public String getResource(String string) {
        try {
            if (this.m_bundle != null) {
                return this.m_bundle.getString(string);
            }
        }
        catch (MissingResourceException missingResourceException) {
            Logger.info(CloudObjectType.class, (String)("Could not translate key:" + string));
        }
        return string;
    }
}

