/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.cloud.navigator;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.ide.net.URIFactory;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.cloud.CloudBrowserResources;
import oracle.dbtools.raptor.cloud.connection.CConnection;
import oracle.dbtools.raptor.cloud.connection.CConnectionException;
import oracle.dbtools.raptor.cloud.connection.CloudTask;
import oracle.dbtools.raptor.cloud.connection.JSONNodeHandler;
import oracle.dbtools.raptor.cloud.connection.JSONUtils;
import oracle.dbtools.raptor.cloud.navigator.AbstractCloudFilter;
import oracle.dbtools.raptor.cloud.navigator.CloudConnection;
import oracle.dbtools.raptor.cloud.navigator.CloudFolder;
import oracle.dbtools.raptor.cloud.navigator.CloudObjectType;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.rt.json.JSONArray;
import oracle.dbtools.rt.json.JSONNode;
import oracle.dbtools.rt.json.JSONObject;
import oracle.dbtools.rt.json.JSONValue;
import oracle.dbtools.util.Logger;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;

public class CloudConnectionFilter
extends AbstractCloudFilter<CloudConnection> {
    @Override
    protected CloudTask<List<Element>> getTask() {
        final CloudConnection cloudConnection = (CloudConnection)this.getOwningElement();
        final String string = cloudConnection.getConnectionName();
        return new CloudTask<List<Element>>(CloudBrowserResources.getString("TASK_CLOUD_CONNECT"), true, IRaptorTaskRunMode.TASKVIEWER){

            @Override
            protected String getConnectionName() {
                return string;
            }

            protected List<Element> doWork() throws TaskException {
                List<Element> list = null;
                try {
                    CConnection cConnection = cloudConnection.getConnection();
                    URI uRI = cConnection.getDefaultServiceURI();
                    list = cConnection.executeQuery(uRI, new JSONNodeHandler<List<Element>>(){

                        @Override
                        protected List<Element> build(JSONNode jSONNode) throws IOException {
                            ArrayList<Element> arrayList = new ArrayList<Element>();
                            JSONObject jSONObject = (JSONObject)jSONNode;
                            JSONArray jSONArray = (JSONArray)JSONUtils.getValue(jSONObject, "items");
                            this.checkJSONElement(jSONArray, "items");
                            for (JSONValue jSONValue : jSONArray.values()) {
                                JSONObject jSONObject2 = (JSONObject)jSONValue.value();
                                String string = (String)JSONUtils.getValue(jSONObject2, "type");
                                this.checkJSONElement(string, "type");
                                JSONObject jSONObject3 = (JSONObject)JSONUtils.getValue(jSONObject2, "uri");
                                this.checkJSONElement(jSONObject3, "uri");
                                String string2 = (String)JSONUtils.getValue(jSONObject3, "$ref");
                                try {
                                    CloudObjectType cloudObjectType = new CloudObjectType(string);
                                    URL uRL = DBURLFormatHelper.getURL("sqldev.cloud", string, null, null, string);
                                    CloudFolder cloudFolder = CloudConnectionFilter.this.createFolder(uRL, cloudObjectType);
                                    cloudFolder.setRemoteURI(URIFactory.newURI((String)string2));
                                    cloudFolder.setConnectionName(cloudConnection.getConnectionName());
                                    arrayList.add((Element)cloudFolder);
                                }
                                catch (Exception exception) {}
                            }
                            return arrayList;
                        }
                    });
                }
                catch (CConnectionException cConnectionException) {
                    Logger.warn(CloudConnectionFilter.class, (Throwable)cConnectionException);
                    throw new TaskException((Throwable)cConnectionException);
                }
                catch (IOException iOException) {
                    Logger.warn(CloudConnectionFilter.class, (Throwable)iOException);
                    throw new TaskException((Throwable)iOException);
                }
                return list;
            }
        };
    }

    private CloudFolder createFolder(URL uRL, CloudObjectType cloudObjectType) {
        CloudFolder cloudFolder = new CloudFolder(uRL);
        cloudFolder.setObjectType(cloudObjectType);
        return cloudFolder;
    }

    protected boolean loadInThread() {
        return false;
    }

    public Comparator<?> getComparator() {
        return null;
    }

    @Override
    protected Object getKey(Object object) {
        if (object instanceof CloudFolder) {
            return ((CloudFolder)object).getType();
        }
        if (object instanceof Locatable) {
            return ((Locatable)object).getURL();
        }
        return null;
    }
}

