/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.cloud.connection;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Set;
import javax.ide.net.URIFactory;
import oracle.dbtools.raptor.cloud.connection.CConnectionInfo;
import oracle.ide.config.Preferences;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;

class Storage
extends HashStructureAdapter {
    private static final String KEY = "CLOUD_CONNECTIONS";
    private static final String CONNECTIONS = "ConnectionsList";
    private static final String ROOT = "RootURL";
    private static final String SERVICE_URL = "ServiceURL";
    private static final String USERNAME = "User";
    private static final String SFTP_DETAILS = "SftpDetails";
    private static final String SFTP_HOST = "SftpHost";
    private static final String SFTP_PORT = "SftpPort";

    static Storage getInstance() {
        return new Storage(Storage.findOrCreate((PropertyStorage)Preferences.getPreferences(), (String)KEY));
    }

    private Storage(HashStructure hashStructure) {
        super(hashStructure);
    }

    String[] listConnections(String string) {
        HashStructure hashStructure = this.getConnectionsHash(string, false);
        if (hashStructure != null) {
            Set set = hashStructure.keySet();
            return set.toArray(new String[0]);
        }
        return new String[0];
    }

    private HashStructure getConnectionsHash(String string, boolean bl) {
        HashStructure hashStructure = null;
        if (bl) {
            HashStructure hashStructure2 = this._hash.getOrCreateHashStructure(CONNECTIONS);
            hashStructure = hashStructure2.getOrCreateHashStructure(string);
        } else {
            HashStructure hashStructure3 = this._hash.getHashStructure(CONNECTIONS);
            if (hashStructure3 != null) {
                hashStructure = hashStructure3.getHashStructure(string);
            }
        }
        return hashStructure;
    }

    CConnectionInfo getCloudConnection(String string, String string2) {
        HashStructure hashStructure;
        CConnectionInfo cConnectionInfo = null;
        HashStructure hashStructure2 = this.getConnectionsHash(string, false);
        if (hashStructure2 != null && (hashStructure = hashStructure2.getHashStructure(string2)) != null) {
            URI uRI = Storage.toURI(hashStructure.getURL(ROOT));
            URI uRI2 = Storage.toURI(hashStructure.getURL(SERVICE_URL));
            String string3 = hashStructure.getString(USERNAME);
            HashStructure hashStructure3 = hashStructure.getHashStructure(SFTP_DETAILS);
            if (hashStructure3 == null) {
                cConnectionInfo = new CConnectionInfo(string2, uRI, uRI2, string3);
            } else {
                String string4 = hashStructure3.getString(USERNAME);
                String string5 = hashStructure3.getString(SFTP_HOST);
                int n = hashStructure3.getInt(SFTP_PORT);
                CConnectionInfo.SftpInfo sftpInfo = new CConnectionInfo.SftpInfo(string4, string5, n);
                cConnectionInfo = new CConnectionInfo(string2, uRI, uRI2, string3, sftpInfo);
            }
        }
        return cConnectionInfo;
    }

    private static URI toURI(URL uRL) {
        return uRL != null ? URIFactory.newURI((URL)uRL) : null;
    }

    private static URL toURL(URI uRI) {
        try {
            return uRI != null ? uRI.toURL() : null;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    void putCloudConnection(String string, CConnectionInfo cConnectionInfo) {
        HashStructure hashStructure = this.getConnectionsHash(string, true);
        HashStructure hashStructure2 = HashStructure.newInstance();
        hashStructure2.putURL(ROOT, Storage.toURL(cConnectionInfo.getServerRoot()));
        hashStructure2.putURL(SERVICE_URL, Storage.toURL(cConnectionInfo.getServiceRoot()));
        hashStructure2.putString(USERNAME, cConnectionInfo.getUsername());
        CConnectionInfo.SftpInfo sftpInfo = cConnectionInfo.getSftpInfo();
        if (sftpInfo != null) {
            HashStructure hashStructure3 = HashStructure.newInstance();
            hashStructure3.putString(SFTP_HOST, sftpInfo.getSftpHost());
            hashStructure3.putInt(SFTP_PORT, sftpInfo.getSftpPort());
            hashStructure3.putString(USERNAME, sftpInfo.getSftpUser());
            hashStructure2.putHashStructure(SFTP_DETAILS, hashStructure3);
        }
        hashStructure.putHashStructure(cConnectionInfo.getName(), hashStructure2);
    }

    void removeCloudConnection(String string, String string2) {
        HashStructure hashStructure = this.getConnectionsHash(string, false);
        if (hashStructure != null) {
            hashStructure.remove(string2);
        }
    }
}

