/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.cloud.connection;

import java.io.IOException;
import java.net.URI;
import java.util.concurrent.locks.ReentrantLock;
import javax.ide.net.URIFactory;
import oracle.dbtools.raptor.cloud.auth.Authentication;
import oracle.dbtools.raptor.cloud.auth.AuthenticationEngine;
import oracle.dbtools.raptor.cloud.auth.AuthenticationFailedException;
import oracle.dbtools.raptor.cloud.connection.CConnectionException;
import oracle.dbtools.raptor.cloud.connection.CConnectionInfo;
import oracle.dbtools.raptor.cloud.connection.Client;
import oracle.dbtools.raptor.utils.StreamCopy;
import oracle.dbtools.util.Logger;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicHeader;

public class CConnection {
    private static final String AUTH_HEADER = "Authorization";
    private static final String PATH_SEPARATOR = "/";
    private CConnectionInfo m_info;
    private URI m_root;
    private transient State m_state = State.CLOSED;
    private Authentication m_auth;
    private transient ReentrantLock m_lock;
    private URI m_baseURI;
    private Client m_client;

    CConnection(CConnectionInfo cConnectionInfo, Client client, Authentication authentication) {
        this.m_info = cConnectionInfo;
        this.m_root = cConnectionInfo.getServerRoot();
        this.m_auth = authentication;
        this.m_client = client;
        this.m_lock = new ReentrantLock();
        this.m_baseURI = cConnectionInfo.getServiceRoot();
    }

    public URI getRoot() {
        return this.m_root;
    }

    public URI getDefaultServiceURI() {
        return this.m_baseURI;
    }

    public boolean isOpen() {
        return this.m_state == State.OPEN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void open() throws CConnectionException {
        if (this.m_state == State.OPEN) {
            return;
        }
        this.m_lock.lock();
        try {
            this.m_state = State.OPEN;
        }
        finally {
            this.m_lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        if (this.isOpen()) {
            this.m_lock.lock();
            try {
                this.m_auth = null;
                this.m_state = State.CLOSED;
            }
            finally {
                this.m_lock.unlock();
            }
        }
    }

    private static void signRequest(HttpRequest httpRequest, Authentication authentication) {
        httpRequest.removeHeaders(AUTH_HEADER);
        String string = authentication.getToken();
        BasicHeader basicHeader = new BasicHeader(AUTH_HEADER, "Bearer " + string);
        httpRequest.addHeader((Header)basicHeader);
    }

    public <V> V executeQuery(String string, ResponseHandler<V> responseHandler) throws CConnectionException {
        if (!this.isOpen()) {
            throw new CConnectionException("connection closed");
        }
        return this.executeQueryImpl(string, responseHandler);
    }

    public <V> V executeQuery(URI uRI, ResponseHandler<V> responseHandler) throws CConnectionException {
        if (!this.isOpen()) {
            throw new CConnectionException("connection closed");
        }
        HttpGet httpGet = new HttpGet(uRI);
        return this.executeImpl(responseHandler, (HttpUriRequest)httpGet);
    }

    private <V> V executeQueryImpl(String string, ResponseHandler<V> responseHandler) throws CConnectionException {
        HttpGet httpGet = new HttpGet(this.getURI(string));
        return this.executeImpl(responseHandler, (HttpUriRequest)httpGet);
    }

    private <V> V executeImpl(ResponseHandler<V> responseHandler, HttpUriRequest httpUriRequest) throws CConnectionException {
        CConnection.signRequest((HttpRequest)httpUriRequest, this.m_auth);
        try {
            try {
                Logger.info(CConnection.class, (String)("HTTP Request: " + httpUriRequest.getMethod() + "; URI: " + httpUriRequest.getURI()));
                return this.m_client.executeRequest(httpUriRequest, new ResponseHandlerWrapper<V>(responseHandler));
            }
            catch (AuthenticationFailedException authenticationFailedException) {
                StatusLine statusLine = authenticationFailedException.getStatusLine();
                int n = statusLine.getStatusCode();
                switch (n) {
                    case 401: {
                        AuthenticationEngine authenticationEngine = this.m_client.getAuthenticationEngine();
                        try {
                            Authentication authentication = authenticationEngine.reauthenticate(this.m_auth, this.m_info);
                            if (authentication != null) {
                                this.m_auth = authentication;
                                CConnection.signRequest((HttpRequest)httpUriRequest, this.m_auth);
                                V v = this.m_client.executeRequest(httpUriRequest, new ResponseHandlerWrapper<V>(responseHandler));
                                return v;
                            }
                        }
                        catch (AuthenticationFailedException authenticationFailedException2) {
                            Throwable throwable = authenticationFailedException2.getCause();
                            if (throwable instanceof IOException) {
                                throw (IOException)throwable;
                            }
                            if (throwable instanceof ClientProtocolException) {
                                throw (ClientProtocolException)throwable;
                            }
                            throw authenticationFailedException2;
                        }
                        return null;
                    }
                }
                throw authenticationFailedException;
            }
        }
        catch (ClientProtocolException clientProtocolException) {
            Logger.warn(CConnection.class, (Throwable)clientProtocolException);
            throw new CConnectionException(clientProtocolException);
        }
        catch (IOException iOException) {
            Logger.warn(CConnection.class, (Throwable)iOException);
            throw new CConnectionException(iOException);
        }
    }

    public <V> V executeRequest(HttpUriRequest httpUriRequest, ResponseHandler<V> responseHandler) throws CConnectionException {
        if (!this.isOpen()) {
            throw new CConnectionException("connection closed");
        }
        return this.executeImpl(responseHandler, httpUriRequest);
    }

    public HttpPost createPost(String string) {
        URI uRI = this.getURI(string);
        return this.createPost(uRI);
    }

    public HttpPost createPost(URI uRI) {
        return new HttpPost(uRI);
    }

    public HttpPut createPut(URI uRI) {
        return new HttpPut(uRI);
    }

    public HttpPut createPut(String string) {
        URI uRI = this.getURI(string);
        return this.createPut(uRI);
    }

    private URI getURI(String string) {
        String string2 = string.startsWith(PATH_SEPARATOR) ? string.substring(1) : string;
        return URIFactory.newURI((URI)this.m_baseURI, (String)string2);
    }

    private static enum State {
        OPEN,
        CLOSED;

    }

    private static class ResponseHandlerWrapper<V>
    implements ResponseHandler<V> {
        private final ResponseHandler<V> m_handler;

        ResponseHandlerWrapper(ResponseHandler<V> responseHandler) {
            this.m_handler = responseHandler;
        }

        public V handleResponse(HttpResponse httpResponse) throws ClientProtocolException, IOException {
            StatusLine statusLine = httpResponse.getStatusLine();
            int n = statusLine.getStatusCode();
            Logger.info(CConnection.class, (String)("HTTP Response code: " + n));
            switch (n) {
                case 401: {
                    Header header = httpResponse.getFirstHeader("Content-Type");
                    if (header != null) {
                        // empty if block
                    }
                    String string = StreamCopy.string(Client.createReader(httpResponse));
                    System.out.println(string);
                    throw new AuthenticationFailedException(statusLine);
                }
            }
            return (V)this.m_handler.handleResponse(httpResponse);
        }
    }

    private static final class ExpiredTokenException
    extends AuthenticationFailedException {
        ExpiredTokenException() {
            super("Expired authentication token");
        }
    }
}

