/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.backgroundTask.utils;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.concurrent.locks.ReentrantLock;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.ISchedulingRule;
import oracle.dbtools.raptor.backgroundTask.Messages;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.internal.ConnectionMutexFactory;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.MessageLogging;
import oracle.dbtools.util.Debug;
import oracle.dbtools.util.Logger;
import oracle.javatools.db.DBException;

public abstract class DatabaseQueryTask<V>
extends RaptorTask<V> {
    private static String MSG = "{0} locked at completion of {1} (statement = {2})";
    ISchedulingRule _rule = null;
    boolean _hasRule = true;
    boolean _isLockedBeforePause = false;

    public DatabaseQueryTask(String string, IRaptorTaskRunMode iRaptorTaskRunMode, boolean bl, boolean bl2) {
        this(string, iRaptorTaskRunMode, bl, bl2, true);
    }

    public DatabaseQueryTask(String string, IRaptorTaskRunMode iRaptorTaskRunMode, boolean bl, boolean bl2, boolean bl3) {
        super(string, bl3, iRaptorTaskRunMode);
        this.setMessage(MessageFormat.format(Messages.getString((String)"IRaptorTaskStatus.7"), this.getQuery()));
        this.setPausable(bl);
        this.setCancellable(bl2);
    }

    public ISchedulingRule getSchedulingRule() {
        if (this._hasRule) {
            if (this._rule == null) {
                this._rule = ConnectionMutexFactory.getRule((String)this.getConnectionName());
            }
            return this._rule;
        }
        return null;
    }

    public abstract String getConnectionName();

    public abstract String getQuery();

    protected void pause() {
        this.releaseSchedulingRule();
        super.pause();
        this.acquireSchedulingRule();
    }

    protected void releaseSchedulingRule() {
        this._hasRule = false;
        ReentrantLock reentrantLock = Connections.getInstance().getLock(this.getConnectionName());
        this._isLockedBeforePause = reentrantLock.isHeldByCurrentThread();
        if (this._isLockedBeforePause) {
            reentrantLock.unlock();
        }
    }

    protected void acquireSchedulingRule() {
        this._hasRule = true;
        ReentrantLock reentrantLock = Connections.getInstance().getLock(this.getConnectionName());
        if (!reentrantLock.isHeldByCurrentThread() && this._isLockedBeforePause) {
            reentrantLock.lock();
        }
    }

    protected void tearDown() {
        Connections connections = Connections.getInstance();
        String string = this.getConnectionName();
        Connection connection = null;
        if (string != null) {
            try {
                connection = connections.getConnection(string, false);
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        if (connection != null) {
            if (Debug.DEBUG && connections.checkLock(connection)) {
                Object[] objectArray = new Object[]{this.getConnectionName(), ((Object)((Object)this)).getClass().getName(), this.getQuery()};
                String string2 = MessageFormat.format(MSG, objectArray);
                Logger.severe(DatabaseQueryTask.class, (String)string2);
                MessageLogging.getInstance().reportAPIException(string2, (Throwable)new ExpiredConnectionLockException(), "Connections.unlock()");
            }
            while (connections.checkLock(connection)) {
                connections.unlock(connection);
            }
        }
    }

    private static class ExpiredConnectionLockException
    extends Exception {
        private ExpiredConnectionLockException() {
        }
    }
}

