/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.proformatter.treePreferences.treetable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.TreePath;
import oracle.dbtools.proformatter.treePreferences.treetable.CodingStyleTreeCategory;
import oracle.dbtools.proformatter.treePreferences.treetable.CodingStyleTreeItem;
import oracle.ide.controls.AbstractTreeTableModel;
import oracle.ide.controls.TreeTableModel;

public class CodingStyleTreeTableModel
extends AbstractTreeTableModel {
    protected List<ChangeListener> m_changeList;
    private JTree tree;

    public CodingStyleTreeTableModel(CodingStyleTreeCategory codingStyleTreeCategory) {
        super((Object)codingStyleTreeCategory);
        this.setRoot(codingStyleTreeCategory);
    }

    public void setRoot(CodingStyleTreeCategory codingStyleTreeCategory) {
        this.root = codingStyleTreeCategory;
    }

    public void setTree(JTree jTree) {
        this.tree = jTree;
    }

    public Object getValueAt(Object object, int n) {
        if (object instanceof CodingStyleTreeItem) {
            CodingStyleTreeItem codingStyleTreeItem = (CodingStyleTreeItem)object;
            return codingStyleTreeItem.getValue(n);
        }
        return null;
    }

    public String getColumnName(int n) {
        return "";
    }

    public int getColumnCount() {
        return 2;
    }

    public int getChildCount(Object object) {
        if (object instanceof CodingStyleTreeCategory) {
            CodingStyleTreeCategory codingStyleTreeCategory = (CodingStyleTreeCategory)object;
            return codingStyleTreeCategory.getChildCount();
        }
        return 0;
    }

    public Object getChild(Object object, int n) {
        if (object instanceof CodingStyleTreeCategory) {
            CodingStyleTreeCategory codingStyleTreeCategory = (CodingStyleTreeCategory)object;
            return codingStyleTreeCategory.getChild(n);
        }
        return null;
    }

    public Class<?> getColumnClass(int n) {
        return n == 0 ? TreeTableModel.class : String.class;
    }

    public boolean isCellEditable(Object object, int n) {
        if (n == 1 && object instanceof CodingStyleTreeItem) {
            return ((CodingStyleTreeItem)object).isValueEditable();
        }
        return true;
    }

    public void setValueAt(Object object, Object object2, int n) {
        if (object2 instanceof CodingStyleTreeItem) {
            CodingStyleTreeItem codingStyleTreeItem = (CodingStyleTreeItem)object2;
            Object object3 = codingStyleTreeItem.getValue();
            codingStyleTreeItem.setValue(object);
            if (!object3.equals(object)) {
                this.fireChangeEvent(object2);
            }
        }
    }

    public void itemsChanged(CodingStyleTreeCategory codingStyleTreeCategory, int[] nArray) {
        this.fireChangeEvent((Object)this);
        Object[] objectArray = new Object[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            objectArray[i] = codingStyleTreeCategory.getChild(nArray[i]);
        }
        Object[] objectArray2 = this.getPath(codingStyleTreeCategory);
        final TreePath[] treePathArray = this.tree.getSelectionPaths();
        this.fireTreeNodesChanged((Object)this, objectArray2, nArray, objectArray);
        if (treePathArray != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CodingStyleTreeTableModel.this.tree.setSelectionPaths(treePathArray);
                }
            });
        }
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        if (this.m_changeList == null) {
            this.m_changeList = new ArrayList<ChangeListener>();
            this.m_changeList.add(changeListener);
        }
    }

    public synchronized void removeListenerList(ChangeListener changeListener) {
        if (this.m_changeList != null) {
            this.m_changeList.remove(changeListener);
        }
    }

    protected void fireChangeEvent(Object object) {
        if (this.m_changeList != null) {
            for (ChangeListener changeListener : this.m_changeList) {
                changeListener.stateChanged(new ChangeEvent(object));
            }
        }
    }

    private Object[] getPath(CodingStyleTreeItem codingStyleTreeItem) {
        ArrayList<CodingStyleTreeItem> arrayList = new ArrayList<CodingStyleTreeItem>();
        arrayList.add(codingStyleTreeItem);
        for (CodingStyleTreeItem codingStyleTreeItem2 = codingStyleTreeItem.getParent(); codingStyleTreeItem2 != null; codingStyleTreeItem2 = codingStyleTreeItem2.getParent()) {
            arrayList.add(codingStyleTreeItem2);
        }
        Collections.reverse(arrayList);
        return arrayList.toArray();
    }
}

