/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.proformatter;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.proformatter.Messages;
import oracle.dbtools.proformatter.SQLFormatCommand;
import oracle.dbtools.proformatter.SQLFormatToPropertiesCommand;
import oracle.dbtools.proformatter.SQLFormatterArb;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.WaitCursor;
import oracle.ide.db.model.SqlNode;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.HelpSystem;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.model.Node;
import oracle.ide.view.View;
import oracle.javatools.editor.BasicEditorPane;

public class FormatterMenu
implements Controller,
ContextMenuListener {
    private static final String ACCELERATOR_FILE = "oracle/dbtools/proformatter/accelerators.xml";
    private static FormatterMenu _instance;
    public static String FORMAT_SQL;
    public static String FORMAT_SQL_POPUP;
    public static int FORMAT_ID;
    public static int FORMAT_POPUP_ID;
    private IdeAction actionFormat = null;
    private IdeAction actionFormatPopup = null;
    private static JMenu menuRefactor;

    public static FormatterMenu getInstance() {
        if (_instance == null) {
            _instance = new FormatterMenu();
        }
        return _instance;
    }

    public void initAction() {
        String string = FORMAT_SQL;
        String string2 = StringUtils.stripMnemonic((String)string);
        Integer n = StringUtils.getMnemonicKeyCode((String)string);
        if (this.actionFormat == null) {
            this.actionFormat = IdeAction.get((int)FORMAT_ID, null, (String)string2, null, (Integer)n, (Icon)SQLFormatterArb.getIcon("FORMAT_ICON"), null, (boolean)false);
            this.actionFormat.setEnabled(true);
        }
        string = FORMAT_SQL_POPUP;
        string2 = StringUtils.stripMnemonic((String)string);
        n = StringUtils.getMnemonicKeyCode((String)string);
        if (this.actionFormatPopup == null) {
            this.actionFormatPopup = IdeAction.get((int)FORMAT_POPUP_ID, null, (String)string2, null, (Integer)n, null, null, (boolean)false);
            this.actionFormatPopup.setEnabled(true);
        }
        this.actionFormat.addController((Controller)this);
        this.actionFormat.setEnabled(true);
        this.actionFormatPopup.addController((Controller)this);
        this.actionFormatPopup.setEnabled(true);
    }

    public static void init() {
        FormatterMenu.getInstance().initAction();
        EditorManager.getEditorManager().getContextMenu().addContextMenuListener((ContextMenuListener)FormatterMenu.getInstance());
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        keyStrokeContextRegistry.addAcceleratorDefinitionFile(FormatterMenu.getInstance().getClass().getClassLoader(), ACCELERATOR_FILE);
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        WaitCursor waitCursor = Ide.getWaitCursor();
        int n = ideAction.getCommandId();
        if (FORMAT_ID == n) {
            waitCursor.show();
            this.invoke(context, null);
            waitCursor.hide();
            return true;
        }
        if (FORMAT_POPUP_ID == n) {
            waitCursor.show();
            this.invoke(context, new String[]{Integer.valueOf(FORMAT_POPUP_ID).toString()});
            waitCursor.hide();
            return true;
        }
        return false;
    }

    public boolean invoke(Context context, String[] stringArray) {
        if (stringArray != null) {
            if (stringArray[0].equals(Integer.valueOf(FORMAT_POPUP_ID).toString())) {
                this.executeCommandPopup(context);
            }
        } else {
            this.executeCommand(context);
        }
        return true;
    }

    private boolean executeCommand(Context context) {
        SQLFormatCommand sQLFormatCommand = new SQLFormatCommand(context);
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        try {
            if (commandProcessor.invoke((Command)sQLFormatCommand) == 1) {
                return true;
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return true;
    }

    private boolean executeCommandPopup(Context context) {
        final Context context2 = context;
        final Boolean[] booleanArray = new Boolean[]{Boolean.FALSE};
        final JComboBox<String> jComboBox = new JComboBox<String>(new String[]{Messages.getString("EDITOR"), Messages.getString("CLIPBOARD")});
        final JComboBox<String> jComboBox2 = new JComboBox<String>(new String[]{Messages.getString("ConfigPanelData.3"), Messages.getString("ConfigPanelData.4"), Messages.getString("ConfigPanelData.5"), Messages.getString("ConfigPanelData.6"), Messages.getString("ConfigPanelData.7"), Messages.getString("ConfigPanelData.8"), Messages.getString("ConfigPanelData.9"), Messages.getString("ConfigPanelData.10"), Messages.getString("ConfigPanelData.11"), Messages.getString("ConfigPanelData.12"), Messages.getString("ConfigPanelData.13"), Messages.getString("ConfigPanelData.14"), Messages.getString("ConfigPanelData.15"), Messages.getString("ConfigPanelData.16"), Messages.getString("ConfigPanelData.17")});
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel(StringUtils.stripMnemonic((String)Messages.getString("OUTPUT_DESTINATION")));
        jLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("OUTPUT_DESTINATION")));
        jLabel.setLabelFor(jComboBox);
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        jPanel.add(jComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(10, 5, 0, 0), 0, 0));
        JLabel jLabel2 = new JLabel(StringUtils.stripMnemonic((String)Messages.getString("OUTPUT_TYPE")));
        jLabel2.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("OUTPUT_TYPE")));
        jLabel2.setLabelFor(jComboBox2);
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        jPanel.add(jComboBox2, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(10, 5, 0, 0), 0, 0));
        jPanel.setMinimumSize(new Dimension(400, 400));
        jPanel.add(Box.createVerticalGlue(), new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 17, 1, new Insets(10, 5, 0, 0), 0, 0));
        jPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(10, 5, 0, 0), 0, 0));
        HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_idedidesetsqlformat_html");
        UIUtils.showPanelAsDialog((JPanel)jPanel, (String)Messages.getString("FORMAT_PROPERTIES"), (ActionListener)new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((JEWTDialog)actionEvent.getSource()).closeDialog(true);
                SQLFormatToPropertiesCommand sQLFormatToPropertiesCommand = new SQLFormatToPropertiesCommand(context2, jComboBox.getSelectedIndex() == 0, jComboBox2.getSelectedIndex());
                CommandProcessor commandProcessor = CommandProcessor.getInstance();
                try {
                    if (commandProcessor.invoke((Command)sQLFormatToPropertiesCommand) == 1) {
                        booleanArray[0] = Boolean.TRUE;
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
            }
        });
        return booleanArray[0];
    }

    public boolean update(IdeAction ideAction, Context context) {
        return true;
    }

    public boolean handleDefaultAction(Context context) {
        return true;
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public void menuWillShow(ContextMenu contextMenu) {
        Context context;
        Context context2 = context = contextMenu == null ? null : contextMenu.getContext();
        if (context == null) {
            return;
        }
        if (FormatterMenu.isMenuAvailable(context)) {
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)this.actionFormat));
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)this.actionFormatPopup));
        }
    }

    private static boolean isMenuAvailable(Context context) {
        Node node = context.getNode();
        View view = context.getView();
        if (node instanceof PlSqlNode && "BLOCK".equals(((PlSqlNode)node).getObjectType())) {
            return false;
        }
        return node.getClass().getName().endsWith("PlSqlNode") || node.getClass().getName().endsWith("PlSqlBaseNode") || node.getClass().getName().endsWith("TriggerNode") || node.getClass().getName().endsWith("WorksheetNode") || node instanceof SqlNode || view instanceof BasicEditorPane;
    }

    static {
        FORMAT_SQL = SQLFormatterArb.getString("FORMAT_SQL");
        FORMAT_SQL_POPUP = SQLFormatterArb.getString("FORMAT_SQL_POPUP");
        FORMAT_ID = Ide.findOrCreateCmdID((String)"oracle.dbtools.proformatter.FormatterMenu.FORMAT_ID");
        FORMAT_POPUP_ID = Ide.findOrCreateCmdID((String)"oracle.dbtools.proformatter.FormatterMenu.FORMAT_POPUP_ID");
        menuRefactor = null;
    }
}

