/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql;

import java.awt.Component;
import java.awt.Point;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.plsql.IdentifiersDb;
import oracle.dbtools.parser.plsql.LazyNode;
import oracle.dbtools.parser.plsql.Messages;
import oracle.dbtools.parser.plsql.Query;
import oracle.dbtools.raptor.RaptorDBAddin;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.ViewerOpener;
import oracle.dbtools.raptor.editors.DbEditor;
import oracle.dbtools.raptor.navigator.impl.DatabaseNavigatorElementFactory;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.navigator.plsql.Member;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.plsql.BackgroundParser;
import oracle.dbtools.raptor.plsql.EquippedWithParser;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.TNSHelper;
import oracle.dbtools.util.Service;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.AbstractBrowseClickPlugin;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.find.FindableEditor;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.model.Node;
import oracle.ide.view.View;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.language.NumberRange;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.Pair;

public final class IdentifierDefinitionLookup
extends AbstractBrowseClickPlugin
implements Controller {
    private static final Logger LOGGER = Logger.getLogger(IdentifierDefinitionLookup.class.getName());
    public static final int DEF_LOOKUP_ID = Ide.findOrCreateCmdID((String)"oracle.dbtools.parser.plsql.IdentifierDefinitionLookup.DEF_LOOKUP_ID");
    private static final String ACCELERATOR_FILE = "oracle/dbtools/parser/plsql/accelerators.xml";
    private LazyNode m_output;
    private List<LexerToken> m_src;
    BasicEditorPane m_pane;
    String m_connName;
    private String m_schema;
    private static IdentifierDefinitionLookup instance = null;
    private ParseNode m_id;
    private ParseNode m_def;
    private Action m_action;
    Context ctx;
    private static ViewerOpener viewerOpener;

    private String getConnectionName(Context context) {
        String string = null;
        Node node = context.getNode();
        View view = context.getView();
        if (node instanceof PlSqlNode) {
            PlSqlNode plSqlNode = (PlSqlNode)node;
            string = plSqlNode.getConnectionName() != null ? plSqlNode.getConnectionName() : DBURLFormatHelper.getConnectionName(plSqlNode.getURL());
        } else if (view instanceof FindableEditor) {
            string = view instanceof DbEditor ? ((DbEditor)view).getConnectionName() : (String)context.getProperty("Connections.db_name");
        }
        return string;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == DEF_LOOKUP_ID) {
            Node node = context.getNode();
            View view = context.getView();
            this.m_connName = this.getConnectionName(context);
            if (node instanceof PlSqlNode) {
                PlSqlNode plSqlNode = (PlSqlNode)node;
                this.m_schema = (String)plSqlNode.getProperty("SCHEMA");
                this.m_pane = ((FindableEditor)view).getFocusedEditorPane();
                this.m_src = plSqlNode.getParser().src;
                this.m_output = plSqlNode.getParser().output;
                this.finishIdLookup(plSqlNode);
            } else if (view instanceof FindableEditor && view instanceof EquippedWithParser && view instanceof DbEditor) {
                this.m_pane = ((FindableEditor)view).getFocusedEditorPane();
                BackgroundParser backgroundParser = ((EquippedWithParser)view).getParser();
                this.m_src = backgroundParser.src;
                this.m_output = backgroundParser.output;
                this.finishIdLookup(null);
            }
            return true;
        }
        return false;
    }

    void finishIdLookup(PlSqlNode plSqlNode) {
        int n = this.m_pane.getCaretPosition();
        LOGGER.info(Messages.getString("IdentifierDefinitionLookup.3") + n);
        this.parseIdentifierAtOffset(n, this.m_output, this.m_src, this.m_connName, this.m_pane, plSqlNode);
        if (this.m_action != null) {
            this.m_action.schema = this.m_schema;
            this.m_action.eval();
        }
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == DEF_LOOKUP_ID) {
            ideAction.setEnabled(this.isAvailable(context));
            return true;
        }
        return false;
    }

    private boolean isAvailable(Context context) {
        BackgroundParser backgroundParser;
        PlSqlNode plSqlNode;
        this.m_connName = this.getConnectionName(context);
        if (this.m_connName == null) {
            return false;
        }
        if (Connections.getInstance() == null || Connections.getInstance().getLock(this.m_connName) == null || Connections.getInstance().getLock(this.m_connName).isLocked()) {
            return false;
        }
        Node node = context.getNode();
        View view = context.getView();
        return node instanceof PlSqlNode ? (plSqlNode = (PlSqlNode)node).getParser() != null && plSqlNode.getParser().output != null : view instanceof FindableEditor && view instanceof EquippedWithParser && view instanceof DbEditor && (backgroundParser = ((EquippedWithParser)view).getParser()) != null && backgroundParser.output != null;
    }

    public static void init() {
        if (instance == null) {
            instance = new IdentifierDefinitionLookup(null);
        }
        IdeAction ideAction = IdeAction.get((int)DEF_LOOKUP_ID, null, (String)Messages.getString("IdentifierDefinitionLookup.4"), null, null, null, null, null, (boolean)true);
        ideAction.addController((Controller)instance);
        JMenuItem jMenuItem = Ide.getMenubar().createMenuItem((ToggleAction)ideAction);
        CtxMenuListener ctxMenuListener = new CtxMenuListener(jMenuItem);
        EditorManager.getEditorManager().getContextMenu().addContextMenuListener((ContextMenuListener)ctxMenuListener);
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        keyStrokeContextRegistry.addAcceleratorDefinitionFile(((Object)((Object)instance)).getClass().getClassLoader(), ACCELERATOR_FILE);
    }

    private static boolean isMenuAvailable(Context context) {
        Node node = context.getNode();
        View view = context.getView();
        return node instanceof PlSqlNode || view instanceof FindableEditor && view instanceof EquippedWithParser && view instanceof DbEditor;
    }

    protected void parseIdentifierAtOffset(int n, LazyNode lazyNode, List<LexerToken> list, String string, BasicEditorPane basicEditorPane, PlSqlNode plSqlNode) {
        Object object;
        Object object22;
        this.m_action = null;
        LOGGER.info("Source offset:" + n);
        int n2 = -1;
        for (Object object22 : list) {
            ++n2;
            if (object22.begin > n || n > object22.end) continue;
            if (object22.type == Token.IDENTIFIER && object22.content.startsWith("@")) {
                String string2 = object22.content.substring(1);
                if (string2.charAt(0) == '\"') {
                    string2 = string2.substring(1, string2.length() - 1);
                }
                this.m_action = new Action.SCRIPT(string2, string);
                this.m_id = new ParseNode(n2, n2 + 1, -1, -1, null);
                return;
            }
            if (object22.type != Token.IDENTIFIER && object22.type != Token.DQUOTED_STRING) continue;
            this.m_id = new ParseNode(n2, n2 + 1, -1, -1, null);
            break;
        }
        if (this.m_id == null) {
            return;
        }
        LOGGER.info("Identifier: [" + this.m_id.from + "," + this.m_id.to + ")");
        this.m_def = this.getIdentifierDefinition(this.m_id.content(list), this.m_id.from, (ParseNode)lazyNode, list);
        if (this.m_def != null && this.m_def.from <= this.m_id.from && this.m_id.to <= this.m_def.to && (this.m_def.contains(IdentifiersDb.instance.table_reference) || this.m_def.contains(IdentifiersDb.instance.aliased_dml_table_expression_clause))) {
            this.m_action = new Action.TABLE(list, this.m_id, string);
            return;
        }
        if (this.m_def != null) {
            LOGGER.info(MessageFormat.format(Messages.getString("IdentifierDefinitionLookup.10"), this.m_def.from, this.m_def.to));
            this.m_action = new Action.LOCAL(list, this.m_def, basicEditorPane);
            return;
        }
        if (plSqlNode != null) {
            object = plSqlNode.getMember(this.m_id.content(list));
            if (object != null) {
                if (!plSqlNode.isBody()) {
                    object22 = plSqlNode.getURL();
                    String string3 = DBURLFormatHelper.getBaseType((URL)object22) + " BODY";
                    URL uRL = DBURLFormatHelper.getURL(DBURLFormatHelper.getURL("sqldev.nav", DBURLFormatHelper.getConnectionName((URL)object22), "", DBURLFormatHelper.getSchema((URL)object22), string3), DBURLFormatHelper.getName((URL)object22));
                    PlSqlNode plSqlNode2 = (PlSqlNode)DatabaseNavigatorElementFactory.getObjectNode(uRL);
                    if (plSqlNode2 != null) {
                        plSqlNode2.initMembers();
                        Member member = plSqlNode2.getMember(this.m_id.content(list));
                        if (member != null) {
                            LOGGER.info("Found member:" + member.name);
                            this.m_action = new Action.MEMBER(member, plSqlNode2);
                            return;
                        }
                    }
                }
                LOGGER.info("Found member:" + ((Member)object).name);
                this.m_action = new Action.MEMBER((Member)object, basicEditorPane);
                return;
            }
            if (plSqlNode.isBody()) {
                object22 = plSqlNode.getURL();
                String string4 = DBURLFormatHelper.getBaseType((URL)object22);
                Object object3 = DBURLFormatHelper.getURL(DBURLFormatHelper.getURL("sqldev.nav", DBURLFormatHelper.getConnectionName((URL)object22), "", DBURLFormatHelper.getSchema((URL)object22), string4.substring(0, string4.indexOf(32))), DBURLFormatHelper.getName((URL)object22));
                PlSqlNode plSqlNode3 = (PlSqlNode)DatabaseNavigatorElementFactory.getObjectNode((URL)object3);
                object = plSqlNode3.getMember(this.m_id.content(list));
                if (object != null) {
                    LOGGER.info("Found member:" + ((Member)object).name);
                    this.m_action = new Action.MEMBER((Member)object, plSqlNode3);
                    return;
                }
            }
        }
        object = lazyNode.parent(this.m_id.from, this.m_id.to);
        object22 = this.m_id;
        if (object == null) {
            System.err.println("parseIdentifierAtOffset: parent == null output=" + lazyNode.toString() + "m_id=" + this.m_id.toString());
            return;
        }
        for (Object object3 : object.children()) {
            if (object3.from != this.m_id.from || object3.to != this.m_id.to) continue;
            object22 = object3;
        }
        if (object != null && (object.contains(IdentifiersDb.instance.procedure_call) || object.contains(IdentifiersDb.instance.name_wo_function_call))) {
            this.m_action = new Action.PLSQL(list, (ParseNode)object, string, n, (ParseNode)lazyNode, basicEditorPane);
            this.m_id = object;
            return;
        }
        if (object22.contains(IdentifiersDb.instance.procedure_call) || object22.contains(IdentifiersDb.instance.expr) || object22.contains(IdentifiersDb.instance.unconstrained_type)) {
            this.m_action = new Action.PLSQL(list, (ParseNode)object22, string, n, (ParseNode)lazyNode, basicEditorPane);
            this.m_id = object22;
            return;
        }
        if (object != null && object.contains(IdentifiersDb.instance.adt_field) || object != null && object.contains(IdentifiersDb.instance.object_d)) {
            this.m_action = new Action.TYPE(list, (ParseNode)object, string);
            return;
        }
    }

    private static void goToTable(String string, String string2, String string3, String string4) {
        Query query = new Query(string, string4){

            @Override
            public int limit() {
                return 2;
            }
        };
        query.prepareObject(string2, "TABLE", string3);
        query.prepareObject(string2, "VIEW", string3);
        URL uRL = query.fetch();
        IdentifierDefinitionLookup.goTo(uRL, true);
    }

    private static void goToPlSql(String string, String string2, String string3, List<LexerToken> list, String string4) {
        Object object;
        Query query = new Query(string, string4){

            @Override
            public int limit() {
                return 10;
            }
        };
        if (string2 == null) {
            query.prepareAllObjects(string3, "FUNCTION");
            query.prepareAllObjects(string3, "PROCEDURE");
            object = IdentifierDefinitionLookup.getPkgName(list);
            if (object != null) {
                query.prepareAllSource(string4, (String)object, string3);
            } else {
                query.prepareAllObjects(string3, "PACKAGE");
            }
        } else {
            query.prepareProcedure(string2, string3);
            query.prepareAllSource(string2, string3);
        }
        object = query.fetch();
        IdentifierDefinitionLookup.goTo((URL)object, true);
    }

    private static void goToType(String string, String string2, String string3, String string4) {
        Query query = new Query(string, string4){

            @Override
            public int limit() {
                return 2;
            }
        };
        query.prepareObject(string2, "TYPE", string3);
        URL uRL = query.fetch();
        IdentifierDefinitionLookup.goTo(uRL, true);
    }

    private static void goToScript(String string, String string2) {
        Object object;
        String string3 = File.separator;
        if ((string2 = string2.replaceFirst("@", "").trim()).startsWith("?")) {
            object = TNSHelper.getOracleHome();
            string2 = (String)(object == null ? "" : object) + string2.substring(1);
        } else if (!string2.startsWith(File.separator) && !string2.contains(":")) {
            object = DBConfig.getInstance().getScriptDirectory().getFile();
            string2 = (String)object + File.separator + string2;
        }
        object = new File(string2);
        if (((File)object).exists() && ((File)object).canRead()) {
            try {
                URL uRL = ((File)object).toURI().toURL();
                RaptorDBAddin.getSqlOpener().openNewEditor(uRL, string);
            }
            catch (MalformedURLException malformedURLException) {
                System.err.println("goToScript() MalformedURLException: " + string2);
            }
        } else {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)"File does not exist or cannot be located. ", (String)"File Not Found", (String)"f1_ctrlclick_file_html");
        }
    }

    private static String getPkgName(List<LexerToken> list) {
        String string = null;
        boolean bl = false;
        boolean bl2 = false;
        int n = -1;
        for (LexerToken lexerToken : list) {
            if (++n > 10) break;
            if (bl2) {
                string = lexerToken.content;
            }
            bl2 = bl && "BODY".equalsIgnoreCase(lexerToken.content);
            if ("PACKAGE".equalsIgnoreCase(lexerToken.content)) {
                bl = true;
                continue;
            }
            bl = false;
        }
        return string;
    }

    public ParseNode getIdentifierDefinition(String string, int n, ParseNode parseNode, List<LexerToken> list) {
        Map<ParseNode, Pair<Integer, Integer>> map = null;
        map = parseNode instanceof LazyNode ? IdentifiersDb.collectIdentifiers(n, n + 1, (LazyNode)parseNode) : IdentifiersDb.instance.collectIdentifiers(parseNode);
        return IdentifiersDb.getIdentifierDefinition(string, n, list, map);
    }

    public IdentifierDefinitionLookup() {
        this(null);
    }

    public IdentifierDefinitionLookup(Context context) {
        this.ctx = context;
    }

    protected NumberRange getIdentifierAtOffset(int n) {
        if (this.ctx == null) {
            return null;
        }
        Node node = this.ctx.getNode();
        View view = this.ctx.getView();
        if (node instanceof PlSqlNode) {
            PlSqlNode plSqlNode = (PlSqlNode)node;
            this.m_pane = ((FindableEditor)view).getFocusedEditorPane();
            this.m_schema = (String)plSqlNode.getProperty("SCHEMA");
            this.m_connName = plSqlNode.getConnectionName() != null ? plSqlNode.getConnectionName() : DBURLFormatHelper.getConnectionName(plSqlNode.getURL());
            this.m_src = plSqlNode.getParser().src;
            this.m_output = plSqlNode.getParser().output;
            return this.finishIdSelection(n, plSqlNode);
        }
        if (view instanceof FindableEditor && view instanceof EquippedWithParser && view instanceof DbEditor) {
            this.m_pane = ((FindableEditor)view).getFocusedEditorPane();
            this.m_connName = ((DbEditor)view).getConnectionName();
            BackgroundParser backgroundParser = ((EquippedWithParser)view).getParser();
            this.m_src = backgroundParser.src;
            this.m_output = backgroundParser.output;
            return this.finishIdSelection(n, null);
        }
        return null;
    }

    private NumberRange finishIdSelection(int n, PlSqlNode plSqlNode) {
        this.parseIdentifierAtOffset(n, this.m_output, this.m_src, this.m_connName, this.m_pane, plSqlNode);
        if (this.m_action != null) {
            return new NumberRange(this.m_src.get((int)this.m_id.from).begin, this.m_src.get((int)(this.m_id.to - 1)).end);
        }
        return null;
    }

    protected void performDeclarationClick(Point point) {
        if (this.m_action != null) {
            this.m_action.schema = this.m_schema;
            this.m_action.eval();
        }
    }

    public static boolean goTo(URL uRL, boolean bl) {
        if (uRL == null) {
            return false;
        }
        String string = null;
        if (bl) {
            string = Service.from2chars((String)DBURLFormatHelper.getCatalog(uRL));
        }
        if (string != null) {
            int n = string.indexOf(44);
            int n2 = Integer.parseInt(string.substring(0, n));
            int n3 = Service.X((int)n2);
            int n4 = Service.Y((int)n2);
            URL uRL2 = DBURLFormatHelper.getURL(DBURLFormatHelper.getURL("sqldev.nav", DBURLFormatHelper.getConnectionName(uRL), "", DBURLFormatHelper.getSchema(uRL), DBURLFormatHelper.getBaseType(uRL)), DBURLFormatHelper.getName(uRL));
            return viewerOpener.waitOnOpen(uRL2, n3, n4);
        }
        String string2 = DBURLFormatHelper.getName(uRL);
        boolean bl2 = viewerOpener.waitOnOpen(uRL, 0, 0);
        if (!bl2 && ModelUtil.hasLength((String)string2) && string2.indexOf(46) >= 0) {
            string2 = string2.substring(0, string2.indexOf(46));
            uRL = DBURLFormatHelper.getURL(DBURLFormatHelper.getURL("sqldev.nav", DBURLFormatHelper.getConnectionName(uRL), "", DBURLFormatHelper.getSchema(uRL), DBURLFormatHelper.getBaseType(uRL)), string2);
            return viewerOpener.waitOnOpen(uRL, 0, 0);
        }
        return bl2;
    }

    public static void registerViewerOpener(ViewerOpener viewerOpener) {
        IdentifierDefinitionLookup.viewerOpener = viewerOpener;
    }

    static abstract class Action {
        String schema = null;

        Action() {
        }

        abstract void eval();

        static class SCRIPT
        extends Action {
            String fileName;
            String connName;

            SCRIPT(String string, String string2) {
                this.fileName = string;
                this.connName = string2;
            }

            @Override
            void eval() {
                IdentifierDefinitionLookup.goToScript(this.connName, this.fileName);
            }
        }

        static class TYPE
        extends Action {
            List<LexerToken> src;
            ParseNode id;
            String connName;

            TYPE(List<LexerToken> list, ParseNode parseNode, String string) {
                this.src = list;
                this.id = parseNode;
                this.connName = string;
            }

            @Override
            void eval() {
                String string = null;
                if (this.id.from + 3 == this.id.to) {
                    string = this.src.get((int)this.id.from).content;
                }
                IdentifierDefinitionLookup.goToType(this.connName, this.src.get((int)(this.id.to - 1)).content, string, this.schema);
            }
        }

        static class PLSQL
        extends Action {
            List<LexerToken> src;
            ParseNode id;
            ParseNode output;
            String connName;
            int scannerPos;
            BasicEditorPane panel;

            PLSQL(List<LexerToken> list, ParseNode parseNode, String string, int n, ParseNode parseNode2, BasicEditorPane basicEditorPane) {
                this.src = list;
                this.id = parseNode;
                this.connName = string;
                this.scannerPos = n;
                this.output = parseNode2;
                this.panel = basicEditorPane;
            }

            @Override
            void eval() {
                String string = null;
                String string2 = this.src.get((int)this.id.from).content;
                if (this.src.size() > this.id.from + 2 && ".".equals(this.src.get((int)(this.id.from + 1)).content)) {
                    string = this.src.get((int)this.id.from).content;
                    string2 = this.src.get((int)(this.id.from + 2)).content;
                }
                if (string == null || string.equalsIgnoreCase(IdentifierDefinitionLookup.getPkgName(this.src))) {
                    block0: for (ParseNode parseNode : this.output.children()) {
                        int n = -1;
                        block1: for (ParseNode parseNode2 : parseNode.children()) {
                            if (++n > 0) continue block0;
                            int n2 = -1;
                            for (ParseNode parseNode3 : parseNode2.children()) {
                                if (++n2 == 0) continue;
                                if (n2 > 1) continue block1;
                                LexerToken lexerToken = this.src.get(parseNode3.from);
                                if (!string2.equalsIgnoreCase(lexerToken.content)) continue;
                                this.panel.setSelectionStart(lexerToken.begin);
                                this.panel.setSelectionEnd(lexerToken.end);
                                return;
                            }
                        }
                    }
                }
                IdentifierDefinitionLookup.goToPlSql(this.connName, string, string2, this.src, this.schema);
            }
        }

        static class MEMBER
        extends Action {
            Member member;
            BasicEditorPane panel = null;
            PlSqlNode node = null;

            MEMBER(Member member, BasicEditorPane basicEditorPane) {
                this.member = member;
                this.panel = basicEditorPane;
            }

            MEMBER(Member member, PlSqlNode plSqlNode) {
                this.member = member;
                this.node = plSqlNode;
            }

            @Override
            void eval() {
                if (this.panel != null) {
                    this.panel.setSelectionStart(this.member.codeOffset);
                    this.panel.setSelectionEnd(this.member.codeOffset + this.member.name.length());
                } else {
                    Object object2;
                    EditorManager editorManager = EditorManager.getEditorManager();
                    Context context = null;
                    for (Object object2 : editorManager.getAllEditors()) {
                        Context context2 = ((Editor)object2).getContext();
                        Node node = context2 != null ? context2.getNode() : null;
                        if (node != this.node) continue;
                        context = context2;
                    }
                    if (context == null) {
                        context = Context.newIdeContext((Node)this.node);
                    }
                    OpenEditorOptions openEditorOptions = new OpenEditorOptions(context, CodeEditor.class);
                    object2 = (CodeEditor)editorManager.openEditor(openEditorOptions);
                    object2.setCaretPosition(this.member.codeOffset);
                }
            }
        }

        static class LOCAL
        extends Action {
            List<LexerToken> src;
            ParseNode def;
            BasicEditorPane panel;

            LOCAL(List<LexerToken> list, ParseNode parseNode, BasicEditorPane basicEditorPane) {
                this.src = list;
                this.def = parseNode;
                this.panel = basicEditorPane;
            }

            @Override
            void eval() {
                NumberRange numberRange = new NumberRange(this.src.get((int)this.def.from).begin, this.src.get((int)this.def.from).end);
                this.panel.setSelectionStart(numberRange.start);
                this.panel.setSelectionEnd(numberRange.end);
            }
        }

        static class TABLE
        extends Action {
            List<LexerToken> src;
            ParseNode id;
            String connName;

            TABLE(List<LexerToken> list, ParseNode parseNode, String string) {
                this.src = list;
                this.id = parseNode;
                this.connName = string;
            }

            @Override
            void eval() {
                String string = null;
                if (this.id.from + 3 == this.id.to) {
                    string = this.src.get((int)this.id.from).content;
                }
                IdentifierDefinitionLookup.goToTable(this.connName, this.src.get((int)(this.id.to - 1)).content, string, this.schema);
            }
        }
    }

    private static final class CtxMenuListener
    implements ContextMenuListener {
        private JMenuItem mi;

        CtxMenuListener(JMenuItem jMenuItem) {
            this.mi = jMenuItem;
        }

        public void menuWillHide(ContextMenu contextMenu) {
        }

        public boolean handleDefaultAction(Context context) {
            return false;
        }

        public void menuWillShow(ContextMenu contextMenu) {
            Context context;
            Context context2 = context = contextMenu == null ? null : contextMenu.getContext();
            if (context == null) {
                return;
            }
            if (IdentifierDefinitionLookup.isMenuAvailable(context)) {
                contextMenu.add((Component)this.mi);
            }
        }
    }
}

