/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.queryBuilder;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.bali.dbUI.columnPropertyEditor.ColumnPropertyEditor;
import oracle.bali.dbUI.constraint.DataConstraint;
import oracle.bali.dbUI.constraintBuilder.ConstraintBuilder;
import oracle.bali.dbUI.db.Column;
import oracle.bali.dbUI.db.DataDescriptor;
import oracle.bali.dbUI.db.DataDescriptorProvider;
import oracle.bali.dbUI.db.Database;
import oracle.bali.dbUI.db.DynamicRelationship;
import oracle.bali.dbUI.db.OuterJoin;
import oracle.bali.dbUI.db.Relationship;
import oracle.bali.dbUI.db.Schema;
import oracle.bali.dbUI.db.Table;
import oracle.bali.dbUI.dnd.DBUIDataFlavors;
import oracle.bali.dbUI.laf.DBUILookAndFeel;
import oracle.bali.dbUI.resultsTable.ModelFactory;
import oracle.bali.dbUI.resultsTable.ResultsTable;
import oracle.bali.dbUI.schemaViewer.SchemaViewer;
import oracle.bali.dbUI.schemaViewer.SchemaViewerEvent;
import oracle.bali.dbUI.schemaViewer.SchemaViewerListener;
import oracle.bali.dbUI.util.jdbc.JDBCSchema;
import oracle.bali.dbUI.util.jdbc.JDBCTable;
import oracle.bali.dbUI.viewBuilder.VBOuterJoinListener;
import oracle.bali.dbUI.viewBuilder.VBRelationshipListener;
import oracle.bali.dbUI.viewBuilder.ViewBuilder;
import oracle.bali.dbUI.viewBuilder.ViewBuilderEvent;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.event.Cancelable;
import oracle.bali.ewt.text.WrappedText;
import oracle.bali.ewt.util.LocaleUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.share.util.IntegerUtils;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.CommonArb;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.controls.display.DisplayPanel;
import oracle.dbtools.raptor.models.SQLComboxModel;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.queryBuilder.QBConstraintBuilder;
import oracle.dbtools.raptor.queryBuilder.QBTable;
import oracle.dbtools.raptor.queryBuilder.QueryBuilderDatabase;
import oracle.dbtools.raptor.queryBuilder.SQLGenerator;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;

public class CustomizedQueryBuilder
extends LWComponent
implements Accessible {
    public static final String PROPERTY_SELECTED_COMPONENT = "selectedComponent";
    private DisplayPanel _panel;
    private QueryBuilderDatabase _db;
    private DefaultListModel _fullTableListModel;
    private JTextField _search;
    private JComboBox _schema;
    private String _schemaName;
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private static final int _INDEX_VIEW_BUILDER = 0;
    private static final int _INDEX_CONSTRAINT_BUILDER = 1;
    private static final int _INDEX_SQL = 2;
    private static final int _INDEX_RESULTS = 3;
    private static final String _KEY_VIEWBUILDER = "VIEWBUILDER";
    private static final String _KEY_CONSTRAINTBUILDER = "CONSTRAINTBUILDER";
    private static final String _KEY_SQL = "SQL";
    private static final String _KEY_RESULTS = "RESULTS";
    private static final String _KEY_SCHEMA_VIEWER_NAME = "SCHEMA_VIEWER_NAME";
    private ViewBuilder _viewBuilder;
    private boolean _viewBuilderDirty;
    private ConstraintBuilder _constraintBuilder;
    private boolean _constraintBuilderDirty;
    private DDProvider _dataDescriptorProvider;
    private JScrollPane _sqlScrollBox;
    private JTextArea _codeEditor;
    private SQLGenerator _generator;
    private boolean _sqlDirty;
    private String _lastSQL;
    private boolean _resultsDirty;
    private boolean _needToUpdateResults;
    private JTabbedPane _tabPanel;
    private int _lastIndex = -1;
    private JPanel _tablePane;
    private JList _tableList;
    private JSplitPane _splitter;

    public CustomizedQueryBuilder() {
        this(null);
    }

    public CustomizedQueryBuilder(QueryBuilderDatabase queryBuilderDatabase) {
        this(queryBuilderDatabase, null);
    }

    public CustomizedQueryBuilder(QueryBuilderDatabase queryBuilderDatabase, ModelFactory modelFactory) {
        UIListener uIListener = new UIListener();
        this._db = queryBuilderDatabase;
        this._tableList = new JList();
        this._fullTableListModel = new DefaultListModel();
        this._tableList.setModel(this._fullTableListModel);
        this._tablePane = new JPanel();
        JScrollPane jScrollPane = new JScrollPane(this._tableList);
        this._tablePane.setLayout(new GridBagLayout());
        this._search = new JTextField();
        this._search.setEditable(true);
        this._search.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                CustomizedQueryBuilder.this.filterSearch();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                CustomizedQueryBuilder.this.filterSearch();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                CustomizedQueryBuilder.this.filterSearch();
            }
        });
        this._schemaName = null;
        try {
            this._schemaName = queryBuilderDatabase.getConnection().getMetaData().getUserName();
        }
        catch (SQLException sQLException) {
            this.logger.severe("Could not get username:" + sQLException.getMessage());
        }
        SQLComboxModel sQLComboxModel = new SQLComboxModel(queryBuilderDatabase.getConnection(), "select username from sys.all_users order by username", null, this._schemaName);
        sQLComboxModel.setDelayed(true);
        this._schema = new JComboBox(sQLComboxModel);
        this._schema.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                Object object = popupMenuEvent.getSource();
                if (object instanceof JComboBox && ((JComboBox)object).getModel() instanceof SQLComboxModel) {
                    ((SQLComboxModel)((JComboBox)object).getModel()).load();
                }
            }
        });
        this._schema.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    CustomizedQueryBuilder.this.loadListOfTables();
                    CustomizedQueryBuilder.this.filterSearch();
                }
            }
        });
        this._tablePane.add((Component)this._schema, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(2, 1, 0, 0), 0, 0));
        this._tablePane.add((Component)this._search, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(2, 1, 0, 0), 0, 0));
        this._tablePane.add((Component)jScrollPane, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 1, new Insets(2, 1, 0, 0), 0, 0));
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this._tableList, 1, new DragGestureListener(){

            @Override
            public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
                final Object e = CustomizedQueryBuilder.this._tableList.getSelectedValue();
                Transferable transferable = new Transferable(){
                    private DataFlavor[] flavs = new DataFlavor[]{DBUIDataFlavors.TABLE_FLAVOR};

                    @Override
                    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
                        return dataFlavor == DBUIDataFlavors.TABLE_FLAVOR ? e : null;
                    }

                    @Override
                    public DataFlavor[] getTransferDataFlavors() {
                        return this.flavs;
                    }

                    @Override
                    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
                        return dataFlavor == DBUIDataFlavors.TABLE_FLAVOR;
                    }
                };
                dragGestureEvent.startDrag(Cursor.getPredefinedCursor(13), transferable, new DragSourceAdapter(){});
            }
        });
        this._tableList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (component instanceof JLabel) {
                    ((JLabel)component).setText(object.toString());
                }
                return component;
            }
        });
        this._viewBuilder = this.createViewBuilder();
        this._viewBuilder.addPropertyChangeListener((PropertyChangeListener)uIListener);
        this._viewBuilder.addOuterJoinListener((VBOuterJoinListener)uIListener);
        this._viewBuilder.addRelationshipListener((VBRelationshipListener)uIListener);
        this._viewBuilder.setTableAliasAllowed(true);
        this._viewBuilder.setLinkDeletionAllowed(true);
        this._viewBuilder.add((Component)new JLabel(CommonArb.getString("QB_CANVAS_TIP")), (Object)"South");
        this._constraintBuilder = this.createConstraintBuilder();
        this._constraintBuilder.addPropertyChangeListener((PropertyChangeListener)uIListener);
        this._dataDescriptorProvider = new DDProvider();
        this._codeEditor = new JTextArea();
        this._codeEditor.getDocument().addDocumentListener(uIListener);
        this._codeEditor.setEditable(false);
        this._codeEditor.setLineWrap(true);
        this._codeEditor.setWrapStyleWord(true);
        this._sqlScrollBox = new JScrollPane(this._codeEditor);
        this._tabPanel = new JTabbedPane();
        this._tabPanel.addChangeListener(uIListener);
        this._tabPanel.add((Component)this._viewBuilder);
        this._tabPanel.add((Component)this._constraintBuilder);
        this._tabPanel.add(this._sqlScrollBox);
        DisplayModel displayModel = new DisplayModel();
        ArrayList<Query> arrayList = new ArrayList<Query>();
        arrayList.add(new Query());
        ((Query)arrayList.get(0)).setSql("");
        displayModel.setQueries(arrayList);
        displayModel.setConnName(this._db.getConnectionName());
        displayModel.setConnection(this._db.getConnection());
        this._panel = new DisplayPanel(displayModel, null, null);
        this._panel.getMainUI().setConn(this._db.getConnection());
        this._panel.getMainUI().setConnName(this._db.getConnectionName());
        this._panel.revalidate();
        this._tabPanel.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                CustomizedQueryBuilder.this._panel.getMainUI().getQuery().setSql(CustomizedQueryBuilder.this.getSQLString());
            }
        });
        this._tabPanel.add(this._panel);
        this._splitter = new JSplitPane();
        this._splitter.setLeftComponent(this._tablePane);
        this._splitter.setRightComponent(this._tabPanel);
        this._splitter.setContinuousLayout(false);
        this.setLayout(new BorderLayout());
        this.add("Center", this._splitter);
        this.setDatabase(queryBuilderDatabase);
        this.loadListOfTables();
    }

    public void filterSearch() {
        if (this._search.getText() == "") {
            this._tableList.setModel(this._fullTableListModel);
        } else if (this._tableList.getModel() == this._fullTableListModel) {
            this._tableList.setModel(new DefaultListModel());
        }
        String string = this._search.getText();
        if (this._tableList.getModel() != this._fullTableListModel) {
            DefaultListModel defaultListModel = (DefaultListModel)this._tableList.getModel();
            defaultListModel.clear();
            for (Object object : this._fullTableListModel.toArray()) {
                QBTable qBTable = (QBTable)((Object)object);
                if (!qBTable.getName().toUpperCase().startsWith(string.toUpperCase())) continue;
                defaultListModel.addElement(qBTable);
            }
        }
    }

    public void setDatabase(QueryBuilderDatabase queryBuilderDatabase) {
        this._db = queryBuilderDatabase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadListOfTables() {
        block16: {
            DefaultListModel defaultListModel = this._fullTableListModel;
            ResultSetWrapper resultSetWrapper = null;
            JDBCTable jDBCTable = null;
            defaultListModel.clear();
            this._search.setText("");
            try {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("OWNER", this._schema.getSelectedItem());
                Connection connection = this._db.getConnection();
                if (!Connections.getInstance().lock(connection)) break block16;
                try {
                    resultSetWrapper = DBUtil.getInstance((Connection)connection).executeQuery("select object_name from sys.all_objects where owner = :OWNER and object_type in ('TABLE','VIEW') and object_name not like 'BIN$%' and object_name not like 'DR$%' and object_name not like 'MLOG$%' order by object_name ", hashMap);
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    JDBCSchema jDBCSchema = new JDBCSchema(connection, (Database)this._db, (String)this._schema.getSelectedItem());
                    while (resultSet.next()) {
                        jDBCTable = new JDBCTable(connection, (Schema)jDBCSchema, resultSet.getString(1));
                        defaultListModel.addElement(new QBTable(jDBCTable));
                    }
                }
                finally {
                    Connections.getInstance().unlock(connection);
                }
            }
            catch (SQLException sQLException) {
                ExceptionHandler.handleException((Throwable)sQLException);
            }
            finally {
                try {
                    if (resultSetWrapper != null) {
                        resultSetWrapper.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        this._needToUpdateResults = true;
    }

    public Database getDatabase() {
        return this._db;
    }

    public ViewBuilder getViewBuilder() {
        return this._viewBuilder;
    }

    public ConstraintBuilder getConstraintBuilder() {
        return this._constraintBuilder;
    }

    public Component getSelectedComponent() {
        return this._tabPanel.getSelectedComponent();
    }

    public void setSelectedComponent(Component component) {
        if (component == this._viewBuilder) {
            this._tabPanel.setSelectedIndex(0);
        } else if (component == this._constraintBuilder) {
            this._tabPanel.setSelectedIndex(1);
        } else if (component == this._sqlScrollBox) {
            this._tabPanel.setSelectedIndex(2);
        }
    }

    public void setSQLGenerator(SQLGenerator sQLGenerator) {
        if (sQLGenerator != this._generator) {
            this._generator = sQLGenerator;
            if (this.getSelectedComponent() == this._sqlScrollBox) {
                this._updateSQLComponent();
            }
        }
    }

    public SQLGenerator getSQLGenerator() {
        if (this._generator == null) {
            this._generator = SQLGenerator.getSQLGenerator();
        }
        this._generator.setConnName(this.getDatabase().getName());
        return this._generator;
    }

    public String getSQLString() {
        Column[] columnArray = this._viewBuilder.getSelectedColumns();
        DataConstraint dataConstraint = this.getConstraintBuilder().getDataConstraint();
        Relationship[] relationshipArray = this.getViewBuilder().getIncludedRelationships();
        OuterJoin[] outerJoinArray = this.getViewBuilder().getOuterJoins();
        return this.getSQLGenerator().getSQLString(columnArray, dataConstraint, relationshipArray, outerJoinArray);
    }

    public void setSQLString(String string) throws ParseException {
        throw new ParseException(string, 0);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._viewBuilder.setEnabled(bl);
        this._constraintBuilder.setEnabled(bl);
        this._codeEditor.setEnabled(bl);
        this._sqlScrollBox.setEnabled(bl);
        this._tabPanel.setEnabled(bl);
        this._splitter.setEnabled(bl);
        this._tableList.setEnabled(bl);
    }

    protected ViewBuilder createViewBuilder() {
        return new ViewBuilder();
    }

    protected ConstraintBuilder createConstraintBuilder() {
        return new QBConstraintBuilder();
    }

    protected ColumnPropertyEditor createColumnPropertyEditor() {
        return new ColumnPropertyEditor();
    }

    protected ResultsTable createResultsTable() {
        return new ResultsTable();
    }

    public SchemaViewer createSchemaViewer() {
        return new SchemaViewer();
    }

    public void addNotify() {
        super.addNotify();
        this._updateLabels(LocaleUtils.getDefaultableLocale((Component)((Object)this)));
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this._updateLabels(LocaleUtils.getDefaultableLocale((Component)((Object)this)));
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleQueryBuilder();
        }
        return this.accessibleContext;
    }

    boolean updatePage(int n) {
        int n2 = this._lastIndex;
        this._lastIndex = n;
        if (n2 == 0) {
            if (this._viewBuilderDirty) {
                this._needToUpdateResults = true;
                this._viewBuilderDirty = false;
            }
        } else if (n2 == 1) {
            if (this._constraintBuilderDirty) {
                this._needToUpdateResults = true;
                this._constraintBuilderDirty = false;
            }
        } else if (n2 == 2) {
            if (this._sqlDirty) {
                String string = this._codeEditor.getText();
                if (this._lastSQL == null || !this._lastSQL.equals(string)) {
                    try {
                        this.setSQLString(string);
                    }
                    catch (ParseException parseException) {
                        return false;
                    }
                }
                this._sqlDirty = false;
            }
        } else if (n2 == 3 && this._resultsDirty) {
            this._resultsDirty = false;
        }
        if (n == 0) {
            this._updateViewBuilder();
        } else if (n == 1) {
            this._updateConstraintBuilder();
        } else if (n == 2) {
            this._updateSQLComponent();
        } else if (n == 3) {
            this._updateResultsTable();
        }
        return true;
    }

    void tableSelected(Table table) {
        int n = this._tabPanel.getSelectedIndex();
        if (n == 0) {
            this.getViewBuilder().addTable(table, true);
        }
    }

    void columnSelected(Column column) {
        int n = this._tabPanel.getSelectedIndex();
        if (n == 0) {
            this.getViewBuilder().addTable(column.getTable(), true);
            this.getViewBuilder().setColumnSelected(column, true);
        } else if (n == 1) {
            this.getConstraintBuilder().addConstraintComponent(this.getConstraintBuilder().getConstraintCompFactory().createConstraintComponent((DataDescriptorProvider)this._dataDescriptorProvider, (DataDescriptor)column, null));
        }
    }

    private void _updateLabels(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.bali.dbUI.resource.DBUIBundle", locale);
        String string = resourceBundle.getString(_KEY_VIEWBUILDER);
        this._tabPanel.setTitleAt(0, StringUtils.stripMnemonic((String)string));
        string = resourceBundle.getString(_KEY_CONSTRAINTBUILDER);
        this._tabPanel.setTitleAt(1, StringUtils.stripMnemonic((String)string));
        string = resourceBundle.getString(_KEY_SQL);
        this._tabPanel.setTitleAt(2, StringUtils.stripMnemonic((String)string));
        string = resourceBundle.getString(_KEY_RESULTS);
        this._tabPanel.setTitleAt(3, StringUtils.stripMnemonic((String)string));
    }

    private void _updateViewBuilder() {
    }

    private void _updateConstraintBuilder() {
        int n;
        QBConstraintBuilder qBConstraintBuilder = (QBConstraintBuilder)this.getConstraintBuilder();
        ArrayList<Column> arrayList = new ArrayList<Column>();
        Table[] tableArray = this.getViewBuilder().getTables();
        if (tableArray != null && tableArray.length > 0) {
            for (int i = 0; i < tableArray.length; ++i) {
                for (n = 0; n < tableArray[i].getColumnCount(); ++n) {
                    arrayList.add(tableArray[i].getColumn(n));
                }
            }
        }
        Column[] columnArray = new Column[arrayList.size()];
        arrayList.toArray(columnArray);
        n = columnArray.length;
        this._dataDescriptorProvider.setDescriptors((DataDescriptor[])columnArray);
        qBConstraintBuilder.setDataDescriptorProvider(this._dataDescriptorProvider);
        if (n != 0 && qBConstraintBuilder.getLeafCount() == 0) {
            qBConstraintBuilder.addConstraintComponent(qBConstraintBuilder.getConstraintCompFactory().createConstraintComponent((DataDescriptorProvider)this._dataDescriptorProvider, null, null));
        }
    }

    private void _updateSQLComponent() {
        String string = this.getSQLString();
        JTextArea jTextArea = this._codeEditor.getSize().width <= 0 ? this._viewBuilder.getCanvas().getComponent() : this._codeEditor;
        string = WrappedText.wrapText((String)string, (Component)jTextArea);
        this._codeEditor.setText(string);
        this._lastSQL = string;
    }

    private void _updateResultsTable() {
        if (this._needToUpdateResults) {
            this._needToUpdateResults = false;
            ArrayList<Query> arrayList = new ArrayList<Query>();
            arrayList.add(new Query());
            ((Query)arrayList.get(0)).setSql(this.getSQLString());
            this._panel.getModel().setQueries(arrayList);
            this._panel.refresh();
        }
    }

    public void clearWhere() {
        ((QBConstraintBuilder)this._constraintBuilder).clear();
    }

    private class AccessibleQueryBuilder
    extends JComponent.AccessibleJComponent {
        public AccessibleQueryBuilder() {
            super((JComponent)((Object)CustomizedQueryBuilder.this));
            AccessibleContext accessibleContext = CustomizedQueryBuilder.this._tableList.getAccessibleContext();
            accessibleContext.setAccessibleParent(CustomizedQueryBuilder.this);
            ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.bali.dbUI.resource.AccessibleBundle", LocaleUtils.getDefaultableLocale((Component)((Object)CustomizedQueryBuilder.this)));
            String string = resourceBundle.getString(CustomizedQueryBuilder._KEY_SCHEMA_VIEWER_NAME);
            accessibleContext.setAccessibleName(string);
            accessibleContext = CustomizedQueryBuilder.this._viewBuilder.getAccessibleContext();
            accessibleContext.setAccessibleParent(CustomizedQueryBuilder.this);
            accessibleContext = CustomizedQueryBuilder.this._constraintBuilder.getAccessibleContext();
            accessibleContext.setAccessibleParent(CustomizedQueryBuilder.this);
            accessibleContext.setAccessibleName(CustomizedQueryBuilder.this._tabPanel.getTitleAt(1));
            accessibleContext = CustomizedQueryBuilder.this._codeEditor.getAccessibleContext();
            accessibleContext.setAccessibleParent(CustomizedQueryBuilder.this);
            accessibleContext.setAccessibleName(CustomizedQueryBuilder.this._tabPanel.getTitleAt(2));
            accessibleContext.setAccessibleParent(CustomizedQueryBuilder.this);
            accessibleContext.setAccessibleName(CustomizedQueryBuilder.this._tabPanel.getTitleAt(3));
        }
    }

    private static class DDProvider
    implements DataDescriptorProvider {
        private DataDescriptor[] _descriptors;
        private PropertyChangeSupport _support;

        private DDProvider() {
        }

        public int getDescriptorCount() {
            return this._descriptors == null ? 0 : this._descriptors.length;
        }

        public void setDescriptors(DataDescriptor[] dataDescriptorArray) {
            int n = this._descriptors == null ? 0 : this._descriptors.length;
            int n2 = dataDescriptorArray == null ? 0 : dataDescriptorArray.length;
            boolean bl = false;
            bl = n == n2 && dataDescriptorArray != null && this._descriptors != null ? !Arrays.equals(dataDescriptorArray, this._descriptors) : true;
            this._descriptors = null;
            if (n2 != 0) {
                this._descriptors = new DataDescriptor[n2];
                System.arraycopy(dataDescriptorArray, 0, this._descriptors, 0, n2);
            }
            this._fireEvent(n, n2);
            this._fireEvent(bl);
        }

        public DataDescriptor getDescriptor(int n) {
            return this._descriptors[n];
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this._support == null) {
                this._support = new PropertyChangeSupport(this);
            }
            this._support.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this._support != null) {
                this._support.removePropertyChangeListener(propertyChangeListener);
            }
        }

        private void _fireEvent(int n, int n2) {
            if (this._support != null) {
                this._support.firePropertyChange("descriptorCount", IntegerUtils.getInteger((int)n), IntegerUtils.getInteger((int)n2));
            }
        }

        private void _fireEvent(boolean bl) {
            if (this._support != null) {
                this._support.firePropertyChange("descriptorChanged", false, bl);
            }
        }
    }

    private class UIListener
    implements ChangeListener,
    PropertyChangeListener,
    SchemaViewerListener,
    VBRelationshipListener,
    VBOuterJoinListener,
    DocumentListener {
        private UIListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            DBUILookAndFeel.getLookAndFeel().setCursor((Component)((Object)CustomizedQueryBuilder.this), true);
            int n = CustomizedQueryBuilder.this._tabPanel.getSelectedIndex();
            if (!CustomizedQueryBuilder.this.updatePage(n)) {
                // empty if block
            }
            DBUILookAndFeel.getLookAndFeel().setCursor((Component)((Object)CustomizedQueryBuilder.this), false);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("dataConstraint".equals(string)) {
                CustomizedQueryBuilder.this._constraintBuilderDirty = true;
            } else if ("selectedColumns".equals(string)) {
                CustomizedQueryBuilder.this._viewBuilderDirty = true;
            } else if ("includedRelationships".equals(string)) {
                CustomizedQueryBuilder.this._viewBuilderDirty = true;
            } else if ("relationshipType".equals(string)) {
                CustomizedQueryBuilder.this._viewBuilderDirty = true;
            }
        }

        public void tableActivated(SchemaViewerEvent schemaViewerEvent) {
            CustomizedQueryBuilder.this.tableSelected(schemaViewerEvent.getTable());
        }

        public void columnActivated(SchemaViewerEvent schemaViewerEvent) {
            CustomizedQueryBuilder.this.columnSelected(schemaViewerEvent.getColumn());
        }

        public void relationshipAdding(ViewBuilderEvent viewBuilderEvent) {
            Relationship relationship = viewBuilderEvent.getRelationship();
            Table table = relationship.getReferencedColumn(0).getTable();
            Table table2 = relationship.getColumn(0).getTable();
            int n = 0;
            for (Table table3 : CustomizedQueryBuilder.this._viewBuilder.getTables()) {
                if (table3.getName().equals(table2.getName())) {
                    ++n;
                }
                if (!table3.getName().equals(table.getName())) continue;
                ++n;
            }
            if (table2.getName().equals(table.getName())) {
                n = 0;
            }
            if (n != 2 && viewBuilderEvent instanceof Cancelable) {
                ((Cancelable)viewBuilderEvent).cancel();
            }
        }

        public void relationshipAdded(ViewBuilderEvent viewBuilderEvent) {
            if (viewBuilderEvent.getRelationship() instanceof DynamicRelationship) {
                DynamicRelationship dynamicRelationship = (DynamicRelationship)viewBuilderEvent.getRelationship();
                dynamicRelationship.addPropertyChangeListener((PropertyChangeListener)this);
            }
        }

        public void relationshipRemoving(ViewBuilderEvent viewBuilderEvent) {
        }

        public void relationshipRemoved(ViewBuilderEvent viewBuilderEvent) {
            if (viewBuilderEvent.getRelationship() instanceof DynamicRelationship) {
                DynamicRelationship dynamicRelationship = (DynamicRelationship)viewBuilderEvent.getRelationship();
                dynamicRelationship.removePropertyChangeListener((PropertyChangeListener)this);
            }
        }

        public void outerJoinAdded(ViewBuilderEvent viewBuilderEvent) {
            CustomizedQueryBuilder.this._viewBuilderDirty = true;
        }

        public void outerJoinRemoved(ViewBuilderEvent viewBuilderEvent) {
            CustomizedQueryBuilder.this._viewBuilderDirty = true;
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            CustomizedQueryBuilder.this._sqlDirty = true;
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            CustomizedQueryBuilder.this._sqlDirty = true;
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }
    }
}

