/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.snippet;

import java.awt.Component;
import javax.swing.Icon;
import oracle.dbtools.raptor.snippet.Resources;
import oracle.dbtools.raptor.snippet.SnippetController;
import oracle.dbtools.raptor.snippet.SnippetPanel;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controls.Toolbar;
import oracle.ide.docking.DockableWindow;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.Layout;

public class SnippetWindow
extends DockableWindow {
    static final String VIEW_ID = "SNIPPET_VIEW_ID";
    private SnippetPanel _ui;
    private ContextMenu _contextMenu;

    SnippetWindow() {
        super(SnippetWindow.getViewId());
    }

    public ContextMenu getContextMenu() {
        if (this._contextMenu == null) {
            this._contextMenu = new ContextMenu();
            this._contextMenu.addContextMenuListener((ContextMenuListener)SnippetController.getInstance());
        }
        return this._contextMenu;
    }

    public static String getViewId() {
        return "SNIPPET_VIEW_TYPE.SNIPPET_VIEW_ID";
    }

    public String getTabName() {
        return Resources.getString("SNIPPET_TITLE");
    }

    public String getTitleName() {
        return this.getTabName();
    }

    public Icon getTabIcon() {
        return Resources.getIcon("SNIPPET_ICON");
    }

    public Component getGUI() {
        if (this._ui == null) {
            this._ui = new SnippetPanel(this);
        } else if (this._ui != null && this.isVisible()) {
            this._ui.init();
            SnippetController.getInstance().installToolbar(this.getToolbar());
            this._ui.fillCategories();
        }
        return this._ui;
    }

    public int getDefaultVisibility(Layout layout) {
        return 0;
    }

    public void setFileChanged(boolean bl) {
    }

    public Toolbar getToolbar() {
        return this._ui.getToolbar();
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_dbsnippets_html");
    }
}

