/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.snippet;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.raptor.snippet.Messages;
import oracle.dbtools.raptor.snippet.Snippet;
import oracle.dbtools.raptor.snippet.SnippetAddin;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SaxHandler
extends DefaultHandler {
    private String _name;
    private String _category;
    private String _language;
    private String _description;
    private String _code;
    private String _current;
    private Map<String, Map<String, List<Snippet>>> _languages;

    public SaxHandler(Map<String, Map<String, List<Snippet>>> map) {
        this._languages = map;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this._current = string3;
        if ("snippet".equals(string3)) {
            this._description = null;
            this._code = null;
        }
        this.set(string3, null);
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            String string4 = attributes.getQName(i);
            String string5 = attributes.getValue(i);
            this.set(string4, string5);
        }
    }

    private void set(String string, String string2) {
        if ("name".equals(string)) {
            this._name = string2;
        } else if ("category".equals(string)) {
            this._category = string2;
        } else if ("language".equals(string)) {
            this._language = string2;
        } else if ("description".equals(string)) {
            this._description = string2 != null ? (this._description == null ? string2 : this._description + string2) : null;
        } else if ("code".equals(string) || "snippet".equals(string)) {
            this._code = string2 != null ? (this._code == null ? string2 : this._code + string2) : null;
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if ("snippet".equals(string3)) {
            this.addSnippet(this._name, SnippetAddin.getXliff().getTranslation(this._category), this._language, SnippetAddin.getXliff().getTranslation(this._description), this._code);
            if (this._code == null) {
                this._current = null;
                return;
            }
        }
        this._current = null;
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this._current != null) {
            String string = new String(cArray, n, n2);
            this.set(this._current, string);
        }
    }

    public void addSnippet(String string, String string2, String string3, String string4, String string5) {
        ArrayList<Snippet> arrayList;
        if (string == null) {
            throw new IllegalArgumentException(Messages.getString("SaxHandler.0"));
        }
        HashMap hashMap = (HashMap)this._languages.get(string3);
        if (hashMap == null) {
            hashMap = new HashMap();
            this._languages.put(SnippetAddin.getXliff().getTranslation(string3), hashMap);
        }
        if ((arrayList = (ArrayList<Snippet>)hashMap.get(string2)) == null) {
            arrayList = new ArrayList<Snippet>();
            hashMap.put(string2, arrayList);
        }
        Snippet snippet = new Snippet(string, string5, string4);
        boolean bl = true;
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!((Snippet)arrayList.get(i)).getName().equals(string)) continue;
            arrayList.remove(i);
            arrayList.add(i, snippet);
            bl = false;
        }
        if (bl) {
            arrayList.add(snippet);
        }
    }
}

