/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.net.URL;
import java.text.MessageFormat;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Token;

public class Service {
    public static void main(String[] stringArray) throws Exception {
        System.out.println(Service.handleMixedCase("emp"));
        System.out.println(Service.handleMixedCase("\"DOT.DOt\""));
        System.out.println(Service.handleMixedCase("\"HR\".\"DOT.DOT\""));
    }

    public static String readFile(Class clazz, String string) throws Exception {
        URL uRL = clazz.getResource(string);
        return Service.readFile(uRL.openStream());
    }

    public static String readFile(String string) throws Exception {
        return Service.readFile(new FileInputStream(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(InputStream inputStream) throws Exception {
        byte[] byArray = new byte[4096];
        int n = 0;
        BufferedInputStream bufferedInputStream = null;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            bufferedInputStream = new BufferedInputStream(inputStream);
            n = bufferedInputStream.read(byArray, 0, byArray.length);
            while (n != -1) {
                stringBuffer.append(new String(byArray).substring(0, n));
                n = bufferedInputStream.read(byArray, 0, byArray.length);
            }
        }
        finally {
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
            }
        }
        return stringBuffer.toString();
    }

    public static String cleanFileName(String string) {
        return Service.cleanFileName(string, "@");
    }

    public static String cleanFileName(String string, String string2) {
        String string3 = string.replaceAll("[<>:/\\|?*]", string2);
        return string3;
    }

    public static String cleanScriptFileName(String string) {
        return Service.cleanScriptFileName(string, "_", "_");
    }

    public static String cleanScriptFileName(String string, String string2, String string3) {
        String string4 = string.replaceAll("[<>:/\\|?*()%&'$@^~/#]", string2);
        string4 = string4.replaceAll(" ", string3);
        return string4;
    }

    public static void copy(URL uRL, String string) {
        try {
            int n;
            String string2;
            InputStream inputStream;
            Object object;
            if (uRL.toString().startsWith("jar:file:")) {
                int n2 = uRL.toString().indexOf(33);
                object = uRL.toString().substring("jar:file:".length(), n2);
                JarFile jarFile = new JarFile((String)object);
                JarEntry jarEntry = jarFile.getJarEntry(uRL.toString().substring(n2 + 2));
                inputStream = jarFile.getInputStream(jarEntry);
                String string3 = jarEntry.getName();
                File file = new File(string3);
                string2 = file.getName();
            } else {
                String string4 = uRL.getPath();
                object = new File(string4);
                string2 = ((File)object).getName();
                inputStream = new FileInputStream(string4);
            }
            FileOutputStream fileOutputStream = new FileOutputStream(new File(string + File.separator + string2));
            object = new byte[1024];
            while ((n = inputStream.read((byte[])object)) > 0) {
                ((OutputStream)fileOutputStream).write((byte[])object, 0, n);
            }
            inputStream.close();
            ((OutputStream)fileOutputStream).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String toNull(String string) {
        return "".equals(string) ? null : string;
    }

    public static String identln(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static String padln(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = string.length(); i < n; ++i) {
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public static int pair(int n, int n2) {
        return n2 << 16 | n;
    }

    public static int Y(int n) {
        return n >> 16;
    }

    public static int X(int n) {
        return n & 0xFFFF;
    }

    public static long lPair(int n, int n2) {
        return (long)n2 << 32 | (long)n;
    }

    public static int lY(long l) {
        return (int)(l >> 32);
    }

    public static int lX(long l) {
        return (int)l;
    }

    public static int decrPair(int n) {
        return n - 65537;
    }

    public static long addlX(long l, int n) {
        return l + (long)n;
    }

    public static long addlY(long l, int n) {
        return l + ((long)n << 32);
    }

    public static String handleMixedCase(String string) {
        List<LexerToken> list = LexerToken.parse(string, true, true);
        StringBuilder stringBuilder = new StringBuilder();
        for (LexerToken lexerToken : list) {
            String string2 = lexerToken.content;
            if (lexerToken.type == Token.DQUOTED_STRING) {
                if (1 < string2.length()) {
                    string2 = string2.substring(1, string2.length() - 1);
                }
            } else {
                string2 = string2.toUpperCase();
            }
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    public static String addDoubleQuote(String string) {
        boolean bl = false;
        String string2 = "$#_";
        if (!string.startsWith("\"") && !bl) {
            char[] cArray = new char[string.length()];
            string.getChars(0, cArray.length, cArray, 0);
            if (cArray.length > 0 && '0' <= cArray[0] && cArray[0] <= '9') {
                bl = true;
            } else {
                for (char c : cArray) {
                    if (string2.indexOf(c) >= 0 || c >= '0' && ('9' >= c || c >= 'A') && 'Z' >= c) continue;
                    bl = true;
                    break;
                }
            }
        }
        if (string.startsWith("_") || string.startsWith("$") || string.startsWith("#")) {
            bl = true;
        }
        return bl ? MessageFormat.format("\"{0}\"", string) : string;
    }

    public static String into2chars(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            stringBuffer.append(Service.into2chars(string.charAt(i)));
        }
        return stringBuffer.toString();
    }

    public static String from2chars(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char[] cArray = new char[2];
            cArray[0] = string.charAt(n++);
            if (n >= string.length()) {
                return null;
            }
            cArray[1] = string.charAt(n++);
            stringBuffer.append(Service.from2chars(cArray));
        }
        return stringBuffer.toString();
    }

    static char[] into2chars(char c) {
        char[] cArray = new char[]{(char)(Service.periodicRemainder(c, 16) + 70), (char)(Service.periodicDivision(c, 16) + 70)};
        return cArray;
    }

    static char from2chars(char[] cArray) {
        return (char)((cArray[1] - 70) * 16 + (cArray[0] - 70));
    }

    static int periodicRemainder(int n, int n2) {
        int n3 = n % n2;
        if (n3 < 0) {
            n3 += n2;
        }
        return n3;
    }

    static int periodicDivision(int n, int n2) {
        int n3 = n / n2;
        if (n3 < 0) {
            --n3;
        }
        return n3;
    }

    public static int[] toArray(Set<Integer> set) {
        int[] nArray = new int[set.size()];
        int n = 0;
        for (int n2 : set) {
            nArray[n++] = n2;
        }
        return nArray;
    }

    public static void profile(final int n, final int n2) {
        final String string = Thread.currentThread().getName();
        new Thread(){

            @Override
            public void run() {
                long l = System.currentTimeMillis();
                while (System.currentTimeMillis() < l + (long)n) {
                    try {
                        Thread.sleep(n2);
                        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
                        ThreadInfo[] threadInfoArray = threadMXBean.dumpAllThreads(true, true);
                        System.out.println("=================" + (System.currentTimeMillis() - l));
                        for (ThreadInfo threadInfo : threadInfoArray) {
                            if (!string.equals(threadInfo.getThreadName())) continue;
                            StackTraceElement[] stackTraceElementArray = threadInfo.getStackTrace();
                            int n3 = 0;
                            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                                if (stackTraceElement.toString().startsWith("java.") || n3 >= 5) continue;
                                System.out.println(stackTraceElement.toString());
                                ++n3;
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        }.start();
    }
}

