/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.dbtools.parser.CYK;
import oracle.dbtools.parser.Cell;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.plsql.PlsqlCYK;
import oracle.dbtools.util.Service;

public class VolumeTest {
    static boolean isSQL = false;
    private static Connection c = null;
    private static String query = null;
    private static ResultSet rs = null;

    public static String nextPLSQL() throws Exception {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; (n = rs.getInt("line")) != 1 || i == 0; ++i) {
            stringBuffer.append(rs.getString("text"));
            if (!rs.next()) break;
        }
        return stringBuffer.toString();
    }

    public static String nextSQL() throws Exception {
        if (rs.next()) {
            return rs.getString(1);
        }
        return null;
    }

    public static String next() throws Exception {
        if (isSQL) {
            return VolumeTest.nextSQL();
        }
        return VolumeTest.nextPLSQL();
    }

    public static void main(String[] stringArray) throws Exception {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        if (!isSQL) {
            treeSet.add(PlsqlCYK.getInstance().getSymbol("compilation_unit"));
        }
        String string = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while ((string = VolumeTest.next()) != null) {
            if (++n % 10 == 0) {
                System.out.println("============== " + n + " ==============");
                System.out.println("Cumulative parse time: " + n2);
                System.out.println("Cumulative member count: " + n3);
            }
            try {
                long l = System.currentTimeMillis();
                Cell cell = VolumeTest.parse(string);
                long l2 = System.currentTimeMillis();
                n2 = (int)((long)n2 + (l2 - l));
                boolean bl = false;
                Iterator iterator = treeSet.iterator();
                while (iterator.hasNext()) {
                    int n4 = (Integer)iterator.next();
                    for (int i = 0; i < cell.size(); ++i) {
                        int n5 = cell.getRule(i);
                        if (n5 != n4) continue;
                        bl = true;
                    }
                }
                if (bl) continue;
                System.out.println(string);
                return;
            }
            catch (Exception exception) {
                System.out.println(n);
                System.out.println(exception.getMessage());
                if (exception.getMessage() != null && exception.getMessage().contains("Skipped")) continue;
                System.out.println(string);
                exception.printStackTrace();
                return;
            }
        }
    }

    static Cell parse(String string) throws Exception {
        List<LexerToken> list = LexerToken.parse(string);
        long l = System.currentTimeMillis();
        Matrix matrix = VolumeTest.getInstance().initArray1(list);
        int n = 0;
        int n2 = matrix.size();
        int n3 = matrix.size();
        TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>();
        l = System.currentTimeMillis();
        VolumeTest.getInstance().closure(matrix, 0, n3 + 1, treeMap, -1);
        long l2 = System.currentTimeMillis();
        Cell cell = (Cell)matrix.get(Service.lPair(n, n2));
        System.out.print("txt.length=" + string.length());
        System.out.print(", #tokens=" + n2);
        System.out.println(", time = " + (l2 - l));
        return cell;
    }

    private static CYK getInstance() {
        if (isSQL) {
            return null;
        }
        return PlsqlCYK.getInstance();
    }

    static {
        try {
            Class.forName("oracle.jdbc.OracleDriver");
            if (isSQL) {
                c = DriverManager.getConnection("jdbc:oracle:thin:@rws60115rems.us.oracle.com:1526:VIS", "sqlrepo", "sqlrepo");
                query = "select sql_text||';' from statements\nwhere sql_id between 0 and 20000\nand length(sql_text) between 1000 and 5000\nand sql_text not like '%:symbolic_arguments:i_symargs%'\nand sql_text not like '%for update of order_number%'\nand sql_text not like '%and service_line_id = :B2 for update of unit_effectivity_id%'\norder by sql_id";
            } else {
                c = DriverManager.getConnection("jdbc:oracle:thin:@rws60115rems.us.oracle.com:1552:seed120", "apps_read_only", "apps");
                query = "select * from dba_source\nwhere owner = 'APPS'\nand type = 'PACKAGE BODY'\nand name like 'FND%'order by name,line";
            }
            PreparedStatement preparedStatement = c.prepareStatement(query);
            rs = preparedStatement.executeQuery();
            rs.next();
        }
        catch (Exception exception) {
            throw new RuntimeException("failed to connect to database");
        }
    }
}

