/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql;

import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import oracle.dbtools.parser.Grammar;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.RuleTransforms;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.plsql.PlsqlRules;
import oracle.dbtools.parser.plsql.SqlRules;
import oracle.dbtools.util.Service;

public class UnifiedRules {
    private static final String fname = "serializedAllRules.xml";
    private static final String path = "/oracle/dbtools/parser/plsql/";

    public static void main(String[] stringArray) throws Exception {
        UnifiedRules.memorizeRules();
    }

    private static void memorizeRules() throws Exception {
        Set<RuleTuple> set = UnifiedRules.extractRules();
        FileOutputStream fileOutputStream = new FileOutputStream("utils-nodeps/src/oracle/dbtools/parser/plsql/serializedAllRules.xml");
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        objectOutputStream.writeObject(set);
        objectOutputStream.close();
    }

    public static Set<RuleTuple> getRules() throws Exception {
        URL uRL = PlsqlRules.class.getResource("/oracle/dbtools/parser/plsql/serializedAllRules.xml");
        InputStream inputStream = uRL.openStream();
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        Set set = (Set)objectInputStream.readObject();
        objectInputStream.close();
        return set;
    }

    private static Set<RuleTuple> extractRules() throws Exception {
        Set<RuleTuple> set = PlsqlRules.parseBNFtext(PlsqlRules.readBNFfile());
        String string = Service.readFile(UnifiedRules.class, "PlsqlFixes.grammar");
        List<LexerToken> list = LexerToken.parse(string);
        ParseNode parseNode = Grammar.parseGrammarFile(list, string);
        Grammar.grammar(parseNode, list, set);
        for (RuleTuple ruleTuple : set) {
            if (!ruleTuple.head.contains("constrained_type")) continue;
            System.out.println(ruleTuple.toString());
        }
        Set<RuleTuple> set2 = SqlRules.extractRules();
        set.addAll((Collection<RuleTuple>)set2);
        RuleTransforms.eliminateEmptyProductions(set);
        RuleTransforms.substituteSingleUnaryProductions(set);
        return set;
    }
}

