/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql;

import java.util.Iterator;
import java.util.List;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.parser.Cell;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.util.Messages;
import oracle.dbtools.util.Service;

public class SyntaxError {
    public int line;
    public int offset;
    public int end;
    public String code;
    public String marker;
    public String[] suggestions;
    static final String TITLE = Messages.getString("SyntaxError_Title");
    static final String MESSAGE_KEY = "SyntaxError_Message";
    static final String DETAILED_MESSAGE_KEY = "SyntaxError_DetailedMessage";

    public static SyntaxError checkSQLQuerySyntax(String string) {
        return SyntaxError.checkSyntax(string, new String[]{"subquery", "select"});
    }

    public static SyntaxError checkSyntax(String string, String[] stringArray) {
        List<LexerToken> list = LexerToken.parse(string);
        SqlEarley sqlEarley = SqlEarley.getInstance();
        Matrix matrix = new Matrix(sqlEarley);
        sqlEarley.parse(list, matrix);
        return SyntaxError.checkSyntax(string, stringArray, list, sqlEarley, matrix);
    }

    public static SyntaxError checkSyntax(String string, String[] stringArray, List<LexerToken> list, Earley earley, Matrix matrix) {
        int n;
        int n2;
        Cell cell = (Cell)matrix.get(Service.lPair(0, list.size()));
        if (cell != null) {
            for (String string2 : stringArray) {
                for (n2 = 0; n2 < cell.size(); ++n2) {
                    Earley.Tuple tuple = earley.rules[cell.getRule(n2)];
                    String string3 = earley.allSymbols[tuple.head];
                    if (!string3.equals(string2)) continue;
                    return null;
                }
            }
        }
        for (n = list.size(); 0 < n && matrix.get(Service.lPair(n, n)) == null; --n) {
        }
        NavigableMap navigableMap = matrix.subMap(Service.lPair(n, n), true, matrix.lastKey(), true);
        Iterator iterator = navigableMap.keySet().iterator();
        while (iterator.hasNext()) {
            long l = (Long)iterator.next();
            int n3 = Service.lY(l);
            if (n >= n3) continue;
            n = n3;
        }
        int n4 = 0;
        if (0 < n) {
            n4 = list.get((int)(n - 1)).end;
        }
        int n5 = 0;
        n2 = 0;
        int n6 = string.length();
        for (int i = 0; i < n6; ++i) {
            if (string.charAt(i) != '\n') continue;
            if (i < n4) {
                ++n5;
                n2 = i;
                continue;
            }
            n6 = i;
            break;
        }
        String string4 = string.substring(n2, n6);
        int n7 = n4 - n2;
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = 0; i <= n; ++i) {
            Cell cell2 = (Cell)matrix.get(Service.lPair(i, n));
            if (cell2 == null) continue;
            for (int j = 0; j < cell2.size(); ++j) {
                String string5;
                int n8 = cell2.getRule(j);
                int n9 = cell2.getPosition(j);
                if (n9 >= earley.rules[n8].rhs.length || (string5 = earley.allSymbols[earley.rules[n8].rhs[n9]]).startsWith("xml")) continue;
                treeSet.add(string5);
            }
        }
        String string6 = "";
        if (n < list.size()) {
            string6 = list.get((int)n).content.toUpperCase();
        }
        return new SyntaxError(n5, n7, n4, string4, Service.identln(n7, "^^^"), SyntaxError.order(treeSet, "'" + string6 + "'"));
    }

    private static String[] order(Set<String> set, String string) {
        String string2 = null;
        for (String string3 : set) {
            if (!SyntaxError.isTypo(string3, string)) continue;
            string2 = string3;
        }
        String[] stringArray = new String[set.size()];
        int n = 0;
        for (String string4 : set) {
            stringArray[n++] = string4;
        }
        if (string2 != null) {
            String string5 = stringArray[0];
            stringArray[0] = string2;
            for (int i = 1; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(stringArray[0])) continue;
                stringArray[i] = string5;
            }
        }
        return stringArray;
    }

    private static boolean isTypo(String string, String string2) {
        if (string.length() + 1 == string2.length() || string.length() == string2.length() + 1 || string.length() == string2.length()) {
            int n;
            int n2 = 0;
            int n3 = -1;
            for (n = 0; n < string.length() && n < string2.length(); ++n) {
                if (string.charAt(n) == string2.charAt(n)) {
                    ++n2;
                    continue;
                }
                n3 = n;
                break;
            }
            if (n3 + 1 < string.length() && n3 + 1 < string2.length() && string.charAt(n3 + 1) == string2.charAt(n3 + 1)) {
                for (n = n3 + 1; n < string.length() && n < string2.length() && string.charAt(n) == string2.charAt(n); ++n) {
                    ++n2;
                }
            } else if (n3 + 1 < string.length() && string.charAt(n3 + 1) == string2.charAt(n3)) {
                for (n = n3; n + 1 < string.length() && n < string2.length() && string.charAt(n + 1) == string2.charAt(n); ++n) {
                    ++n2;
                }
            } else if (n3 + 1 < string2.length() && string.charAt(n3) == string2.charAt(n3 + 1)) {
                for (n = n3; n < string.length() && n + 1 < string2.length() && string.charAt(n) == string2.charAt(n + 1); ++n) {
                    ++n2;
                }
            }
            if (n2 == string.length() - 1 || n2 == string2.length() - 1) {
                return true;
            }
        }
        return false;
    }

    private SyntaxError(int n, int n2, int n3, String string, String string2, String[] stringArray) {
        this.line = n;
        this.offset = n2;
        this.end = n3;
        this.code = string;
        this.marker = string2;
        this.suggestions = stringArray;
    }

    public String toString() {
        return this.getDetailedMessage();
    }

    public String getDetailedMessage() {
        String string = Service.padln(this.marker, this.code.length());
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : this.suggestions) {
            stringBuilder.append(string2 + ',');
        }
        return Messages.format(DETAILED_MESSAGE_KEY, this.line, this.offset, stringBuilder.toString(), this.code, string);
    }

    public String getMessage() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.suggestions) {
            stringBuilder.append(string + ',');
        }
        return Messages.format(MESSAGE_KEY, this.line, this.offset, stringBuilder.toString());
    }

    public String getTitle() {
        return TITLE;
    }

    public static void main(String[] stringArray) throws Exception {
        String string = Service.readFile(SyntaxError.class, "test.sql");
        SyntaxError syntaxError = SyntaxError.checkSQLQuerySyntax(string);
        if (syntaxError != null) {
            System.out.println(syntaxError.getDetailedMessage());
        }
    }
}

