/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql;

import java.io.BufferedInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.Grammar;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.RuleTransforms;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.Visual;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.util.Service;

public class SqlRules {
    private static char[] identifiers = new char[]{'(', ')', '\'', ',', ';', ':', '=', '+', '-', '*', '/', '@', '!', '^', 'e', 'f', 'd'};
    private static Earley earley;
    static int bnf;
    static int rawbnf;
    static int boldrawbnf;
    static int identifier;
    static int concat;
    static int block;
    static int sqBr;
    static int curlyBr;
    static int dot;
    static int lt;
    static int gt;
    static int lbr;
    static int rbr;
    static int dbar;
    static Map<String, String> missingSymbols;
    private static final String path = "/oracle/dbtools/parser/plsql/";
    private static Set<String> toDo;
    private static Set<String> notFound;
    private static Set<String> masterRules;
    private static ParseNode fixesParseTree;
    private static List<LexerToken> fixesScan;

    public static void main(String[] stringArray) throws Exception {
        boolean bl = true;
        if (bl) {
            SqlRules.testParseSqlBnf();
        } else {
            SqlRules.memorizeRules();
        }
    }

    private static void testParseSqlBnf() throws Exception {
        String string = Service.readFile(SqlRules.class, "testsql.bnf");
        List<LexerToken> list = LexerToken.parse(string, false, true);
        SqlRules.correctDots(list);
        Visual visual = null;
        visual = new Visual(list, earley);
        Matrix matrix = new Matrix(earley);
        earley.parse(list, matrix);
        ParseNode parseNode = earley.forest(list, matrix);
        parseNode.printTree();
        if (visual != null) {
            visual.draw(matrix);
        }
        TreeSet<RuleTuple> treeSet = new TreeSet<RuleTuple>();
        String string2 = "test";
        treeSet.addAll(SqlRules.bnf(parseNode, list, string2));
        System.out.println("-------------Optimized---------------");
        RuleTuple.printRules(treeSet);
        System.out.println("-------------------------------------");
    }

    private static void bnfIdentifiers(Set<RuleTuple> set) {
        for (char c : identifiers) {
            set.add(new RuleTuple("identifier", new String[]{"'" + c + "'"}));
        }
    }

    private static Earley bnfParser() throws Exception {
        TreeSet<RuleTuple> treeSet = new TreeSet<RuleTuple>();
        String string = Service.readFile(SqlRules.class, "DocBnf.grammar");
        List<LexerToken> list = LexerToken.parse(string);
        ParseNode parseNode = Grammar.parseGrammarFile(list, string);
        Grammar.grammar(parseNode, list, treeSet);
        return new Earley(treeSet){

            @Override
            protected boolean isIdentifier(int n, List<LexerToken> list, int n2, Integer n3) {
                LexerToken lexerToken = list.get(n);
                return n2 == this.identifier && lexerToken.type == Token.IDENTIFIER || n2 == this.identifier && lexerToken.type == Token.DQUOTED_STRING;
            }
        };
    }

    static Set<RuleTuple> extractRules() throws Exception {
        TreeSet<RuleTuple> treeSet = new TreeSet<RuleTuple>();
        missingSymbols.put("access_driver_type", "identifier");
        missingSymbols.put("alias", "identifier");
        missingSymbols.put("argument", "expr");
        missingSymbols.put("attribute", "identifier");
        missingSymbols.put("c_alias", "identifier");
        missingSymbols.put("char1", "expr");
        missingSymbols.put("char2", "expr");
        missingSymbols.put("cluster", "identifier");
        missingSymbols.put("class", "literal");
        missingSymbols.put("class_value", "literal");
        missingSymbols.put("cost_value", "literal");
        missingSymbols.put("collection_item", "identifier");
        missingSymbols.put("column_expression", "expr");
        missingSymbols.put("column_name", "identifier");
        missingSymbols.put("comparison_expr", "expr");
        missingSymbols.put("constant", "literal");
        missingSymbols.put("constraint_name", "identifier");
        missingSymbols.put("constraint", "identifier");
        missingSymbols.put("data_item", "identifier");
        missingSymbols.put("database", "identifier");
        missingSymbols.put("domain", "identifier");
        missingSymbols.put("dimension_column", "identifier");
        missingSymbols.put("else_expr", "expr");
        missingSymbols.put("esc_char", "string_literal");
        missingSymbols.put("expr1", "expr");
        missingSymbols.put("expr2", "expr");
        missingSymbols.put("expr3", "expr");
        missingSymbols.put("filename", "string_literal");
        missingSymbols.put("fractional_seconds_precision", "digits");
        missingSymbols.put("fractional_second_precision", "digits");
        missingSymbols.put("hash_partition_quantity", "digits");
        missingSymbols.put("hash_subpartition_quantity", "digits");
        missingSymbols.put("index", "identifier");
        missingSymbols.put("integer", "digits");
        missingSymbols.put("java_ext_name", "identifier");
        missingSymbols.put("leading_field_precision", "digits");
        missingSymbols.put("len", "digits");
        missingSymbols.put("lib_name", "identifier");
        missingSymbols.put("LOB_item", "identifier");
        missingSymbols.put("LOB_segname", "identifier");
        missingSymbols.put("main_model_name", "identifier");
        missingSymbols.put("measure_column", "identifier");
        missingSymbols.put("method", "identifier");
        missingSymbols.put("model", "identifier");
        missingSymbols.put("name", "identifier");
        missingSymbols.put("nested_item", "identifier");
        missingSymbols.put("nested_table", "identifier");
        missingSymbols.put("nested_table1", "identifier");
        missingSymbols.put("nested_table2", "identifier");
        missingSymbols.put("new_name", "identifier");
        missingSymbols.put("new_table_name", "identifier");
        missingSymbols.put("object", "identifier");
        missingSymbols.put("object_table_alias", "identifier");
        missingSymbols.put("old_name", "identifier");
        missingSymbols.put("old_password", "identifier");
        missingSymbols.put("package", "identifier");
        missingSymbols.put("parameter", "identifier");
        missingSymbols.put("partition", "identifier");
        missingSymbols.put("password", "identifier");
        missingSymbols.put("pattern", "string_literal");
        missingSymbols.put("position", "digits");
        missingSymbols.put("precision", "digits");
        missingSymbols.put("procedure_name", "identifier");
        missingSymbols.put("profile", "identifier");
        missingSymbols.put("query_name", "identifier");
        missingSymbols.put("reference_spreadsheet_name", "identifier");
        missingSymbols.put("return_expr", "expr");
        missingSymbols.put("role", "identifier");
        missingSymbols.put("sample_percent", "digits");
        missingSymbols.put("scale", "digits");
        missingSymbols.put("schema", "identifier");
        missingSymbols.put("scope_table", "identifier");
        missingSymbols.put("seed_value", "digits");
        missingSymbols.put("sequence", "identifier");
        missingSymbols.put("size", "digits");
        missingSymbols.put("storage_table", "identifier");
        missingSymbols.put("subpartition", "identifier");
        missingSymbols.put("synonym", "identifier");
        missingSymbols.put("t_alias", "identifier");
        missingSymbols.put("table", "identifier");
        missingSymbols.put("tablespace", "identifier");
        missingSymbols.put("table_alias", "identifier");
        missingSymbols.put("tablespace", "identifier");
        missingSymbols.put("type_name", "identifier");
        missingSymbols.put("type", "identifier");
        missingSymbols.put("user", "identifier");
        missingSymbols.put("user_defined_types", "identifier");
        missingSymbols.put("value_expr", "expr");
        missingSymbols.put("value_expression", "expr");
        missingSymbols.put("view", "identifier");
        missingSymbols.put("variable_expression", "bind_var");
        missingSymbols.put("varray_type", "identifier");
        for (String string : missingSymbols.keySet()) {
            treeSet.add(new RuleTuple(string, new String[]{missingSymbols.get(string)}));
        }
        treeSet.add(new RuleTuple("literal", new String[]{"string_literal"}));
        treeSet.add(new RuleTuple("literal", new String[]{"number"}));
        treeSet.add(new RuleTuple("datetime_literal", new String[]{"'TO_DATE'", "'('", "string_literal", "','", "string_literal", "')'"}));
        treeSet.add(new RuleTuple("literal", new String[]{"datetime_literal"}));
        treeSet.add(new RuleTuple("not_eq", new String[]{"'<'", "'>'"}));
        SqlRules.addToDo("sql_statements");
        while (0 < toDo.size()) {
            String string = SqlRules.nextToDo();
            SqlRules.recursiveCollectBNF(treeSet, string);
            toDo.remove(string);
        }
        RuleTransforms.eliminateEmptyProductions(treeSet);
        RuleTransforms.injectMissingEmptyProductions(treeSet);
        RuleTransforms.substituteSingleBinaryProductions(treeSet);
        RuleTransforms.substituteSingleUnaryProductions(treeSet);
        System.out.println("*************NOT FOUND************");
        System.out.println(notFound);
        return treeSet;
    }

    public static void memorizeRules() throws Exception {
        SqlRules.memorizeRules("serializedSqlBNF.xml");
    }

    public static Set<RuleTuple> getRules() throws Exception {
        return SqlRules.getRules("serializedSqlBNF.xml");
    }

    private static void memorizeRules(String string) throws Exception {
        Set<RuleTuple> set = SqlRules.extractRules();
        FileOutputStream fileOutputStream = new FileOutputStream("utils-nodeps/src/oracle/dbtools/parser/plsql/" + string);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        objectOutputStream.writeObject(set);
        objectOutputStream.close();
    }

    private static Set<RuleTuple> getRules(String string) throws Exception {
        URL uRL = SqlRules.class.getResource(path + string);
        InputStream inputStream = uRL.openStream();
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        Set set = (Set)objectInputStream.readObject();
        objectInputStream.close();
        return set;
    }

    private static void addToDo(String string) {
        if (string.charAt(0) != '\'' && !notFound.contains(string) && !masterRules.contains(string)) {
            toDo.add(string);
        }
    }

    private static String nextToDo() {
        Iterator<String> iterator = toDo.iterator();
        if (iterator.hasNext()) {
            String string = iterator.next();
            return string;
        }
        throw new AssertionError((Object)"Empty toDo");
    }

    private static void recursiveCollectBNF(Set<RuleTuple> set, String string) throws Exception {
        if (masterRules.contains(string)) {
            return;
        }
        if (notFound.contains(string)) {
            return;
        }
        System.out.println("searching for...  " + string);
        if ("hint".equals(string)) {
            return;
        }
        if (!SqlRules.fetchFromFixes(set, string)) {
            SqlRules.fetchFromDocWebsite(set, string);
        }
    }

    private static void fetchFromDocWebsite(Set<RuleTuple> set, String string) throws Exception {
        String string2 = SqlRules.readURL(string, "http://st-doc.us.oracle.com/sql_grammar/sqlbnf112/bnffiles");
        if (string2 == null) {
            if (notFound.contains(string)) {
                return;
            }
            string2 = SqlRules.readURL(string, "http://st-doc.us.oracle.com/sql_grammar/sqlbnf112/bnffiles");
            if (string2 == null) {
                System.exit(1);
            }
        }
        string2 = string2.replace("'ODCI_parameters'", "string_literal");
        string2 = string2.replace("'filename'", "string_literal");
        string2 = string2.replace("'location'", "string_literal");
        string2 = string2.replace("'instance_name'", "string_literal");
        string2 = string2.replace("'sid'", "string_literal");
        string2 = string2.replace("'*'", "string_literal");
        List<LexerToken> list = LexerToken.parse(string2, false, false);
        SqlRules.correctDots(list);
        System.out.println(string + "...");
        Matrix matrix = new Matrix(earley);
        earley.parse(list, matrix);
        ParseNode parseNode = earley.forest(list, matrix);
        if (!parseNode.contains((Integer)SqlRules.earley.symbolIndexes.get("bnf"))) {
            System.err.println("failed to parse >>>" + string + "<<< to bnf");
            System.exit(0);
        }
        set.addAll(SqlRules.bnf(parseNode, list, string));
    }

    public static String readURL(String string, String string2) {
        if ("outer_join_type".equals(string)) {
            System.out.println("!");
        }
        try {
            return SqlRules.readURL(string2 + "/" + string + ".htm");
        }
        catch (Exception exception) {
            if (exception.getClass().getPackage().getName().contains("java.net")) {
                System.err.println("Failed to connect to " + exception.getMessage());
                return null;
            }
            try {
                return SqlRules.readURL(string2 + "/" + string + "s.htm");
            }
            catch (Exception exception2) {
                if (exception.getClass().getPackage().getName().contains("java.net")) {
                    System.err.println("Failed to connect to " + exception.getMessage());
                    return null;
                }
                notFound.add(string);
                return null;
            }
        }
    }

    private static boolean contains(Set<RuleTuple> set, String string) {
        for (RuleTuple ruleTuple : set) {
            if (!ruleTuple.head.equals(string)) continue;
            return true;
        }
        return false;
    }

    private static ParseNode parseFixesFile(List<LexerToken> list, String string) throws Exception {
        SqlRules.correctDots(list);
        Matrix matrix = new Matrix(earley);
        earley.parse(list, matrix);
        SyntaxError syntaxError = SyntaxError.checkSyntax(string, new String[]{"bnflist"}, list, earley, matrix);
        if (syntaxError != null) {
            System.out.println("Syntax Error");
            System.out.println("at line#" + syntaxError.line);
            System.out.println(syntaxError.code);
            System.out.println(syntaxError.marker);
            System.out.println("Expected:  ");
            for (String string2 : syntaxError.suggestions) {
                System.out.print(string2 + ',');
            }
            throw new Exception(">>>> Parse error in SqlFixes.bnf <<<<");
        }
        ParseNode parseNode = earley.forest(list, matrix);
        return parseNode;
    }

    private static boolean fetchFromFixes(Set<RuleTuple> set, String string) throws Exception {
        if (fixesParseTree == null || fixesScan == null) {
            String string2 = Service.readFile(SqlRules.class, "SqlFixes.bnf");
            fixesScan = LexerToken.parse(string2);
            fixesParseTree = SqlRules.parseFixesFile(fixesScan, string2);
            SqlRules.bnflist(fixesParseTree, fixesScan, set);
        }
        return masterRules.contains(string);
    }

    private static void correctDots(List<LexerToken> list) {
        int n = -1;
        for (LexerToken lexerToken : list) {
            if (!".".equals(lexerToken.content) || ++n != 0 && ".".equals(list.get((int)(n - 1)).content) || n != list.size() - 1 && ".".equals(list.get((int)(n + 1)).content)) continue;
            lexerToken.content = "'.'";
            lexerToken.type = Token.IDENTIFIER;
        }
    }

    private static void bnflist(ParseNode parseNode, List<LexerToken> list, Set<RuleTuple> set) {
        if (parseNode.contains(bnf)) {
            set.addAll(SqlRules.bnf(parseNode, list, null));
        } else {
            for (ParseNode parseNode2 : parseNode.children()) {
                SqlRules.bnflist(parseNode2, list, set);
            }
        }
    }

    private static Set<RuleTuple> bnf(ParseNode parseNode, List<LexerToken> list, String string) {
        TreeSet<RuleTuple> treeSet = new TreeSet<RuleTuple>();
        for (ParseNode parseNode2 : parseNode.children()) {
            if (string == null && parseNode2.contains(identifier)) {
                string = parseNode2.content(list);
                continue;
            }
            if (!parseNode2.contains(rawbnf)) continue;
            treeSet.addAll(SqlRules.rawbnf(parseNode2, list, string, false));
        }
        RuleTransforms.eliminateEmptyProductions(treeSet);
        RuleTransforms.substituteSingleUnaryProductions(treeSet);
        RuleTransforms.substituteSingleBinaryProductions(treeSet);
        masterRules.add(string);
        return treeSet;
    }

    private static Set<RuleTuple> rawbnf(ParseNode parseNode, List<LexerToken> list, String string, boolean bl) {
        if (parseNode.contains(concat)) {
            return SqlRules.concat(parseNode, list, string, bl);
        }
        TreeSet<RuleTuple> treeSet = new TreeSet<RuleTuple>();
        for (ParseNode parseNode2 : parseNode.children()) {
            if (parseNode2.contains(identifier) && parseNode2.from + 1 == parseNode2.to) {
                String string2 = parseNode2.content(list);
                boolean bl2 = false;
                if (string2.length() == 1) {
                    for (char c : identifiers) {
                        if (string2.charAt(0) != c) continue;
                        bl2 = true;
                    }
                }
                if (bl || bl2) {
                    string2 = "'" + string2.toUpperCase() + "'";
                }
                treeSet.add(new RuleTuple(string, new String[]{string2}));
                SqlRules.addToDo(string2);
                continue;
            }
            if (!parseNode2.contains(rawbnf) && !parseNode2.contains(concat)) continue;
            treeSet.addAll(SqlRules.rawbnf(parseNode2, list, string, bl));
        }
        return treeSet;
    }

    private static Set<RuleTuple> concat(ParseNode parseNode, List<LexerToken> list, String string, boolean bl) {
        if (parseNode.contains(block)) {
            return SqlRules.block(parseNode, list, string, bl);
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        TreeSet<RuleTuple> treeSet = new TreeSet<RuleTuple>();
        for (ParseNode parseNode2 : parseNode.children()) {
            if (parseNode2.contains(identifier) && parseNode2.from + 1 == parseNode2.to) {
                String string2 = parseNode2.content(list);
                boolean bl2 = false;
                if (string2.length() == 1) {
                    for (char c : identifiers) {
                        if (string2.charAt(0) != c) continue;
                        bl2 = true;
                    }
                }
                if (bl || bl2) {
                    string2 = "'" + string2.toUpperCase() + "'";
                }
                linkedList.add(string2);
                SqlRules.addToDo(string2);
                continue;
            }
            if (parseNode2.contains(concat)) {
                int n = string.indexOf(91);
                String string3 = (0 < n ? string.substring(0, n) : string) + parseNode2.interval();
                Object object = SqlRules.concat(parseNode2, list, string3, bl);
                TreeSet<String[]> treeSet2 = new TreeSet<String[]>();
                Object object2 = object.iterator();
                while (object2.hasNext()) {
                    String[] stringArray = (RuleTuple)object2.next();
                    if (!stringArray.head.equals(string3)) continue;
                    treeSet2.add(stringArray);
                }
                if (treeSet2.size() == 1) {
                    object2 = null;
                    for (RuleTuple ruleTuple : treeSet2) {
                        object2 = ruleTuple;
                    }
                    object.remove(object2);
                    treeSet.addAll((Collection<RuleTuple>)object);
                    for (String string4 : ((RuleTuple)object2).rhs) {
                        linkedList.add(string4);
                    }
                    continue;
                }
                treeSet.addAll((Collection<RuleTuple>)object);
                linkedList.add(string3);
                continue;
            }
            if (!parseNode2.contains(block)) continue;
            int n = string.indexOf(91);
            String string5 = (0 < n ? string.substring(0, n) : string) + parseNode2.interval();
            treeSet.addAll(SqlRules.block(parseNode2, list, string5, bl));
            linkedList.add(string5);
        }
        RuleTuple ruleTuple = new RuleTuple(string, linkedList);
        treeSet.add(ruleTuple);
        return treeSet;
    }

    private static Set<RuleTuple> block(ParseNode parseNode, List<LexerToken> list, String string, boolean bl) {
        if (parseNode.contains(boldrawbnf)) {
            return SqlRules.boldrawbnf(parseNode, list, string);
        }
        if (parseNode.contains(identifier)) {
            String string2 = parseNode.content(list);
            boolean bl2 = false;
            if (string2.length() == 1) {
                for (char ruleTuple2 : identifiers) {
                    if (string2.charAt(0) != ruleTuple2) continue;
                    bl2 = true;
                }
            }
            if (bl || bl2) {
                string2 = "'" + string2.toUpperCase() + "'";
            }
            SqlRules.addToDo(string2);
            RuleTuple parseNode2 = new RuleTuple(string, new String[]{string2});
            TreeSet<RuleTuple> ruleTuple = new TreeSet<RuleTuple>();
            ruleTuple.add(parseNode2);
            return ruleTuple;
        }
        TreeSet<RuleTuple> treeSet = new TreeSet<RuleTuple>();
        for (ParseNode parseNode2 : parseNode.children()) {
            RuleTuple ruleTuple = new RuleTuple(string, new String[0]);
            if (parseNode2.contains(sqBr)) {
                treeSet.add(ruleTuple);
                continue;
            }
            if (parseNode2.contains(rawbnf)) {
                treeSet.addAll(SqlRules.rawbnf(parseNode2, list, string, false));
                continue;
            }
            if (!parseNode2.contains(dot)) continue;
            for (RuleTuple ruleTuple2 : treeSet) {
                if (!ruleTuple2.head.equals(string) || 0 >= ruleTuple2.rhs.length) continue;
                ruleTuple2.head = string + "#";
            }
            treeSet.add(new RuleTuple(string, new String[]{string + "#"}));
            treeSet.add(new RuleTuple(string, new String[]{string, string + "#"}));
            break;
        }
        return treeSet;
    }

    private static Set<RuleTuple> boldrawbnf(ParseNode parseNode, List<LexerToken> list, String string) {
        TreeSet<RuleTuple> treeSet = new TreeSet<RuleTuple>();
        for (ParseNode parseNode2 : parseNode.children()) {
            if (parseNode2.contains(rawbnf)) {
                treeSet.addAll(SqlRules.rawbnf(parseNode2, list, string, true));
                continue;
            }
            if (parseNode2.contains(lt)) {
                treeSet.add(new RuleTuple(string, new String[]{"'<'"}));
                continue;
            }
            if (parseNode2.contains(gt)) {
                treeSet.add(new RuleTuple(string, new String[]{"'>'"}));
                continue;
            }
            if (parseNode2.contains(lbr)) {
                treeSet.add(new RuleTuple(string, new String[]{"'['"}));
                continue;
            }
            if (parseNode2.contains(rbr)) {
                treeSet.add(new RuleTuple(string, new String[]{"']'"}));
                continue;
            }
            if (!parseNode2.contains(dbar)) continue;
            treeSet.add(new RuleTuple(string, new String[]{"'|'", "'|'"}));
        }
        if (treeSet.size() == 0) {
            throw new AssertionError((Object)("unexpected ret for " + string));
        }
        return treeSet;
    }

    static String readURL(String string) throws Exception {
        byte[] byArray = new byte[4096];
        int n = 0;
        URL uRL = new URL(string.toLowerCase());
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
        StringBuffer stringBuffer = new StringBuffer();
        n = bufferedInputStream.read(byArray, 0, byArray.length);
        StringBuffer stringBuffer2 = new StringBuffer();
        while (n != -1) {
            stringBuffer2.append(new String(byArray).substring(0, n));
            n = bufferedInputStream.read(byArray, 0, byArray.length);
        }
        String string2 = stringBuffer2.toString();
        int n2 = string2.indexOf("<p>Note:");
        if (n2 > 0) {
            string2 = string2.substring(0, n2);
        }
        if ((n2 = string2.indexOf("Note:")) > 0) {
            string2 = string2.substring(0, n2);
        }
        if ((n2 = string2.indexOf("</pre>")) < 0) {
            n2 = string2.indexOf("</PRE>");
        }
        if (n2 < 0) {
            string2 = string2 + "</pre>";
        }
        return string2;
    }

    static {
        try {
            earley = SqlRules.bnfParser();
            bnf = (Integer)SqlRules.earley.symbolIndexes.get("bnf");
            rawbnf = (Integer)SqlRules.earley.symbolIndexes.get("rawbnf");
            boldrawbnf = (Integer)SqlRules.earley.symbolIndexes.get("boldrawbnf");
            identifier = (Integer)SqlRules.earley.symbolIndexes.get("identifier");
            concat = (Integer)SqlRules.earley.symbolIndexes.get("concat");
            block = (Integer)SqlRules.earley.symbolIndexes.get("block");
            sqBr = (Integer)SqlRules.earley.symbolIndexes.get("'['");
            curlyBr = (Integer)SqlRules.earley.symbolIndexes.get("'{'");
            dot = (Integer)SqlRules.earley.symbolIndexes.get("'.'");
            lt = (Integer)SqlRules.earley.symbolIndexes.get("lt");
            gt = (Integer)SqlRules.earley.symbolIndexes.get("gt");
            lbr = (Integer)SqlRules.earley.symbolIndexes.get("lbr");
            rbr = (Integer)SqlRules.earley.symbolIndexes.get("rbr");
            dbar = (Integer)SqlRules.earley.symbolIndexes.get("dbar");
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
        missingSymbols = new TreeMap<String, String>();
        toDo = new HashSet<String>();
        notFound = new HashSet<String>();
        masterRules = new HashSet<String>();
        fixesParseTree = null;
        fixesScan = null;
    }
}

