/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.parser.CYK;
import oracle.dbtools.parser.CykCell;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.Visual;
import oracle.dbtools.parser.plsql.EssentialSQLRules;
import oracle.dbtools.parser.plsql.PlsqlCYK;
import oracle.dbtools.parser.plsql.SqlRules;
import oracle.dbtools.util.Service;

public class SqlCYK
extends CYK {
    private static SqlCYK instance = null;
    private Set<Integer> keywords = new TreeSet<Integer>();
    int identifier = (Integer)this.symbolIndexes.get("identifier");
    int string_literal = (Integer)this.symbolIndexes.get("string_literal");
    int digits = (Integer)this.symbolIndexes.get("digits");
    int expr = (Integer)this.symbolIndexes.get("expr");
    boolean tryMinSymbolSet = true;
    private static Map<Integer, int[]> essentialRhsRules = null;

    public static SqlCYK getInstance() {
        if (instance != null) {
            return instance;
        }
        SqlCYK.init();
        return instance;
    }

    public static void main(String[] stringArray) throws Exception {
        long l = Runtime.getRuntime().totalMemory();
        long l2 = Runtime.getRuntime().freeMemory();
        System.out.println("mem=" + (l - l2));
        SqlCYK sqlCYK = SqlCYK.getInstance();
        sqlCYK.printSelectedChomskiRules("simple_comparison_condition");
        System.out.println("1479*=" + sqlCYK.singleRhsRules[1479]);
        System.out.println("1853*=" + sqlCYK.singleRhsRules[1853]);
        System.out.println(sqlCYK.allSymbols.length);
        System.out.println(sqlCYK.doubleRhsRules.size());
        String string = Service.readFile(SqlCYK.class, "test.sql");
        List<LexerToken> list = LexerToken.parse(string);
        sqlCYK.tryMinSymbolSet = true;
        Visual visual = null;
        if (list.size() < 1000) {
            visual = new Visual(list, sqlCYK);
        }
        long l3 = System.currentTimeMillis();
        Matrix matrix = sqlCYK.initArray(list);
        long l4 = System.currentTimeMillis();
        System.out.println("Init array time = " + (l4 - l3));
        int n = matrix.size();
        TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>();
        l3 = System.currentTimeMillis();
        sqlCYK.closure(matrix, 0, n + 1, treeMap, -1);
        l4 = System.currentTimeMillis();
        System.out.println("Parse time = " + (l4 - l3));
        System.out.println(treeMap);
        instance.print(matrix, 0, n);
        if (visual != null) {
            visual.draw(matrix);
        }
        l3 = System.currentTimeMillis();
        ParseNode parseNode = instance.forest(list, matrix);
        l4 = System.currentTimeMillis();
        System.out.println("Reduction time = " + (l4 - l3));
        l = Runtime.getRuntime().totalMemory();
        l2 = Runtime.getRuntime().freeMemory();
        System.out.println("mem=" + (l - l2));
        if (list.size() < 1000) {
            parseNode.printTree();
        }
    }

    static void init() {
        try {
            Set<RuleTuple> set = SqlRules.getRules();
            instance = new SqlCYK(set);
            instance.initKeywords();
        }
        catch (Exception exception) {
            instance = null;
            Logger.getLogger(PlsqlCYK.class.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    void initKeywords() {
        this.keywords.add(this.getSymbol("'SELECT'"));
        this.keywords.add(this.getSymbol("'FROM'"));
        this.keywords.add(this.getSymbol("'WHERE'"));
        this.keywords.add(this.getSymbol("'AND'"));
        this.keywords.add(this.getSymbol("'OR'"));
        this.keywords.add(this.getSymbol("'NOT'"));
        this.keywords.add(this.getSymbol("'UNION'"));
        this.keywords.add(this.getSymbol("'ALL'"));
        this.keywords.add(this.getSymbol("'INNER'"));
        this.keywords.add(this.getSymbol("'LEFT'"));
        this.keywords.add(this.getSymbol("'NATURAL'"));
        this.keywords.add(this.getSymbol("'FULL'"));
        this.keywords.add(this.getSymbol("'OUTER'"));
        this.keywords.add(this.getSymbol("'JOIN'"));
        this.keywords.add(this.getSymbol("'CREATE'"));
        this.keywords.add(this.getSymbol("'ALTER'"));
        this.keywords.add(this.getSymbol("'TABLE'"));
        this.keywords.add(this.getSymbol("'TABLESPACE'"));
        this.keywords.add(this.getSymbol("'VALUES'"));
        this.keywords.add(this.getSymbol("'NUMBER'"));
        this.keywords.add(this.getSymbol("'VARCHAR2'"));
        this.keywords.add(this.getSymbol("'DATE'"));
        this.keywords.add(this.getSymbol("'INTEGER'"));
    }

    public SqlCYK(Set<RuleTuple> set) {
        super(set);
    }

    @Override
    protected void extractSymbols(Set<RuleTuple> set) {
        TreeSet<Object> treeSet = new TreeSet<Object>();
        for (RuleTuple serializable2 : set) {
            if (serializable2.head == null || serializable2.rhs[0] == null || serializable2.rhs.length > 1 && serializable2.rhs[1] == null) {
                throw new RuntimeException("ct has null symbols");
            }
            treeSet.add(serializable2.head);
            for (String string : serializable2.rhs) {
                treeSet.add(string);
            }
        }
        this.allSymbols = new String[treeSet.size() + 1];
        this.symbolIndexes = new TreeMap();
        int n = 0;
        if (treeSet.contains("exec")) {
            this.symbolIndexes.put("exec", n);
            this.allSymbols[n] = "exec";
            treeSet.remove("exec");
            ++n;
        }
        TreeSet<String> treeSet2 = new TreeSet<String>();
        for (String string : treeSet) {
            if (string.contains("+") || string.charAt(0) == '.' || string.charAt(string.length() - 1) == ')') continue;
            this.symbolIndexes.put(string, n);
            this.allSymbols[n] = string;
            treeSet2.add(string);
            ++n;
        }
        treeSet.removeAll(treeSet2);
        TreeSet<String> treeSet3 = new TreeSet<String>();
        for (String string : treeSet) {
            if (string.contains("+")) continue;
            this.symbolIndexes.put(string, n);
            this.allSymbols[n] = string;
            treeSet3.add(string);
            ++n;
        }
        treeSet.removeAll(treeSet3);
        TreeSet<String> treeSet4 = new TreeSet<String>();
        for (String string : treeSet) {
            this.symbolIndexes.put(string, n);
            this.allSymbols[n] = string;
            treeSet4.add(string);
            ++n;
        }
        treeSet.removeAll(treeSet4);
        this.symbolIndexes.put("identifier", n);
        this.allSymbols[n] = "identifier";
        ++n;
    }

    @Override
    public int[] atomicSymbols() {
        return new int[]{(Integer)this.symbolIndexes.get("scalar_subquery_expression"), (Integer)this.symbolIndexes.get("parenthesized_condition")};
    }

    @Override
    public Map<Integer, Integer> delimitedSymbols() {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        hashMap.put((Integer)this.symbolIndexes.get("select_list"), (Integer)this.symbolIndexes.get("','"));
        hashMap.put((Integer)this.symbolIndexes.get("condition"), (Integer)this.symbolIndexes.get("AND_OR"));
        hashMap.put((Integer)this.symbolIndexes.get("subquery"), (Integer)this.symbolIndexes.get("SET_OPER"));
        return hashMap;
    }

    @Override
    public void initArrayElement(Matrix matrix, int n, LexerToken lexerToken, boolean bl) {
        Integer n2 = (Integer)this.symbolIndexes.get("'" + lexerToken.content.toUpperCase() + "'");
        TreeSet treeSet = new TreeSet();
        if (n2 != null) {
            treeSet.addAll(this.singleRhsRules[n2]);
        }
        if (lexerToken.type == Token.IDENTIFIER) {
            if (n2 == null || !this.keywords.contains(n2)) {
                treeSet.addAll(this.singleRhsRules[this.identifier]);
            }
        } else if (lexerToken.type == Token.DQUOTED_STRING) {
            treeSet.addAll(this.singleRhsRules[this.identifier]);
        } else if (lexerToken.type == Token.QUOTED_STRING) {
            treeSet.addAll(this.singleRhsRules[this.string_literal]);
        } else if (lexerToken.type == Token.DIGITS) {
            treeSet.addAll(this.singleRhsRules[this.digits]);
        }
        int[] nArray = new int[treeSet.size()];
        int n3 = 0;
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            int n4 = (Integer)iterator.next();
            nArray[n3++] = n4;
        }
        matrix.put(Service.lPair(n, n + 1), new CykCell(nArray));
    }

    private boolean partialInitArray(List<LexerToken> list, Matrix matrix) {
        int n = 0;
        for (LexerToken lexerToken : list) {
            boolean bl = this.partialInitArrayElement(matrix, n, lexerToken);
            if (!bl) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean partialInitArrayElement(Matrix matrix, int n, LexerToken lexerToken) {
        Integer n2 = (Integer)this.symbolIndexes.get("'" + lexerToken.content.toUpperCase() + "'");
        int[] nArray = null;
        int[] nArray2 = null;
        if (n2 != null && (nArray = essentialRhsRules.get(n2)) == null) {
            return false;
        }
        if (lexerToken.type == Token.IDENTIFIER) {
            if (n2 == null || !this.keywords.contains(n2)) {
                nArray2 = essentialRhsRules.get(this.identifier);
            }
        } else if (lexerToken.type == Token.DQUOTED_STRING) {
            nArray2 = essentialRhsRules.get(this.identifier);
        } else if (lexerToken.type == Token.QUOTED_STRING) {
            nArray2 = essentialRhsRules.get(this.string_literal);
        } else if (lexerToken.type == Token.DIGITS) {
            nArray2 = essentialRhsRules.get(this.digits);
        }
        if (nArray2 == null && nArray == null) {
            return false;
        }
        int n3 = 0;
        if (nArray != null) {
            n3 += nArray.length;
        }
        if (nArray2 != null) {
            n3 += nArray2.length;
        }
        int[] nArray3 = new int[n3];
        int n4 = 0;
        if (nArray != null) {
            for (int n5 : nArray) {
                nArray3[n4++] = n5;
            }
        }
        if (nArray2 != null) {
            for (int n5 : nArray2) {
                nArray3[n4++] = n5;
            }
        }
        matrix.put(Service.lPair(n, n + 1), new CykCell(nArray3));
        return true;
    }

    @Override
    public Matrix initArray(List<LexerToken> list) {
        SqlCYK.initEssentials();
        Matrix matrix = new Matrix(this);
        if (this.tryMinSymbolSet && this.partialInitArray(list, matrix)) {
            return matrix;
        }
        super.initArray(list, matrix);
        return matrix;
    }

    @Override
    public Matrix initArray1(List<LexerToken> list) {
        return this.initArray(list);
    }

    public void printChomskiRulesHierachy(String string) {
        System.out.println("-------------Chomsky Rules Hierachy------------");
        int n = string.indexOf(91);
        LinkedList<CYK.ChomskiTuple> linkedList = new LinkedList<CYK.ChomskiTuple>();
        for (CYK.ChomskiTuple chomskiTuple : this.rules) {
            if (!this.allSymbols[chomskiTuple.head].contains(n > 0 ? string.substring(0, n) : string) && !this.allSymbols[chomskiTuple.rhs0].contains(string) && (chomskiTuple.rhs1 <= 0 || !this.allSymbols[chomskiTuple.rhs1].contains(string))) continue;
            linkedList.add(chomskiTuple);
        }
        this.printRule(string, linkedList, 0);
        System.out.println("-------------------------------------");
    }

    private void printRule(String string, List<CYK.ChomskiTuple> list, int n) {
        for (CYK.ChomskiTuple chomskiTuple : list) {
            if (!this.allSymbols[chomskiTuple.head].equals(string)) continue;
            Service.identln(n, chomskiTuple.toString());
            this.printRule(this.allSymbols[chomskiTuple.rhs0], list, n + 1);
            if (chomskiTuple.rhs1 < 0) continue;
            this.printRule(this.allSymbols[chomskiTuple.rhs1], list, n + 1);
        }
    }

    private static void initEssentials() {
        if (essentialRhsRules == null) {
            try {
                essentialRhsRules = EssentialSQLRules.getRules();
            }
            catch (Exception exception) {
                System.out.println("Failed to init essentialRhsRules: " + exception.getMessage());
                essentialRhsRules = new HashMap<Integer, int[]>();
            }
        }
    }
}

