/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql;

import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.parser.Grammar;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.RuleTransforms;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.plsql.UnitTest;
import oracle.dbtools.util.Service;

public class PlsqlRules {
    private static final String fname = "serializedPlsqlBNF.xml";
    private static final String path = "/oracle/dbtools/parser/plsql/";

    public static void main(String[] stringArray) throws Exception {
        throw new AssertionError((Object)"VT: broken");
    }

    private static void memorizeRules() throws Exception {
        Set<RuleTuple> set = PlsqlRules.extractRules();
        FileOutputStream fileOutputStream = new FileOutputStream("utils-nodeps/src/oracle/dbtools/parser/plsql/serializedPlsqlBNF.xml");
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        objectOutputStream.writeObject(set);
        objectOutputStream.close();
        RuleTuple.printRules(set);
    }

    public static Set<RuleTuple> getRules() throws Exception {
        URL uRL = PlsqlRules.class.getResource("/oracle/dbtools/parser/plsql/serializedPlsqlBNF.xml");
        InputStream inputStream = uRL.openStream();
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        Set set = (Set)objectInputStream.readObject();
        objectInputStream.close();
        return set;
    }

    public static Set<RuleTuple> parseBNFtext(String string) throws Exception {
        TreeSet<RuleTuple> treeSet = new TreeSet<RuleTuple>();
        List<LexerToken> list = LexerToken.parse(string);
        LinkedList<LexerToken> linkedList = new LinkedList<LexerToken>();
        for (LexerToken lexerToken : list) {
            if (lexerToken.content.charAt(0) != '.' && lexerToken.content.charAt(0) != '_' && lexerToken.content.charAt(lexerToken.content.length() - 1) == '_' && lexerToken.content.toUpperCase().equals(lexerToken.content)) {
                lexerToken.content = "'" + lexerToken.content.substring(0, lexerToken.content.length() - 1).toUpperCase() + "'";
            }
            linkedList.add(lexerToken);
        }
        ParseNode parseNode = Grammar.parseGrammarFile(linkedList, string);
        Grammar.grammar(parseNode, linkedList, treeSet);
        PlsqlRules.substituteExpr(treeSet);
        return treeSet;
    }

    private static void substituteExpr(Set<RuleTuple> set) {
        TreeSet<RuleTuple> treeSet = new TreeSet<RuleTuple>();
        TreeSet<RuleTuple> treeSet2 = new TreeSet<RuleTuple>();
        String string = "expr";
        String string2 = "pls_expr";
        boolean bl = false;
        for (RuleTuple ruleTuple : set) {
            RuleTuple ruleTuple2 = new RuleTuple(ruleTuple.head, new String[ruleTuple.rhs.length]);
            if (ruleTuple.head.equals(string)) {
                ruleTuple2.head = string2;
                bl = true;
            }
            for (int i = 0; i < ruleTuple.rhs.length; ++i) {
                if (ruleTuple.rhs[i].equals(string)) {
                    ruleTuple2.rhs[i] = string2;
                    bl = true;
                    continue;
                }
                ruleTuple2.rhs[i] = ruleTuple.rhs[i];
            }
            if (!bl) continue;
            treeSet.add(ruleTuple);
            treeSet2.add(ruleTuple2);
        }
        set.removeAll(treeSet);
        set.addAll(treeSet2);
    }

    private static Set<RuleTuple> extractRules() throws Exception {
        Set<RuleTuple> set = PlsqlRules.parseBNFtext(PlsqlRules.readBNFfile());
        PlsqlRules.numberRules(set);
        RuleTransforms.removeRules("dml_start", set);
        RuleTransforms.removeRules("ddl_start", set);
        RuleTransforms.removeRules("merge_", set);
        RuleTransforms.removeRules("seq_of_stmts", set);
        set.add(new RuleTuple("seq_of_stmts", new String[]{"..stmt.."}));
        set.remove(new RuleTuple("bulk_executable_stmt", new String[]{"static_dml_stmt"}));
        set.remove(new RuleTuple("unlabeled_nonblock_stmt", new String[]{"static_dml_stmt", "';'"}));
        set.remove(new RuleTuple("static_dml_stmt", new String[]{"dml_start", "'SQL_STMT'"}));
        set.remove(new RuleTuple("static_dml_stmt", new String[]{"'MERGE'", "'SQL_STMT'"}));
        set.remove(new RuleTuple("static_dml_stmt", new String[]{"merge_", "'SQL_STMT'"}));
        set.remove(new RuleTuple("unlabeled_nonblock_stmt", new String[]{"static_ddl_stmt", "';'"}));
        set.remove(new RuleTuple("static_ddl_stmt", new String[]{"ddl_start", "'SQL_STMT'"}));
        set.remove(new RuleTuple("loop_prm_spec", new String[]{"'SQL_STMT'"}));
        set.remove(new RuleTuple("curs_body", new String[]{"'SQL_STMT'"}));
        set.remove(new RuleTuple("cursor_open_statement", new String[]{"'SELECT'", "'SQL_STMT'"}));
        set.remove(new RuleTuple("cursor_open_statement", new String[]{"'WITH'", "'SQL_STMT'"}));
        set.remove(new RuleTuple("id_or_reserved", new String[]{"reserved_id"}));
        set.remove(new RuleTuple("selector", new String[]{"reserved_id"}));
        RuleTransforms.removeRules("reserved_id", set);
        RuleTransforms.removeRules("identifier", set);
        set.remove(new RuleTuple("binary_add_op", new String[]{"'&'"}));
        set.remove(new RuleTuple("binary_add_op", new String[]{"'CAT'"}));
        set.remove(new RuleTuple("mult_op", new String[]{"'MOD'"}));
        set.remove(new RuleTuple("mult_op", new String[]{"'REM'"}));
        set.remove(new RuleTuple("mult_op", new String[]{"'REMAINDER'"}));
        set.remove(new RuleTuple(".TYPE.", new String[]{"'TYPE'"}));
        set.add(new RuleTuple("bind_var", new String[]{"':'", "identifier"}));
        set.add(new RuleTuple("bind_var", new String[]{"':'", "digits"}));
        set.add(new RuleTuple("edit_compilation", new String[]{"'CREATE'", "compilation_unit"}));
        set.add(new RuleTuple("edit_compilation", new String[]{"'CREATE'", "'OR'", "'REPLACE'", "compilation_unit"}));
        set.add(new RuleTuple("exec", new String[]{"'EXEC'", "stmt"}));
        set.add(new RuleTuple("exec", new String[]{"'EXECUTE'", "stmt"}));
        set.add(new RuleTuple("from_table_reference_or_subquery", new String[]{"'('", "from_table_reference_or_subquery", "')'"}));
        set.add(new RuleTuple("join_type", new String[]{"'OUTER'"}));
        set.add(new RuleTuple("join_type", new String[]{"'FULL'"}));
        set.add(new RuleTuple("join_type", new String[]{"'CROSS'"}));
        set.add(new RuleTuple("join_type", new String[]{"'NATURAL'"}));
        set.add(new RuleTuple("join_type", new String[]{"'LEFT'"}));
        set.add(new RuleTuple("join_type", new String[]{"'RIGHT'"}));
        set.add(new RuleTuple("join_type", new String[]{"'INNER'"}));
        set.add(new RuleTuple("join_type3", new String[]{"'JOIN'"}));
        set.add(new RuleTuple("join_type3", new String[]{"join_type", "'JOIN'"}));
        set.add(new RuleTuple("join_type3", new String[]{"join_type", "join_type", "'JOIN'"}));
        set.add(new RuleTuple("on_condition", new String[]{"'ON'", "expr"}));
        set.add(new RuleTuple("on_condition", new String[]{"'USING'", "insupd_column_list"}));
        set.add(new RuleTuple("from_table_reference_or_subquery", new String[]{"from_table_reference_or_subquery", "join_type3", "from_table_reference_or_subquery", "on_condition"}));
        set.add(new RuleTuple("from_table_reference_or_subquery", new String[]{"from_table_reference_or_subquery", "join_type3", "from_table_reference_or_subquery"}));
        set.add(new RuleTuple("factor", new String[]{"table_subquery"}));
        set.add(new RuleTuple("cmpon_asc", new String[]{"query_expression"}));
        set.add(new RuleTuple("sel_expr", new String[]{"'CONNECT_BY_ROOT'", "expr"}));
        set.add(new RuleTuple("comparison_predicate", new String[]{"table_subquery", "relal_op", "sim_expr"}));
        set.add(new RuleTuple("set_function_specification", new String[]{"'COUNT'", "'('", "ALLorDISTINCT", "'*'", "')'"}));
        set.add(new RuleTuple("factors", new String[]{"procedure_call", "'AS'", "table_subquery"}));
        set.add(new RuleTuple("factors", new String[]{"factors", "','", "factors"}));
        set.add(new RuleTuple("sql_stmt", new String[]{"'WITH'", "factors", "select_statement"}));
        set.add(new RuleTuple("select_statement", new String[]{"ordered_subquery", "no_joke_order_by_clause"}));
        set.add(new RuleTuple("select_statement", new String[]{"query_expression"}));
        set.add(new RuleTuple("no_joke_order_by_clause", new String[]{"'ORDER'", "'SIBLINGS'", "'BY'", "...sort_specification.."}));
        RuleTransforms.removeRules("connect_by_clause", set);
        set.add(new RuleTuple("connect_by_subclause", new String[]{"'CONNECT'", "'BY'", "expr"}));
        set.add(new RuleTuple("connect_by_subclause", new String[]{"'CONNECT'", "'BY'", "'NOCYCLE'", "expr"}));
        set.add(new RuleTuple("connect_by_subclause", new String[]{"'CONNECT'", "'BY'", "expr", "'NOCYCLE'"}));
        set.add(new RuleTuple("start_with_subclause", new String[]{"'START'", "'WITH'", "expr"}));
        set.add(new RuleTuple("connect_by_clause", new String[]{"connect_by_subclause", "start_with_subclause"}));
        set.add(new RuleTuple("connect_by_clause", new String[]{"start_with_subclause", "connect_by_subclause"}));
        set.add(new RuleTuple("connect_by_clause", new String[]{"connect_by_subclause"}));
        RuleTransforms.removeRules("insert_statement", set);
        set.add(new RuleTuple("insert_into_clause", new String[]{"'INTO'", "table_reference_or_subquery", "insupd_column_list"}));
        set.add(new RuleTuple("insert_into_clause", new String[]{"'INTO'", "table_reference_or_subquery"}));
        set.add(new RuleTuple("insert_into_values_clause", new String[]{"insert_into_clause"}));
        set.add(new RuleTuple("insert_into_values_clause", new String[]{"insert_into_clause", "insert_stmt_values_seq"}));
        set.add(new RuleTuple("insert_into_values*", new String[]{"insert_into_values_clause"}));
        set.add(new RuleTuple("insert_into_values*", new String[]{"insert_into_values_clause", "insert_into_values*"}));
        set.add(new RuleTuple(".all_first.", new String[]{"'ALL'"}));
        set.add(new RuleTuple(".all_first.", new String[]{"'FIRST'"}));
        set.add(new RuleTuple(".all_first.", new String[0]));
        set.add(new RuleTuple("when_condition_clause", new String[]{"'WHEN'", "cond", "'THEN'", "insert_into_values*"}));
        set.add(new RuleTuple("when_condition*", new String[]{"when_condition_clause"}));
        set.add(new RuleTuple("when_condition*", new String[]{"when_condition_clause", "when_condition*"}));
        set.add(new RuleTuple(".else_insert_clause.", new String[0]));
        set.add(new RuleTuple(".else_insert_clause.", new String[]{"'ELSE'", "insert_into_values*"}));
        set.add(new RuleTuple("conditional_insert_clause", new String[]{".all_first.", "when_condition*", ".else_insert_clause."}));
        set.add(new RuleTuple("multi_table_insert", new String[]{"conditional_insert_clause", "query_expression"}));
        set.add(new RuleTuple("multi_table_insert", new String[]{"'ALL'", "insert_into_values*", ".else_insert_clause.", "query_expression"}));
        set.add(new RuleTuple("insert_statement", new String[]{"'INSERT'", "insert_into_clause", "insert_stmt_values_seq", ".returning_into_clause."}));
        set.add(new RuleTuple("insert_statement", new String[]{"'INSERT'", "insert_into_clause", "query_expression"}));
        set.add(new RuleTuple("insert_statement", new String[]{"'INSERT'", "multi_table_insert"}));
        set.add(new RuleTuple("over_clause", new String[]{"'OVER'", "'('", "analytic_clause", "')'"}));
        set.add(new RuleTuple("pri", new String[]{"procedure_call", "over_clause"}));
        set.add(new RuleTuple("pri", new String[]{"procedure_call", "'KEEP'", "'('", "keep_clause", "')'", "over_clause"}));
        set.add(new RuleTuple("pri", new String[]{"set_function_specification", "over_clause"}));
        set.add(new RuleTuple("analytic_clause", new String[]{"analytic_clause[0,3)", "analytic_clause[3,9)"}));
        set.add(new RuleTuple("analytic_clause[0,3)", new String[0]));
        set.add(new RuleTuple("analytic_clause[0,3)", new String[]{"query_partition_clause"}));
        set.add(new RuleTuple("analytic_clause[3,9)", new String[0]));
        set.add(new RuleTuple("analytic_clause[3,9)", new String[]{"analytic_clause[4,8)"}));
        set.add(new RuleTuple("analytic_clause[4,8)", new String[]{".order_by_clause.", "analytic_clause[5,8)"}));
        set.add(new RuleTuple("analytic_clause[5,8)", new String[0]));
        set.add(new RuleTuple("analytic_clause[5,8)", new String[]{"windowing_clause"}));
        set.add(new RuleTuple("query_partition_clause", new String[]{"'PARTITION'", "'BY'", "sim_expr", "...sim_expr.."}));
        set.add(new RuleTuple("query_partition_clause", new String[]{"'PARTITION'", "'BY'", "'('", "sim_expr", "...sim_expr..", "')'"}));
        set.add(new RuleTuple("windowing_clause", new String[]{"windowing_clause[1,4)", "windowing_clause[6,47)"}));
        set.add(new RuleTuple("windowing_clause[1,4)", new String[]{"'RANGE'"}));
        set.add(new RuleTuple("windowing_clause[1,4)", new String[]{"'ROWS'"}));
        set.add(new RuleTuple("windowing_clause[11,13)", new String[]{"'CURRENT'", "'ROW'"}));
        set.add(new RuleTuple("windowing_clause[11,20)", new String[]{"windowing_clause[11,13)"}));
        set.add(new RuleTuple("windowing_clause[11,20)", new String[]{"windowing_clause[14,20)"}));
        set.add(new RuleTuple("windowing_clause[14,20)", new String[]{"expr", "windowing_clause[16,19)"}));
        set.add(new RuleTuple("windowing_clause[16,19)", new String[]{"'FOLLOWING'"}));
        set.add(new RuleTuple("windowing_clause[16,19)", new String[]{"'PRECEDING'"}));
        set.add(new RuleTuple("windowing_clause[21,36)", new String[]{"'AND'", "windowing_clause[23,35)"}));
        set.add(new RuleTuple("windowing_clause[23,35)", new String[]{"'UNBOUNDED'", "'FOLLOWING'"}));
        set.add(new RuleTuple("windowing_clause[23,35)", new String[]{"windowing_clause[26,35)"}));
        set.add(new RuleTuple("windowing_clause[26,28)", new String[]{"'CURRENT'", "'ROW'"}));
        set.add(new RuleTuple("windowing_clause[26,35)", new String[]{"windowing_clause[26,28)"}));
        set.add(new RuleTuple("windowing_clause[26,35)", new String[]{"windowing_clause[29,35)"}));
        set.add(new RuleTuple("windowing_clause[29,35)", new String[]{"expr", "windowing_clause[31,34)"}));
        set.add(new RuleTuple("windowing_clause[31,34)", new String[]{"'FOLLOWING'"}));
        set.add(new RuleTuple("windowing_clause[31,34)", new String[]{"'PRECEDING'"}));
        set.add(new RuleTuple("windowing_clause[38,46)", new String[]{"'UNBOUNDED'", "'PRECEDING'"}));
        set.add(new RuleTuple("windowing_clause[38,46)", new String[]{"windowing_clause[41,46)"}));
        set.add(new RuleTuple("windowing_clause[41,46)", new String[]{"'CURRENT'", "'ROW'"}));
        set.add(new RuleTuple("windowing_clause[41,46)", new String[]{"windowing_clause[44,46)"}));
        set.add(new RuleTuple("windowing_clause[44,46)", new String[]{"expr", "'PRECEDING'"}));
        set.add(new RuleTuple("windowing_clause[6,36)", new String[]{"'BETWEEN'", "windowing_clause[7,36)"}));
        set.add(new RuleTuple("windowing_clause[6,47)", new String[]{"windowing_clause[38,46)"}));
        set.add(new RuleTuple("windowing_clause[6,47)", new String[]{"windowing_clause[6,36)"}));
        set.add(new RuleTuple("windowing_clause[7,36)", new String[]{"windowing_clause[8,20)", "windowing_clause[21,36)"}));
        set.add(new RuleTuple("windowing_clause[8,20)", new String[]{"windowing_clause[11,20)"}));
        set.add(new RuleTuple("windowing_clause[8,20)", new String[]{"'UNBOUNDED'", "'PRECEDING'"}));
        set.add(new RuleTuple("keep_clause", new String[]{"keep_col"}));
        set.add(new RuleTuple("keep_clause", new String[]{"keep_clause", "keep_col"}));
        set.add(new RuleTuple("keep_col", new String[]{"'DENSE_RANK'", "first_last", "analytic_clause"}));
        set.add(new RuleTuple("first_last", new String[]{"'FIRST'"}));
        set.add(new RuleTuple("first_last", new String[]{"'LAST'"}));
        set.add(new RuleTuple("flashback_query_clause", new String[]{"flashback_query_clause[72,108)"}));
        set.add(new RuleTuple("flashback_query_clause", new String[]{"flashback_query_clause[4,71)"}));
        set.add(new RuleTuple("flashback_query_clause", new String[]{"flashback_query_clause[4,71)", "flashback_query_clause[72,108)"}));
        set.add(new RuleTuple("flashback_query_clause[12,71)", new String[]{"'BETWEEN'", "flashback_query_clause[20,71)"}));
        set.add(new RuleTuple("flashback_query_clause[20,71)", new String[]{"scn_or_timestamp", "expr_or_minval_and_expr_or_maxval"}));
        set.add(new RuleTuple("scn_or_timestamp", new String[]{"'SCN'"}));
        set.add(new RuleTuple("scn_or_timestamp", new String[]{"'TIMESTAMP'"}));
        set.add(new RuleTuple("expr_or_minval_and_expr_or_maxval", new String[]{"expr_or_minval", "and_expr_or_maxval"}));
        set.add(new RuleTuple("flashback_query_clause[4,71)", new String[]{"'VERSIONS'", "flashback_query_clause[12,71)"}));
        set.add(new RuleTuple("expr_or_minval", new String[]{"sim_expr"}));
        set.add(new RuleTuple("expr_or_minval", new String[]{"'MINVALUE'"}));
        set.add(new RuleTuple("and_expr_or_maxval", new String[]{"'AND'", "sim_expr"}));
        set.add(new RuleTuple("and_expr_or_maxval", new String[]{"'AND'", "'MAXVALUE'"}));
        set.add(new RuleTuple("flashback_query_clause[72,108)", new String[]{"'AS'", "flashback_query_clause[80,108)"}));
        set.add(new RuleTuple("flashback_query_clause[80,108)", new String[]{"'OF'", "flashback_query_clause[88,108)"}));
        set.add(new RuleTuple("flashback_query_clause[88,108)", new String[]{"scn_or_timestamp", "sim_expr"}));
        set.add(new RuleTuple("table_reference_or_subquery", new String[]{"link_expanded_n_optional_partition", "flashback_query_clause", "identifier"}));
        set.add(new RuleTuple("table_reference_or_subquery", new String[]{"link_expanded_n_optional_partition", "flashback_query_clause"}));
        RuleTransforms.removeRules("sort_specification", set);
        set.add(new RuleTuple(".nulls_first_last.", new String[]{"'NULLS'", "'FIRST'"}));
        set.add(new RuleTuple(".nulls_first_last.", new String[]{"'NULLS'", "'LAST'"}));
        set.add(new RuleTuple(".nulls_first_last.", new String[0]));
        set.add(new RuleTuple(".asc_desc.", new String[]{"'ASC'"}));
        set.add(new RuleTuple(".asc_desc.", new String[]{"'DESC'"}));
        set.add(new RuleTuple(".asc_desc.", new String[0]));
        set.add(new RuleTuple("sort_specification", new String[]{"sim_expr", ".asc_desc.", ".nulls_first_last."}));
        set.add(new RuleTuple("pivot_in_clause", new String[]{"in_predicate"}));
        set.add(new RuleTuple("pivot_in_clause", new String[]{"sim_expr", "'IN'", "'('", "select_list", "')'"}));
        set.add(new RuleTuple("unpivot_list", new String[]{"valued_col"}));
        set.add(new RuleTuple("unpivot_list", new String[]{"unpivot_list", "','", "valued_col"}));
        set.add(new RuleTuple("valued_col", new String[]{"identifier"}));
        set.add(new RuleTuple("valued_col", new String[]{"identifier", "'AS'", "sim_expr"}));
        set.add(new RuleTuple("unpivot_in_clause", new String[]{"sim_expr", "'IN'", "'('", "unpivot_list", "')'"}));
        set.add(new RuleTuple("pivot_clause", new String[]{"'PIVOT'", "'('", "idxed_cmpon", "'FOR'", "pivot_in_clause", "')'"}));
        set.add(new RuleTuple("unpivot_clause", new String[]{"'UNPIVOT'", "'('", "sim_expr", "'FOR'", "unpivot_in_clause", "')'"}));
        set.add(new RuleTuple("table_expression_clause", new String[]{"pivot_clause"}));
        set.add(new RuleTuple("table_expression_clause", new String[]{"unpivot_clause"}));
        set.addAll(PlsqlRules.additionalFixes());
        RuleTransforms.printSelectedRules("..stmt..", set);
        RuleTransforms.eliminateEmptyProductions(set);
        RuleTransforms.printSelectedRules("..stmt..", set);
        return set;
    }

    private static Set<RuleTuple> additionalFixes() throws Exception {
        String string = Service.readFile(UnitTest.class, "PlsqlFixes.grammar");
        List<LexerToken> list = LexerToken.parse(string);
        ParseNode parseNode = Grammar.parseGrammarFile(list, string);
        TreeSet<RuleTuple> treeSet = new TreeSet<RuleTuple>();
        Grammar.grammar(parseNode, list, treeSet);
        return treeSet;
    }

    public static void numberRules(Set<RuleTuple> set) {
        set.add(new RuleTuple(".fd.", new String[0]));
        set.add(new RuleTuple(".fd.", new String[]{"'f'"}));
        set.add(new RuleTuple(".fd.", new String[]{"'d'"}));
        set.add(new RuleTuple(".+-.", new String[0]));
        set.add(new RuleTuple(".+-.", new String[]{"'+'"}));
        set.add(new RuleTuple(".+-.", new String[]{"'-'"}));
        set.add(new RuleTuple(".exp.", new String[0]));
        set.add(new RuleTuple(".exp.", new String[]{"'E'", ".+-.", "digits"}));
        set.add(new RuleTuple("numeric_literal", new String[]{"digits", ".exp.", ".fd."}));
        set.add(new RuleTuple("numeric_literal", new String[]{"digits", "'.'", ".exp.", ".fd."}));
        set.add(new RuleTuple("numeric_literal", new String[]{"'.'", "digits", ".exp.", ".fd."}));
        set.add(new RuleTuple("numeric_literal", new String[]{"digits", "'.'", "digits", ".exp.", ".fd."}));
    }

    public static Set<String> getKeywords(Set<RuleTuple> set) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (RuleTuple ruleTuple : set) {
            for (String string : ruleTuple.rhs) {
                if (!string.startsWith("'")) continue;
                treeSet.add(string);
            }
        }
        return treeSet;
    }

    static String readBNFfile() throws Exception {
        String string = Service.readFile(PlsqlRules.class, "plsql.y");
        string = string.substring(string.indexOf("/*---------------------------- Start of Rules -------------------------------*/") + "/*---------------------------- Start of Rules -------------------------------*/".length());
        string = PlsqlRules.removeNestedBlock(string, "/*", "*/");
        string = PlsqlRules.removeNestedBlock(string, "{", "}");
        string = PlsqlRules.removeNestedBlock(string, "{", "}");
        string = PlsqlRules.removeNestedBlock(string, "{", "}");
        string = PlsqlRules.removeNestedBlock(string, "{", "}");
        string = string.replace("ASSIGN_", "':' '='");
        string = string.replace("LTEQ_", "'<' '='");
        string = string.replace("GTEQL_", "'>' '='");
        string = string.replace("NOTEQL_", "'!' '='");
        string = string.replace("BOX_", "'<' '>'");
        string = string.replace("CAT_", "'|' '|'");
        string = string.replace(" DBLDOT_ ", " '.' '.' ");
        string = string.replace("ARROW_", "'=' '>'");
        string = string.replace("EXP_ pri", "'*' '*' pri");
        string = string.replace("L_LBL_", "'<' '<'");
        string = string.replace("R_LBL_", "'>' '>'");
        string = string.replace(" INDICATOR_ ", " ':' ");
        string = string.replace("')'", " ')' ");
        string = string.replace("'('", " '(' ");
        string = string.replace("%%", "");
        string = string.replace("bind_var.INDICATOR_id.", "\"bind_var.INDICATOR_id.\"");
        string = string.replace("...from_table_reference_or_subquery..", "\"...from_table_reference_or_subquery..\"");
        return string;
    }

    static String removeNestedBlock(String string, String string2, String string3) {
        int n = string2.length();
        int n2 = string3.length();
        int n3 = 0;
        int n4 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (n3 < string.length()) {
            n3 = string.indexOf(string2, n4);
            int n5 = string.indexOf(string2, n3 + n);
            int n6 = string.indexOf(string3, n3 + n) + n2;
            if (n3 > 0 && n3 < n5 && n5 < n6) {
                stringBuffer.append(string.substring(n4, n3 + n));
                n4 = n3 + n;
                continue;
            }
            if (n3 < 0) {
                n3 = string.length();
            }
            stringBuffer.append(string.substring(n4, n3));
            n4 = string.indexOf(string3, n3 + n) + n2;
            if (n4 >= n2) continue;
            stringBuffer.append(string.substring(n3));
            break;
        }
        return stringBuffer.toString();
    }
}

