/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.parser.CYK;
import oracle.dbtools.parser.Cell;
import oracle.dbtools.parser.CykCell;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.Visual;
import oracle.dbtools.parser.plsql.PlsqlRules;
import oracle.dbtools.util.Array;
import oracle.dbtools.util.Service;

public class PlsqlCYK
extends CYK {
    public static PlsqlCYK instance;
    private Set<Integer> keywords = new TreeSet<Integer>();
    static boolean debug;
    private int body = this.getSymbol("body");
    private int stmt = this.getSymbol("stmt");
    private int fml_part = this.getSymbol("fml_part");
    private int plain_subquery = this.getSymbol("plain_subquery");
    private int query_term = -1;
    private int set_operator = -1;
    private int binary_add_op = -1;
    private int procedure_call = -1;
    private int expr = -1;
    private int orSymbol = -1;
    private int andSymbol = -1;
    private int verticalStrokeSymbol = -1;
    private int commaSymbol = -1;
    private int semicolonSymbol = -1;
    private int allSymbol = -1;
    private int beginSymbol = -1;
    private int dotdotAND__reldotdot = -1;
    private int dotdot_basic_decl_item_dotdot = this.getSymbol("..basic_decl_item..");
    private int dotdot_dotprm_specdotdot = -1;
    private int dotdotdotsim_expr_dotiddotdotdot = -1;
    private int dotdotdotcmpon_ascdotdot = -1;
    private int dotdotstmtdotdot = -1;
    private int termdotdotbinary_add_op__termdotdot = -1;
    private int idents = -1;
    private int table_reference_or_subquery = -1;
    private int from_table_reference_or_subquery = -1;
    private int identifier = -1;
    private final int maxKwdIdx;

    public static PlsqlCYK getInstance() {
        if (instance != null) {
            return instance;
        }
        return instance;
    }

    static void init() {
        try {
            Set<RuleTuple> set = PlsqlRules.getRules();
            set.add(new RuleTuple("cursor_subquery", new String[]{"'CURSOR'", "'('", "query_expression", "order_by_clause_opt", "')'"}));
            set.add(new RuleTuple("cursor_subquery", new String[]{"'CURSOR'", "'('", "query_expression", "')'"}));
            instance = new PlsqlCYK(set);
        }
        catch (Exception exception) {
            Logger.getLogger(PlsqlCYK.class.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        long l = Runtime.getRuntime().totalMemory();
        long l2 = Runtime.getRuntime().freeMemory();
        System.out.println("mem=" + (l - l2));
        String string = Service.readFile(PlsqlCYK.class, "test.sql");
        PlsqlCYK plsqlCYK = PlsqlCYK.getInstance();
        plsqlCYK.printSelectedChomskiRules("table_subquery");
        long l3 = System.currentTimeMillis();
        List<LexerToken> list = LexerToken.parse(string);
        long l4 = System.currentTimeMillis();
        System.out.println("Lexer time = " + (l4 - l3));
        Visual visual = null;
        if (list.size() < 1000) {
            visual = new Visual(list, plsqlCYK);
        }
        l = Runtime.getRuntime().totalMemory();
        l2 = Runtime.getRuntime().freeMemory();
        System.out.println("mem=" + (l - l2));
        l3 = System.currentTimeMillis();
        Matrix matrix = plsqlCYK.initArray1(list);
        l4 = System.currentTimeMillis();
        System.out.println("Init array time = " + (l4 - l3));
        int n = matrix.size();
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        l3 = System.currentTimeMillis();
        ((CYK)plsqlCYK).closure(matrix, 0, n + 1, hashMap, -1);
        l4 = System.currentTimeMillis();
        System.out.println("Parse time = " + (l4 - l3));
        System.out.println(hashMap);
        plsqlCYK.print(matrix, 0, n);
        System.out.println("^^^^^^^^^^^^^");
        if (visual != null) {
            visual.draw(matrix);
        }
        l3 = System.currentTimeMillis();
        ParseNode parseNode = plsqlCYK.forest(list, matrix);
        l4 = System.currentTimeMillis();
        System.out.println("Reduction time = " + (l4 - l3));
        System.gc();
        l = Runtime.getRuntime().totalMemory();
        l2 = Runtime.getRuntime().freeMemory();
        System.out.println("mem=" + (l - l2));
        if (list.size() < 1000) {
            parseNode.printTree();
        }
        for (ParseNode parseNode2 : parseNode.descendants()) {
            if (!parseNode2.contains((Integer)plsqlCYK.symbolIndexes.get("stmt"))) continue;
        }
    }

    private PlsqlCYK(Set<RuleTuple> set) {
        super(set);
        this.expr = this.getSymbol("expr");
        this.query_term = this.getSymbol("query_term");
        this.set_operator = this.getSymbol("set_operator");
        this.procedure_call = this.getSymbol("procedure_call");
        this.allSymbol = this.getSymbol("'ALL'");
        this.beginSymbol = this.getSymbol("'BEGIN'");
        this.dotdotAND__reldotdot = this.getSymbol("..AND__rel..");
        this.andSymbol = this.getSymbol("'AND'");
        this.orSymbol = this.getSymbol("'OR'");
        this.commaSymbol = this.getSymbol("','");
        this.semicolonSymbol = this.getSymbol("';'");
        this.verticalStrokeSymbol = this.getSymbol("'|'");
        this.dotdot_dotprm_specdotdot = this.getSymbol(".._.prm_spec..");
        this.dotdotdotsim_expr_dotiddotdotdot = this.getSymbol("...sim_expr_.id...");
        this.dotdotdotcmpon_ascdotdot = this.getSymbol("...cmpon_asc..");
        this.dotdotstmtdotdot = this.getSymbol("..stmt..");
        this.binary_add_op = this.getSymbol("binary_add_op");
        this.termdotdotbinary_add_op__termdotdot = this.getSymbol("term..binary_add_op__term..");
        this.idents = this.getSymbol("idents");
        this.table_reference_or_subquery = this.getSymbol("table_reference_or_subquery");
        this.from_table_reference_or_subquery = this.getSymbol("from_table_reference_or_subquery");
        this.identifier = this.getSymbol("identifier");
        this.maxKwdIdx = this.getSymbol("'|'");
        this.keywords.add(this.getSymbol("'IF'"));
        this.keywords.add(this.beginSymbol);
        this.keywords.add(this.getSymbol("'ELSE'"));
        this.keywords.add(this.getSymbol("'THEN'"));
        this.keywords.add(this.getSymbol("'ELSIF'"));
        this.keywords.add(this.getSymbol("'CHAR'"));
        this.keywords.add(this.getSymbol("'FOR'"));
        this.keywords.add(this.getSymbol("'LOOP'"));
        this.keywords.add(this.getSymbol("'WITH'"));
        this.keywords.add(this.getSymbol("'SELECT'"));
        this.keywords.add(this.getSymbol("'FROM'"));
        this.keywords.add(this.getSymbol("'WHERE'"));
        this.keywords.add(this.getSymbol("'AND'"));
        this.keywords.add(this.getSymbol("'NOT'"));
        this.keywords.add(this.getSymbol("'OR'"));
        this.keywords.add(this.getSymbol("'PROCEDURE'"));
        this.keywords.add(this.getSymbol("'IS'"));
        this.keywords.add(this.getSymbol("'AS'"));
        this.keywords.add(this.getSymbol("'EXCEPTION'"));
        this.keywords.add(this.getSymbol("'IN'"));
        this.keywords.add(this.getSymbol("'RETURN'"));
        this.keywords.add(this.getSymbol("'NULL'"));
        this.keywords.add(this.getSymbol("'CURSOR'"));
    }

    private boolean containsKwd(Cell cell) {
        if (cell == null) {
            return false;
        }
        for (int n : cell.getContent()) {
            if (n > this.maxKwdIdx) continue;
            return true;
        }
        return false;
    }

    @Override
    public void initArrayElement(Matrix matrix, int n, LexerToken lexerToken, boolean bl) {
        int n2;
        Integer n3 = (Integer)this.symbolIndexes.get("'" + lexerToken.content.toUpperCase() + "'");
        TreeSet treeSet = new TreeSet();
        if (n3 != null) {
            treeSet.addAll(this.singleRhsRules[n3]);
        }
        if (lexerToken.type == Token.IDENTIFIER) {
            if (!bl || n3 == null || !this.keywords.contains(n3)) {
                treeSet.addAll(this.singleRhsRules[this.identifier]);
            }
        } else if (lexerToken.type == Token.DQUOTED_STRING) {
            treeSet.addAll(this.singleRhsRules[this.identifier]);
        } else if (lexerToken.type == Token.QUOTED_STRING) {
            n2 = (Integer)this.symbolIndexes.get("string_literal");
            treeSet.addAll(this.singleRhsRules[n2]);
        } else if (lexerToken.type == Token.DIGITS) {
            n2 = (Integer)this.symbolIndexes.get("digits");
            treeSet.addAll(this.singleRhsRules[n2]);
        }
        int[] nArray = new int[treeSet.size()];
        int n4 = 0;
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            int n5 = (Integer)iterator.next();
            nArray[n4++] = n5;
        }
        matrix.put(Service.lPair(n, n + 1), new CykCell(nArray));
    }

    @Override
    public void closure(Matrix matrix, int n, int n2, Map<Integer, Integer> map, int n3) {
        for (int i = 1; i < n2; ++i) {
            block1: for (int j = i - 2; j >= n; --j) {
                Object object;
                Integer n4;
                if (map != null && (n4 = map.get(j)) != null) {
                    if (Visual.skipped != null) {
                        for (int k = j; k > n4; --k) {
                            Visual.skipped[k][i] = Visual.causes.get(Service.lPair(j, n4));
                        }
                    }
                    j = n4 + 1;
                    continue;
                }
                long l = Service.lPair(j, i);
                long l2 = Service.lPair(0, i + 1);
                int[] nArray = null;
                SortedMap sortedMap = matrix.subMap(l, l2);
                for (long l3 : sortedMap.keySet()) {
                    Cell cell;
                    object = Service.lX(l3);
                    Cell cell2 = (Cell)matrix.get(Service.lPair(j, object));
                    if (cell2 == null || (cell = (Cell)matrix.get(Service.lPair(object, i))) == null) continue;
                    for (int n5 : cell2.getContent()) {
                        for (int n6 : cell.getContent()) {
                            int[] nArray2 = (int[])this.doubleRhsRules.get(Service.pair(n5, n6));
                            if (nArray2 == null) continue;
                            nArray = Array.merge(nArray, nArray2);
                        }
                    }
                }
                if (nArray == null) continue;
                matrix.put(Service.lPair(j, i), new CykCell(nArray));
                if (map == null || i - 1 == j + 1 || n3 >= 0 && (j <= n3 && n3 < i || j <= n3 + 3 && n3 + 3 < i)) continue;
                Iterator<Long> iterator = nArray;
                int n7 = ((Iterator<Long>)iterator).length;
                for (int k = 0; k < n7; ++k) {
                    int n8;
                    int n9;
                    object = iterator[k];
                    if (object == this.body || object == this.fml_part || object == this.plain_subquery || object == this.dotdotstmtdotdot && j > 1 && PlsqlCYK.containsEither((Cell)matrix.get(Service.lPair(j - 1, j)), new int[]{this.semicolonSymbol, this.beginSymbol}) || object == this.dotdot_basic_decl_item_dotdot && j > 1 && PlsqlCYK.containsSymbol((Cell)matrix.get(Service.lPair(j - 1, j)), this.semicolonSymbol) && !PlsqlCYK.containsSymbol((Cell)matrix.get(Service.lPair(j, j + 1)), this.beginSymbol) || object == this.query_term && j > 1 && (PlsqlCYK.containsSymbol((Cell)matrix.get(Service.lPair(j - 1, j)), this.set_operator) || PlsqlCYK.containsSymbol((Cell)matrix.get(Service.lPair(j - 2, j - 1)), this.set_operator) && PlsqlCYK.containsSymbol((Cell)matrix.get(Service.lPair(j - 1, j)), this.allSymbol)) && i < n2 - 1 && PlsqlCYK.containsSymbol((Cell)matrix.get(Service.lPair(i, i + 1)), this.set_operator) || object == this.termdotdotbinary_add_op__termdotdot && j > 1 && (PlsqlCYK.containsSymbol((Cell)matrix.get(Service.lPair(j - 1, j)), this.binary_add_op) || PlsqlCYK.containsSymbol((Cell)matrix.get(Service.lPair(j - 2, j - 1)), this.verticalStrokeSymbol) && PlsqlCYK.containsSymbol((Cell)matrix.get(Service.lPair(j - 1, j)), this.verticalStrokeSymbol)) && i < n2 - 2 && (PlsqlCYK.containsSymbol((Cell)matrix.get(Service.lPair(i, i + 1)), this.binary_add_op) || PlsqlCYK.containsSymbol((Cell)matrix.get(Service.lPair(i, i + 1)), this.verticalStrokeSymbol) && PlsqlCYK.containsSymbol((Cell)matrix.get(Service.lPair(i + 1, i + 2)), this.verticalStrokeSymbol)) || object == this.expr && j > 0 && PlsqlCYK.containsSymbol((Cell)matrix.get(Service.lPair(j - 1, j)), this.orSymbol) && PlsqlCYK.containsSymbol((Cell)matrix.get(Service.lPair(i, i + 1)), this.orSymbol) || object == this.procedure_call && !this.containsKwd((Cell)matrix.get(Service.lPair(j, j + 1))) || object == this.dotdotAND__reldotdot && j > 0 && PlsqlCYK.containsSymbol((Cell)matrix.get(Service.lPair(j - 1, j)), this.andSymbol) && PlsqlCYK.containsSymbol((Cell)matrix.get(Service.lPair(i, i + 1)), this.andSymbol)) {
                        int n10 = j;
                        int n11 = i - 1;
                        map.put(n11, n10);
                        if (Visual.skipped == null) continue block1;
                        if (Visual.causes.get(Service.lPair(n11, n10)) != null) {
                            throw new AssertionError((Object)"Visual.causes.get(Service.lPair(Y,X))!=null");
                        }
                        Visual.causes.put(Service.lPair(n11, n10), (Integer)object);
                        continue block1;
                    }
                    if (i < j + 6 || (object != this.dotdot_dotprm_specdotdot || i >= n2 - 1 || !PlsqlCYK.containsSymbol((Cell)matrix.get(Service.lPair(i, i + 1)), this.commaSymbol)) && object != this.dotdotdotsim_expr_dotiddotdotdot && object != this.dotdotdotcmpon_ascdotdot || (n9 = PlsqlCYK.splitInterval(matrix, j, i, object, true)) == -1 || (n8 = PlsqlCYK.splitInterval(matrix, n9, i, object, false)) == -1) continue;
                    if (n8 <= n9) {
                        throw new AssertionError((Object)"iY <= iX");
                    }
                    int n12 = this.next(n9, map);
                    int n13 = n8 - 1;
                    map.put(n13, n12);
                    if (Visual.skipped == null) continue block1;
                    Visual.causes.put(Service.lPair(n13, n12), (Integer)object);
                    continue block1;
                }
            }
        }
    }

    static {
        PlsqlCYK.init();
        debug = true;
    }
}

