/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.Visual;
import oracle.dbtools.parser.plsql.SyntaxError;

public class Grammar {
    private static Earley earley = Grammar.bnfParser();
    static int rule;
    static int grammar;
    static int variable;
    static int disjunct;
    static int concat;
    static int or;
    static int minus;

    private static Earley bnfParser() {
        TreeSet<RuleTuple> treeSet = new TreeSet<RuleTuple>();
        treeSet.add(new RuleTuple("variable", new String[]{"identifier"}));
        treeSet.add(new RuleTuple("variable", new String[]{"string_literal"}));
        treeSet.add(new RuleTuple("concat", new String[]{"variable"}));
        treeSet.add(new RuleTuple("concat", new String[]{"concat", "variable"}));
        treeSet.add(new RuleTuple("disjunct", new String[]{"concat"}));
        treeSet.add(new RuleTuple("disjunct", new String[]{"'|'", "concat"}));
        treeSet.add(new RuleTuple("disjunct", new String[]{"disjunct", "'|'", "concat"}));
        treeSet.add(new RuleTuple("disjunct", new String[]{"disjunct", "'|'"}));
        treeSet.add(new RuleTuple("rule", new String[]{"variable", "':'", "disjunct", "';'"}));
        treeSet.add(new RuleTuple("rule", new String[]{"variable", "':'", "';'"}));
        treeSet.add(new RuleTuple("rule", new String[]{"'-'", "variable", "';'"}));
        treeSet.add(new RuleTuple("grammar", new String[]{"rule"}));
        treeSet.add(new RuleTuple("grammar", new String[]{"grammar", "rule"}));
        TreeSet<RuleTuple> treeSet2 = treeSet;
        earley = new Earley(treeSet2){

            @Override
            protected boolean isIdentifier(int n, List<LexerToken> list, int n2, Integer n3) {
                LexerToken lexerToken = list.get(n);
                return n2 == this.identifier && lexerToken.type == Token.IDENTIFIER || n2 == this.identifier && lexerToken.type == Token.DQUOTED_STRING;
            }
        };
        rule = (Integer)Grammar.earley.symbolIndexes.get("rule");
        grammar = (Integer)Grammar.earley.symbolIndexes.get("grammar");
        variable = (Integer)Grammar.earley.symbolIndexes.get("variable");
        disjunct = (Integer)Grammar.earley.symbolIndexes.get("disjunct");
        concat = (Integer)Grammar.earley.symbolIndexes.get("concat");
        or = (Integer)Grammar.earley.symbolIndexes.get("'|'");
        minus = (Integer)Grammar.earley.symbolIndexes.get("'-'");
        return earley;
    }

    public static void main(String[] stringArray) throws Exception {
        String string = "x: a b c | A | B;";
        List<LexerToken> list = LexerToken.parse(string);
        ParseNode parseNode = Grammar.parseGrammarFile(list, string);
        parseNode.printTree();
        TreeSet<RuleTuple> treeSet = new TreeSet<RuleTuple>();
        Grammar.grammar(parseNode, list, treeSet);
        RuleTuple.printRules(treeSet);
    }

    public static ParseNode parseGrammarFile(List<LexerToken> list, String string) throws Exception {
        Visual visual = null;
        Matrix matrix = new Matrix(earley);
        earley.parse(list, matrix);
        SyntaxError syntaxError = SyntaxError.checkSyntax(string, new String[]{"grammar"}, list, earley, matrix);
        if (syntaxError != null) {
            if (visual != null) {
                visual.draw(matrix);
            }
            System.out.println("Syntax Error");
            System.out.println("at line#" + syntaxError.line);
            System.out.println(syntaxError.code);
            System.out.println(syntaxError.marker);
            System.out.println("Expected:  ");
            for (String string2 : syntaxError.suggestions) {
                System.out.print(string2 + ',');
            }
            throw new Exception(">>>> syntactically invalid code fragment <<<<");
        }
        ParseNode parseNode = earley.forest(list, matrix);
        return parseNode;
    }

    public static void grammar(ParseNode parseNode, List<LexerToken> list, Set<RuleTuple> set) {
        if (parseNode.contains(rule)) {
            Grammar.rule(parseNode, list, set);
        } else {
            for (ParseNode parseNode2 : parseNode.children()) {
                Grammar.grammar(parseNode2, list, set);
            }
        }
    }

    private static void rule(ParseNode parseNode, List<LexerToken> list, Set<RuleTuple> set) {
        String string = null;
        Set<RuleTuple> set2 = null;
        for (ParseNode parseNode2 : parseNode.children()) {
            if (string == null && parseNode2.contains(minus)) {
                Grammar.delete(parseNode, list, set);
                return;
            }
            if (string == null && parseNode2.contains(variable)) {
                string = parseNode2.content(list);
                continue;
            }
            if (!parseNode2.contains(disjunct)) continue;
            set2 = Grammar.disjunct(string, parseNode2, list);
            set.addAll(set2);
        }
        if (set2 == null) {
            set.add(new RuleTuple(string, new String[0]));
        }
    }

    private static void delete(ParseNode parseNode, List<LexerToken> list, Set<RuleTuple> set) {
        String string = null;
        for (ParseNode object : parseNode.children()) {
            if (string != null || !object.contains(variable)) continue;
            string = object.content(list);
            break;
        }
        TreeSet treeSet = new TreeSet();
        block1: for (RuleTuple ruleTuple : set) {
            if (ruleTuple.head.equals(string)) {
                treeSet.add(ruleTuple);
                continue;
            }
            for (String string2 : ruleTuple.rhs) {
                if (!string2.equals(string)) continue;
                treeSet.add(ruleTuple);
                continue block1;
            }
        }
        set.removeAll(treeSet);
    }

    private static Set<RuleTuple> disjunct(String string, ParseNode parseNode, List<LexerToken> list) {
        TreeSet<RuleTuple> treeSet = new TreeSet<RuleTuple>();
        if (parseNode.contains(concat) || parseNode.contains(disjunct) && parseNode.from + 1 == parseNode.to) {
            treeSet.add(Grammar.concat(string, parseNode, list));
        } else {
            int n = -1;
            int n2 = -1;
            for (ParseNode parseNode2 : parseNode.children()) {
                ++n;
                if (parseNode2.contains(disjunct)) {
                    treeSet.addAll(Grammar.disjunct(string, parseNode2, list));
                } else if (parseNode2.contains(concat)) {
                    treeSet.add(Grammar.concat(string, parseNode2, list));
                }
                if (n2 + 1 == n && parseNode2.contains(or)) {
                    treeSet.add(new RuleTuple(string, new String[0]));
                }
                if (!parseNode2.contains(or)) continue;
                n2 = n;
                if (n != parseNode.children().size() - 1) continue;
                treeSet.add(new RuleTuple(string, new String[0]));
            }
        }
        return treeSet;
    }

    private static RuleTuple concat(String string, ParseNode parseNode, List<LexerToken> list) {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (int i = parseNode.from; i < parseNode.to; ++i) {
            linkedList.add(list.get((int)i).content);
        }
        return new RuleTuple(string, linkedList);
    }
}

