/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.dbtools.parser.Cell;
import oracle.dbtools.parser.CykCell;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.RuleTransforms;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.Visual;
import oracle.dbtools.util.Array;
import oracle.dbtools.util.Service;

public class CYK
extends Parser {
    public HashMap<Integer, int[]> doubleRhsRules;
    Set<Integer> keywords = new TreeSet<Integer>();
    public ChomskiTuple[] rules;

    public CYK(Set<RuleTuple> set) {
        super(CYK.extractBinaryRules(set));
        this.rules = this.getChomskyRules(set);
        this.singleRhsRules = this.filterSingleRhsRules();
        this.doubleRhsRules = this.filterDoubleRhsRules();
    }

    public void printSelectedChomskiRules(String string) {
        System.out.println("-------------Chomsky Rules---------------");
        for (ChomskiTuple chomskiTuple : this.rules) {
            if (!this.allSymbols[chomskiTuple.head].contains(string) && !this.allSymbols[chomskiTuple.rhs0].contains(string) && (chomskiTuple.rhs1 <= 0 || !this.allSymbols[chomskiTuple.rhs1].contains(string))) continue;
            System.out.println(chomskiTuple.toString());
        }
        System.out.println("-------------------------------------");
    }

    public void printIds() {
        System.out.println("-------------Id Rules---------------");
        for (ChomskiTuple chomskiTuple : this.rules) {
            Iterator iterator = this.singleRhsRules[(Integer)this.symbolIndexes.get("digits")].iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                if (chomskiTuple.head != n) continue;
                System.out.println(chomskiTuple.toString());
            }
        }
        System.out.println("-------------------------------------");
    }

    public Matrix initArray(List<LexerToken> list) {
        Matrix matrix = new Matrix(this);
        int n = 0;
        for (LexerToken lexerToken : list) {
            this.initArrayElement(matrix, n, lexerToken, false);
            ++n;
        }
        return matrix;
    }

    public Matrix initArray1(List<LexerToken> list) {
        Matrix matrix = new Matrix(this);
        this.initArray(list, matrix);
        return matrix;
    }

    public void initArray(List<LexerToken> list, Matrix matrix) {
        int n = 0;
        for (LexerToken lexerToken : list) {
            this.initArrayElement(matrix, n, lexerToken, true);
            ++n;
        }
    }

    public void initArrayElement(Matrix matrix, int n, LexerToken lexerToken, boolean bl) {
        int n2;
        Integer n3 = (Integer)this.symbolIndexes.get("'" + lexerToken.content + "'");
        TreeSet treeSet = new TreeSet();
        if (n3 != null) {
            treeSet.addAll(this.singleRhsRules[n3]);
        }
        if (lexerToken.type == Token.IDENTIFIER) {
            if (!bl || n3 == null || !this.keywords.contains(n3)) {
                n2 = (Integer)this.symbolIndexes.get("identifier");
                treeSet.addAll(this.singleRhsRules[n2]);
            }
        } else if (lexerToken.type == Token.DQUOTED_STRING || lexerToken.type == Token.QUOTED_STRING) {
            n2 = (Integer)this.symbolIndexes.get("string_literal");
            treeSet.addAll(this.singleRhsRules[n2]);
        } else if (lexerToken.type == Token.DIGITS) {
            n2 = (Integer)this.symbolIndexes.get("digits");
            treeSet.addAll(this.singleRhsRules[n2]);
        }
        int[] nArray = new int[treeSet.size()];
        int n4 = 0;
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            int n5 = (Integer)iterator.next();
            nArray[n4++] = n5;
        }
        matrix.put(Service.lPair(n, n + 1), new CykCell(nArray));
    }

    public int[] atomicSymbols() {
        return new int[0];
    }

    public Map<Integer, Integer> delimitedSymbols() {
        return new HashMap<Integer, Integer>();
    }

    public void closure(Matrix matrix, int n, int n2, Map<Integer, Integer> map, int n3) {
        int[] nArray = this.atomicSymbols();
        Map<Integer, Integer> map2 = this.delimitedSymbols();
        for (int i = 1; i < n2; ++i) {
            block1: for (int j = i - 2; j >= n; --j) {
                int n4;
                int n5;
                Object object;
                Object object2;
                Object object3;
                Integer n6;
                if (map != null && (n6 = map.get(j)) != null) {
                    if (Visual.skipped != null) {
                        for (int k = j; k > n6; --k) {
                            Visual.skipped[k][i] = Visual.causes.get(Service.lPair(j, n6));
                        }
                    }
                    j = n6 + 1;
                    continue;
                }
                long l = Service.lPair(j, i);
                long l2 = Service.lPair(0, i + 1);
                int[] nArray2 = null;
                SortedMap sortedMap = matrix.subMap(l, l2);
                for (long l3 : sortedMap.keySet()) {
                    Cell cell;
                    object3 = Service.lX(l3);
                    object2 = (Cell)matrix.get(Service.lPair(j, object3));
                    if (object2 == null || (cell = (Cell)matrix.get(Service.lPair(object3, i))) == null) continue;
                    int[] nArray3 = object2.getContent();
                    object = nArray3.length;
                    for (n5 = 0; n5 < object; ++n5) {
                        n4 = nArray3[n5];
                        for (int n7 : cell.getContent()) {
                            int[] nArray4 = this.doubleRhsRules.get(Service.pair(n4, n7));
                            if (nArray4 == null) continue;
                            nArray2 = Array.merge(nArray2, nArray4);
                        }
                    }
                }
                if (nArray2 == null) continue;
                matrix.put(Service.lPair(j, i), new CykCell(nArray2));
                if (map == null || nArray.length <= 0 && map2.size() <= 0 || i - 1 == j + 1 || j <= n3 && n3 < i) continue;
                Iterator<Long> iterator = nArray2;
                int n8 = ((Iterator<Long>)iterator).length;
                block6: for (int k = 0; k < n8; ++k) {
                    int n9;
                    object3 = iterator[k];
                    object2 = nArray;
                    int n10 = ((Object)object2).length;
                    for (n9 = 0; n9 < n10; ++n9) {
                        object = object2[n9];
                        if (object3 != object) continue;
                        n5 = j;
                        n4 = i - 1;
                        map.put(n4, n5);
                        if (Visual.skipped == null) continue block1;
                        if (Visual.causes.get(Service.lPair(n4, n5)) != null) {
                            throw new AssertionError((Object)"Visual.causes.get(Service.lPair(Y,X))!=null");
                        }
                        Visual.causes.put(Service.lPair(n4, n5), (Integer)object3);
                        continue block1;
                    }
                    object2 = map2.keySet().iterator();
                    while (object2.hasNext()) {
                        n10 = object2.next();
                        if (object3 != n10 || (n9 = CYK.splitInterval(matrix, j, i, n10, map2.get(object3), true)) == -1 || (object = CYK.splitInterval(matrix, n9, i, n10, map2.get(object3), false)) == -1 || (n5 = object - 1) <= (n4 = n9)) continue;
                        map.put(n5, n4);
                        if (Visual.skipped == null) continue block6;
                        Visual.causes.put(Service.lPair(n5, n4), (Integer)object3);
                        continue block6;
                    }
                }
            }
        }
    }

    protected int next(int n, Map<Integer, Integer> map) {
        Integer n2 = map.get(n - 1);
        if (n2 == null) {
            return n;
        }
        return this.next(n2, map);
    }

    public void recalculateRectangle(Matrix matrix, Map<Integer, Integer> map, int n, int n2, int n3) {
        Object object;
        Object object2;
        if (map != null) {
            Set<Integer> set = map.keySet();
            Integer[] integerArray = new Integer[set.size()];
            object2 = set.toArray(integerArray);
            int n4 = ((Integer[])object2).length;
            for (int i = 0; i < n4; ++i) {
                Integer n5 = object2[i];
                if (n3 >= n5) continue;
                object = map.get(n5);
                map.remove(n5);
                map.put(n5 - n3 + n2, (Integer)object - n3 + n2);
            }
        }
        for (int i = n3; i < n; ++i) {
            for (int j = n2; j >= 0; --j) {
                if (i == j + 1) continue;
                matrix.remove(Service.lPair(j, i));
                if (map != null && (object2 = map.get(j)) != null) {
                    j = (Integer)object2 + 1;
                    continue;
                }
                long l = Service.lPair(j, i);
                long l2 = Service.lPair(0, i + 1);
                object = null;
                SortedMap sortedMap = matrix.subMap(l, l2);
                for (long l3 : sortedMap.keySet()) {
                    Cell cell;
                    int n6 = Service.lX(l3);
                    Cell cell2 = (Cell)matrix.get(Service.lPair(j, n6));
                    if (cell2 == null || (cell = (Cell)matrix.get(Service.lPair(n6, i))) == null) continue;
                    for (int n7 : cell2.getContent()) {
                        for (int n8 : cell.getContent()) {
                            int[] nArray = this.doubleRhsRules.get(Service.pair(n7, n8));
                            if (nArray == null) continue;
                            object = Array.merge((int[])object, nArray);
                        }
                    }
                }
                if (object == null) continue;
                matrix.put(Service.lPair(j, i), new CykCell((int[])object));
            }
        }
    }

    public void print(Matrix matrix) {
        Iterator iterator = matrix.keySet().iterator();
        while (iterator.hasNext()) {
            long l = (Long)iterator.next();
            int n = Service.lX(l);
            int n2 = Service.lY(l);
            this.print(matrix, n, n2);
        }
    }

    public void print(Matrix matrix, int n, int n2) {
        System.out.print("[" + n + "," + n2 + ")");
        Cell cell = (Cell)matrix.get(Service.lPair(n, n2));
        if (cell == null) {
            System.out.println("- syntactically invalid code fragment");
            return;
        }
        for (int n3 : cell.getContent()) {
            if (n3 == -1) {
                System.out.print("-1");
                continue;
            }
            System.out.print("  " + this.allSymbols[n3]);
        }
        System.out.println();
    }

    Set<Integer>[] filterSingleRhsRules() {
        TreeSet<Integer> treeSet;
        TreeMap treeMap = new TreeMap();
        for (int i = 0; i < this.allSymbols.length; ++i) {
            TreeSet<Integer> treeSet2 = new TreeSet<Integer>();
            treeSet2.add(i);
            treeMap.put(i, treeSet2);
        }
        for (ChomskiTuple chomskiTuple : this.rules) {
            if (chomskiTuple.rhs1 != -1) continue;
            treeSet = (TreeSet<Integer>)treeMap.get(chomskiTuple.rhs0);
            treeSet.add(chomskiTuple.head);
            treeMap.put(chomskiTuple.rhs0, treeSet);
        }
        boolean bl = true;
        TreeMap<Integer, TreeSet<Integer>> treeMap2 = new TreeMap<Integer, TreeSet<Integer>>();
        while (bl) {
            bl = false;
            Iterator iterator = treeMap.keySet().iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                treeSet = new TreeSet<Integer>();
                treeSet.addAll((Collection)treeMap.get(n));
                Iterator iterator2 = ((Set)treeMap.get(n)).iterator();
                while (iterator2.hasNext()) {
                    int n2 = (Integer)iterator2.next();
                    Set set = (Set)treeMap.get(n2);
                    if (set == null) continue;
                    treeSet.addAll(set);
                }
                if (treeSet.size() > ((Set)treeMap.get(n)).size()) {
                    bl = true;
                }
                treeMap2.put(n, treeSet);
            }
            treeMap = treeMap2;
        }
        Set[] setArray = new Set[this.allSymbols.length];
        Iterator iterator = treeMap.keySet().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            setArray[n] = (Set)treeMap.get(n);
        }
        return setArray;
    }

    HashMap<Integer, int[]> filterDoubleRhsRules() {
        HashMap<Integer, int[]> hashMap = new HashMap<Integer, int[]>();
        for (ChomskiTuple chomskiTuple : this.rules) {
            if (chomskiTuple.rhs1 == -1) continue;
            int[] nArray = hashMap.get(Service.pair(chomskiTuple.rhs0, chomskiTuple.rhs1));
            Iterator iterator = this.singleRhsRules[chomskiTuple.head].iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                nArray = Array.insert(nArray, n);
            }
            hashMap.put(Service.pair(chomskiTuple.rhs0, chomskiTuple.rhs1), nArray);
        }
        return hashMap;
    }

    public static int[] toArray(Set<Integer> set) {
        int[] nArray = new int[set.size()];
        int n = 0;
        for (int n2 : set) {
            nArray[n++] = n2;
        }
        return nArray;
    }

    protected static int splitInterval(Matrix matrix, int n, int n2, int n3, boolean bl) {
        int n4;
        int n5 = n4 = bl ? n + 1 : n2 - 1;
        while (n < n4 && n4 < n2) {
            Cell cell;
            Cell cell2 = (Cell)matrix.get(Service.lPair(n, n4));
            if (cell2 != null && (cell = (Cell)matrix.get(Service.lPair(n4, n2))) != null) {
                for (int n6 : cell2.getContent()) {
                    if (n6 != n3) continue;
                    for (int n7 : cell.getContent()) {
                        if (n7 != n3) continue;
                        return n4;
                    }
                }
            }
            n4 = bl ? n4 + 1 : n4 - 1;
        }
        return -1;
    }

    protected static int splitInterval(Matrix matrix, int n, int n2, int n3, int n4, boolean bl) {
        int n5;
        int n6 = n5 = bl ? n + 1 : n2 - 1;
        while (n < n5 && n5 < n2) {
            Cell cell = (Cell)matrix.get(Service.lPair(n, n5));
            if (cell != null) {
                for (int n7 : cell.getContent()) {
                    if (n7 != n3) continue;
                    for (int i = 1; i <= n2 - n5; ++i) {
                        int n8;
                        int n9;
                        Cell cell2 = (Cell)matrix.get(Service.lPair(n5 + i, n2));
                        if (cell2 == null) continue;
                        boolean bl2 = true;
                        Object object = cell2.getContent();
                        int n10 = ((int[])object).length;
                        for (n9 = 0; n9 < n10; ++n9) {
                            n8 = object[n9];
                            if (n8 != n3) continue;
                            bl2 = false;
                        }
                        if (bl2 || (object = (Object)((Cell)matrix.get(Service.lPair(n5, n5 + i)))) == null) continue;
                        int[] nArray = object.getContent();
                        n9 = nArray.length;
                        for (n8 = 0; n8 < n9; ++n8) {
                            int n11 = nArray[n8];
                            if (n11 != n4) continue;
                            return bl ? n5 + i : n5;
                        }
                    }
                }
            }
            n5 = bl ? n5 + 1 : n5 - 1;
        }
        return -1;
    }

    protected static boolean containsSymbol(Cell cell, int n) {
        if (cell == null) {
            return false;
        }
        for (int n2 : cell.getContent()) {
            if (n != n2) continue;
            return true;
        }
        return false;
    }

    protected static boolean containsEither(Cell cell, int[] nArray) {
        for (int n : nArray) {
            if (!CYK.containsSymbol(cell, n)) continue;
            return true;
        }
        return false;
    }

    public static void printErrors(String string, List<LexerToken> list, ParseNode parseNode) {
        int n = 0;
        int n2 = string.length();
        for (ParseNode parseNode2 : parseNode.children()) {
            if (n < list.get((int)parseNode2.from).begin) {
                n = list.get((int)parseNode2.from).begin;
            }
            if (list.get((int)parseNode2.to).end >= n2) continue;
            n2 = list.get((int)(parseNode2.to - 1)).end;
        }
        Object object = string.substring(n, n2);
        if (((String)object).length() > 200) {
            object = ((String)object).substring(0, 40) + " ... " + ((String)object).substring(((String)object).length() - 40);
        }
        System.out.println(string.substring(0, n) + "<<<*****\n" + (String)object + "\n*****>>>" + string.substring(n2));
    }

    @Override
    public ParseNode treeForACell(List<LexerToken> list, Matrix matrix, Cell cell, int n, int n2) {
        for (int i = 0; i < cell.size(); ++i) {
            int n3 = cell.getSymbol(i);
            if (n3 == -1) continue;
            return this.tree(matrix, n, n2, n3);
        }
        return null;
    }

    protected ChomskiTuple[] getChomskyRules(Set<RuleTuple> set) {
        RuleTransforms.eliminateEmptyProductions(set);
        return this.convertToChomskyRules(set);
    }

    private ChomskiTuple[] convertToChomskyRules(Set<RuleTuple> set) {
        Set<RuleTuple> set2 = CYK.extractBinaryRules(set);
        ChomskiTuple[] chomskiTupleArray = new ChomskiTuple[set2.size()];
        int n = 0;
        for (RuleTuple ruleTuple : set2) {
            chomskiTupleArray[n++] = new ChomskiTuple((Integer)this.symbolIndexes.get(ruleTuple.head), (Integer)this.symbolIndexes.get(ruleTuple.rhs[0]), ruleTuple.rhs.length > 1 ? (Integer)this.symbolIndexes.get(ruleTuple.rhs[1]) : -1);
        }
        return chomskiTupleArray;
    }

    static Set<RuleTuple> split(RuleTuple ruleTuple) {
        TreeSet<RuleTuple> treeSet = new TreeSet<RuleTuple>();
        if (ruleTuple.rhs.length == 0) {
            throw new RuntimeException("Empty Rule!");
        }
        if (ruleTuple.rhs.length == 1 || ruleTuple.rhs.length == 2) {
            treeSet.add(ruleTuple);
        } else {
            int n = ruleTuple.rhs.length / 2;
            ArrayList<String> arrayList = new ArrayList<String>();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                arrayList.add(ruleTuple.rhs[i]);
                if (i > 0) {
                    stringBuffer.append('+');
                }
                stringBuffer.append(ruleTuple.rhs[i]);
            }
            if (n > 1) {
                treeSet.addAll(CYK.split(new RuleTuple(stringBuffer.toString(), arrayList)));
            }
            arrayList = new ArrayList();
            StringBuffer stringBuffer2 = new StringBuffer();
            for (int i = n; i < ruleTuple.rhs.length; ++i) {
                arrayList.add(ruleTuple.rhs[i]);
                if (i > n) {
                    stringBuffer2.append('+');
                }
                stringBuffer2.append(ruleTuple.rhs[i]);
            }
            if (n < ruleTuple.rhs.length) {
                treeSet.addAll(CYK.split(new RuleTuple(stringBuffer2.toString(), arrayList)));
            }
            treeSet.add(new RuleTuple(ruleTuple.head, new String[]{stringBuffer.toString(), stringBuffer2.toString()}));
        }
        return treeSet;
    }

    private static Set<RuleTuple> extractBinaryRules(Set<RuleTuple> set) {
        TreeSet<RuleTuple> treeSet = new TreeSet<RuleTuple>();
        for (RuleTuple ruleTuple : set) {
            treeSet.addAll(CYK.split(ruleTuple));
        }
        return treeSet;
    }

    private ParseNode tree(Matrix matrix, int n, int n2, int n3) {
        if (n + 1 == n2) {
            int n4 = n3;
            for (int i = 0; i < this.singleRhsRules.length; ++i) {
                Set set = this.singleRhsRules[i];
                if (!set.contains(n3)) continue;
                n4 = i;
                break;
            }
            return new ParseNode(n, n2, n4, n3, this);
        }
        for (int i = n2 - 1; n < i; --i) {
            Cell cell;
            Cell cell2 = (Cell)matrix.get(Service.lPair(n, i));
            if (cell2 == null || (cell = (Cell)matrix.get(Service.lPair(i, n2))) == null) continue;
            for (int n5 : cell2.getContent()) {
                for (int n6 : cell.getContent()) {
                    int n7;
                    int[] nArray = this.doubleRhsRules.get(Service.pair(n5, n6));
                    if (nArray == null || (n7 = this.head(n5, n6, n3)) == -1) continue;
                    ParseNode parseNode = new ParseNode(n, n2, n7, n3, this);
                    parseNode.lft = this.tree(matrix, n, i, n5);
                    parseNode.rgt = this.tree(matrix, i, n2, n6);
                    return parseNode;
                }
            }
        }
        throw new AssertionError((Object)("failed to extract the tree at [" + n + "," + n2 + ")"));
    }

    private int head(int n, int n2, int n3) {
        for (ChomskiTuple chomskiTuple : this.rules) {
            if (chomskiTuple.rhs0 != n || chomskiTuple.rhs1 != n2 || !this.singleRhsRules[chomskiTuple.head].contains(n3)) continue;
            return chomskiTuple.head;
        }
        return -1;
    }

    public class ChomskiTuple
    implements Comparable<ChomskiTuple> {
        public int head;
        public int rhs0;
        public int rhs1;

        public ChomskiTuple(int n, int n2, int n3) {
            this.head = n;
            this.rhs0 = n2;
            this.rhs1 = n3;
        }

        int size() {
            return this.rhs1 == -1 ? 1 : 2;
        }

        int content(int n) {
            if (n == 0) {
                return this.rhs0;
            }
            if (n == 1) {
                return this.rhs1;
            }
            throw new IndexOutOfBoundsException("ChomskiTuple.content(" + n + ")");
        }

        public boolean equals(Object object) {
            return this == object || object instanceof ChomskiTuple && this.compareTo((ChomskiTuple)object) == 0;
        }

        public int hashCode() {
            throw new RuntimeException("hashCode inconssitent with equals");
        }

        @Override
        public int compareTo(ChomskiTuple chomskiTuple) {
            if (this.head == 0 || chomskiTuple.head == 0) {
                throw new RuntimeException("head==0 || src.head==0");
            }
            int n = this.head - chomskiTuple.head;
            if (n != 0) {
                return n;
            }
            n = this.rhs0 - chomskiTuple.rhs0;
            if (n != 0) {
                return n;
            }
            return this.rhs1 - chomskiTuple.rhs1;
        }

        public String toString() {
            if (this.rhs1 == -1) {
                return CYK.this.allSymbols[this.head] + ": " + CYK.this.allSymbols[this.rhs0] + ";";
            }
            return CYK.this.allSymbols[this.head] + ": " + CYK.this.allSymbols[this.rhs0] + "  " + CYK.this.allSymbols[this.rhs1] + ";";
        }
    }
}

