/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.sybase12;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.migration.capture.AbstractOfflineCapturer;
import oracle.dbtools.migration.capture.CaptureContext;
import oracle.dbtools.migration.capture.CaptureException;
import oracle.dbtools.migration.capture.offline.OfflineCaptureException;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.plugin.sybaseofflinecapture.ObjectStatusList;
import oracle.dbtools.migration.workbench.sybase12.Sybase12AbstractCapturer;
import oracle.dbtools.migration.workbench.sybase12.Sybase12CaptureObjectsOfflineCapturer;
import oracle.dbtools.migration.workbench.sybase12.Sybase12DoOfflineCaptureLoad;
import oracle.dbtools.migration.workbench.sybase12.Sybase12Messages;
import oracle.dbtools.migration.workbench.sybase12.Sybase12OfflineCaptureTables;
import oracle.dbtools.util.Resource;
import oracle.javatools.db.DBException;

public class Sybase12OfflineCapturer
extends AbstractOfflineCapturer {
    protected Sybase12DoOfflineCaptureLoad dsml = null;
    protected Connection m_repositoryConnection = null;
    protected MigrationStorer m_storer = null;
    protected Sybase12CaptureObjectsOfflineCapturer m_captureObjectsOfflineCapturer = null;

    protected String captureInitializeImpl(String string, Properties properties) throws OfflineCaptureException {
        this.setRepositoryConnection(MigrationAddin.getPersistenceManager().getConn());
        this.m_captureObjectsOfflineCapturer = new Sybase12CaptureObjectsOfflineCapturer(this.getStorer(), MigrationAddin.getPersistenceManager().getConn());
        HashMap<File, ObjectStatusList> hashMap = new HashMap();
        Object var4_4 = null;
        ArrayList arrayList = this.getSelectedDatabaseList();
        Connection connection = this.getRepositoryConnection();
        Statement statement = null;
        try {
            try {
                Sybase12OfflineCaptureTables sybase12OfflineCaptureTables = new Sybase12OfflineCaptureTables();
                String[] stringArray = sybase12OfflineCaptureTables.getDropStatements();
                statement = connection.createStatement();
                for (String string2 : stringArray) {
                    try {
                        statement.executeUpdate(string2);
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
            }
            catch (SQLException sQLException) {
                throw new OfflineCaptureException((Exception)sQLException);
            }
            finally {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                }
            }
            try {
                this.createStagingTables(this.getRepositoryConnection());
            }
            catch (DBException dBException) {
                throw new OfflineCaptureException((Exception)((Object)dBException));
            }
        }
        catch (SQLException sQLException) {
            throw new OfflineCaptureException((Exception)sQLException);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        hashMap = this.getSelectedDatabaseDirectoryStructure(string, arrayList);
        this.dsml = new Sybase12DoOfflineCaptureLoad(connection);
        Sybase12DoOfflineCaptureLoad.setEncoding(this.getEncoding());
        this.dsml.sourceModelIndexCreate(this.getRepositoryConnection());
        try {
            this.dsml.convertBcpDumpToXML(hashMap);
        }
        catch (Exception exception) {
            throw new OfflineCaptureException(exception);
        }
        return "Sybase12" + string;
    }

    protected HashMap<File, ObjectStatusList> getSelectedDatabaseDirectoryStructure(String string, ArrayList<String> arrayList) {
        File file = new File(string);
        String[] stringArray = file.list();
        HashMap<File, ObjectStatusList> hashMap = new HashMap<File, ObjectStatusList>();
        ObjectStatusList objectStatusList = null;
        for (String string2 : stringArray) {
            String[] stringArray2;
            if (!new File(string + File.separator + string2).isDirectory()) continue;
            if (!"master".equals(string2.toLowerCase()) && arrayList.contains(string2)) {
                this.addDatabaseToCapture(string2);
            }
            File file2 = new File(string + File.separator + string2);
            objectStatusList = new ObjectStatusList();
            for (String string3 : stringArray2 = file2.list()) {
                if (!string3.endsWith(".dat") && !string3.endsWith(".DAT")) continue;
                objectStatusList.add(new File(string + File.separator + string2 + File.separator + string3), Sybase12Messages.getString("Sybase12OfflineCapturer.2"));
            }
            hashMap.put(file2, objectStatusList);
        }
        return hashMap;
    }

    public void createStagingTables(Connection connection) throws DBException, SQLException, OfflineCaptureException {
        Sybase12OfflineCaptureTables sybase12OfflineCaptureTables = new Sybase12OfflineCaptureTables();
        String[] stringArray = sybase12OfflineCaptureTables.getCreateStatements();
        Statement statement = null;
        try {
            statement = connection.createStatement();
            for (String string : stringArray) {
                statement.executeUpdate(string);
            }
        }
        catch (SQLException sQLException) {
            throw new OfflineCaptureException((Exception)sQLException);
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    public void cleanUp() throws OfflineCaptureException {
        Connection connection = this.getRepositoryConnection();
        Statement statement = null;
        try {
            Sybase12OfflineCaptureTables sybase12OfflineCaptureTables = new Sybase12OfflineCaptureTables();
            String[] stringArray = sybase12OfflineCaptureTables.getTruncateStatements();
            statement = connection.createStatement();
            for (String string : stringArray) {
                try {
                    statement.executeUpdate(string);
                }
                catch (SQLException sQLException) {
                    throw new OfflineCaptureException((Exception)sQLException);
                }
            }
        }
        catch (SQLException sQLException) {
            throw new OfflineCaptureException((Exception)sQLException);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    public String[] generateScripts(String string, int n) throws OfflineCaptureException {
        String string2 = "/oracle/dbtools/migration/workbench/plugin/";
        this.writeFile(string, string2 + "Sybase12Files", "properties.sql");
        this.writeFile(string, string2 + "Sybase12Files", "get_indexes.sql");
        this.writeFile(string, string2 + "Sybase12Files", "get_constraints.sql");
        this.writeFile(string, string2 + "Sybase12Files", "sybase12.ocp");
        this.writeFile(string, string2 + "Sybase12Files", "ROW.TXT");
        this.writeFile(string, string2 + "Sybase12Files", "COLUMN.TXT");
        if (n == 1) {
            this.writeFile(string, string2 + "Sybase12Files", "SYB12_OFFLINE_CAPTURE.BAT");
            this.writeFile(string, string2 + "Sybase12Files", "SYB12_BCP_SCRIPT.BAT");
            String[] stringArray = new String[]{"SYB12_OFFLINE_CAPTURE.BAT", "sybase12.ocp", "properties.sql", "SYB12_BCP_SCRIPT.BAT", "ROW.TXT", "COLUMN.TXT", "get_indexes.sql", "get_constraints.sql"};
            return stringArray;
        }
        this.writeFile(string, string2 + "Sybase12Files", "SYB12_OFFLINE_CAPTURE.sh");
        String[] stringArray = new String[]{"SYB12_OFFLINE_CAPTURE.sh", "sybase12.ocp", "properties.sql", "ROW.TXT", "COLUMN.TXT", "get_indexes.sql", "get_constraints.sql"};
        return stringArray;
    }

    public Connection getRepositoryConnection() {
        return this.m_repositoryConnection;
    }

    public void setRepositoryConnection(Connection connection) {
        this.m_repositoryConnection = connection;
    }

    public void setStorer(MigrationStorer migrationStorer) {
        this.m_storer = migrationStorer;
    }

    public MigrationStorer getStorer() {
        return this.m_storer;
    }

    public String[] getScriptFiles(int n) throws OfflineCaptureException {
        return null;
    }

    public void captureObjects(String string, CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws PersistenceException, CaptureException {
        this.m_captureObjectsOfflineCapturer.captureObjects(string, captureContext, migrationObjectFilter);
    }

    public String getModelName() throws CaptureException {
        return "Sybase12";
    }

    public String getSourceURL() throws CaptureException {
        return "/tmp/sybase12";
    }

    public Sybase12OfflineCapturer(MigrationStorer migrationStorer, Connection connection) {
    }

    public String writeFile(String string, String string2, String string3) throws OfflineCaptureException {
        InputStream inputStream = null;
        FilterOutputStream filterOutputStream = null;
        try {
            Object object;
            inputStream = new BufferedInputStream(Resource.getResourceAsStream(((Object)((Object)this)).getClass(), (String)(string2 + "/" + string3)));
            File file = null;
            file = new File(string + File.separator + string3);
            if (!file.exists()) {
                filterOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                object = new byte[10000];
                int n = 0;
                while ((n = inputStream.read((byte[])object)) > -1) {
                    ((BufferedOutputStream)filterOutputStream).write((byte[])object, 0, n);
                }
                ((BufferedOutputStream)filterOutputStream).flush();
                inputStream.close();
            }
            object = file.getPath();
            String string4 = object;
            return string4;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new OfflineCaptureException((Exception)fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new OfflineCaptureException((Exception)iOException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void captureStarting() {
        try {
            int n;
            File file = this.dsml.getDbFile("MASTER");
            Connection connection = this.getRepositoryConnection();
            this.dsml.populateSourceModel(connection, file, 1);
            String string = this.getNextDatabase();
            File file2 = this.dsml.getDbFile(string);
            Sybase12AbstractCapturer.OfflineDbId = n = this.dsml.getDbId(connection, string);
            this.dsml.populateSourceModel(connection, file2, n);
            connection.commit();
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public String getEnterpriseCaptureFileName() {
        return "SybaseEnterpriseCapture.xml";
    }
}

