/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin.sybaseofflinecapture;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import oracle.dbtools.migration.capture.offline.OfflineCaptureException;
import oracle.dbtools.migration.workbench.plugin.sybaseofflinecapture.ObjectStatusList;

public class GenerateDSMLFormattedFiles {
    private StringBuffer m_carriedToken = new StringBuffer();
    private HashMap<File, ArrayList<File>> m_dbXMLMetadataList = new HashMap();
    private HashMap<File, ObjectStatusList> m_dSMLMap = null;
    private String m_endRow = "";
    private String m_endCol = "";
    private static StringBuffer s_strBuff = new StringBuffer();
    private String m_encoding = null;

    public GenerateDSMLFormattedFiles(HashMap<File, ObjectStatusList> hashMap, String string) throws OfflineCaptureException {
        Iterator<File> iterator = hashMap.keySet().iterator();
        iterator.hasNext();
        File file = iterator.next();
        String string2 = file.getParentFile().getAbsolutePath();
        this.m_encoding = string;
        try {
            BufferedReader bufferedReader = null;
            bufferedReader = this.m_encoding == null ? new BufferedReader(new InputStreamReader(new FileInputStream(string2 + File.separator + "COLUMN.TXT"))) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string2 + File.separator + "COLUMN.TXT"), this.m_encoding));
            int n = 0;
            while (n != -1) {
                n = bufferedReader.read();
                if (n == -1 && this.m_endCol.equals("")) {
                    throw new OfflineCaptureException(new Exception(string2 + File.separator + "COLUMN.TXT"));
                }
                if (n == -1) continue;
                this.m_endCol = this.m_endCol + new Character((char)n).toString();
            }
            bufferedReader = string == null ? new BufferedReader(new InputStreamReader(new FileInputStream(string2 + File.separator + "ROW.TXT"))) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string2 + File.separator + "ROW.TXT"), string));
            n = 0;
            while (n != -1) {
                n = bufferedReader.read();
                if (n == -1 && this.m_endRow.equals("")) {
                    throw new OfflineCaptureException(new Exception(string2 + File.separator + "ROW.TXT"));
                }
                if (n == -1) continue;
                this.m_endRow = this.m_endRow + new Character((char)n).toString();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new OfflineCaptureException((Exception)fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new OfflineCaptureException((Exception)iOException);
        }
        this.m_dSMLMap = hashMap;
        this.generateDSMLFiles();
    }

    public static String getMessage(String string, Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        MessageFormat messageFormat = new MessageFormat(string);
        messageFormat.format(objectArray, stringBuffer, (FieldPosition)null);
        return stringBuffer.toString();
    }

    public static String getUnqualifiedName(String string) {
        String string2 = null;
        int n = string.lastIndexOf(46);
        if (n > 0 && n < string.length() - 1) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    private void generateDSMLFiles() throws OfflineCaptureException {
        int n = 0;
        this.m_dbXMLMetadataList.clear();
        try {
            for (File file : this.m_dSMLMap.keySet()) {
                ObjectStatusList objectStatusList = this.m_dSMLMap.get(file);
                ArrayList<File> arrayList = new ArrayList<File>();
                int n2 = 0;
                Iterator iterator = objectStatusList.getKeys();
                while (iterator.hasNext()) {
                    File file2 = (File)iterator.next();
                    String string = null;
                    string = file2.getPath();
                    String string2 = file2.getParent();
                    String string3 = GenerateDSMLFormattedFiles.getUnqualifiedName(file2.getName());
                    String string4 = string3 + ".XML";
                    String string5 = string2 + File.separator + string4;
                    File file3 = new File(string);
                    File file4 = new File(string5);
                    String string6 = "";
                    String string7 = "UTF-8";
                    BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file4), string7));
                    BufferedReader bufferedReader = null;
                    bufferedReader = this.m_encoding == null ? new BufferedReader(new InputStreamReader(new FileInputStream(file3))) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file3), this.m_encoding));
                    Object[] objectArray = new Object[]{string7};
                    String string8 = "<?xml version=\"1.0\" encoding=\"{0}\" ?>";
                    String string9 = GenerateDSMLFormattedFiles.getMessage(string8, objectArray);
                    bufferedWriter.write(string9);
                    bufferedWriter.write("<START><er>");
                    block4: while ((string6 = bufferedReader.readLine()) != null) {
                        string6 = this.removeBadChars(string6);
                        Iterator iterator2 = this.breakup(string6, this.m_endRow);
                        while (iterator2.hasNext()) {
                            String string10 = (String)iterator2.next();
                            if (string10.indexOf(this.m_endRow) != -1) {
                                n = 0;
                                bufferedWriter.write("</er><er>");
                                continue block4;
                            }
                            int n3 = 0;
                            int n4 = 0;
                            String string11 = "";
                            int n5 = string10.length();
                            boolean bl = true;
                            while ((n4 = string10.indexOf(this.m_endCol, n3)) != -1 || n3 < n5) {
                                CharSequence charSequence;
                                if (n4 == -1) {
                                    if (!bl) {
                                        ++n3;
                                    }
                                    if (n3 != n5) {
                                        string11 = string10.substring(n3, n5);
                                        charSequence = GenerateDSMLFormattedFiles.processString(string11, false);
                                        this.m_carriedToken.append(((StringBuffer)charSequence).toString());
                                        this.m_carriedToken.append("\n");
                                        break;
                                    }
                                    if (string6.length() != n5) break;
                                    this.m_carriedToken.append("\n");
                                    break;
                                }
                                ++n;
                                if (!bl) {
                                    ++n3;
                                }
                                string11 = string10.substring(n3, n4 - 1);
                                bufferedWriter.write("<ec>");
                                if (this.m_carriedToken.length() != 0) {
                                    bufferedWriter.write(this.m_carriedToken.toString());
                                    this.m_carriedToken.setLength(0);
                                }
                                if (((String)(charSequence = GenerateDSMLFormattedFiles.processString(string11, false).toString())).length() != 0) {
                                    bufferedWriter.write((String)charSequence);
                                }
                                bufferedWriter.write("</ec>");
                                n3 = n4 + this.m_endCol.length();
                                bl = false;
                            }
                            if (!string10.endsWith(this.m_endRow)) continue;
                            bufferedWriter.write("</er><er>");
                        }
                    }
                    bufferedWriter.write("</er></START>");
                    ((Writer)bufferedWriter).flush();
                    ((Writer)bufferedWriter).close();
                    arrayList.add(file4);
                    ++n2;
                }
                this.m_dbXMLMetadataList.put(file, arrayList);
            }
        }
        catch (Exception exception) {
            throw new OfflineCaptureException(exception);
        }
    }

    private String removeBadChars(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (this.isBadChar(string, i)) continue;
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    private boolean isBadChar(String string, int n) {
        int n2 = string.codePointAt(n);
        return !(n2 == 9 || n2 == 10 || n2 == 13 || n2 >= 32 && n2 <= 55295 || n2 >= 57344 && n2 <= 65533) && (n2 < 65536 || n2 > 0x10FFFF);
    }

    Iterator breakup(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string == null || string.equals("")) {
            return arrayList.iterator();
        }
        int n = 0;
        int n2 = 0;
        while ((n = string.indexOf(string2, n2)) != -1) {
            if (n == n2) {
                arrayList.add("");
            } else {
                arrayList.add(string.substring(n2, n));
            }
            arrayList.add(string2);
            n2 = n + string2.length();
        }
        if (n2 != string.length()) {
            arrayList.add(string.substring(n2));
        }
        return arrayList.iterator();
    }

    private static StringBuffer processString(String string, boolean bl) {
        int n = 0;
        int n2 = string.length();
        s_strBuff.setLength(0);
        if (bl) {
            s_strBuff.append("<ec>");
        }
        while (n < n2) {
            char c = string.charAt(n);
            if (c == '<') {
                s_strBuff.append("&lt;");
            } else if (c == '>') {
                s_strBuff.append("&gt;");
            } else if (c == '\'') {
                s_strBuff.append("&apos;");
            } else if (c == '\"') {
                s_strBuff.append("&quot;");
            } else if (c == '&') {
                s_strBuff.append("&amp;");
            } else if (c != '\u0000' && c != '\u0007' && c != '\u000e' && c != '\u0014' && c != '\u0015' && c != '\u000f') {
                s_strBuff.append(c);
            }
            ++n;
        }
        if (bl) {
            s_strBuff.append("</ec>");
        }
        return s_strBuff;
    }

    public HashMap<File, ArrayList<File>> getDSMLFormattedFilesTable() {
        return this.m_dbXMLMetadataList;
    }
}

