/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.uicli.graph;

import java.awt.Component;
import java.io.InputStream;
import java.util.ArrayList;
import javax.swing.JPanel;
import oracle.adf.model.binding.DCBindingContainer;
import oracle.adf.model.binding.DCDataControl;
import oracle.adf.model.binding.DCIteratorBinding;
import oracle.dss.graph.Graph;
import oracle.dss.util.CubeDataDirector;
import oracle.dss.util.DataSource;
import oracle.dss.util.DefaultErrorHandler;
import oracle.dss.util.ErrorHandler;
import oracle.dss.util.RelationalDataDirector;
import oracle.dss.util.xml.BIIOException;
import oracle.dss.util.xml.BIParseException;
import oracle.dss.util.xml.BISAXException;
import oracle.jbo.DeleteEvent;
import oracle.jbo.InsertEvent;
import oracle.jbo.JboException;
import oracle.jbo.Row;
import oracle.jbo.RowSetIterator;
import oracle.jbo.common.JBOClass;
import oracle.jbo.uicli.binding.JUAccessorIteratorDef;
import oracle.jbo.uicli.graph.BIBeanDataAccessAdapter;
import oracle.jbo.uicli.graph.GraphDataFromCol;
import oracle.jbo.uicli.graph.JUGraphBinding;

public class JUMasterDetailGraphBinding
extends JUGraphBinding
implements DataSource {
    protected BIBeanDataAccessAdapter mAdapter;
    protected String mChildAccessorName;
    protected String[] mDataValueAttrNames;
    protected int mNumberOfColumnValuesPerMarker;
    protected String mSeriesLabelAttributeName;
    protected ArrayList mChildSeries = new ArrayList(10);
    protected InputStream mGraphPropertiesStream;
    protected String mGraphDefFileName = null;

    public JUMasterDetailGraphBinding(Graph control, DCIteratorBinding seriesBinding, String seriesLabelAttributeName, String childAccessorName, String[] dataValueAttrNames, int numberOfColumnValuesPerMarker) {
        this(control, seriesBinding, seriesLabelAttributeName, childAccessorName, dataValueAttrNames, numberOfColumnValuesPerMarker, (InputStream)null);
    }

    public JUMasterDetailGraphBinding(Graph control, DCIteratorBinding seriesBinding, String seriesLabelAttributeName, String childAccessorName, String[] dataValueAttrNames, int numberOfColumnValuesPerMarker, String graphPropertiesFileName) {
        this(control, seriesBinding, seriesLabelAttributeName, childAccessorName, dataValueAttrNames, numberOfColumnValuesPerMarker, JBOClass.getResourceAsStream((String)graphPropertiesFileName));
    }

    public JUMasterDetailGraphBinding(Graph control, DCIteratorBinding seriesBinding, String seriesLabelAttributeName, String childAccessorName, String[] dataValueAttrNames, int numberOfColumnValuesPerMarker, InputStream is) {
        super(control, seriesBinding, new String[]{seriesLabelAttributeName, childAccessorName});
        this.mAdapter = new BIBeanDataAccessAdapter(this);
        this.mChildAccessorName = childAccessorName;
        this.mDataValueAttrNames = dataValueAttrNames;
        this.mNumberOfColumnValuesPerMarker = numberOfColumnValuesPerMarker;
        this.mSeriesLabelAttributeName = seriesLabelAttributeName;
        this.mGraphPropertiesStream = is;
        this.init(control, this.mGraphPropertiesStream);
    }

    protected void init(Graph control, InputStream is) {
        ErrorHandler errHandler;
        if (is != null && control != null) {
            try {
                control.readXML(is, 0);
            }
            catch (BIParseException bipe) {
                throw new JboException((Throwable)bipe);
            }
            catch (BISAXException bie) {
                throw new JboException((Throwable)bie);
            }
            catch (BIIOException biioe) {
                if (this.mGraphDefFileName != null) {
                    is = JBOClass.getResourceAsStream((String)this.mGraphDefFileName);
                    try {
                        control.readXML(is, 0);
                    }
                    catch (BIParseException bipe) {
                        throw new JboException((Throwable)bipe);
                    }
                    catch (BISAXException bie) {
                        throw new JboException((Throwable)bie);
                    }
                    catch (BIIOException biioe2) {
                        throw new JboException((Throwable)biioe);
                    }
                }
                throw new JboException((Throwable)biioe);
            }
        }
        if (control != null && (errHandler = control.getErrorHandler()) != null && errHandler instanceof DefaultErrorHandler) {
            DefaultErrorHandler defErrHandler = (DefaultErrorHandler)errHandler;
            defErrHandler.setDebugMode(0);
        }
    }

    protected GraphDataFromCol getSeries(int whichSeries) {
        GraphDataFromCol childSeries;
        if (this.mChildSeries.size() == 0) {
            this.getIteratorBinding().executeQueryIfNeeded();
            Row[] rows = this.getIteratorBinding().getAllRowsInRange();
            this.updateSeries(rows);
        }
        if ((childSeries = (GraphDataFromCol)((Object)this.mChildSeries.get(whichSeries))) == null) {
            throw new JboException("Graph : Child series missing ");
        }
        return childSeries;
    }

    @Override
    protected String getColumnLabel(int i) {
        GraphDataFromCol series = this.getSeries(0);
        return series.getColumnLabel(i);
    }

    @Override
    protected int getColumnCount() {
        GraphDataFromCol series = this.getSeries(0);
        int rc = series.getColumnCount();
        return rc;
    }

    @Override
    protected String getRowLabel(int i) {
        GraphDataFromCol series = this.getSeries(i);
        return series.getSeriesLabel();
    }

    @Override
    protected long getRowCount() {
        return this.getEstimatedRowCount();
    }

    @Override
    protected Object getValue(int row, int col) {
        GraphDataFromCol series = this.getSeries(row);
        return series.getColumnValue(col);
    }

    @Override
    public void addControlToPanel(Object panel, Object layoutObject, Object layoutCons) {
        ((JPanel)panel).add((Component)layoutObject, layoutCons);
    }

    @Override
    public void updateRowInserted(InsertEvent event) {
        this.notifyView();
    }

    @Override
    public void updateRowDeleted(DeleteEvent event) {
        this.notifyView();
    }

    @Override
    public void updateValuesFromRows(Row[] rows, boolean clear) {
        super.updateValuesFromRows(rows, clear);
        if (!this.getBindingContainer().isFindMode()) {
            this.updateSeries(rows);
        }
        this.notifyView();
    }

    void updateSeries(Row[] rows) {
        if (rows == null) {
            return;
        }
        for (int i = 0; i < rows.length; ++i) {
            Object seriesLabel = rows[i].getAttribute(this.mSeriesLabelAttributeName);
            if (seriesLabel == null) {
                seriesLabel = "";
            }
            DCDataControl dc = this.getIteratorBinding().getDataControl();
            DCBindingContainer bc = this.getBindingContainer();
            JUAccessorIteratorDef accDef = new JUAccessorIteratorDef(this.mChildAccessorName, this.getIteratorBinding().getName());
            DCIteratorBinding iterBnd = accDef.createIterBinding(dc, bc, null);
            RowSetIterator accrsi = dc.createAccessorRowSetIterator(this.getIteratorBinding().getRowSetIterator(), rows[i], iterBnd, this.mChildAccessorName, null);
            iterBnd.executeQueryIfNeeded();
            GraphDataFromCol childData = this.createGraphDataFromCol((Graph)this.getControl(), iterBnd, this.mDataValueAttrNames, this.mNumberOfColumnValuesPerMarker, seriesLabel.toString());
            this.mChildSeries.add(i, childData);
        }
    }

    protected GraphDataFromCol createGraphDataFromCol(Graph control, DCIteratorBinding iterBinding, String[] dataValueAttrNames, int numberOfColumnValuesPerMarker, String seriesLabel) {
        return new GraphDataFromCol(control, iterBinding, dataValueAttrNames, numberOfColumnValuesPerMarker, seriesLabel);
    }

    @Override
    protected void notifyView() {
        super.refreshBIBeanAdapter(this.mAdapter);
    }

    public RelationalDataDirector createRelationalDataDirector() {
        return this.mAdapter;
    }

    public CubeDataDirector createCubeDataDirector() {
        return this.mAdapter;
    }

    public void releaseReferences() {
        this.mAdapter.releaseReferences();
        this.mAdapter = null;
        this.mGraphPropertiesStream = null;
        this.mChildSeries.clear();
    }
}

