/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.shapes;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import oracle.dss.util.ErrorHandler;
import oracle.dss.util.shapes.CommonRenderer;
import oracle.dss.util.shapes.DrawableObject;
import oracle.dss.util.shapes.Fill;
import oracle.dss.util.shapes.FillColor;
import oracle.dss.util.shapes.Filter;
import oracle.dss.util.shapes.Image;
import oracle.dss.util.shapes.Label;
import oracle.dss.util.shapes.Stroke;

public class Graphics2DRenderer
implements CommonRenderer {
    private Graphics2D m_graphics;
    private AffineTransform m_origAT = null;
    private ErrorHandler m_errorHandler;
    private BasicStroke m_defaultStroke;

    public Graphics2DRenderer(Graphics2D g, ErrorHandler eh) {
        this.m_graphics = g;
        this.m_errorHandler = eh;
        this.m_defaultStroke = new BasicStroke();
    }

    @Override
    public void drawShape(DrawableObject obj) {
        this.m_origAT = this.m_graphics.getTransform();
        AffineTransform at = null;
        if (obj instanceof Image) {
            Image img = (Image)obj;
            at = img.getTransform();
            Shape s = img.getShape();
            s = at.createTransformedShape(s);
            at = AffineTransform.getTranslateInstance(s.getBounds2D().getX(), s.getBounds2D().getY());
            this.m_graphics.drawImage(img.getImage(), at, null);
        } else if (obj instanceof Label) {
            Label l = (Label)obj;
            Shape s = l.getShape();
            at = l.getTransform();
            if (at != null) {
                s = at.createTransformedShape(s);
            }
            Font f = l.getFont();
            this.m_graphics.setFont(f);
            FontMetrics fm = this.m_graphics.getFontMetrics();
            int ascent = fm.getMaxAscent();
            int descent = fm.getMaxDescent();
            String text = l.toString();
            float x = (float)s.getBounds2D().getX();
            float y = (float)(s.getBounds2D().getY() + s.getBounds2D().getHeight() / 2.0 - (double)(descent / 2) + (double)(ascent / 2));
            this.m_graphics.drawString(text, x, y);
        } else {
            Shape s = obj.getShape();
            at = obj.getTransform();
            if (at != null) {
                s = at.createTransformedShape(s);
            }
            if (obj.hasFill()) {
                Fill f = obj.getFill();
                this.renderFill(f);
            } else {
                this.m_graphics.setColor(Color.decode("0xEEEEEE"));
            }
            this.m_graphics.fill(s);
            if (obj.hasStroke()) {
                Stroke stroke = obj.getStroke();
                this.renderStroke(stroke);
            } else {
                this.m_graphics.setStroke(this.m_defaultStroke);
                this.m_graphics.setColor(Color.BLACK);
            }
            this.m_graphics.draw(s);
            if (obj.hasFilter()) {
                Filter filter = obj.getFilter();
                this.renderFilter(filter);
            }
        }
        this.m_graphics.setTransform(this.m_origAT);
    }

    @Override
    public void renderFill(Fill fill) {
        if (fill instanceof FillColor) {
            FillColor fillColor = (FillColor)fill;
            Color c = fillColor.getColor();
            if (c == null) {
                this.m_graphics.setColor(Color.decode("0xEEEEEE"));
            } else {
                this.m_graphics.setColor(fillColor.getColor());
            }
        }
    }

    @Override
    public void renderStroke(Stroke stroke) {
        float width = stroke.getWidth();
        String style = stroke.getStyle();
        if (style != null) {
            if (style.equals("none") || style.equals("hidden")) {
                width = 0.0f;
            } else if (style.equals("dashed")) {
                float[] dash = new float[]{10.0f};
                this.m_graphics.setStroke(new BasicStroke(width, 0, 0, 10.0f, dash, 0.0f));
            } else if (style.equals("dotted")) {
                float[] dots = new float[]{width, 2.0f * width};
                this.m_graphics.setStroke(new BasicStroke(width, 1, 1, 10.0f, dots, 0.0f));
            } else {
                this.m_graphics.setStroke(new BasicStroke(width));
            }
        } else {
            this.m_graphics.setStroke(new BasicStroke(width));
        }
        Color c = stroke.getColor();
        if (c == null) {
            this.m_graphics.setColor(Color.BLACK);
        } else {
            this.m_graphics.setColor(stroke.getColor());
        }
    }

    @Override
    public void renderFilter(Filter filter) {
    }
}

