/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.shapes;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;
import oracle.dss.util.shapes.Fill;
import oracle.dss.util.shapes.Filter;
import oracle.dss.util.shapes.Stroke;

public abstract class DrawableObject {
    protected Shape m_shape;
    protected AffineTransform m_transform;
    protected Fill m_fill;
    protected Stroke m_stroke;
    protected Filter m_filter;
    protected Map m_properties;

    public DrawableObject(Shape shape) {
        this.m_shape = shape;
        this.m_transform = null;
        this.m_fill = null;
        this.m_stroke = null;
        this.m_filter = null;
        this.m_properties = new HashMap();
    }

    public DrawableObject(Shape shape, HashMap map) {
        this.m_shape = shape;
        this.m_transform = null;
        this.m_fill = null;
        this.m_stroke = null;
        this.m_filter = null;
        this.m_properties = map;
    }

    public boolean contains(double x, double y) {
        return this.m_shape.contains(x, y);
    }

    public Rectangle2D getBounds() {
        return this.m_shape.getBounds2D();
    }

    public Shape getShape() {
        return this.m_shape;
    }

    public void setTransform(AffineTransform at) {
        this.m_transform = at;
    }

    public AffineTransform getTransform() {
        return this.m_transform;
    }

    public Map getProperties() {
        return this.m_properties;
    }

    public void setProperty(Object key, Object value) {
        this.m_properties.put(key, value);
    }

    public Object getProperty(Object key) {
        return this.m_properties.get(key);
    }

    public boolean hasFill() {
        return this.m_fill != null;
    }

    public boolean hasStroke() {
        return this.m_stroke != null;
    }

    public boolean hasFilter() {
        return this.m_filter != null;
    }

    public Fill getFill() {
        return this.m_fill;
    }

    public Stroke getStroke() {
        return this.m_stroke;
    }

    public Filter getFilter() {
        return this.m_filter;
    }

    public void setFill(Fill fill) {
        this.m_fill = fill;
    }

    public void setStroke(Stroke stroke) {
        this.m_stroke = stroke;
    }

    public void setFilter(Filter filter) {
        this.m_filter = filter;
    }
}

