/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.table.managers;

import java.util.Enumeration;
import java.util.Hashtable;
import oracle.dss.dataView.managers.ViewSizing;
import oracle.dss.gridView.managers.GridViewRuleSizing;
import oracle.dss.rules.DiscriminatorRule;
import oracle.dss.rules.Mergeable;
import oracle.dss.rules.ResolutionService;
import oracle.dss.rules.Rule;
import oracle.dss.rules.RuleBundle;
import oracle.dss.rules.RuleContext;
import oracle.dss.rules.RuleException;
import oracle.dss.rules.discriminator.Discriminator;
import oracle.dss.rules.discriminator.QDRDiscriminator;
import oracle.dss.table.TableCommon;
import oracle.dss.table.TableDefaultValues;
import oracle.dss.table.TableSizingManager;
import oracle.dss.util.ColumnComponentInfo;
import oracle.dss.util.DataAccess;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.QDR;
import oracle.dss.util.RowComponentInfo;
import oracle.dss.util.persistence.ObjectScope;
import oracle.dss.util.persistence.XMLContext;
import oracle.dss.util.xml.BaseNode;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class TableRuleSizing
extends GridViewRuleSizing
implements TableSizingManager {
    protected static final String a_manualRowHeaderColumnSizingEnabled = "manualRowHeaderColumnSizingEnabled";
    protected static final String a_manualColumnHeaderRowSizingEnabled = "manualColumnHeaderRowSizingEnabled";
    protected static final String a_preferredColumnHeaderRowHeight = "prefColHdrRowH";
    protected static final String a_preferredRowHeaderColumnWidth = "prefRowHdrColW";
    protected int d_preferredRowHeaderColumnWidth = TableDefaultValues.getSizingMgrPrefRowHeaderColWidth();
    protected int d_preferredColumnHeaderRowHeight = TableDefaultValues.getSizingMgrPrefColHeaderRowHeight();
    private transient TableCommon m_table = null;
    protected transient ViewSizing m_calculatedHeaderSizes;
    protected ViewSizing m_preferredHeaderSizes;
    protected Hashtable m_context = null;
    private static final String m_method_setPreferredColumnWidth = "setPreferredColumnWidth(GridView view, int column, int width)";
    private static final String m_method_getPreferredColumnWidth = "getPreferredColumnWidth(GridView view, int column)";
    private static final String m_method_setPreferredRowHeight = "setPreferredRowHeight(GridView view, int row, int height)";
    private static final String m_method_getPreferredRowHeight = "getPreferredRowHeight(GridView view, int row)";
    private static final String m_method_setCalculatedColumnHeaderRowHeight = "setCalculatedColumnHeaderRowHeight(Table view, int height)";
    private static final String m_method_setCalculatedRowHeaderColumnWidth = "setCalculatedRowHeaderColumnWidth(Table view, int width)";
    private static final String m_method_setPreferredColumnHeaderRowHeight = "setPreferredColumnHeaderRowHeight(Table view, int height)";
    private static final String m_method_setPreferredRowHeaderColumnWidth = "setPreferredRowHeaderColumnWidth(Table view, int width)";
    private static final String m_method__getSize = "_getSize(QDR qdr, RuleBundle bundle, int application)";
    private static final String m_method__createRule = "_createRule(QDR ruleQDR, RuleBundle bundle, int size, int ruleApplication)";
    private static final String m_method_createCalculatedRowHeightsArray = "createCalculatedRowHeightsArray()";

    public TableRuleSizing(TableCommon t) {
        super(t);
        this.m_table = t;
    }

    @Override
    public void setPreferredColumnWidth(int column, int width) {
        if (this.m_table.getModel() == null) {
            this.m_table.getErrorHandler().log("null Model", this.getClass().getName(), m_method_setPreferredColumnWidth);
            return;
        }
        int colCount = 0;
        try {
            colCount = this.m_table.getModel().getDataAccess().getEdgeExtent(0);
        }
        catch (EdgeOutOfRangeException e) {
            this.m_table.getErrorHandler().log("edge out of range", this.getClass().getName(), m_method_setPreferredColumnWidth);
        }
        if (column < 0 || column >= colCount) {
            this.m_table.getErrorHandler().log("invalid column index", this.getClass().getName(), m_method_setPreferredColumnWidth);
            return;
        }
        if (width < 0 && width != -1) {
            this.m_table.getErrorHandler().log("invalid column width", this.getClass().getName(), m_method_setPreferredColumnWidth);
            return;
        }
        DataAccess dataAccess = null;
        dataAccess = this.m_table.getModel().getDataAccess();
        if (dataAccess == null) {
            this.m_table.getErrorHandler().log("null DataAccess", this.getClass().getName(), m_method_setPreferredColumnWidth);
            return;
        }
        if (this.cci == null) {
            this.cci = new ColumnComponentInfo(column);
        } else {
            this.cci.setColumn(column);
        }
        QDR columnQDR = this.cci.getQDR(dataAccess, 0);
        if (columnQDR == null) {
            this.m_table.getErrorHandler().log("null QDR", this.getClass().getName(), m_method_setPreferredColumnWidth);
            this.setCalculatedColumnWidth(column, width);
            return;
        }
        this.getPreferredColumnWidthsCache()[column] = width;
        this.createIndividualColumnWidthRule(columnQDR, width);
    }

    @Override
    public int getPreferredColumnWidth(int column) {
        if (this.m_table.getModel() == null) {
            this.m_table.getErrorHandler().log("null Model", this.getClass().getName(), m_method_getPreferredColumnWidth);
            return -1;
        }
        int colCount = 0;
        try {
            colCount = this.m_table.getModel().getDataAccess().getEdgeExtent(0);
        }
        catch (EdgeOutOfRangeException e) {
            this.m_table.getErrorHandler().log("edge out of range", this.getClass().getName(), m_method_getPreferredColumnWidth);
        }
        if (column < 0 || column >= colCount) {
            this.m_table.getErrorHandler().log("invalid column index", this.getClass().getName(), m_method_getPreferredColumnWidth);
            return -1;
        }
        if (this.m_preferredColumnWidthsCache != null && this.m_preferredColumnWidthsCache[column] != -2) {
            return this.m_preferredColumnWidthsCache[column];
        }
        int width = -1;
        if (this.m_preferredColumnWidths != null && this.m_preferredColumnWidths.getCount() > 0) {
            DataAccess dataAccess = null;
            dataAccess = this.m_table.getModel().getDataAccess();
            if (dataAccess == null) {
                this.m_table.getErrorHandler().log("null DataAccess", this.getClass().getName(), m_method_getPreferredColumnWidth);
                return -1;
            }
            if (this.cci == null) {
                this.cci = new ColumnComponentInfo(column);
            } else {
                this.cci.setColumn(column);
            }
            QDR columnQDR = this.cci.getQDR(dataAccess, 0);
            if (columnQDR == null) {
                this.m_table.getErrorHandler().log("null QDR", this.getClass().getName(), m_method_getPreferredColumnWidth);
                return -1;
            }
            width = this._getSize(columnQDR, this.getPreferredColumnWidths(), 1);
        }
        this.getPreferredColumnWidthsCache()[column] = width;
        return width;
    }

    @Override
    public void setPreferredRowHeight(int row, int height) {
        if (this.m_table.getModel() == null) {
            this.m_table.getErrorHandler().log("null Model", this.getClass().getName(), m_method_setPreferredRowHeight);
            return;
        }
        int rowCount = 0;
        try {
            rowCount = this.m_table.getModel().getDataAccess().getEdgeExtent(1);
        }
        catch (EdgeOutOfRangeException e) {
            this.m_table.getErrorHandler().log("edge out of range", this.getClass().getName(), m_method_setPreferredRowHeight);
        }
        if (this.m_table.isIncrementalFetchEnabled() && this.m_table.isIncrementalFetchRowVisible()) {
            ++rowCount;
        }
        if (row < 0 || row >= rowCount) {
            this.m_table.getErrorHandler().log("invalid row index", this.getClass().getName(), m_method_setPreferredRowHeight);
            return;
        }
        if (height < 0 && height != -1) {
            this.m_table.getErrorHandler().log("invalid row height", this.getClass().getName(), m_method_setPreferredRowHeight);
            return;
        }
        if (this.m_table.isIncrementalFetchEnabled() && this.m_table.isIncrementalFetchRowVisible() && row == rowCount - 1) {
            this.setCalculatedRowHeight(row, height);
            return;
        }
        DataAccess dataAccess = null;
        dataAccess = this.m_table.getModel().getDataAccess();
        if (dataAccess == null) {
            this.m_table.getErrorHandler().log("null DataAccess", this.getClass().getName(), m_method_setPreferredRowHeight);
            return;
        }
        if (this.rci == null) {
            this.rci = new RowComponentInfo(row);
        } else {
            this.rci.setRow(row);
        }
        QDR rowQDR = this.rci.getQDR(dataAccess, 0);
        if (rowQDR == null) {
            this.m_table.getErrorHandler().log("null QDR", this.getClass().getName(), m_method_setPreferredRowHeight);
            this.setCalculatedRowHeight(row, height);
            return;
        }
        this.getPreferredRowHeightsCache()[row] = height;
        this.createIndividualRowHeightRule(rowQDR, height);
    }

    @Override
    public int getPreferredRowHeight(int row) {
        if (this.m_table.getModel() == null) {
            this.m_table.getErrorHandler().log("null Model", this.getClass().getName(), m_method_getPreferredRowHeight);
            return -1;
        }
        int rowCount = 0;
        try {
            rowCount = this.m_table.getModel().getDataAccess().getEdgeExtent(1);
        }
        catch (EdgeOutOfRangeException e) {
            this.m_table.getErrorHandler().log("edge out of range", this.getClass().getName(), m_method_getPreferredRowHeight);
        }
        if (this.m_table.isIncrementalFetchEnabled() && this.m_table.isIncrementalFetchRowVisible()) {
            ++rowCount;
        }
        if (row < 0 || row >= rowCount) {
            this.m_table.getErrorHandler().log("invalid row index", this.getClass().getName(), m_method_getPreferredRowHeight);
            return -1;
        }
        if (this.m_table.isIncrementalFetchEnabled() && this.m_table.isIncrementalFetchRowVisible() && row == rowCount - 1) {
            return -1;
        }
        if (this.m_preferredRowHeightsCache != null && this.m_preferredRowHeightsCache[row] != -2) {
            return this.m_preferredRowHeightsCache[row];
        }
        if (this.m_table.getWaitDataForRow(row) != null) {
            return -1;
        }
        int height = -1;
        if (this.m_preferredRowHeights != null && this.m_preferredRowHeights.getCount() > 0) {
            DataAccess dataAccess = null;
            dataAccess = this.m_table.getModel().getDataAccess();
            if (dataAccess == null) {
                this.m_table.getErrorHandler().log("null DataAccess", this.getClass().getName(), m_method_getPreferredRowHeight);
                return -1;
            }
            if (this.rci == null) {
                this.rci = new RowComponentInfo(row);
            } else {
                this.rci.setRow(row);
            }
            QDR rowQDR = this.rci.getQDR(dataAccess, 0);
            if (rowQDR == null) {
                this.m_table.getErrorHandler().log("null QDR", this.getClass().getName(), m_method_getPreferredRowHeight);
                return -1;
            }
            height = this._getSize(rowQDR, this.getPreferredRowHeights(), 0);
        }
        this.getPreferredRowHeightsCache()[row] = height;
        return height;
    }

    @Override
    public void clearCalculatedSizes() {
        super.clearCalculatedSizes();
        this.m_calculatedHeaderSizes = null;
    }

    @Override
    public void clearPreferredSizes() {
        super.clearPreferredSizes();
        this.m_preferredHeaderSizes = null;
    }

    @Override
    public Object clone() {
        TableRuleSizing trs = new TableRuleSizing(this.m_table);
        TableRuleSizing.copyMembersForClone(this, trs);
        return trs;
    }

    @Override
    public void setCalculatedColumnHeaderRowHeight(int height) {
        if (height < 0 && height != -1) {
            this.m_table.getErrorHandler().log("invalid height", this.getClass().getName(), m_method_setCalculatedColumnHeaderRowHeight);
            return;
        }
        if (this.m_calculatedHeaderSizes == null) {
            this.m_calculatedHeaderSizes = new ViewSizing();
        }
        this.m_calculatedHeaderSizes.setRowHeight(height);
    }

    @Override
    public int getCalculatedColumnHeaderRowHeight() {
        if (this.m_calculatedHeaderSizes != null && this.m_calculatedHeaderSizes.isRowHeightUsed()) {
            return this.m_calculatedHeaderSizes.getRowHeight();
        }
        return -1;
    }

    @Override
    public void setCalculatedRowHeaderColumnWidth(int width) {
        if (width < 0 && width != -1) {
            this.m_table.getErrorHandler().log("invalid width", this.getClass().getName(), m_method_setCalculatedRowHeaderColumnWidth);
            return;
        }
        if (this.m_calculatedHeaderSizes == null) {
            this.m_calculatedHeaderSizes = new ViewSizing();
        }
        this.m_calculatedHeaderSizes.setColumnWidth(width);
    }

    @Override
    public int getCalculatedRowHeaderColumnWidth() {
        if (this.m_calculatedHeaderSizes != null && this.m_calculatedHeaderSizes.isColumnWidthUsed()) {
            return this.m_calculatedHeaderSizes.getColumnWidth();
        }
        return -1;
    }

    @Override
    public void setPreferredColumnHeaderRowHeight(int height) {
        if (height < 0 && height != -1) {
            this.m_table.getErrorHandler().log("invalid height", this.getClass().getName(), m_method_setPreferredColumnHeaderRowHeight);
            return;
        }
        if (this.m_preferredHeaderSizes == null) {
            this.m_preferredHeaderSizes = new ViewSizing(this.d_preferredColumnHeaderRowHeight, this.d_preferredRowHeaderColumnWidth);
        }
        this.m_preferredHeaderSizes.setRowHeight(height);
        this.m_table.updateSizes(2);
    }

    @Override
    public int getPreferredColumnHeaderRowHeight() {
        if (this.m_preferredHeaderSizes != null && this.m_preferredHeaderSizes.isRowHeightUsed()) {
            return this.m_preferredHeaderSizes.getRowHeight();
        }
        return -1;
    }

    @Override
    public void setPreferredRowHeaderColumnWidth(int width) {
        if (width < 0 && width != -1) {
            this.m_table.getErrorHandler().log("invalid width", this.getClass().getName(), m_method_setPreferredRowHeaderColumnWidth);
            return;
        }
        if (this.m_preferredHeaderSizes == null) {
            this.m_preferredHeaderSizes = new ViewSizing(this.d_preferredColumnHeaderRowHeight, this.d_preferredRowHeaderColumnWidth);
        }
        this.m_preferredHeaderSizes.setColumnWidth(width);
        this.m_table.updateSizes(3);
    }

    @Override
    public int getPreferredRowHeaderColumnWidth() {
        if (this.m_preferredHeaderSizes != null && this.m_preferredHeaderSizes.isColumnWidthUsed()) {
            return this.m_preferredHeaderSizes.getColumnWidth();
        }
        return -1;
    }

    @Override
    public int getColumnHeaderRowHeight() {
        int desiredHeight = this.getPreferredColumnHeaderRowHeight();
        if (desiredHeight == -1 && (desiredHeight = this.getCalculatedColumnHeaderRowHeight()) == -1) {
            desiredHeight = this.getDefaultColumnHeaderRowHeight();
        }
        if (desiredHeight < this.m_table.getCellMinHeight()) {
            desiredHeight = this.m_table.getCellMinHeight();
        }
        if (desiredHeight > this.m_table.getCellMaxHeight()) {
            desiredHeight = this.m_table.getCellMaxHeight();
        }
        return desiredHeight;
    }

    @Override
    public int getRowHeaderColumnWidth() {
        int desiredWidth = this.getPreferredRowHeaderColumnWidth();
        if (desiredWidth == -1 && (desiredWidth = this.getCalculatedRowHeaderColumnWidth()) == -1) {
            desiredWidth = this.getDefaultRowHeaderColumnWidth();
        }
        if (desiredWidth < this.m_table.getCellMinWidth()) {
            desiredWidth = this.m_table.getCellMinWidth();
        }
        if (desiredWidth > this.m_table.getCellMaxWidth()) {
            desiredWidth = this.m_table.getCellMaxWidth();
        }
        return desiredWidth;
    }

    public void setContext(Hashtable context) {
        this.m_context = context;
    }

    public ObjectNode getXML(boolean allProperties) {
        ObjectNode node = new ObjectNode("SizingManager");
        boolean nodeExists = false;
        if (allProperties || this.getDefaultColumnWidth() != this.d_defaultColumnWidth) {
            node.addProperty("defColW", this.getDefaultColumnWidth());
            nodeExists = true;
        }
        if (allProperties || this.getDefaultRowHeight() != this.d_defaultRowHeight) {
            node.addProperty("defRowH", this.getDefaultRowHeight());
            nodeExists = true;
        }
        if (allProperties || this.getDefaultColumnHeaderRowHeight() != this.d_defaultColumnHeaderRowHeight) {
            node.addProperty("defColHdrRowH", this.getDefaultColumnHeaderRowHeight());
            nodeExists = true;
        }
        if (allProperties || this.getDefaultRowHeaderColumnWidth() != this.d_defaultRowHeaderColumnWidth) {
            node.addProperty("defRowHdrColW", this.getDefaultRowHeaderColumnWidth());
            nodeExists = true;
        }
        if (allProperties || this.getPreferredColumnHeaderRowHeight() != this.d_preferredColumnHeaderRowHeight) {
            node.addProperty(a_preferredColumnHeaderRowHeight, this.getPreferredColumnHeaderRowHeight());
            nodeExists = true;
        }
        if (allProperties || this.getPreferredRowHeaderColumnWidth() != this.d_preferredRowHeaderColumnWidth) {
            node.addProperty(a_preferredRowHeaderColumnWidth, this.getPreferredRowHeaderColumnWidth());
            nodeExists = true;
        }
        ContainerNode columnBundleXML = new ContainerNode("ColBundle");
        boolean colXMLExists = false;
        if (this.m_preferredColumnWidths != null) {
            for (int i = 0; i < this.m_preferredColumnWidths.getCount(); ++i) {
                ObjectNode descRuleXML = new ObjectNode("SizingDiscRule");
                DiscriminatorRule rule = (DiscriminatorRule)this.m_preferredColumnWidths.getRule(i);
                if (this.m_context != null) {
                    rule.setContext(this.m_context);
                }
                ObjectNode qdrXML = ((QDRDiscriminator)rule.getDiscriminator()).getXML(allProperties, null, true);
                descRuleXML.addProperty(qdrXML);
                descRuleXML.addProperty("ColW", ((ViewSizing)rule.getFixedMergeable()).getColumnWidth(), false);
                if (rule == null) continue;
                columnBundleXML.addContainedObject((BaseNode)descRuleXML);
                colXMLExists = true;
            }
        }
        if (colXMLExists) {
            node.addContainer(columnBundleXML);
            nodeExists = true;
        }
        ContainerNode rowBundleXML = new ContainerNode("RowBundle");
        boolean rowXMLExists = false;
        if (this.m_preferredRowHeights != null) {
            for (int i = 0; i < this.m_preferredRowHeights.getCount(); ++i) {
                ObjectNode descRuleXML = new ObjectNode("SizingDiscRule");
                DiscriminatorRule rule = (DiscriminatorRule)this.m_preferredRowHeights.getRule(i);
                if (this.m_context != null) {
                    rule.setContext(this.m_context);
                }
                ObjectNode qdrXML = ((QDRDiscriminator)rule.getDiscriminator()).getXML(allProperties, null, true);
                descRuleXML.addProperty(qdrXML);
                descRuleXML.addProperty("RowH", ((ViewSizing)rule.getFixedMergeable()).getRowHeight(), false);
                if (rule == null) continue;
                rowBundleXML.addContainedObject((BaseNode)descRuleXML);
                rowXMLExists = true;
            }
        }
        if (rowXMLExists) {
            node.addContainer(rowBundleXML);
            nodeExists = true;
        }
        if (nodeExists) {
            return node;
        }
        return null;
    }

    public void setXML(ObjectNode node) {
        ContainerNode rowBundleXML;
        ContainerNode columnBundleXML;
        PropertyNode pNode;
        XMLContext xmlContext = this.m_context != null && this.m_context.containsKey("xml_context") ? (XMLContext)this.m_context.get("xml_context") : new XMLContext(new ObjectScope(), false);
        if (xmlContext.getScope() == null) {
            xmlContext.setScope(new ObjectScope());
        }
        if ((pNode = node.getProperty("defColW")) != null) {
            this.setDefaultColumnWidth(pNode.getValueAsInteger());
        }
        if ((pNode = node.getProperty("defRowH")) != null) {
            this.setDefaultRowHeight(pNode.getValueAsInteger());
        }
        if ((pNode = node.getProperty("defColHdrRowH")) != null) {
            this.setDefaultColumnHeaderRowHeight(pNode.getValueAsInteger());
        }
        if ((pNode = node.getProperty("defRowHdrColW")) != null) {
            this.setDefaultRowHeaderColumnWidth(pNode.getValueAsInteger());
        }
        if ((pNode = node.getProperty(a_preferredColumnHeaderRowHeight)) != null) {
            this.setPreferredColumnHeaderRowHeight(pNode.getValueAsInteger());
        }
        if ((pNode = node.getProperty(a_preferredRowHeaderColumnWidth)) != null) {
            this.setPreferredRowHeaderColumnWidth(pNode.getValueAsInteger());
        }
        if ((columnBundleXML = node.getContainer("ColBundle")) != null) {
            if (this.m_preferredColumnWidths == null) {
                this.m_preferredColumnWidths = new RuleBundle();
            }
            Enumeration e = columnBundleXML.getContainedObject();
            while (e.hasMoreElements()) {
                ObjectNode discriminatorRuleNode = (ObjectNode)e.nextElement();
                if (discriminatorRuleNode == null) continue;
                ObjectNode QDRDiscXML = discriminatorRuleNode.getPropertyValueAsObjectNode("QDRDisc", true);
                QDRDiscriminator qdrDisc = new QDRDiscriminator();
                qdrDisc.setXML(QDRDiscXML, null, null, 0);
                QDR qdr = qdrDisc.getQDR();
                PropertyNode columnWidthNode = discriminatorRuleNode.getProperty("ColW");
                if (columnWidthNode == null) continue;
                this._createRule(qdr, this.getPreferredColumnWidths(), columnWidthNode.getValueAsInteger(), 1);
            }
        }
        if ((rowBundleXML = node.getContainer("RowBundle")) != null) {
            if (this.m_preferredRowHeights == null) {
                this.m_preferredRowHeights = new RuleBundle();
            }
            Enumeration e = rowBundleXML.getContainedObject();
            while (e.hasMoreElements()) {
                ObjectNode discriminatorRuleNode = (ObjectNode)e.nextElement();
                if (discriminatorRuleNode == null) continue;
                ObjectNode QDRDiscXML = discriminatorRuleNode.getPropertyValueAsObjectNode("QDRDisc", true);
                QDRDiscriminator qdrDisc = new QDRDiscriminator();
                qdrDisc.setXML(QDRDiscXML, null, null, 0);
                QDR qdr = qdrDisc.getQDR();
                PropertyNode rowHeightNode = discriminatorRuleNode.getProperty("RowH");
                if (rowHeightNode == null) continue;
                this._createRule(qdr, this.getPreferredRowHeights(), rowHeightNode.getValueAsInteger(), 0);
            }
        }
        this.clearPreferredRowHeightsCache();
        this.clearPreferredColumnWidthsCache();
        this.m_table.doSizing();
    }

    protected static void copyMembersForClone(TableRuleSizing from, TableRuleSizing to) {
        GridViewRuleSizing.copyMembersForClone(from, to);
        if (from.m_preferredHeaderSizes != null) {
            to.m_preferredHeaderSizes = (ViewSizing)from.m_preferredHeaderSizes.clone();
        }
    }

    protected void createIndividualRowHeightRule(QDR rowQDR, int height) {
        this._createRule(rowQDR, this.getPreferredRowHeights(), height, 0);
    }

    protected void createIndividualColumnWidthRule(QDR columnQDR, int width) {
        this._createRule(columnQDR, this.getPreferredColumnWidths(), width, 1);
    }

    @Override
    protected void createCalculatedRowHeightsArray() {
        int rowCount = 0;
        try {
            rowCount = this.m_table.getModel().getDataAccess().getEdgeExtent(1);
        }
        catch (EdgeOutOfRangeException e) {
            this.m_table.getErrorHandler().log("edge out of range", this.getClass().getName(), m_method_createCalculatedRowHeightsArray);
        }
        if (this.m_table.isIncrementalFetchEnabled()) {
            ++rowCount;
        }
        this.m_calculatedRowHeights = new int[rowCount];
        for (int i = 0; i < this.m_calculatedRowHeights.length; ++i) {
            this.m_calculatedRowHeights[i] = -1;
        }
    }

    private int _getSize(QDR qdr, RuleBundle bundle, int application) {
        RuleContext context = new RuleContext();
        context.put((Object)"QDR", (Object)qdr);
        ViewSizing result = null;
        ViewSizing defaultVS = new ViewSizing(-1, -1);
        result = (ViewSizing)ResolutionService.resolveRules((RuleContext)context, (Mergeable)defaultVS, (RuleBundle)bundle);
        if (result == null) {
            this.m_table.getErrorHandler().log("Error when resolving rules", this.getClass().getName(), m_method__getSize);
            return -1;
        }
        switch (application) {
            case 1: {
                if (!result.isColumnWidthUsed()) break;
                return result.getColumnWidth();
            }
            case 0: {
                if (!result.isRowHeightUsed()) break;
                return result.getRowHeight();
            }
            default: {
                this.m_table.getErrorHandler().log("invalid argument - application", this.getClass().getName(), m_method__getSize);
                return -1;
            }
        }
        return -1;
    }

    private void _createRule(QDR ruleQDR, RuleBundle bundle, int size, int ruleApplication) {
        RuleContext context = new RuleContext();
        context.put((Object)"QDR", (Object)ruleQDR);
        try {
            bundle.removeRulesThatApply(context, null);
        }
        catch (RuleException re) {
            this.m_table.getErrorHandler().log("RuleException when removing previous rule", this.getClass().getName(), m_method__createRule);
        }
        ViewSizing vs = new ViewSizing();
        QDRDiscriminator disc = new QDRDiscriminator();
        disc.setQDR(ruleQDR);
        switch (ruleApplication) {
            case 0: {
                vs.setRowHeight(size);
                break;
            }
            case 1: {
                vs.setColumnWidth(size);
                break;
            }
            default: {
                this.m_table.getErrorHandler().log("invalid ruleApplication", this.getClass().getName(), m_method__createRule);
                return;
            }
        }
        disc.setSetOperator(3);
        bundle.addRule((Rule)new DiscriminatorRule((Discriminator)disc, (Mergeable)vs));
        this.m_table.updateSizes(ruleApplication);
    }
}

